/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import net.lightbody.bmp.BrowserMobProxy;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Network {
    private static final String USE_IP_PROPERTY = "useIP";
    private static final Logger LOG = LoggerFactory.getLogger(Network.class);

    private Network() {
    }

    public static URI getRebasedURL(URI originalURI) throws SocketException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(originalURI);
        String host = originalURI.getHost();
        if ("localhost".equals(host) || host.indexOf(46) < 0) {
            String envIP = System.getenv("IP");
            if (envIP != null) {
                uriBuilder.setHost(envIP);
            } else {
                String firstLocalIP = System.getProperty(USE_IP_PROPERTY, Network.getFirstLocalIP());
                if (firstLocalIP != null) {
                    uriBuilder.setHost(firstLocalIP);
                }
            }
        }
        uriBuilder.setPath(StringUtils.removeEnd((String)originalURI.getPath(), (String)"/"));
        return uriBuilder.build();
    }

    public static String proxyURL(BrowserMobProxy proxy) {
        String hostName = null;
        try {
            hostName = Network.getRebasedURL(new URI("http://" + InetAddress.getLocalHost())).getHost();
            hostName = hostName + ":" + proxy.getPort();
        }
        catch (SocketException | URISyntaxException | UnknownHostException e) {
            LOG.error("Issue trying to compute proxy url", (Throwable)e);
        }
        return hostName;
    }

    private static String getFirstLocalIP() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        ArrayList<String> possibleIPs = new ArrayList<String>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!networkInterface.isUp()) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                String hostAddress;
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet4Address) || !(hostAddress = inetAddress.getHostAddress()).startsWith("192.168.") && !hostAddress.startsWith("10.")) continue;
                possibleIPs.add(hostAddress);
            }
        }
        return (String)possibleIPs.stream().sorted().findFirst().orElseThrow();
    }
}

