/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.utils;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.ResourceUtil;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Coverage {
    private static final Logger LOG = LoggerFactory.getLogger(Coverage.class);
    private static final String DEFAULT_COVERAGE_CONFIG = "coverage.config";
    private boolean jsCoverAvailable;
    private String config;
    private SlingClient adminClient;
    private String configName = "coverage.config";
    private boolean configPresent;
    private boolean autoClean;

    public Coverage(SlingClient client) {
        this.adminClient = client;
        try {
            this.config = ResourceUtil.readResourceAsString((String)this.configName);
            this.configPresent = true;
            SlingHttpResponse response = this.adminClient.doGet("/apps/granite/testing/clientlibs/jscover.js", new int[0]);
            this.jsCoverAvailable = response != null && response.getStatusLine().getStatusCode() == 200;
        }
        catch (IOException | ClientException e) {
            LOG.error("Cannot initialize", e);
        }
    }

    public Coverage withAutoClean(boolean withAutoClean) {
        this.autoClean = withAutoClean;
        return this;
    }

    public boolean isJSCoverAvailable() {
        return this.jsCoverAvailable;
    }

    public void invalidateLibraryCaches() throws ClientException {
        FormEntityBuilder entityBuilder = FormEntityBuilder.create();
        entityBuilder.addParameter("invalidate", "true");
        this.adminClient.doPost("/libs/granite/ui/content/dumplibs.rebuild.html", (HttpEntity)entityBuilder.build(), new int[0]);
    }

    public void cleanCoverageJSON() throws ClientException {
        FormEntityBuilder entityBuilder = FormEntityBuilder.create();
        entityBuilder.addParameter("clear", "1");
        this.adminClient.doPost("/bin/jscover/store", (HttpEntity)entityBuilder.build(), new int[0]);
    }

    public void setupService() throws ClientException {
        if (this.autoClean) {
            this.cleanCoverageJSON();
        }
        if (StringUtils.isNotBlank((CharSequence)this.config)) {
            SlingHttpResponse response = this.adminClient.doGet("/apps/system/config/com.adobe.granite.ui.clientlibs.jscover.impl.JSCoverInstrumentationServiceImpl.config", new int[0]);
            FormEntityBuilder entityBuilder = FormEntityBuilder.create();
            if (response.getStatusLine().getStatusCode() == 404) {
                entityBuilder.addParameter("jcr:primaryType", "nt:file");
                entityBuilder.addParameter("jcr:content/jcr:primaryType", "nt:resource");
            }
            entityBuilder.addParameter("jcr:content/jcr:data", this.config);
            entityBuilder.addParameter("jcr:content/jcr:data@TypeHint", "Binary");
            entityBuilder.addParameter("jcr:content/jcr:lastModifiedBy", "");
            entityBuilder.addParameter("jcr:content/jcr:lastModified", "");
            this.adminClient.doPost("/apps/system/config/com.adobe.granite.ui.clientlibs.jscover.impl.JSCoverInstrumentationServiceImpl.config", (HttpEntity)entityBuilder.build(), new int[0]);
            LOG.info("Coverage setup done");
        }
    }

    public void generateExport() throws ClientException {
        if (this.isConfigPresent() && this.isJSCoverAvailable()) {
            URLParameterBuilder parameterBuilder = URLParameterBuilder.create().add("overwrite", Boolean.toString(!this.autoClean));
            this.adminClient.doGet("/bin/jscover/export", parameterBuilder.getList(), new int[]{200});
            LOG.info("Coverage exported");
        }
    }

    public void storeCoverage(String coverageData) throws ClientException {
        FormEntityBuilder entityBuilder = FormEntityBuilder.create();
        entityBuilder.addParameter("data", coverageData);
        this.adminClient.doPost("/bin/jscover/store", (HttpEntity)entityBuilder.build(), new int[0]);
        LOG.info("Coverage stored");
    }

    public boolean isConfigPresent() {
        return this.configPresent;
    }

    public void tearDown() {
        if (this.adminClient != null && this.isConfigPresent() && this.isJSCoverAvailable()) {
            try {
                this.generateExport();
            }
            catch (ClientException e) {
                throw new AssertionError((Object)("Coverage Export Failed due to " + e.getMessage()));
            }
        }
    }

    public void setup() {
        if (this.adminClient != null && this.isConfigPresent() && this.isJSCoverAvailable()) {
            try {
                this.invalidateLibraryCaches();
                this.setupService();
            }
            catch (ClientException e) {
                throw new AssertionError((Object)("Coverage Setup Failed due to " + e.getMessage()));
            }
        }
    }
}

