/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationHelper.class);

    private AnnotationHelper() {
    }

    public static <A extends Annotation> Optional<A> findOptionalAnnotation(ExtensionContext context, Class<A> annotationType) {
        Optional current = Optional.of(context);
        try {
            while (current.isPresent()) {
                Optional annotation = AnnotationUtils.findAnnotation((AnnotatedElement)current.get().getRequiredTestClass(), annotationType);
                if (annotation.isPresent()) {
                    return annotation;
                }
                current = current.get().getParent();
            }
        }
        catch (Exception ex) {
            LOGGER.trace(ex.getMessage());
        }
        return Optional.empty();
    }
}

