/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralCheckbox;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralRadio;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import org.junit.jupiter.api.Assertions;

public class RolloutDialog
extends Dialog {
    public RolloutDialog() {
        super("coral-dialog.msm-rollout-dialog");
    }

    public int numberOfLiveCopies() {
        return this.content().$$("[handle=table] tbody tr").size();
    }

    public boolean isLiveCopySelected(String livecopyPath) {
        SelenideElement livecopyRow = this.content().$$("[handle=table] tbody tr").filter(Condition.attribute((String)"data-path", (String)livecopyPath)).first();
        if (!livecopyRow.isDisplayed()) {
            return false;
        }
        return livecopyRow.$$("td").get(0).find("coral-checkbox").has(Condition.attribute((String)"checked", (String)"true"));
    }

    public void selectLivecopy(String livecopyPath) {
        if (this.isLiveCopySelected(livecopyPath)) {
            return;
        }
        SelenideElement livecopyRow = this.getLivecopy(livecopyPath);
        livecopyRow.$$("td").get(0).find("coral-checkbox").click();
    }

    public void deselectLivecopy(String livecopyPath) {
        if (!this.isLiveCopySelected(livecopyPath)) {
            return;
        }
        SelenideElement livecopyRow = this.getLivecopy(livecopyPath);
        livecopyRow.$$("td").get(0).find("coral-checkbox").click();
    }

    public void clickSelectAllLivecopy() {
        this.getSelectAll().click();
    }

    public boolean isSelectAllChecked() {
        CoralCheckbox selectAll = this.getSelectAll();
        return selectAll.isChecked() && !selectAll.isIndeterminate();
    }

    public void close() {
        ElementUtils.clickableClick(Selenide.$((String)"button[title='Cancel']"));
    }

    public void rolloutNow() {
        ElementUtils.clickableClick(Selenide.$((String)"button[title='Rollout']"));
        CoralRadio scheduleOptions = new CoralRadio(Selenide.$((String)"coral-dialog[id='aem-sites-schedule-dialog']"), "reportSchedule");
        Assertions.assertTrue((scheduleOptions.elementByValue("now") != null ? 1 : 0) != 0, (String)"Schedule Now should be present");
        ElementUtils.clickableClick(scheduleOptions.elementByValue("now"));
        ElementUtils.clickableClick(Selenide.$((String)"button[trackingelement='continue']"));
    }

    public void submitRollout() {
        ElementUtils.clickableClick(Selenide.$((String)"button[title='Rollout']"));
    }

    public boolean isContinueEnabled() {
        return Selenide.$((String)"button[trackingelement='continue']").isEnabled();
    }

    private SelenideElement getLivecopy(String livecopyPath) {
        return this.content().$$("[handle=table] tbody tr").filter(Condition.attribute((String)"data-path", (String)livecopyPath)).first();
    }

    private CoralCheckbox getSelectAll() {
        return new CoralCheckbox("[labelled='Select All']");
    }
}

