/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pageobject.EditorPage;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.common.ActionComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.InlineEditor;
import com.adobe.cq.testing.selenium.pagewidgets.cq.InsertComponentDialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.PolicyDialog;
import com.adobe.cq.testing.selenium.pagewidgets.cq.StylesSelector;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public class EditableToolbar
extends AEMBaseComponent {
    private static final String EDITABLETOOLBAR_IDENTIFIER = "#EditableToolbar";
    private ActionComponent<InsertComponentDialog> insertButton = new ActionComponent<Object>(EditableToolbarAction.INSERT.getButton(), () -> new InsertComponentDialog(), false);
    private ActionComponent<Dialog> configureButton = new ActionComponent<Object>(EditableToolbarAction.CONFIGURE.getButton(), () -> new Dialog(), false);
    private SelenideElement parentButton = EditableToolbarAction.PARENT.getButton();
    private SelenideElement editButton = EditableToolbarAction.EDIT.getButton();
    private SelenideElement layoutButton = EditableToolbarAction.LAYOUT.getButton();
    private SelenideElement copyButton = EditableToolbarAction.COPY.getButton();
    private SelenideElement cutButton = EditableToolbarAction.CUT.getButton();
    private SelenideElement pasteButton = EditableToolbarAction.PASTE.getButton();
    private SelenideElement panelSelectButton = EditableToolbarAction.PANEL_SELECT.getButton();
    private ActionComponent<Dialog> deleteButton = new ActionComponent<Object>(EditableToolbarAction.DELETE.getButton(), () -> new Dialog("coral-dialog"), false);
    private SelenideElement groupButton = EditableToolbarAction.GROUP.getButton();
    private ActionComponent<StylesSelector> stylesButton = new ActionComponent<Object>(EditableToolbarAction.STYLE.getButton(), () -> new StylesSelector(StylesSelector.Variant.COMPONENT), false);
    private ActionComponent<PolicyDialog> policyButton = new ActionComponent<Object>(this.element().find(EditableToolbarAction.POLICY.getSelector()), () -> new PolicyDialog(), false);
    private ActionComponent<Dialog> unlockStructureButton = new ActionComponent<Object>(EditableToolbarAction.STRUCTURE_OFF.getButton(), () -> new Dialog("coral-dialog"), false);
    private ActionComponent<Dialog> lockStructureButton = new ActionComponent<Object>(EditableToolbarAction.STRUCTURE_ON.getButton(), () -> new Dialog("coral-dialog"), false);
    private SelenideElement newlineButton = EditableToolbarAction.NEWLINE.getButton();
    private SelenideElement hideButton = EditableToolbarAction.HIDE.getButton();
    private SelenideElement unhideButton = EditableToolbarAction.UNHIDE.getButton();
    private SelenideElement restoreAllButton = EditableToolbarAction.UNHIDE.getButton();
    private SelenideElement amountButton = EditableToolbarAction.AMOUNT.getButton();
    private SelenideElement resetButton = EditableToolbarAction.RESET.getButton();
    private SelenideElement closeButton = EditableToolbarAction.CLOSE.getButton();
    private static final String RESTORE_BUTTON = "button[data-path='%s']";
    private InlineEditor inlineEditor = new InlineEditor(this);
    private EditorPage editorPage;

    public <T extends EditorPage> EditableToolbar(T editorPage) {
        super(EDITABLETOOLBAR_IDENTIFIER);
        this.editorPage = editorPage;
    }

    public SelenideElement getButton(EditableToolbarAction editableToolbarAction) {
        return editableToolbarAction.getButton();
    }

    public SelenideElement getInsertButton() {
        return this.insertButton.element();
    }

    public SelenideElement getConfigureButton() {
        return this.configureButton.element();
    }

    public SelenideElement getParentButton() {
        return this.parentButton;
    }

    public SelenideElement getEditButton() {
        return this.editButton;
    }

    public SelenideElement getLayoutButton() {
        return this.layoutButton;
    }

    public SelenideElement getCopyButton() {
        return this.copyButton;
    }

    public SelenideElement getCutButton() {
        return this.cutButton;
    }

    public SelenideElement getPasteButton() {
        return this.pasteButton;
    }

    public SelenideElement getPanelSelectButton() {
        return this.panelSelectButton;
    }

    public SelenideElement getDeleteButton() {
        return this.deleteButton.element();
    }

    public SelenideElement getGroupButton() {
        return this.groupButton;
    }

    public SelenideElement getStylesButton() {
        return this.stylesButton.element();
    }

    public SelenideElement getPolicyButton() {
        return this.policyButton.element();
    }

    public SelenideElement getUnlockStructureButton() {
        return this.unlockStructureButton.element();
    }

    public SelenideElement getLockStructureButton() {
        return this.lockStructureButton.element();
    }

    public SelenideElement getNewlineButton() {
        return this.newlineButton;
    }

    public SelenideElement getHideButton() {
        return this.hideButton;
    }

    public SelenideElement getUnhideButton() {
        return this.unhideButton;
    }

    public SelenideElement getRestoreAllButton() {
        return this.restoreAllButton;
    }

    public SelenideElement getAmountButton() {
        return this.amountButton;
    }

    public SelenideElement getResetButton() {
        return this.resetButton;
    }

    public SelenideElement getCloseButton() {
        return this.closeButton;
    }

    public SelenideElement getRestoreButton(String resourcePath) {
        return Selenide.$((String)String.format(RESTORE_BUTTON, resourcePath));
    }

    public <T extends EditorPage> T clickCopy() {
        return this.clickVoidAction(this.copyButton);
    }

    public <T extends EditorPage> T clickCut() {
        return this.clickVoidAction(this.cutButton);
    }

    public <T extends EditorPage> T clickPaste() {
        return this.clickVoidAction(this.pasteButton);
    }

    public <T extends EditorPage> T clickHide() {
        return this.clickVoidAction(this.hideButton);
    }

    public <T extends EditorPage> T clickRestoreall() {
        return this.clickVoidAction(this.restoreAllButton);
    }

    public <T extends EditorPage> T clickRestore(String resourcePath) {
        return this.clickVoidAction(this.getRestoreButton(resourcePath));
    }

    private <T extends EditorPage> T clickVoidAction(SelenideElement button) {
        ElementUtils.clickableClick(button);
        this.element().shouldNotBe(new Condition[]{Condition.visible});
        return (T)this.editorPage;
    }

    public InsertComponentDialog clickInsertComponent() {
        return Helpers.clickDialogAction(this.insertButton);
    }

    public Dialog clickConfigure() {
        return Helpers.clickDialogAction(this.configureButton);
    }

    public Dialog clickDelete() {
        return Helpers.clickDialogAction(this.deleteButton);
    }

    public PolicyDialog clickPolicy() {
        return Helpers.clickDialogAction(this.policyButton);
    }

    public Dialog clickUnlockStructure() {
        return Helpers.clickDialogAction(this.unlockStructureButton);
    }

    public Dialog clickLockStructure() {
        return Helpers.clickDialogAction(this.lockStructureButton);
    }

    public EditableToolbar clickLayout() {
        return this.clickEditableToolbarAction(this.layoutButton);
    }

    public EditableToolbar clickClose() {
        return this.clickEditableToolbarAction(this.closeButton);
    }

    public EditableToolbar clickNewLine() {
        return this.clickEditableToolbarAction(this.newlineButton);
    }

    public EditableToolbar clickGroup() {
        return this.clickEditableToolbarAction(this.groupButton);
    }

    public EditableToolbar clickParent() {
        return this.clickEditableToolbarAction(this.parentButton);
    }

    public EditableToolbar clickUnhide() {
        return this.clickEditableToolbarAction(this.unhideButton);
    }

    public EditableToolbar clickReset() {
        return this.clickEditableToolbarAction(this.resetButton);
    }

    public EditableToolbar clickPanelSelect() {
        return this.clickEditableToolbarAction(this.panelSelectButton);
    }

    protected EditableToolbar clickEditableToolbarAction(SelenideElement button) {
        ElementUtils.clickableClick(button);
        this.element().shouldBe(new Condition[]{Condition.visible});
        return this;
    }

    public StylesSelector clickStyles() {
        return Helpers.clickBaseComponentAction(this.stylesButton);
    }

    public EditableToolbar closeStyles(StylesSelector stylesSelector) {
        if (stylesSelector != null && stylesSelector.element().is(Condition.visible)) {
            ElementUtils.clickableClick(this.stylesButton.element());
            stylesSelector.element().shouldNotBe(new Condition[]{Condition.visible});
        }
        return this;
    }

    public InlineEditor clickEdit() {
        ElementUtils.clickableClick(this.editButton);
        this.inlineEditor.element().shouldBe(new Condition[]{Condition.visible});
        return this.inlineEditor;
    }

    public EditableToolbar selectParent(int index) {
        ElementsCollection parentButtons = Selenide.$((String)"coral-popover.is-open .cq-select-parent-list").findAll("button");
        ElementUtils.clickableClick(parentButtons.get(index));
        return this;
    }

    public static enum EditableToolbarAction {
        INSERT,
        CONFIGURE,
        PARENT,
        EDIT,
        LAYOUT,
        COPY,
        CUT,
        PASTE,
        DELETE,
        GROUP,
        STYLE,
        POLICY,
        STRUCTURE_OFF,
        STRUCTURE_ON,
        NEWLINE,
        HIDE,
        UNHIDE,
        AMOUNT,
        RESET,
        CLOSE,
        PANEL_SELECT;


        public String getSelector() {
            return "button[data-action='" + this.name() + "']";
        }

        public SelenideElement getButton() {
            return Selenide.$((String)EditableToolbar.EDITABLETOOLBAR_IDENTIFIER).find(this.getSelector());
        }
    }
}

