/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq;

import com.adobe.cq.testing.selenium.pagewidgets.common.ActionComponent;
import com.adobe.cq.testing.selenium.pagewidgets.common.BaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralButtonList;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralTagList;
import com.adobe.cq.testing.selenium.pagewidgets.cq.FormField;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import java.util.concurrent.Callable;

public class AutoCompleteField<V>
extends ActionComponent<V> {
    private static final String FOUNDATION_AUTOCOMPLETE = "foundation-autocomplete";
    private static final String SELECTOR_CSS = "css:";
    public static final String ARIA_CONTROLS = "aria-controls";
    private SelenideElement inputField;
    private CoralButtonList buttonList;

    public AutoCompleteField(String selector) {
        super(AutoCompleteField.getSelector(selector));
        this.init();
    }

    public AutoCompleteField(String selector, Callable<V> callableCode, boolean expectNav) {
        super(AutoCompleteField.getSelector(selector), callableCode, expectNav);
        this.init();
    }

    public AutoCompleteField(SelenideElement element, Callable<V> callableCode, boolean expectNav) {
        super(element, callableCode, expectNav);
        this.init();
    }

    @Override
    public <T extends BaseComponent> T click() {
        ElementUtils.clickableClick(this.element().$("button"));
        return (T)this;
    }

    private void init() {
        this.buttonList = new CoralButtonList(this.element());
        this.inputField = this.element().$("input[role=\"combobox\"]");
    }

    private static String getSelector(String selector) {
        if (selector.startsWith(SELECTOR_CSS)) {
            return FOUNDATION_AUTOCOMPLETE + selector.substring(SELECTOR_CSS.length());
        }
        return new FormField(selector).getFullyDecoratedElement(FOUNDATION_AUTOCOMPLETE, new String[0]).getSearchCriteria();
    }

    public void sendKeys(CharSequence ... keys) {
        this.inputField.sendKeys(keys);
    }

    public void clear() {
        this.inputField.setValue("");
    }

    public String value() {
        return this.inputField.getValue();
    }

    public CoralButtonList buttonlist() {
        String buttonId = this.inputField.shouldHave(new Condition[]{Condition.attribute((String)ARIA_CONTROLS)}).getAttribute(ARIA_CONTROLS);
        return new CoralButtonList(String.format("#%s", buttonId));
    }

    public CoralButtonList suggestions() {
        return new CoralButtonList(this.element().$("coral-overlay").should(new Condition[]{Condition.exist}));
    }

    public CoralTagList taglist() {
        return new CoralTagList(this.element());
    }
}

