/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;

public class VariantAccessor
extends AEMBaseComponent {
    public static final String VARIANT_ATTRIBUTE = "variant";

    public VariantAccessor(SelenideElement element) {
        super(element);
    }

    public SelenideElement find(VariantType variantType) {
        return this.findAll(variantType).first();
    }

    public ElementsCollection findAll(VariantType variantType, String tag) {
        SelenideElement currentElement = this.element();
        return currentElement.findAll(tag + "[" + VARIANT_ATTRIBUTE + "=\"" + variantType.toString() + "\"]");
    }

    public ElementsCollection findAll(VariantType variantType) {
        return this.findAll(variantType, "");
    }

    public void clickVariant(VariantType variantType) {
        ElementsCollection variantElements = this.findAll(variantType);
        SelenideElement clickableVariantElement = variantElements.stream().filter(selenideElement -> selenideElement.getTagName().equals("button") || selenideElement.getTagName().equals("a")).findFirst().get();
        ElementUtils.clickableClick(clickableVariantElement.shouldBe(new Condition[]{Condition.visible, Condition.enabled}));
    }

    public boolean isVariant(VariantType variantType) {
        return this.element().has(Condition.attribute((String)VARIANT_ATTRIBUTE, (String)variantType.toString()));
    }

    public static enum VariantType {
        PRIMARY,
        SECONDARY,
        DEFAULT,
        MINIMAL,
        SUCCESS,
        ERROR,
        QUIETACTION,
        _CUSTOM,
        WARNING;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

