/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.VariantAccessor;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public class Dialog
extends AEMBaseComponent {
    protected VariantAccessor variantAccessor;

    public Dialog() {
        super("coral-dialog[open]");
        this.init();
    }

    public Dialog(String cssSelector) {
        super(String.format("%s[open]", cssSelector));
        this.init();
    }

    public Dialog(SelenideElement element) {
        super(element);
        this.init();
    }

    private void init() {
        this.variantAccessor = this.adaptTo(VariantAccessor.class);
    }

    public SelenideElement title() {
        return Selenide.$((String)String.format("%s coral-dialog-header", this.getCssSelector()));
    }

    public SelenideElement content() {
        return Selenide.$((String)String.format("%s coral-dialog-content", this.getCssSelector()));
    }

    public boolean isSuccess() {
        return this.variantAccessor.isVariant(VariantAccessor.VariantType.SUCCESS);
    }

    public boolean isError() {
        return this.variantAccessor.isVariant(VariantAccessor.VariantType.ERROR);
    }

    public <T extends Dialog> T clickDefault() {
        this.variantAccessor.clickVariant(VariantAccessor.VariantType.DEFAULT);
        return (T)this;
    }

    public <T extends Dialog> T clickPrimary() {
        this.variantAccessor.clickVariant(VariantAccessor.VariantType.PRIMARY);
        return (T)this;
    }

    public <T extends Dialog> T clickSecondary() {
        this.variantAccessor.clickVariant(VariantAccessor.VariantType.SECONDARY);
        return (T)this;
    }

    public <T extends Dialog> T clickWarning() {
        this.variantAccessor.clickVariant(VariantAccessor.VariantType.WARNING);
        return (T)this;
    }

    public <T extends Dialog> T clickQuietAction() {
        this.variantAccessor.clickVariant(VariantAccessor.VariantType.QUIETACTION);
        return (T)this;
    }

    public SelenideElement button(VariantAccessor.VariantType variantType) {
        return this.variantAccessor.find(variantType);
    }
}

