/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;

public final class CoralSelectList
extends AEMBaseComponent {
    private static final String SELECTOR_ITEM_ELEMENT = "coral-selectlist-item";
    private static final String SELECTOR_ITEM_ELEMENT_CONTENT = "coral-selectlist-item-content";
    private static final String SELECTOR_GROUP_ELEMENT = "coral-selectlist-group";

    public CoralSelectList(SelenideElement parent) {
        super(parent.$("coral-selectlist"));
    }

    public CoralSelectList(String selector) {
        super(selector);
    }

    public ElementsCollection items() {
        return this.element().$$(SELECTOR_ITEM_ELEMENT);
    }

    public ElementsCollection items(SelenideElement group) {
        return group.findAll(SELECTOR_ITEM_ELEMENT);
    }

    public ElementsCollection groups() {
        return this.element().findAll(SELECTOR_GROUP_ELEMENT);
    }

    public SelenideElement getGroupByLabel(String label) {
        return this.element().$(String.format("%s[label=\"%s\"]", SELECTOR_GROUP_ELEMENT, label));
    }

    public SelenideElement getItemByValue(String value) {
        return this.element().$(String.format("%s[value=\"%s\"]", SELECTOR_ITEM_ELEMENT, value));
    }

    public SelenideElement selectedItem() {
        return this.element().$(String.format("%s[selected]", SELECTOR_ITEM_ELEMENT));
    }

    public String selectedItemLabel() {
        return this.selectedItem().find(SELECTOR_ITEM_ELEMENT_CONTENT).getText();
    }

    public void selectByValue(String value) {
        SelenideElement item = this.getItemByValue(value);
        if (item != null) {
            ElementUtils.clickableClick(item);
        }
    }

    public void selectByIndex(int index) {
        ElementsCollection elems = this.items();
        if (elems.size() > index) {
            SelenideElement elem = elems.get(index);
            ElementUtils.clickableClick(elem);
        }
    }

    public void selectByLabel(String label) {
        ElementsCollection elements = this.items();
        SelenideElement item = elements.find(Condition.text((String)label));
        if (item != null) {
            ElementUtils.clickableClick(item);
        }
    }

    public boolean hasItemBySelector(String selector) {
        return this.element().$(String.format("%s%s", SELECTOR_ITEM_ELEMENT, selector)).exists();
    }
}

