/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.util.stream.Stream;

public final class CoralList
extends AEMBaseComponent {
    private static final String SELECTOR_ITEM_ELEMENT = "coral-list-item";

    public CoralList(String cssSelector) {
        super(String.format("coral-list%s", cssSelector));
    }

    public Stream<CoralListItem> getItemsByAttribute(String attribute, String value) {
        return this.items().filter(e -> value.equals(e.element().attr(attribute)));
    }

    public CoralListItem selectedItem() {
        return new CoralListItem(this.element().$(String.format("%s[selected]", SELECTOR_ITEM_ELEMENT)));
    }

    public boolean hasItemByAttribute(String attribute, String value) {
        return this.items().anyMatch(e -> value.equals(e.element().attr(attribute)));
    }

    public Stream<CoralListItem> items() {
        return this.element().$$(SELECTOR_ITEM_ELEMENT).stream().map(x$0 -> new CoralListItem((SelenideElement)x$0));
    }

    public ElementsCollection itemsCollection() {
        return this.element().$$(SELECTOR_ITEM_ELEMENT);
    }

    public void waitForItemByAttribute(String attribute, String expectedValue) {
        Selenide.Wait().until(webDriver -> this.hasItemByAttribute(attribute, expectedValue));
    }

    public class CoralListItem
    extends AEMBaseComponent {
        private CoralListItem(SelenideElement element) {
            super(element);
        }
    }
}

