/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;

public final class CoralAnchorList
extends AEMBaseComponent {
    private static final String SELECTOR_ITEM_ELEMENT = "a[is=\"coral-anchorlist-item\"]";

    public CoralAnchorList(SelenideElement parent) {
        super(parent.$("coral-anchorlist"));
    }

    public CoralAnchorList(String selector) {
        super(selector);
    }

    public ElementsCollection items() {
        return this.element().$$(SELECTOR_ITEM_ELEMENT);
    }

    public void selectByIndex(int index) {
        ElementsCollection elems = this.items();
        if (elems.size() > index) {
            SelenideElement elem = elems.get(index);
            elem.shouldBe(new Condition[]{Condition.enabled, Condition.visible});
            elem.click();
            ElementUtils.clickableClick(elem);
        }
    }

    public void selectByLabel(String label) {
        ElementsCollection elements = this.items();
        SelenideElement item = elements.find(Condition.text((String)label));
        if (item != null) {
            ElementUtils.clickableClick(item);
        }
    }

    public void selectByTrackingValue(String trackingValue) {
        this.items().stream().map(AEMBaseComponent::new).filter(e -> trackingValue.equals(e.getTrackingElement())).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find matching element for " + trackingValue)).click();
    }
}

