/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralClock;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.codeborne.selenide.SelenideElement;

public final class CalendarPicker
extends AEMBaseComponent {
    public CalendarPicker(String name) {
        super(String.format("coral-datepicker[name=\"%s\"]", name));
    }

    public CalendarPicker(SelenideElement element) {
        super(element);
    }

    public SelenideElement calendarButton() {
        String pickerType = this.getPickerType();
        if ("time".equals(pickerType)) {
            return this.element().$("button coral-icon[icon=\"clock\"]");
        }
        return this.element().$("button coral-icon[icon=\"calendar\"]");
    }

    public CoralPopOver popover() {
        return CoralPopOver.firstOpened();
    }

    public SelenideElement today() {
        return this.popover().element().$("a.is-today");
    }

    public SelenideElement date(int dayOfMonth) {
        return this.popover().element().$$("a.is-currentMonth").get(dayOfMonth);
    }

    public SelenideElement prev() {
        return this.popover().element().$("button[handle=\"prev\"]");
    }

    public SelenideElement next() {
        return this.popover().element().$("button[handle=\"next\"]");
    }

    public CoralClock clock() {
        return new CoralClock(this.popover().element());
    }

    public String getPickerType() {
        return this.element().getAttribute("type");
    }

    public String getValue() {
        return this.element().$("input[handle=\"hiddenInput\"]").getValue();
    }
}

