/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.common;

import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseComponent {
    private static final Logger LOG = LoggerFactory.getLogger(BaseComponent.class);
    protected final String cssSelector;
    protected SelenideElement currentElement;

    public BaseComponent(String selector) {
        this.cssSelector = selector;
        this.currentElement = Selenide.$((String)this.cssSelector);
    }

    public BaseComponent(SelenideElement element) {
        this.cssSelector = element.getSearchCriteria();
        this.currentElement = element;
    }

    public boolean isExisting() {
        return this.element().exists();
    }

    public boolean isVisibleWithinViewport() {
        return this.element().isDisplayed();
    }

    public boolean isVisible() {
        return this.element().isDisplayed();
    }

    public <T extends BaseComponent> T waitVisible() {
        Helpers.waitForElementAnimationFinished(this.cssSelector);
        this.element().shouldBe(new Condition[]{Condition.visible});
        return (T)this;
    }

    public <T extends BaseComponent> T waitVanish() {
        this.element().shouldNotBe(new Condition[]{Condition.visible});
        return (T)this;
    }

    public <T extends BaseComponent> T waitEnabled() {
        this.element().shouldBe(new Condition[]{Condition.enabled});
        return (T)this;
    }

    public <T extends BaseComponent> T waitDisabled() {
        this.element().shouldBe(new Condition[]{Condition.disabled});
        return (T)this;
    }

    public <T extends BaseComponent> T render() {
        this.element().shouldBe(Constants.EXISTS_ENABLED_VISIBLE);
        Helpers.waitForElementAnimationFinished(this.cssSelector);
        return (T)this;
    }

    public <T extends BaseComponent> T click() {
        ElementUtils.clickableClick(this.element());
        return (T)this;
    }

    public String getCssSelector() {
        return this.cssSelector;
    }

    public <T extends BaseComponent> T scrollTo() {
        this.element().scrollTo();
        return (T)this;
    }

    public SelenideElement element() {
        return this.currentElement;
    }

    public <T extends BaseComponent> T waitReady() {
        this.waitEnabled();
        return (T)this;
    }

    public <T extends BaseComponent> T adaptTo(Class<T> adapterClass) {
        BaseComponent output = null;
        try {
            output = (BaseComponent)adapterClass.getConstructor(SelenideElement.class).newInstance(this.element());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Cannot instantiate {} due to error", adapterClass, (Object)e);
        }
        return (T)output;
    }
}

