/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject.granite;

import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralReady;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralToast;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.http.client.utils.URIBuilder;

public class BasePage {
    private static final int NETWORK_POLLING_INTERVAL = 250;
    private static final SelenideElement UI_MASK = Selenide.$((String)"div.foundation-ui-mask");
    private final URI baseURI;
    private String path;

    public BasePage(URI base, String pagePath) {
        this.baseURI = base;
        this.path = pagePath;
    }

    public BasePage(String pagePath) {
        this.baseURI = null;
        this.path = pagePath;
    }

    public String getPath() {
        return this.path;
    }

    public String getEditedPath() {
        return Selenide.$((String)".foundation-content-path").data("foundation-content-path");
    }

    public String getUrl() {
        String url;
        URIBuilder uriBuilder;
        if (this.baseURI == null) {
            boolean graniteExists = (Boolean)Selenide.executeJavaScript((String)"return typeof Granite !== 'undefined';", (Object[])new Object[0]);
            if (graniteExists) {
                String externalized = (String)Selenide.executeJavaScript((String)"return Granite.HTTP.externalize(arguments[0]);", (Object[])new Object[]{this.path});
                uriBuilder = this.getURIAbsolutePath(externalized);
            } else {
                uriBuilder = this.getURIAbsolutePath(this.path);
            }
        } else {
            uriBuilder = new URIBuilder(this.baseURI);
            String basePath = uriBuilder.getPath();
            if (basePath.endsWith("/")) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            uriBuilder.setPath(basePath + this.path);
        }
        try {
            url = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot get the url due to syntax", e);
        }
        return url;
    }

    private URIBuilder getURIAbsolutePath(String absolutePath) {
        URIBuilder uriBuilder;
        try {
            URIBuilder uriAbsolute = new URIBuilder(absolutePath);
            List queryParams = uriAbsolute.getQueryParams();
            uriBuilder = new URIBuilder(WebDriverRunner.url());
            uriBuilder.clearParameters();
            uriBuilder.setFragment(uriAbsolute.getFragment());
            if (!queryParams.isEmpty()) {
                uriBuilder.setParameters(queryParams);
            }
            uriBuilder.setPath(uriAbsolute.getPath());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot parse the url " + WebDriverRunner.url(), e);
        }
        return uriBuilder;
    }

    public <T extends BasePage> T open(@Nonnull String pagePath) {
        this.path = pagePath;
        return this.open();
    }

    public <T extends BasePage> T open() {
        Selenide.open((String)this.getUrl());
        this.waitReady();
        return (T)this;
    }

    public BasePage openInNewWindow(String pagePath) {
        if (pagePath != null) {
            this.path = pagePath;
        }
        return this;
    }

    public void refresh() {
        Selenide.refresh();
    }

    public void waitReady() {
        Helpers.switchToAemContentFrame();
        Helpers.waitNetworkIdled(250L);
        Helpers.waitDocumentLoadCompleted();
        CoralReady.waitCoralReady();
    }

    public void waitMasked() {
        UI_MASK.should(new Condition[]{Condition.exist});
    }

    public void waitUnmasked() {
        UI_MASK.shouldNot(new Condition[]{Condition.exist});
    }

    public boolean isOpen() {
        boolean result;
        try {
            URIBuilder uriBuilder = new URIBuilder(WebDriverRunner.url());
            result = uriBuilder.getPath().contains(this.path);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public void waitForMessage(String message) {
        CoralToast toast = new CoralToast();
        toast.waitVisible();
        toast.element().shouldHave(new Condition[]{Condition.matchText((String)message)});
        toast.waitVanish();
    }
}

