/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject.cq.sites;

import com.adobe.cq.testing.selenium.pageobject.cq.sites.CreateLiveCopyWizard;
import com.adobe.cq.testing.selenium.pageobject.cq.sites.CreateSiteWizard;
import com.adobe.cq.testing.selenium.pageobject.cq.sites.CreateWorkflowWizard;
import com.adobe.cq.testing.selenium.pageobject.cq.sites.RestoreTreeWizard;
import com.adobe.cq.testing.selenium.pageobject.cq.sites.RestoreVersionWizard;
import com.adobe.cq.testing.selenium.pageobject.granite.CollectionPage;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralActionBar;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralAnchorList;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.adobe.cq.testing.selenium.pagewidgets.cq.actions.CreateActions;
import com.adobe.cq.testing.selenium.pagewidgets.cq.sites.CreatePageWizard;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.adobe.cq.testing.selenium.utils.ExpectNav;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import javax.annotation.Nonnull;

public class SitesPage
extends CollectionPage {
    private static final String BASE_PATH = "/sites.html";
    private final CreateActions createActions = new CreateActions();

    public SitesPage() {
        super(BASE_PATH);
    }

    @Override
    public SitesPage open(@Nonnull String path) {
        super.open(String.format("%s%s", BASE_PATH, path));
        return this;
    }

    public SitesPage open() {
        super.open();
        return this;
    }

    public CreateActions createAction() {
        return this.createActions;
    }

    public SitesToolbarActions actions() {
        return new SitesToolbarActions();
    }

    public static final class SitesToolbarActions {
        private static SelenideElement deselect = Selenide.$((String)"button.granite-collection-deselect");
        private static SelenideElement create = Selenide.$((String)"button.cq-siteadmin-admin-actions-create-activator");
        private static SelenideElement edit = Selenide.$((String)"button.cq-siteadmin-admin-actions-edit-activator");
        private static SelenideElement properties = Selenide.$((String)"button.cq-siteadmin-admin-actions-properties-activator");
        private static SelenideElement folderProperties = Selenide.$((String)"button.cq-siteadmin-admin-actions-folderproperties-activator");
        private static SelenideElement lock = Selenide.$((String)"button.cq-siteadmin-admin-actions-lockpage-activator");
        private static SelenideElement unlock = Selenide.$((String)"button.cq-siteadmin-admin-actions-unlockpage-activator");
        private static SelenideElement copy = Selenide.$((String)"button.cq-siteadmin-admin-actions-copy-activator");
        private static SelenideElement move = Selenide.$((String)"button.cq-siteadmin-admin-actions-move-activator");
        private static SelenideElement more = Selenide.$((String)"button[coral-actionbar-more]");
        private static SelenideElement quickpublish = Selenide.$((String)"button.cq-siteadmin-admin-actions-quickpublish-activator");
        private static SelenideElement publish = Selenide.$((String)"button.cq-siteadmin-admin-actions-publish-activator");
        private static SelenideElement publishLater = Selenide.$((String)"button.cq-siteadmin-admin-actions-publishlater-activator");
        private static SelenideElement unpublish = Selenide.$((String)"button.cq-siteadmin-admin-actions-unpublish-activator");
        private static SelenideElement delete = Selenide.$((String)"button.cq-siteadmin-admin-actions-delete-activator");
        private static SelenideElement selectAll = Selenide.$((String)"button.foundation-collection-selectall");
        private static SelenideElement restore = Selenide.$((String)"button.cq-siteadmin-admin-actions-restore-activator");
        private static SelenideElement restoreVersion = Selenide.$((String)"a.cq-siteadmin-admin-restoreversion");

        private SitesToolbarActions() {
        }

        public SelenideElement getDeselect() {
            return deselect;
        }

        public SelenideElement getCreate() {
            return create;
        }

        public SelenideElement getEdit() {
            return edit;
        }

        public SelenideElement getProperties() {
            return properties;
        }

        public SelenideElement getFolderProperties() {
            return folderProperties;
        }

        public SelenideElement getLock() {
            return lock;
        }

        public SelenideElement getUnlock() {
            return unlock;
        }

        public static SelenideElement getCopy() {
            return copy;
        }

        public SelenideElement getMove() {
            return move;
        }

        public SelenideElement getMore() {
            return more;
        }

        public SelenideElement getQuickPublish() {
            return quickpublish;
        }

        public SelenideElement getPublish() {
            return publish;
        }

        public SelenideElement getPublishLater() {
            return publishLater;
        }

        public SelenideElement getUnpublish() {
            return unpublish;
        }

        public SelenideElement getDelete() {
            return delete;
        }

        public SelenideElement getSelectAll() {
            return selectAll;
        }

        public SelenideElement getRestore() {
            return restore;
        }
    }

    public static final class SitesPageSmartActions {
        private final SitesPage sitesPage;

        private SitesPageSmartActions(SitesPage context) {
            this.sitesPage = context;
        }

        private SelenideElement getCreateAction(CreateActions.SitesCreateActionType type) {
            CreateActions action = this.sitesPage.createAction();
            action.click();
            return action.getAction(type);
        }

        public CreateSiteWizard openCreateSiteWizard() {
            SelenideElement createAction = this.getCreateAction(CreateActions.SitesCreateActionType.SITE);
            ExpectNav.on(() -> ElementUtils.clickableClick(createAction));
            CreateSiteWizard wizard = new CreateSiteWizard();
            wizard.waitReady();
            return wizard;
        }

        public CreatePageWizard openCreatePageWizard() {
            SelenideElement createAction = this.getCreateAction(CreateActions.SitesCreateActionType.PAGE);
            ExpectNav.on(() -> ElementUtils.clickableClick(createAction));
            CreatePageWizard wizard = new CreatePageWizard();
            wizard.waitReady();
            return wizard;
        }

        public CreateWorkflowWizard openCreateWorkflowWizard() {
            ExpectNav.on(() -> this.openActionBarCreate().selectByLabel("Workflow"));
            CreateWorkflowWizard wizard = new CreateWorkflowWizard();
            wizard.waitReady();
            return wizard;
        }

        public CreateLiveCopyWizard openCreateLiveCopyWizard() {
            ExpectNav.on(() -> this.openActionBarCreate().selectByLabel("Live Copy"));
            CreateLiveCopyWizard wizard = new CreateLiveCopyWizard();
            wizard.waitReady();
            return wizard;
        }

        public CoralAnchorList openActionBarCreate() {
            CoralActionBar actionBar = this.sitesPage.actionBar();
            actionBar.waitVisible();
            ElementUtils.clickableClick(this.sitesPage.actions().getCreate());
            return new CoralAnchorList(CoralPopOver.firstOpened().element());
        }

        public CoralAnchorList openActionBarRestore() {
            CoralActionBar actionBar = this.sitesPage.actionBar();
            actionBar.waitVisible();
            ElementUtils.clickableClick(this.sitesPage.actions().getRestore());
            return new CoralAnchorList(CoralPopOver.firstOpened().element());
        }

        public RestoreVersionWizard openRestoreVersionWizard() {
            ExpectNav.on(() -> this.openActionBarRestore().selectByLabel("Restore Version"));
            RestoreVersionWizard wizard = new RestoreVersionWizard();
            wizard.waitReady();
            return wizard;
        }

        public RestoreTreeWizard openRestoreTreeWizard() {
            ExpectNav.on(() -> this.openActionBarRestore().selectByLabel("Restore Tree"));
            RestoreTreeWizard wizard = new RestoreTreeWizard();
            wizard.waitReady();
            return wizard;
        }
    }
}

