/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.junit.extensions;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.selenium.junit.extensions.SlingClientExtension;
import com.adobe.cq.testing.selenium.utils.TestContentBuilder;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

public final class TestContentExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final String KEY_PREFIX = "_tcb_";
    private static final ExtensionContext.Namespace THIS_STORE = ExtensionContext.Namespace.GLOBAL;
    private final String runmode;

    public TestContentExtension(String runMode) {
        this.runmode = runMode;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        TestContentBuilder testContentBuilder = (TestContentBuilder)context.getStore(THIS_STORE).remove((Object)this.getKey(), TestContentBuilder.class);
        testContentBuilder.dispose();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        TestContentBuilder testContentBuilder = new TestContentBuilder((CQClient)SlingClientExtension.Store.getInstance().getOrCompute(context, this.runmode, false).adaptTo(CQClient.class), ((Method)context.getTestMethod().orElseThrow(Exception::new)).getName());
        context.getStore(THIS_STORE).put((Object)this.getKey(), (Object)testContentBuilder);
    }

    private String getKey() {
        return KEY_PREFIX + Thread.currentThread().getId();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        return TestContentBuilder.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.GLOBAL).get((Object)this.getKey(), TestContentBuilder.class);
    }
}

