/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.junit.extensions;

import io.netty.handler.codec.http.HttpResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.lightbody.bmp.filters.ResponseFilter;
import net.lightbody.bmp.util.HttpMessageContents;
import net.lightbody.bmp.util.HttpMessageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloader
implements ResponseFilter {
    public static final String CONFIG_DEFAULT_DOWNLOAD_PATH = "build/reports/test";
    private static final Logger logger = LoggerFactory.getLogger(FileDownloader.class);
    private Set<String> contentTypes = new HashSet<String>();
    private File tempDir = new File("build/reports/test");
    private boolean deleteTempFiles = false;

    public FileDownloader addContentType(String contentType) {
        this.contentTypes.add(contentType);
        return this;
    }

    public FileDownloader deleteTempFiles(boolean deleteTempFiles) {
        this.deleteTempFiles = deleteTempFiles;
        return this;
    }

    public FileDownloader setDownloadPath(String path) {
        this.tempDir = new File(path);
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
        return this;
    }

    public static FileDownloader withContent(String contentType) {
        return new FileDownloader().addContentType(contentType);
    }

    public static FileDownloader withContents(String ... contentType) {
        FileDownloader downloader = new FileDownloader();
        for (int i = 0; i < contentType.length; ++i) {
            downloader.addContentType(contentType[i]);
        }
        return downloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterResponse(HttpResponse response, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        String contentType;
        if (this.tempDir == null) {
            this.setDownloadPath(CONFIG_DEFAULT_DOWNLOAD_PATH);
        }
        if (this.contentTypes.contains(contentType = response.headers().get("Content-Type"))) {
            logger.info("Filter download for " + messageInfo.getOriginalRequest().uri());
            String tempPath = null;
            try {
                String postfix = contentType.substring(contentType.indexOf(47) + 1);
                File tempFile = File.createTempFile("downloaded", "." + postfix, this.tempDir);
                String string = tempPath = tempFile == null ? "" : tempFile.getAbsolutePath();
                if (this.deleteTempFiles) {
                    tempFile.deleteOnExit();
                }
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                outputStream.write(contents.getBinaryContents());
                outputStream.close();
                logger.info("Saved file to " + tempPath);
                contents.setTextContents(tempPath);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                response.headers().remove("Content-Type");
                response.headers().remove("Content-Encoding");
                response.headers().remove("Content-Disposition");
                response.headers().add("Content-Type", (Object)"text/html");
                response.headers().add("Content-Length", (Object)("" + tempPath.length()));
            }
        }
    }
}

