/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.JsonUtils;

public class TogglesClient
extends CQClient {
    private static final String TOGGLES_PATH = "etc.clientlibs/toggles.json";

    public TogglesClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public TogglesClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public List<String> getEnabledToggles() throws ClientException {
        ArrayList<String> enabledToggles = new ArrayList<String>();
        SlingHttpResponse response = this.doGet(TOGGLES_PATH, new int[]{200});
        JsonUtils.getJsonNodeFromString((String)response.getContent()).path("enabled").forEach(node -> enabledToggles.add(node.textValue()));
        return enabledToggles;
    }

    public boolean isToggleEnabled(String toggle) throws ClientException {
        return this.getEnabledToggles().contains(toggle);
    }
}

