/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.jobs.JobDescriptor;
import com.adobe.cq.testing.client.jobs.JobQueueStat;
import com.adobe.cq.testing.client.jobs.JobsList;
import com.adobe.cq.testing.client.jobs.JobsStatistics;
import com.adobe.cq.testing.client.jobs.TopicStat;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;

public class JobsClient
extends CQClient {
    public static final String QE_QUEUES_SERVLET_PATH = "/libs/granite/qe/jobqueues";
    public static final String QE_JOBS_SERVLET_PATH = "/libs/granite/qe/jobs";
    public static final String QE_JOBS_ALL_SELECTOR = "all";
    public static final String QE_JOBS_JSON_EXTENSION = "json";
    public static final String QE_QUEUES_ALL_PATH = "/libs/granite/qe/jobqueues.all.json";
    public static final String QE_JOBS_ALL_PATH = "/libs/granite/qe/jobs.all.json";

    public JobsClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public JobsClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public JobsStatistics getJobsStatistics() throws ClientException {
        SlingHttpResponse exec = this.doGet(QE_QUEUES_ALL_PATH, new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])new int[0]));
        JsonNode statsJson = JsonUtils.getJsonNodeFromString((String)exec.getContent());
        JsonNode data = statsJson.get("data");
        JobsStatistics jobsStatistics = new JobsStatistics();
        Iterator activeQueuesIter = data.get("active_queues").fieldNames();
        while (activeQueuesIter.hasNext()) {
            String queueName = (String)activeQueuesIter.next();
            JsonNode queueJson = data.get("active_queues").get(queueName);
            jobsStatistics.addJobQueueStat(new JobQueueStat(queueName, queueJson));
        }
        Iterator topicsIter = data.get("topic_statistics").elements();
        while (topicsIter.hasNext()) {
            jobsStatistics.addTopicStat(new TopicStat((JsonNode)topicsIter.next()));
        }
        return jobsStatistics;
    }

    public JobsList getJobs(String topic) throws ClientException {
        SlingHttpResponse exec = this.doGet(QE_JOBS_ALL_PATH, Collections.singletonList(new BasicNameValuePair("topic", topic)), new int[]{200});
        JsonNode statsJson = JsonUtils.getJsonNodeFromString((String)exec.getContent());
        JsonNode data = statsJson.get("data");
        ArrayList<JobDescriptor> active = this.extractJobDescriptors(data.get("active"));
        ArrayList<JobDescriptor> queued = this.extractJobDescriptors(data.get("queued"));
        return new JobsList(active, queued);
    }

    private ArrayList<JobDescriptor> extractJobDescriptors(JsonNode root) {
        ArrayList<JobDescriptor> jobDescriptors = new ArrayList<JobDescriptor>();
        Iterator elems = root.fieldNames();
        while (elems.hasNext()) {
            String jobId = (String)elems.next();
            JsonNode jobNode = root.get(jobId);
            JobDescriptor jd = new JobDescriptor();
            jd.setId(jobId);
            jd.setName(jobNode.get("name").textValue());
            jd.setTopic(jobNode.get("topic").textValue());
            jd.setQueueName(jobNode.get("queue_name").textValue());
            jd.setCreateTime(jobNode.get("created").longValue());
            jd.setStartTime(jobNode.get("processing_started").longValue());
            jd.setMaxRetries(jobNode.get("max_retries").intValue());
            jd.setRetryCount(jobNode.get("retry_count").intValue());
            jd.setCreatedBy(jobNode.get("created_by").textValue());
            jd.setTargetInstanceId(jobNode.get("target_instance").textValue());
            jobDescriptors.add(jd);
        }
        return jobDescriptors;
    }
}

