/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.FormClient;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

public class CommerceClient
extends FormClient {
    public final String PRODUCT_PAGE_RESOURCE_TYPE = "weretail/components/structure/page";
    public final String PROXY_PRODUCT_PAGE_RESOURCE_TYPE = "commerce/components/productpageproxy";
    private String commerceCookieName = "CommercePersistence";

    public CommerceClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public CommerceClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public SlingHttpResponse doCommercePost(String path, String cookieText, Map<String, String> parameters) throws ClientException {
        assert (this.commerceCookieName != null);
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>(2);
        headers.add(new BasicHeader("Cookie", this.commerceCookieName + "=" + this.urlEncode(cookieText)));
        headers.add(new BasicHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8"));
        return this.doPost(path, (HttpEntity)FormEntityBuilder.create().addAllParameters(parameters).build(), headers, new int[0]);
    }

    public SlingHttpResponse doCommerceGet(String path, String cookieText) throws ClientException {
        assert (this.commerceCookieName != null);
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>(1);
        headers.add(new BasicHeader("Cookie", this.commerceCookieName + "=" + this.urlEncode(cookieText)));
        return this.doGet(path, null, headers, new int[0]);
    }

    public JsonNode getCart(String homePath) throws ClientException {
        return this.doGetJson(homePath + "/commerce/cart", -1, new int[0]);
    }

    public JsonNode getOrders() throws ClientException {
        return this.doGetJson("/etc/commerce/orders", -1, new int[0]);
    }

    public String getCommerceCookieText(HttpResponse resp) {
        Header[] headers;
        assert (this.commerceCookieName != null);
        String commerceCookiePreamble = this.commerceCookieName + "=";
        for (Header header : headers = resp.getHeaders("Set-Cookie")) {
            String s = header.getValue();
            if (!s.startsWith(commerceCookiePreamble)) continue;
            try {
                return this.urlDecode(s.substring(commerceCookiePreamble.length()));
            }
            catch (ClientException e) {
                LOG.error("Failed to decode commerce cookie", (Throwable)e);
            }
        }
        return "";
    }

    public void clearCommerceContext(String homePath) throws ClientException {
        String commercePath = homePath + "/commerce";
        if (this.exists(commercePath)) {
            this.deletePath(commercePath, new int[0]);
        }
    }

    public SlingHttpResponse createCatalog(String source, String dest, String label, String title, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.createCatalog(source, dest, label, title, expectedStatus);
    }

    public SlingHttpResponse rolloutSection(String source, String dest, boolean force, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.rolloutSection(source, dest, force, expectedStatus);
    }

    public SlingHttpResponse createClassification(String managementPath, String parentPath, String title, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "createClassification").addParameter("parentPath", parentPath).addParameter("title", title).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse removeClassification(String managementPath, String classificationPath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "removeClassification").addParameter("path", classificationPath).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse addRootCategory(String managementPath, String classificationPath, String title, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "createRootCategory").addParameter("path", classificationPath).addParameter("title", title).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse addCategory(String managementPath, String parentCategoryPath, String title, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "createCategory").addParameter("parentPath", parentCategoryPath).addParameter("title", title).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse removeCategory(String managementPath, String categoryPath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "removeCategory").addParameter("path", categoryPath).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse updateCategory(String managementPath, String categoryPath, String title, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "updateCategory").addParameter("path", categoryPath).addParameter("title", title).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse addAttribute(String managementPath, String categoryPath, String title, String attrName, String attrUnit, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "addAttribute").addParameter("parentPath", categoryPath).addParameter("title", title).addParameter("attributeName", attrName).addParameter("attributeUnit", attrUnit).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse createCollection(String managementPath, String parentPath, String title, String type, String search, String searchType, String[] referencePaths, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "createCollection").addParameter("collectionParentPath", parentPath).addParameter("collectionTitle", title).addParameter("_charset_", "utf-8");
        if (search != null) {
            form.addParameter("search", search);
        }
        if (searchType != null) {
            form.addParameter("searchType", searchType);
        }
        if (type != null) {
            form.addParameter("collectionType", type);
        }
        if (referencePaths != null) {
            for (String ref : referencePaths) {
                form.addParameter("referencePaths", ref);
            }
        }
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse createCollection(String managementPath, String parentPath, String title, String type, String[] referencePaths, int ... expectedStatus) throws ClientException {
        return this.createCollection(managementPath, parentPath, title, type, null, null, referencePaths, expectedStatus);
    }

    public SlingHttpResponse updateCollection(String managementPath, String collectionPath, String title, String[] referencePaths, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "updateCollection").addParameter("collectionPath", collectionPath).addParameter("collectionTitle", title).addParameter("_charset_", "utf-8");
        if (referencePaths != null) {
            for (String ref : referencePaths) {
                form.addParameter("referencePaths", ref);
            }
        }
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse removeCollection(String managementPath, String collectionPath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "removeCollection").addParameter("collectionPath", collectionPath).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse addReferences(String managementPath, String collectionPath, String[] referencePaths, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "addReferences").addParameter("collectionPath", collectionPath).addParameter("_charset_", "utf-8");
        if (referencePaths != null) {
            for (String ref : referencePaths) {
                form.addParameter("referencePaths", ref);
            }
        }
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse removeReferences(String managementPath, String collectionPath, String[] referencePaths, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "removeReferences").addParameter("collectionPath", collectionPath).addParameter("_charset_", "utf-8");
        if (referencePaths != null) {
            for (String ref : referencePaths) {
                form.addParameter("referencePaths", ref);
            }
        }
        return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
    }

    public SlingHttpResponse createSmartList(String managementPath, String title, boolean defaultList, String redirect, List<Header> headers, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "createSmartList").addParameter("title", title).addParameter("default", defaultList ? "on" : "off").addParameter("redirect", redirect).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), headers, expectedStatus);
    }

    public SlingHttpResponse manageSmartListsDelete(String managementPath, String title, String[] delete, String redirect, List<Header> headers, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "manageSmartLists").addParameter("title", title).addParameter("redirect", redirect).addParameter("_charset_", "utf-8");
        if (delete != null) {
            for (String del : delete) {
                form.addParameter("delete", del);
            }
        }
        return this.doPost(managementPath, (HttpEntity)form.build(), headers, expectedStatus);
    }

    public SlingHttpResponse manageSmartListsDefault(String managementPath, String title, String[] defaultList, String redirect, List<Header> headers, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "manageSmartLists").addParameter("title", title).addParameter("redirect", redirect).addParameter("_charset_", "utf-8");
        if (defaultList != null) {
            for (String def : defaultList) {
                form.addParameter("default", def);
            }
        }
        return this.doPost(managementPath, (HttpEntity)form.build(), headers, expectedStatus);
    }

    public SlingHttpResponse editSmartList(String managementPath, String listPath, String redirect, String title, String description, List<Header> headers, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "editSmartList").addParameter("smartlist-path", listPath).addParameter("redirect", redirect).addParameter("title", title).addParameter("description", description).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), headers, expectedStatus);
    }

    public SlingHttpResponse addToSmartList(String managementPath, String productPath, String listName, String redirect, List<Header> headers, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "addToSmartList").addParameter("product-path", productPath).addParameter("redirect", redirect).addParameter("_charset_", "utf-8");
        if (listName != null) {
            form.addParameter("smartlist-path", listName);
        }
        if (headers == null || headers.size() <= 0) {
            return this.doPost(managementPath, (HttpEntity)form.build(), expectedStatus);
        }
        return this.doPost(managementPath, (HttpEntity)form.build(), headers, expectedStatus);
    }

    public SlingHttpResponse deleteSmartListEntry(String managementPath, String productPath, String listName, String redirect, List<Header> headers, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "deleteSmartListEntry").addParameter("product-path", productPath).addParameter("smartlist-path", listName).addParameter("redirect", redirect).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), headers, expectedStatus);
    }

    public SlingHttpResponse modifyQuantitySmartListEntry(String managementPath, String productPath, String listPath, String redirect, String quantity, List<Header> headers, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "modifyQuantitySmartListEntry").addParameter("product-path", productPath).addParameter("smartlist-path", listPath).addParameter("redirect", redirect).addParameter("quantity", quantity).addParameter("_charset_", "utf-8");
        return this.doPost(managementPath, (HttpEntity)form.build(), headers, expectedStatus);
    }

    public SlingHttpResponse addToCart(String managementPath, String productPath, String listPath, boolean delete, String redirect, List<Header> headers, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":operation", "addToCart").addParameter("smartlist-path", listPath).addParameter("delete", delete ? "on" : "off").addParameter("redirect", redirect).addParameter("_charset_", "utf-8");
        if (productPath != null) {
            form.addParameter("product-path", productPath);
        }
        return this.doPost(managementPath, (HttpEntity)form.build(), headers, expectedStatus);
    }

    public SlingHttpResponse configureProductComponent(String productPagePath, String productPath) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./sling:resourceType", "weretail/components/structure/product").addParameter("./image/isDecorative@Delete", "true").addParameter("./productData", productPath);
        String productComponent = productPagePath + "/_jcr_content/root/product";
        this.doPost(productComponent, (HttpEntity)form.build(), new int[]{200});
        form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter(":operation", "checkVariantHierarchy").addParameter("catalogPath", productPagePath + "/jcr:content/root/product");
        return this.doPost("/libs/commerce/products", (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse addProduct(String parent, String title, double price) throws ClientException {
        return this.addProduct(parent, title, price, null, null, null, null);
    }

    public SlingHttpResponse addProduct(String parent, String title, double price, String description, String sku, String color, String size) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./jcr:primaryType", "nt:unstructured").addParameter("parentPath", parent).addParameter("./jcr:title", title).addParameter("./price@TypeHint", "Decimal").addParameter("./cq:commerceType", "product").addParameter("./sling:resourceType", "commerce/components/product").addParameter("./jcr:mixinTypes", "cq:Taggable").addParameter("./jcr:mixinTypes@TypeHint", "String[]").addParameter("./price", String.valueOf(price)).addParameter("./jcr:lastModified", "").addParameter("./jcr:lastModified@TypeHint", "Date");
        if (description != null) {
            form.addParameter("./jcr:description", description);
        }
        if (sku != null) {
            form.addParameter("./identifier", sku);
        }
        if (color != null) {
            form.addParameter("./color", color);
        }
        if (size != null) {
            form.addParameter("./size", size);
        }
        return this.doPost(parent + "/*", (HttpEntity)form.build(), new int[]{201});
    }

    public SlingHttpResponse addTagToProduct(String tagPath, String productPath) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./cq:tags@TypeHint", "String[]").addParameter("./cq:tags", tagPath);
        return this.doPost(productPath, (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse addProductAsset(String product, String asset) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("productPath", product).addParameter("assetReference", asset);
        return this.doPost("/apps/weretail/content/scaffolding/we-retail/product/jcr:content/cq:dialog/content/items/columns/items/column1/items/images/image.create.html", (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse updateProductAsset(String productAssetPath, String newAsset) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("productAssetPath", productAssetPath).addParameter("assetReference", newAsset);
        return this.doPost("/apps/weretail/content/scaffolding/we-retail/product/jcr:content/cq:dialog/content/items/columns/items/column1/items/images/image.update.html", (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse deleteProductAsset(String productAssetPath) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("productAssetPath", productAssetPath);
        return this.doPost("/apps/weretail/content/scaffolding/we-retail/product/jcr:content/cq:dialog/content/items/columns/items/column1/items/images/image.remove.html", (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse addProductVariant(String parentProduct, String title, double price, String description, String sku, String color, String size) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("parentPath", parentProduct).addParameter("./jcr:title", title).addParameter("./price", String.valueOf(price)).addParameter("./price@TypeHint", "Decimal").addParameter("./jcr:primaryType", "nt:unstructured").addParameter("./cq:commerceType", "variant").addParameter("./sling:resourceType", "commerce/components/product").addParameter("./jcr:mixinTypes", "cq:Taggable").addParameter("./jcr:mixinTypes@TypeHint", "String[]").addParameter("./jcr:lastModified", "").addParameter("./jcr:lastModified@TypeHint", "Date");
        if (description != null) {
            form.addParameter("./jcr:description", description);
        }
        if (sku != null) {
            form.addParameter("./identifier", sku);
        }
        if (color != null) {
            form.addParameter("./color", color);
        }
        if (size != null) {
            form.addParameter("./size", size);
        }
        return this.doPost(parentProduct + "/*", (HttpEntity)form.build(), new int[]{201});
    }

    public SlingHttpResponse createBlueprint(String title, String description, String parentPath, String catalogTemplate, String sectionTemplate, String productTemplate, boolean proxyPages) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./jcr:content/templates/catalog", catalogTemplate).addParameter("./jcr:content/templates/section", sectionTemplate).addParameter("./jcr:content/templates/product", productTemplate).addParameter("./jcr:content/templates/proxyProductPages", proxyPages ? "true" : "false").addParameter("./jcr:content/filter/searchType", "simple").addParameter("./jcr:content/jcr:title", title).addParameter("./jcr:content/jcr:description", description).addParameter("./jcr:content/jcr:primaryType", "cq:PageContent").addParameter("./jcr:content/sling:resourceType", "commerce/components/catalog").addParameter("./jcr:content/cq:template", "/libs/commerce/templates/catalog").addParameter("./jcr:content/cq:catalogVersion", "561").addParameter("./jcr:primaryType", "cq:Page").addParameter("parentPath", parentPath).addParameter(":nameHint", title);
        return this.doPost(parentPath + "/*", (HttpEntity)form.build(), new int[]{201});
    }

    public SlingHttpResponse createBlueprintSection(String name, String description, String parentPath, boolean proxyPages) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("./jcr:content/jcr:title", name).addParameter("./jcr:content/jcr:description", description).addParameter("./jcr:content/templates/proxyProductPages", proxyPages ? "true" : "false").addParameter("./jcr:content/filter/searchType", "simple").addParameter("./jcr:content/jcr:primaryType", "cq:PageContent").addParameter("./jcr:content/sling:resourceType", "commerce/components/section").addParameter("./jcr:content/cq:template", "/libs/commerce/templates/section").addParameter("./jcr:content/target/jcr_title", name).addParameter("_charset_", "UTF-8").addParameter("parentPath", parentPath).addParameter("./jcr:primaryType", "cq:Page").addParameter(":nameHint", name);
        return this.doPost(parentPath + "/*", (HttpEntity)form.build(), new int[]{201});
    }

    public boolean isProductPage(String productPage) throws ClientException {
        JsonNode product = this.doGetJson(productPage, -1, new int[]{200});
        String resourceType = product.get("jcr:content").get("sling:resourceType").textValue();
        return "weretail/components/structure/page".equals(resourceType);
    }

    public boolean isProxyPage(String productPage) throws ClientException {
        JsonNode product = this.doGetJson(productPage, -1, new int[]{200});
        String resourceType = product.get("jcr:content").get("sling:resourceType").textValue();
        return "commerce/components/productpageproxy".equals(resourceType);
    }

    public SlingHttpResponse addTagFilter(String blueprintPath, String productFolder, String tag) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./filter/basePath", productFolder).addParameter("./filter/matchTags", tag).addParameter("./filter/matchTags@TypeHint", "String[]").addParameter("./filter/matchTags@Delete", "");
        return this.doPost(blueprintPath + "/_jcr_content", (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse addSQL2QueryFilter(String blueprintPath, String query) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./filter/searchType", "JCR-SQL2").addParameter("./filter/search", query);
        return this.doPost(blueprintPath + "/_jcr_content", (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse addXPathQueryFilter(String blueprintPath, String query) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./filter/searchType", "xpath").addParameter("./filter/search", query);
        return this.doPost(blueprintPath + "/_jcr_content", (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse clearShoppingCart(String page) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("cart", "{\"entries\":[],\"promotions\":[],\"vouchers\":[]}");
        return this.doPost(page + "/jcr:content/contexthub.commerce.cart.json", (HttpEntity)form.build(), new int[]{200});
    }

    public SlingHttpResponse setCommerceProvider(String url, String commerceProvider) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("cq:commerceProvider", commerceProvider);
        return this.doPost(url, (HttpEntity)form.build(), new int[]{200});
    }

    private String urlEncode(String text) throws ClientException {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Failed to encode '" + text + "'", (Throwable)e);
        }
    }

    private String urlDecode(String text) throws ClientException {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Failed to decode '" + text + "'", (Throwable)e);
        }
    }

    public static final class Builder
    extends CQClient.InternalBuilder<CommerceClient> {
        private Builder(URI url, String user, String password) {
            super(url, user, password);
        }

        public static Builder create(URI url, String user, String password) {
            return new Builder(url, user, password);
        }

        public CommerceClient build() throws ClientException {
            return new CommerceClient(this.buildHttpClient(), this.buildSlingClientConfig());
        }
    }
}

