/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.util.CSRFUtils;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.JsonUtils;

public final class TemplateEditorManagerClient
extends CQClient {
    private static final String TEMPLATE_CREATE_ENDPOINT = "/libs/wcm/core/content/sites/createtemplatewizard/_jcr_content";
    private static final String PATH_PATTERN = "<dt class='foundation-form-response-path'>Path</dt>";
    private static final String DD_START_PATTERN = "<dd>";
    private static final String DD_END_PATTERN = "</dd>";
    private static final String PARAM_HIDDEN = "./hidden";
    private static final String PARAM_STATUS = "./status";
    private static final String PARAM_TEMPLATE_TYPE = "templateType";
    private static final String PARAM_COPY_FROM = "./@CopyFrom";
    private static final String PARAM_RESOURCE_TYPE = "./sling:resourceType";
    private static final String PARAM_PARENT_RESOURCE_TYPE = "parentResourceType";
    private static final String PARAM_NAME_HINT = ":nameHint";
    private static final String PARAM_ORDER = ":order";
    private static final String PARAM_LOCK = "lock";
    private static final String PARAM_JCR_PRIMARY_TYPE = "./jcr:primaryType";
    private static final String PARAM_POLICY = "./cq:policy";
    private static final String DEFAULT_TEMPLATE_TYPE = "/libs/settings/wcm/template-types/html5page";
    private static final String POLICIES_RELATIVE_PATH = "%s/settings/wcm/policies";
    private static final String DEFAULT_CONTAINER_RESOURCE_TYPE = "wcm/foundation/components/responsivegrid";
    private static final String PROP_JCR_TITLE = "./jcr:title";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_PARENT_PATH = "_parentPath_";

    public TemplateEditorManagerClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public TemplateEditorManagerClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public String createDefaultTemplate(String configPath, String title, String description) throws ClientException, IOException {
        return this.createTemplate(configPath, DEFAULT_TEMPLATE_TYPE, title, description);
    }

    public String createTemplate(String configPath, String templateType, String title, String description) throws ClientException, IOException {
        FormEntityBuilder formEntry = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter(":cq_csrf_token", CSRFUtils.createCSRFToken(this)).addParameter(PROP_JCR_TITLE, title).addParameter(PARAM_DESCRIPTION, description).addParameter(PARAM_HIDDEN, "true").addParameter(PARAM_STATUS, "draft").addParameter(PARAM_PARENT_PATH, configPath).addParameter(PARAM_TEMPLATE_TYPE, templateType).addParameter("templateType@Delete", "");
        String content = this.doPost(TEMPLATE_CREATE_ENDPOINT, (HttpEntity)formEntry.build(), new int[]{201}).getContent();
        return this.extractPath(content);
    }

    public String createDefaultContainer(String templatePath, String location, String nameHint) throws ClientException {
        if (nameHint == null) {
            nameHint = "responsivegrid";
        }
        FormEntityBuilder formEntry = FormEntityBuilder.create().addParameter(PARAM_COPY_FROM, "/libs/wcm/foundation/components/responsivegrid/cq:template").addParameter("_charset_", "utf-8").addParameter(PARAM_RESOURCE_TYPE, DEFAULT_CONTAINER_RESOURCE_TYPE).addParameter(PARAM_PARENT_RESOURCE_TYPE, DEFAULT_CONTAINER_RESOURCE_TYPE).addParameter(PARAM_ORDER, "last").addParameter(PARAM_NAME_HINT, nameHint);
        location = StringUtils.prependIfMissing((String)location, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String parentPath = templatePath + StringUtils.appendIfMissing((String)location, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        SlingHttpResponse exec = this.doPost(parentPath, (HttpEntity)formEntry.build(), new int[]{201});
        return exec.getSlingPath();
    }

    public String createTopLevelDefaultContainer(String templatePath, String nameHint) throws ClientException {
        return this.createDefaultContainer(templatePath, "/structure/jcr:content/root/", nameHint);
    }

    public void enable(String templatePath) throws ClientException {
        this.setPageProperty(templatePath, PARAM_STATUS, "enabled", 200);
    }

    public void disable(String templatePath) throws ClientException {
        this.setPageProperty(templatePath, PARAM_STATUS, "disabled", 200);
    }

    public String importPolicy(String configPath, String jsonString) throws ClientException {
        return this.importJson(String.format(POLICIES_RELATIVE_PATH, configPath), JsonUtils.getJsonNodeFromString((String)jsonString), new int[]{201}).getSlingPath();
    }

    public void unlockStructureComponent(String componentPath) throws ClientException {
        this.setStructureComponentLock(componentPath, false);
    }

    public void setStructureComponentLock(String componentPath, boolean isLocked) throws ClientException {
        String resourcePath = "/bin/wcm/template/sync.html" + componentPath;
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(PARAM_LOCK, "" + isLocked);
        this.doPost(resourcePath, (HttpEntity)form.build(), new int[]{200, 201}).getContent();
    }

    public String setComponentPolicy(String componentPath, String policyPath) throws ClientException {
        String resourcePath = StringUtils.replaceOnce((String)componentPath, (String)"structure", (String)"policies");
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(PARAM_JCR_PRIMARY_TYPE, "nt:unstructured").addParameter(PARAM_RESOURCE_TYPE, this.getPolicyMappingResourceType(componentPath)).addParameter(PARAM_POLICY, policyPath);
        SlingHttpResponse exec = this.doPost(resourcePath, (HttpEntity)form.build(), new int[]{200, 201});
        return exec.getSlingPath();
    }

    private String getPolicyMappingResourceType(String componentPath) {
        return componentPath.endsWith("/jcr:content") ? "wcm/core/components/policies/mappings" : "wcm/core/components/policies/mapping";
    }

    private String extractPath(String content) {
        int indexPath = content.indexOf(PATH_PATTERN);
        assert (indexPath > 0);
        int indexDDStart = content.indexOf(DD_START_PATTERN, indexPath);
        assert (indexDDStart > 0);
        int indexDDEnd = content.indexOf(DD_END_PATTERN, indexDDStart);
        assert (indexDDEnd > 0);
        return content.substring(indexDDStart + DD_START_PATTERN.length(), indexDDEnd);
    }
}

