/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.render;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.assembler.client.AssemblerOptionSpec;
import com.adobe.fd.assembler.client.AssemblerResult;
import com.adobe.fd.assembler.client.OperationException;
import com.adobe.fd.assembler.service.AssemblerService;
import com.adobe.fd.forms.api.DataFormat;
import com.adobe.fd.forms.api.FormsService;
import com.adobe.fd.forms.api.FormsServiceException;
import com.adobe.fd.forms.api.PDFFormRenderOptions;
import com.adobe.fd.output.api.OutputService;
import com.adobe.fd.output.api.PDFOutputOptions;
import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.util.TempFileManager;
import com.adobe.icc.ddg.api.DocumentRenderHandler;
import com.adobe.icc.render.IRenderService;
import com.adobe.icc.services.api.ACMConfigurationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={IRenderService.class})
@Properties(value={@Property(name="connectors.jsoninvoker", boolValue={true}), @Property(name="connectors.jsoninvoker.alias", value={"lc.icc.renderlib.renderServiceLivecycle"}), @Property(name="connectors.httpinvoker", boolValue={true}), @Property(name="connectors.httpinvoker.alias", value={"lc.icc.renderlib.renderServiceLivecycle"})})
public class AEMRenderServiceImpl
implements IRenderService {
    private static final Logger logger = LoggerFactory.getLogger(AEMRenderServiceImpl.class);
    @Reference
    private FormsService formsService;
    @Reference
    private OutputService outputService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private volatile AssemblerService assemblerService;
    @Reference
    private ACMConfigurationService configurationService;
    @Reference(referenceInterface=Runnable.class, target="(component.name=com.adobe.icc.dbforms.util.TempFileManager)", bind="bindTempFileManager", unbind="unbindTempFileManager")
    private TempFileManager tempFileManager;
    private List<DocumentRenderHandler> renderHandlers;

    protected void bindTempFileManager(Runnable tempFilemanager) {
        this.tempFileManager = (TempFileManager)tempFilemanager;
    }

    protected void unbindTempFileManager(Runnable tempFilemanager) {
        this.tempFileManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] renderPdfForm(byte[] xmlData, byte[] xdpData) throws Exception {
        FileOutputStream fos = null;
        File renderedPDFFile = null;
        try {
            ArrayList<DocumentRenderHandler> interactiveDocHandlers = new ArrayList<DocumentRenderHandler>();
            if (this.renderHandlers != null && this.renderHandlers.size() > 0) {
                for (DocumentRenderHandler handler : this.renderHandlers) {
                    if (handler.getHandlerType() != 0) continue;
                    interactiveDocHandlers.add(handler);
                }
            }
            this.invokeHandlerPreProcess(interactiveDocHandlers, xmlData, xdpData);
            Document docData = new Document(xmlData);
            String sPdfFileUri = Calendar.getInstance().getTimeInMillis() + "";
            String formsLocation = this.tempFileManager.getTmpfolder() + "/forms";
            String renderedPDFFileLocation = formsLocation + "/" + sPdfFileUri;
            File formsFolder = new File(formsLocation);
            renderedPDFFile = new File(renderedPDFFileLocation);
            if (!formsFolder.exists()) {
                formsFolder.mkdirs();
            }
            fos = new FileOutputStream(renderedPDFFile);
            fos.write(xdpData);
            fos.close();
            PDFFormRenderOptions options = new PDFFormRenderOptions();
            options.setContentRoot(formsLocation);
            if (this.configurationService.getDebugDirectory() != null && !this.configurationService.getDebugDirectory().trim().isEmpty()) {
                options.setDebugDir(this.configurationService.getDebugDirectory().trim());
            }
            Document docPDF = this.formsService.renderPDFForm(sPdfFileUri, docData, options);
            byte[] result = IOUtils.toByteArray((InputStream)docPDF.getInputStream());
            byte[] byArray = result = this.invokeHandlerPostProcess(interactiveDocHandlers, result);
            return byArray;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (renderedPDFFile != null && renderedPDFFile.exists()) {
                renderedPDFFile.delete();
            }
        }
    }

    @Override
    public byte[] renderPrintPdf(byte[] xmlData, byte[] xdpData) throws Exception {
        ArrayList<DocumentRenderHandler> interactiveDocHandlers = new ArrayList<DocumentRenderHandler>();
        if (this.renderHandlers != null && this.renderHandlers.size() > 0) {
            for (DocumentRenderHandler handler : this.renderHandlers) {
                if (handler.getHandlerType() != 1) continue;
                interactiveDocHandlers.add(handler);
            }
        }
        this.invokeHandlerPreProcess(interactiveDocHandlers, xmlData, xdpData);
        Document docData = new Document(xmlData);
        Document xdpDoc = new Document(xdpData);
        PDFOutputOptions options = new PDFOutputOptions();
        if (this.configurationService.getDebugDirectory() != null && !this.configurationService.getDebugDirectory().trim().isEmpty()) {
            options.setDebugDir(this.configurationService.getDebugDirectory().trim());
        }
        Document docPDF = this.outputService.generatePDFOutput(xdpDoc, docData, options);
        byte[] result = IOUtils.toByteArray((InputStream)docPDF.getInputStream());
        result = this.invokeHandlerPostProcess(interactiveDocHandlers, result);
        return result;
    }

    private void invokeHandlerPreProcess(List<DocumentRenderHandler> docHandlers, byte[] xmlData, byte[] xdpData) {
        Map<String, byte[]> result = null;
        for (DocumentRenderHandler handler : docHandlers) {
            result = handler.preProcessDocument(xdpData, xmlData);
            if (result == null) continue;
            if (result.containsKey("xdpBytes")) {
                byte[] byArray = xdpData = result.get("xdpBytes") != null ? result.get("xdpBytes") : xdpData;
            }
            if (!result.containsKey("xmlBytes")) continue;
            xmlData = result.get("xmlBytes") != null ? result.get("xmlBytes") : xmlData;
        }
    }

    private byte[] invokeHandlerPostProcess(List<DocumentRenderHandler> docHandlers, byte[] xmlData) {
        for (DocumentRenderHandler handler : docHandlers) {
            byte[] processedPDF = handler.postProcessDocument(xmlData);
            xmlData = processedPDF != null ? processedPDF : xmlData;
        }
        return xmlData;
    }

    @Override
    public void setRenderHandlers(List<DocumentRenderHandler> renderHandlers) {
        this.renderHandlers = renderHandlers;
    }

    @Override
    public Object invokeDDX(Object inputDoc, Map<String, Object> inputMap) throws ICCException {
        Document ddx = (Document)inputDoc;
        Document outDoc = null;
        AssemblerResult result = null;
        AssemblerOptionSpec opts = new AssemblerOptionSpec();
        opts.setValidateOnly(false);
        opts.setLogLevel("INFO");
        try {
            result = this.assemblerService.invoke(ddx, inputMap, opts);
        }
        catch (OperationException e1) {
            throw new ICCException("Error while invoking assembler services.", e1);
        }
        Map<String, Document> allDocs = result.getDocuments();
        if (allDocs.size() > 1) {
            throw new ICCException("Excepted single document but got multiple documents.");
        }
        for (Map.Entry<String, Document> e : allDocs.entrySet()) {
            Document o;
            outDoc = o = e.getValue();
        }
        return outDoc;
    }

    @Override
    public byte[] executeFormScripts(byte[] xdpData) throws FormsServiceException, IOException {
        byte[] result = null;
        Document xdpDoc = new Document(xdpData);
        Document docPDF = this.formsService.exportData(xdpDoc, DataFormat.Auto);
        if (docPDF != null) {
            result = IOUtils.toByteArray((InputStream)docPDF.getInputStream());
        }
        return result;
    }

    protected void bindFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected void unbindFormsService(FormsService formsService) {
        if (this.formsService == formsService) {
            this.formsService = null;
        }
    }

    protected void bindOutputService(OutputService outputService) {
        this.outputService = outputService;
    }

    protected void unbindOutputService(OutputService outputService) {
        if (this.outputService == outputService) {
            this.outputService = null;
        }
    }

    protected void bindAssemblerService(AssemblerService assemblerService) {
        this.assemblerService = assemblerService;
    }

    protected void unbindAssemblerService(AssemblerService assemblerService) {
        if (this.assemblerService == assemblerService) {
            this.assemblerService = null;
        }
    }

    protected void bindConfigurationService(ACMConfigurationService aCMConfigurationService) {
        this.configurationService = aCMConfigurationService;
    }

    protected void unbindConfigurationService(ACMConfigurationService aCMConfigurationService) {
        if (this.configurationService == aCMConfigurationService) {
            this.configurationService = null;
        }
    }
}

