/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.aemds.bedrock.CoreConfigService;
import com.adobe.fd.content.fdinternal.exceptions.ContentException;
import com.adobe.fd.content.fdinternal.util.ContentAssetUtil;
import com.adobe.fd.df.fdinternal.util.DFUtil;
import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.services.api.ACMConfigurationService;
import com.adobe.livecycle.content.repository.FileService;
import com.adobe.livecycle.content.sling.ResourceResolverHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="CM Temp File Manager")
@Service(value={Runnable.class})
@Properties(value={@Property(name="scheduler.concurrent", boolValue={false}, propertyPrivate=true), @Property(name="scheduler.period", longValue={3600L}, description="Period for running the scheduler (in Seconds)")})
public class TempFileManager
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TempFileManager.class);
    public static final String TEMP_FILE_PREFIX = "cmtemp_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private String tmpfolder = null;
    @Reference(target="(component.name=com.adobe.livecycle.content.repository.impl.LocalFileServiceImpl)")
    private FileService fileService;
    @Reference
    private ACMConfigurationService acmConfigurationService;
    @Reference
    private CoreConfigService coreConfigService;

    protected void activate(ComponentContext context) {
        String customTmpDirPath = this.acmConfigurationService.getTmpFolder();
        this.tmpfolder = System.getProperty("java.io.tmpdir");
        if (customTmpDirPath != null && !customTmpDirPath.isEmpty()) {
            File customTempDir = new File(customTmpDirPath);
            if (customTempDir.exists()) {
                this.tmpfolder = customTmpDirPath;
            }
        } else if (this.coreConfigService.getServerTempDir() != null && !this.coreConfigService.getServerTempDir().isEmpty()) {
            this.tmpfolder = this.coreConfigService.getServerTempDir();
        }
        this.tmpfolder = this.tmpfolder.replace('\\', '/');
        logger.info("Temp directory used for creating CM cache: " + this.tmpfolder);
    }

    public String createTempFileInRepository(InputStream inputStream, String mimeType) throws ICCException {
        try {
            com.adobe.livecycle.content.File file = this.fileService.createFile(inputStream, mimeType, null, null);
            ResourceResolver resourceResolver = ResourceResolverHolder.getResourceResolver();
            Session currentSession = (Session)resourceResolver.adaptTo(Session.class);
            currentSession.save();
            return file.getTempPath();
        }
        catch (Exception e) {
            logger.error("Error while creating temp file in repository. Cause: " + e.getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
    }

    public void cleanTemp() {
        try {
            logger.debug("CM: Cleaning temp...");
            File tempFolder = new File(this.tmpfolder);
            if (tempFolder.exists() && tempFolder.isDirectory()) {
                File[] files = tempFolder.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    long liveTime;
                    File f = files[i];
                    if (!f.getName().startsWith(TEMP_FILE_PREFIX) || (liveTime = System.currentTimeMillis() - f.lastModified()) <= 600000L) continue;
                    f.delete();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error deleting temp files : " + e.getCause().getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
    }

    public File writeTempFile(String name) throws ICCException {
        return this.writeTempFile(name, TEMP_FILE_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeToTempFile(String name, byte[] fileContent) throws FileNotFoundException, IOException {
        File uploadedFile = this.writeTempFile(name);
        try (FileOutputStream fos = new FileOutputStream(uploadedFile);){
            fos.write(fileContent);
        }
        return uploadedFile;
    }

    public File writeTempFile(String name, String suffix) throws ICCException {
        File tempFile;
        File tmp = new File(this.tmpfolder);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        try {
            tempFile = File.createTempFile(TEMP_FILE_PREFIX + name, suffix, tmp);
        }
        catch (Exception e) {
            logger.error("Error creating temp file under : " + this.tmpfolder + " : " + e.getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
        return tempFile;
    }

    public byte[] readFile(String fileName) throws ICCException, IOException {
        byte[] result;
        if (fileName == null || "".equals(fileName)) {
            throw new IOException("Please provide a valid filePath: null is not valid...");
        }
        File f = new File(this.tmpfolder, new File(fileName).getName());
        String tempFilePath = f.getAbsolutePath();
        logger.debug("Uploaded file: " + tempFilePath);
        if (!f.exists() || !f.canRead()) {
            String errMsg = "The uploaded file '" + tempFilePath + "' either does not exist or cannot be read...";
            throw new IOException(errMsg);
        }
        try {
            FileInputStream in = new FileInputStream(f);
            BufferedInputStream bin = new BufferedInputStream(in);
            result = IOUtils.toByteArray((InputStream)bin);
            bin.close();
            in.close();
            if (result.length == 0) {
                throw new IOException("The uploaded file '" + tempFilePath + "' was empty...");
            }
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
        return result;
    }

    public String getTmpfolder() {
        return this.tmpfolder;
    }

    public void setTmpfolder(String folder) {
        this.tmpfolder = folder;
    }

    public static byte[] retrieveContentFromJCRRepository(String absPath) throws ICCException, IOException {
        return TempFileManager.retrieveContentFromJCRRepository(absPath, false);
    }

    public static byte[] retrieveContentFromJCRRepository(String absPath, boolean deleteFile) throws ICCException, IOException {
        return TempFileManager.retrieveContentFromJCRRepository(absPath, deleteFile, null);
    }

    public static byte[] retrieveContentFromJCRRepository(String absPath, boolean deleteFile, Session session) throws ICCException, IOException {
        try {
            return ContentAssetUtil.retrieveContentFromJCRRepository((String)absPath, (boolean)deleteFile, (Session)session);
        }
        catch (ContentException e) {
            throw new ICCException(e);
        }
    }

    private static Session getSession() throws RepositoryException {
        ResourceResolver resolver = ResourceResolverHolder.getResourceResolver();
        return (Session)resolver.adaptTo(Session.class);
    }

    public static boolean nodeExists(String absPath) {
        try {
            return ContentAssetUtil.nodeExists((String)absPath, null);
        }
        catch (ContentException e) {
            throw new ICCException(e);
        }
    }

    public static boolean nodeExists(String absPath, Session session) {
        try {
            return ContentAssetUtil.nodeExists((String)absPath, (Session)session);
        }
        catch (ContentException e) {
            throw new ICCException(e);
        }
    }

    public static String getResolvedResourcePath(ResourceResolver resourceResolver, String relativePath) {
        return DFUtil.getResolvedResourcePath((ResourceResolver)resourceResolver, (String)relativePath);
    }

    @Override
    public void run() {
        this.cleanTemp();
    }

    protected void bindFileService(FileService fileService) {
        this.fileService = fileService;
    }

    protected void unbindFileService(FileService fileService) {
        if (this.fileService == fileService) {
            this.fileService = null;
        }
    }

    protected void bindAcmConfigurationService(ACMConfigurationService aCMConfigurationService) {
        this.acmConfigurationService = aCMConfigurationService;
    }

    protected void unbindAcmConfigurationService(ACMConfigurationService aCMConfigurationService) {
        if (this.acmConfigurationService == aCMConfigurationService) {
            this.acmConfigurationService = null;
        }
    }

    protected void bindCoreConfigService(CoreConfigService coreConfigService) {
        this.coreConfigService = coreConfigService;
    }

    protected void unbindCoreConfigService(CoreConfigService coreConfigService) {
        if (this.coreConfigService == coreConfigService) {
            this.coreConfigService = null;
        }
    }
}

