/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.obj.ContainerLayoutAssignment;
import com.adobe.icc.dbforms.obj.Field;
import com.adobe.icc.dbforms.obj.FieldAssignment;
import com.adobe.icc.dbforms.obj.Form;
import com.adobe.icc.dbforms.obj.FragmentLayout;
import com.adobe.icc.dbforms.obj.ModuleAssignment;
import com.adobe.icc.dbforms.obj.Table;
import com.adobe.icc.dbforms.obj.TableRow;
import com.adobe.icc.dbforms.obj.TargetArea;
import com.adobe.icc.dbforms.obj.TargetAreaAssignment;
import com.adobe.icc.dbforms.obj.Variable;
import com.adobe.icc.dbforms.obj.VariableAssignment;
import com.adobe.icc.dbforms.util.ModuleUtil;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Int;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationModelFactory;
import com.adobe.xfa.connectionset.ConnectionSetModelFactory;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.localeset.LocaleSetModelFactory;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.TemplateModelFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutUtil
implements Serializable {
    private static final String INTERNAL_TARGET_IDENTIFIER = "_int";
    private static final String ADDITIONAL_ROW_NAME_PREFIX = "ExtRow";
    private static final String ADDITIONAL_COL_NAME_PREFIX = "Col";
    private static final long serialVersionUID = -1L;
    private static int taCount = 0;
    private static int fieldCount = 0;
    private static int tableCount = 0;
    private static int cellCountInTableRow = 0;
    private static final Logger logger = LoggerFactory.getLogger(LayoutUtil.class);

    public static synchronized void setTargetAreasAndFieldsForLayout(Form form) {
        TreeSet<TargetArea> targetAreas = new TreeSet<TargetArea>();
        TreeSet<Field> fields = new TreeSet<Field>();
        TreeSet<Table> tables = new TreeSet<Table>();
        if (form.getFilexdp() != null) {
            Document xdpDoc = LayoutUtil.loadXFADocument(form.getFilexdp());
            AppModel app = xdpDoc.getAppModel();
            TemplateModel model = TemplateModel.getTemplateModel((AppModel)app, (boolean)true);
            taCount = 0;
            fieldCount = 0;
            LayoutUtil.identifyTargetAreaAndFields(LayoutType.TEMPLATE, targetAreas, fields, tables, null, TableLayout.NONE, model.getNodes(), false);
        }
        form.setTargetAreas(targetAreas);
        form.setFields(fields);
        form.setTables(tables);
    }

    public static synchronized void setTargetAreasAndFieldsForFragmentLayout(FragmentLayout fragmentLayout, boolean retainOldConfig, boolean parsingOriginalLayout) {
        com.adobe.fd.ccm.channels.print.fdinternal.util.LayoutUtil.setTargetAreasAndFieldsForFragmentLayout((FragmentLayout)fragmentLayout, (boolean)retainOldConfig, (boolean)parsingOriginalLayout);
    }

    public static String getLayoutTAAndFields(byte[] layoutXDP) {
        StringBuilder mergedElementList = new StringBuilder();
        if (layoutXDP != null) {
            Document xdpDoc = LayoutUtil.loadXFADocument(layoutXDP);
            AppModel app = xdpDoc.getAppModel();
            TemplateModel model = TemplateModel.getTemplateModel((AppModel)app, (boolean)true);
            LayoutUtil.retriveChildTAAndFields(mergedElementList, model.getNodes(), false);
        }
        return mergedElementList.toString();
    }

    private static void retriveChildTAAndFields(StringBuilder mergedElementList, NodeList nodes, boolean processingPageSetNode) {
        for (int i = 0; i < nodes.length(); ++i) {
            Node node = (Node)nodes.item(i);
            if (XFA.PAGESETTAG == node.getClassTag()) {
                processingPageSetNode = true;
            }
            boolean taFieldFound = false;
            if (!processingPageSetNode && XFA.SUBFORMTAG == node.getClassTag() && !node.getName().endsWith(INTERNAL_TARGET_IDENTIFIER) && node.getName().equals("ModuleContainer")) {
                NodeList childNodes = node.getNodes();
                for (int cnIdx = 0; cnIdx < childNodes.length(); ++cnIdx) {
                    Node childNode = (Node)childNodes.item(cnIdx);
                    if (XFA.SUBFORMTAG != childNode.getClassTag() || !childNode.getName().equals("")) continue;
                    NodeList grandChildNodes = childNode.getNodes();
                    for (int gcnIdx = 0; gcnIdx < grandChildNodes.length(); ++gcnIdx) {
                        Node grandChildNode = (Node)grandChildNodes.item(gcnIdx);
                        if (XFA.SUBFORMSETTAG != grandChildNode.getClassTag() || !grandChildNode.getName().equals("iccModuleObject")) continue;
                        taFieldFound = true;
                        mergedElementList.append("T:" + node.getSOMExpression() + "\n");
                    }
                }
            } else if (LayoutUtil.isQualifyingField(node) && LayoutUtil.isValidField(node) && !node.getName().endsWith(INTERNAL_TARGET_IDENTIFIER) && LayoutUtil.fieldHasBinding(node)) {
                taFieldFound = true;
                mergedElementList.append("F:" + node.getSOMExpression() + "\n");
            }
            if (!taFieldFound) {
                LayoutUtil.retriveChildTAAndFields(mergedElementList, node.getNodes(), processingPageSetNode);
            }
            if (XFA.PAGESETTAG != node.getClassTag()) continue;
            processingPageSetNode = false;
        }
    }

    private static void identifyTargetAreaAndFields(LayoutType layoutType, Set<TargetArea> targetAreas, Set<Field> fields, Set<Table> tables, Table table, TableLayout parentTableLayout, NodeList nodes, boolean processingPageSetNode) {
        for (int i = 0; i < nodes.length(); ++i) {
            Node node = (Node)nodes.item(i);
            TableLayout currentTableLayout = parentTableLayout;
            if (XFA.PAGESETTAG == node.getClassTag()) {
                processingPageSetNode = true;
            }
            if (layoutType != LayoutType.TEMPLATE && XFA.SUBFORMTAG == node.getClassTag()) {
                currentTableLayout = LayoutUtil.getTableLayout(node);
                if (currentTableLayout == TableLayout.NONE && parentTableLayout != TableLayout.NONE) {
                    currentTableLayout = parentTableLayout;
                } else if (currentTableLayout != TableLayout.NONE && parentTableLayout != TableLayout.ROW) {
                    String rowName;
                    if (currentTableLayout == TableLayout.TABLE) {
                        table = new Table();
                        table.setPosition(tableCount++);
                        table.setContainerFieldPosition(fieldCount);
                        table.setContainerTargetAreaPosition(taCount);
                        String tableName = node.getName();
                        if (tableName == null || tableName.trim().length() == 0) {
                            tableName = "Table";
                        }
                        table.setTableName(tableName);
                        table.setTableSOMExpression(node.getSOMExpression());
                        tables.add(table);
                    } else if (currentTableLayout == TableLayout.ROW) {
                        if (table.isDynamicTable()) {
                            throw new ICCException("ALC-ACM-002-354", null, 1);
                        }
                        cellCountInTableRow = 0;
                        List<TableRow> bodyRows = table.getBodyRows();
                        TableRow bodyRow = new TableRow();
                        String rowName2 = node.getName();
                        if (rowName2 == null || rowName2.trim().length() == 0) {
                            rowName2 = "BodyRow";
                        }
                        bodyRow.setName(rowName2);
                        bodyRow.setRowSOMExpression(node.getSOMExpression());
                        bodyRows.add(bodyRow);
                        table.setOriginalBodyRowCount(bodyRows.size());
                        table.setConfiguredBodyRowCount(bodyRows.size());
                        boolean isDynamicTable = LayoutUtil.isRepeatableRow(node);
                        if (isDynamicTable && table.getBodyRows().size() > 1) {
                            throw new ICCException("ALC-ACM-002-354", null, 1);
                        }
                        table.setDynamicTable(isDynamicTable);
                    } else if (currentTableLayout == TableLayout.HEADER) {
                        cellCountInTableRow = 0;
                        TableRow headerRow = new TableRow();
                        rowName = node.getName();
                        if (rowName == null || rowName.trim().length() == 0) {
                            rowName = "HeaderRow";
                        }
                        headerRow.setName(rowName);
                        headerRow.setRowSOMExpression(node.getSOMExpression());
                        table.setHeaderRow(headerRow);
                    } else if (currentTableLayout == TableLayout.FOOTER) {
                        cellCountInTableRow = 0;
                        TableRow footerRow = new TableRow();
                        rowName = node.getName();
                        if (rowName == null || rowName.trim().length() == 0) {
                            rowName = "FooterRow";
                        }
                        footerRow.setName(rowName);
                        footerRow.setRowSOMExpression(node.getSOMExpression());
                        table.setFooterRow(footerRow);
                    }
                }
            }
            if (!processingPageSetNode && XFA.SUBFORMTAG == node.getClassTag() && !node.getName().endsWith(INTERNAL_TARGET_IDENTIFIER) && LayoutUtil.isEmptySubform(node) && LayoutUtil.subformHasNoBinding(node)) {
                TargetArea ta = new TargetArea();
                ta.setPath(node.getSOMExpression());
                ta.setDisplayName(node.getName());
                if (layoutType == LayoutType.TEMPLATE || !LayoutUtil.populateTableInfo(table, currentTableLayout, ta, null)) {
                    ta.setPosition(taCount++);
                    targetAreas.add(ta);
                }
            } else if (LayoutUtil.isQualifyingField(node) && LayoutUtil.isValidField(node) && !node.getName().endsWith(INTERNAL_TARGET_IDENTIFIER) && LayoutUtil.fieldHasBinding(node)) {
                Field field = new Field();
                field.setPath(node.getSOMExpression());
                field.setDisplayName(node.getName());
                field.setType(LayoutUtil.getFieldType(node));
                field.setCaption(LayoutUtil.getFieldCaption(node));
                field.setXfaFieldType(LayoutUtil.getXfaFieldType(node));
                LayoutUtil.setFieldValuesAndLabels(node, field);
                if (layoutType == LayoutType.TEMPLATE || !LayoutUtil.populateTableInfo(table, currentTableLayout, null, field)) {
                    field.setPosition(fieldCount++);
                    fields.add(field);
                }
            } else if (currentTableLayout == TableLayout.HEADER && node.isSameClass(XFA.DRAWTAG)) {
                table.getHeaderRow().setLastDrawPosition(cellCountInTableRow++);
                table.getHeaderRow().setLastDrawSOMExpression(node.getSOMExpression());
            } else if (currentTableLayout == TableLayout.FOOTER && node.isSameClass(XFA.DRAWTAG)) {
                table.getFooterRow().setLastDrawPosition(cellCountInTableRow++);
                table.getFooterRow().setLastDrawSOMExpression(node.getSOMExpression());
            } else if (currentTableLayout == TableLayout.ROW && node.isSameClass(XFA.DRAWTAG)) {
                TableRow currentRow = table.getBodyRows().get(table.getBodyRows().size() - 1);
                currentRow.setLastDrawPosition(cellCountInTableRow++);
                currentRow.setLastDrawSOMExpression(node.getSOMExpression());
                LayoutUtil.setTableColumnCount(table);
            } else {
                LayoutUtil.identifyTargetAreaAndFields(layoutType, targetAreas, fields, tables, table, currentTableLayout, node.getNodes(), processingPageSetNode);
            }
            if (XFA.PAGESETTAG != node.getClassTag()) continue;
            processingPageSetNode = false;
        }
    }

    private static String getXfaFieldType(Node node) {
        if (node.isSameClass(XFA.EXCLGROUPTAG)) {
            return node.getClassName();
        }
        if (node.isSameClass(XFA.FIELDTAG)) {
            Element uiTag = LayoutUtil.getXFASubElement(node, XFA.UITAG, true);
            Node uiChildTag = uiTag.getFirstXFAChild();
            if (uiChildTag != null) {
                return uiChildTag.getClassName();
            }
            return null;
        }
        return null;
    }

    private static void setFieldValuesAndLabels(Node node, Field field) {
        try {
            if (node.isSameClass(XFA.EXCLGROUPTAG)) {
                NodeList nodeList = node.getNodes();
                if (nodeList != null) {
                    ArrayList<String> values = new ArrayList<String>();
                    ArrayList<String> labels = new ArrayList<String>();
                    for (int i = 0; i < nodeList.length(); ++i) {
                        Node childField = (Node)nodeList.item(i);
                        if (!childField.isSameClass(XFA.FIELDTAG)) continue;
                        labels.add(LayoutUtil.getFieldCaption(childField));
                        Element itemsNode = LayoutUtil.getXFASubElement(childField, XFA.ITEMSTAG, true);
                        List<String> itemValues = LayoutUtil.getItemValues((Node)itemsNode);
                        if (itemValues == null || itemValues.size() <= 0) continue;
                        values.add(itemValues.get(0));
                    }
                    field.setValues(values);
                    field.setLabels(labels);
                }
            } else {
                Element uiTag = LayoutUtil.getXFASubElement(node, XFA.UITAG, true);
                Node uiChildTag = uiTag.getFirstXFAChild();
                NodeList nodeList = node.getNodes();
                if (nodeList != null && nodeList.length() > 0) {
                    for (int i = 0; i < nodeList.length(); ++i) {
                        Node childNode = (Node)nodeList.item(i);
                        if (!childNode.isSameClass(XFA.ITEMSTAG)) continue;
                        List<String> itemValues = LayoutUtil.getItemValues(childNode);
                        if (uiChildTag.isSameClass(XFA.CHOICELISTTAG)) {
                            if (childNode.isPropertySpecified(XFA.SAVETAG, true, 1)) {
                                if (itemValues == null) continue;
                                field.setValues(itemValues);
                                continue;
                            }
                            field.setLabels(itemValues);
                            continue;
                        }
                        field.setValues(itemValues);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in setFieldValuesAndLabels: " + field.getDisplayName(), (Throwable)e);
        }
    }

    private static List<String> getItemValues(Node itemNode) {
        ArrayList<String> values = new ArrayList<String>();
        NodeList childNodes = itemNode.getNodes();
        if (childNodes != null && childNodes.length() > 0) {
            for (int i = 0; i < childNodes.length(); ++i) {
                Node childNode = (Node)childNodes.item(i);
                if (childNode == null || childNode.isSameClass(XFA.ATTRIBUTESTAG)) continue;
                Node textNode = childNode.getFirstXFAChild();
                values.add(textNode.getData());
            }
        }
        return values;
    }

    private static String getFieldCaption(Node node) {
        Node value;
        Element captionNode = LayoutUtil.getXFASubElement(node, XFA.CAPTIONTAG, true);
        Element valueNode = LayoutUtil.getXFASubElement((Node)captionNode, XFA.VALUETAG, true);
        Node valueChildNode = valueNode.getFirstXFAChild();
        if (valueChildNode != null && (value = valueChildNode.getFirstXFAChild()) != null) {
            return value.getData();
        }
        return null;
    }

    private static void setTableColumnCount(Table table) {
        if (table.getOriginalColumnCount() < cellCountInTableRow) {
            table.setOriginalColumnCount(cellCountInTableRow);
            table.setConfiguredColumnCount(cellCountInTableRow);
        }
    }

    public static String getContainerWidth(Element containerNode) {
        return com.adobe.fd.ccm.channels.print.fdinternal.util.LayoutUtil.getContainerWidth((Element)containerNode);
    }

    private static TableLayout getTableLayout(Node node) {
        EnumValue ev = (EnumValue)node.getProperty("layout", 0);
        if (ev == null) {
            return TableLayout.NONE;
        }
        if (ev.getAttr().getInt() == 1769476) {
            return TableLayout.TABLE;
        }
        if (ev.getAttr().getInt() == 1769477) {
            NodeList nodes = node.getNodes();
            for (int i = 0; i < nodes.length(); ++i) {
                Node childNode = (Node)nodes.item(i);
                if (childNode.getClassTag() != XFA.ASSISTTAG) continue;
                StringAttr role = (StringAttr)childNode.getProperty("role", 0);
                if (role.getAttrValue().equals("TH")) {
                    return TableLayout.HEADER;
                }
                if (role.getAttrValue().equals("TR")) {
                    return TableLayout.ROW;
                }
                if (role.getAttrValue().equals("TF")) {
                    return TableLayout.FOOTER;
                }
                return TableLayout.NONE;
            }
            return TableLayout.NONE;
        }
        return TableLayout.NONE;
    }

    private static boolean isRepeatableRow(Node node) {
        NodeList nodes = node.getNodes();
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.length(); ++i) {
            Node childNode = (Node)nodes.item(i);
            if (childNode.getClassTag() != XFA.OCCURTAG) continue;
            Int maxAttr = (Int)childNode.getProperty("max", 0);
            if (maxAttr == null) {
                return false;
            }
            int maxInt = maxAttr.getValue();
            return maxInt == -1 || maxInt > 1;
        }
        return false;
    }

    private static boolean populateTableInfo(Table table, TableLayout tableLayout, TargetArea targetArea, Field field) {
        if (table == null || tableLayout == TableLayout.NONE || tableLayout == TableLayout.TABLE) {
            return false;
        }
        Set<Field> fields = null;
        Set<TargetArea> targetAreas = null;
        if (tableLayout == TableLayout.HEADER) {
            fields = table.getHeaderRow().getFields();
            targetAreas = table.getHeaderRow().getTargetAreas();
        } else if (tableLayout == TableLayout.ROW) {
            if (table.isDynamicTable() && targetArea != null) {
                throw new ICCException("ALC-ACM-002-357", null, 1);
            }
            int rowCount = table.getBodyRows().size();
            TableRow currentTableRow = table.getBodyRows().get(rowCount - 1);
            fields = currentTableRow.getFields();
            targetAreas = currentTableRow.getTargetAreas();
        } else if (tableLayout == TableLayout.FOOTER) {
            fields = table.getFooterRow().getFields();
            targetAreas = table.getFooterRow().getTargetAreas();
        }
        if (targetArea != null) {
            targetArea.setPosition(cellCountInTableRow++);
            targetAreas.add(targetArea);
        } else if (field != null) {
            field.setPosition(cellCountInTableRow++);
            fields.add(field);
        }
        LayoutUtil.setTableColumnCount(table);
        return true;
    }

    private static boolean fieldHasBinding(Node node) {
        Element bindElement = LayoutUtil.getXFASubElement(node, XFA.BINDTAG, false);
        return bindElement == null || bindElement != null && ((EnumValue)bindElement.getAttribute(XFA.MATCHTAG)).getInt() != 0x1F0000;
    }

    private static NodeList getChildFields(Node node) {
        NodeList childNodes = node.getNodes();
        int len = childNodes.length();
        for (int i = len - 1; i >= 0; --i) {
            Node childNode = (Node)childNodes.item(i);
            if (childNode.isSameClass(XFA.FIELDTAG)) continue;
            childNodes.remove((Obj)childNode);
        }
        return childNodes;
    }

    private static boolean isQualifyingField(Node node) {
        Element xfaParent;
        if (node.isSameClass(XFA.FIELDTAG) && ((xfaParent = node.getXFAParent()) == null || !xfaParent.isSameClass(XFA.EXCLGROUPTAG))) {
            return true;
        }
        if (node.isSameClass(XFA.EXCLGROUPTAG)) {
            return LayoutUtil.getChildFields(node).length() > 0;
        }
        return false;
    }

    private static boolean isValidField(Node node) {
        if (node.isSameClass(XFA.EXCLGROUPTAG)) {
            NodeList childFields = LayoutUtil.getChildFields(node);
            Field.FieldType exgrpType = null;
            for (int i = 0; i < childFields.length(); ++i) {
                Node childField = (Node)childFields.item(i);
                if (!LayoutUtil.isValidField(childField)) {
                    return false;
                }
                if (exgrpType == null) {
                    exgrpType = LayoutUtil.getFieldType(childField);
                    continue;
                }
                if (LayoutUtil.getFieldType(childField) == exgrpType) continue;
                return false;
            }
            return true;
        }
        Element uiNode = LayoutUtil.getXFASubElement(node, XFA.UITAG, true);
        Element uiChildNode = (Element)uiNode.getOneOfChild(true, true);
        if (uiChildNode.isSameClass(XFA.BUTTONTAG) || uiChildNode.isSameClass(XFA.SIGNATURETAG) || uiChildNode.isSameClass(XFA.DEFAULTUITAG)) {
            return false;
        }
        Element valueNode = LayoutUtil.getXFASubElement(node, XFA.VALUETAG, true);
        Element valueChildNode = (Element)valueNode.getOneOfChild(true, true);
        return !(uiChildNode.isSameClass(XFA.DATETIMEEDITTAG) && !valueChildNode.isSameClass(XFA.DATETAG) && !valueChildNode.isSameClass(XFA.TIMETAG) && !valueChildNode.isSameClass(XFA.DATETIMETAG) || uiChildNode.isSameClass(XFA.NUMERICEDITTAG) && !valueChildNode.isSameClass(XFA.INTEGERTAG) && !valueChildNode.isSameClass(XFA.DECIMALTAG) && !valueChildNode.isSameClass(XFA.FLOATTAG) || valueChildNode.isSameClass(XFA.IMAGETAG) && !uiChildNode.isSameClass(XFA.IMAGEEDITTAG) && !uiChildNode.isSameClass(XFA.EXOBJECTTAG) || valueChildNode.isSameClass("exData") && !uiChildNode.isSameClass(XFA.TEXTEDITTAG) || valueChildNode.isSameClass(XFA.ARCTAG) || valueChildNode.isSameClass(XFA.LINETAG)) && !valueChildNode.isSameClass(XFA.RECTANGLETAG);
    }

    private static boolean isEmptySubform(Node node) {
        return LayoutUtil.getXFASubElement(node, XFA.AREATAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.DRAWTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.EXCLGROUPTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.EXOBJECTTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.FIELDTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.SUBFORMTAG, false) == null && LayoutUtil.getXFASubElement(node, XFA.SUBFORMSETTAG, false) == null;
    }

    private static boolean subformHasNoBinding(Node node) {
        Element bindElement = LayoutUtil.getXFASubElement(node, XFA.BINDTAG, false);
        return bindElement != null && ((EnumValue)bindElement.getAttribute(XFA.MATCHTAG)).getInt() == 0x1F0000;
    }

    private static Field.FieldType getFieldType(Node node) {
        Field.FieldType type = null;
        if (node.isSameClass(XFA.EXCLGROUPTAG)) {
            NodeList childFields = LayoutUtil.getChildFields(node);
            Node childField = (Node)childFields.item(0);
            return LayoutUtil.getFieldType(childField);
        }
        Element uiNode = LayoutUtil.getXFASubElement(node, XFA.UITAG, true);
        Element uiChild = (Element)uiNode.getOneOfChild(true, true);
        if (uiChild != null && uiChild.isSameClass(XFA.CHOICELISTTAG)) {
            return Field.FieldType.CHOICELIST;
        }
        Element valueNode = LayoutUtil.getXFASubElement(node, XFA.VALUETAG, true);
        Element contentNode = (Element)valueNode.getOneOfChild(true, true);
        if (contentNode.isSameClass(XFA.DATETAG)) {
            type = Field.FieldType.DATE;
        } else if (contentNode.isSameClass(XFA.TIMETAG)) {
            type = Field.FieldType.TIME;
        } else if (contentNode.isSameClass(XFA.DATETIMETAG)) {
            type = Field.FieldType.DATETIME;
        } else if (contentNode.isSameClass(XFA.INTEGERTAG)) {
            type = uiChild != null && uiChild.isSameClass(XFA.CHECKBUTTONTAG) ? (node.getXFAParent().isSameClass(XFA.EXCLGROUPTAG) ? Field.FieldType.RADIOBUTTON : Field.FieldType.CHECKBOX) : Field.FieldType.INTEGER;
        } else if (contentNode.isSameClass(XFA.FLOATTAG) || contentNode.isSameClass(XFA.DECIMALTAG)) {
            type = Field.FieldType.FLOAT;
        } else if (contentNode.isSameClass(XFA.EXDATATAG)) {
            type = Field.FieldType.RICHTEXT;
        } else if (contentNode.isSameClass(XFA.TEXTTAG)) {
            type = Field.FieldType.PLAINTEXT;
        } else if (contentNode.isSameClass(XFA.IMAGETAG)) {
            type = Field.FieldType.IMAGE;
        }
        if (type == null) {
            type = Field.FieldType.PLAINTEXT;
        }
        return type;
    }

    private static Document loadXFADocument(byte[] xdp) {
        AppModel appModel = new AppModel(null);
        Document document = new Document(appModel);
        appModel.addFactory((ModelFactory)new TemplateModelFactory());
        appModel.addFactory((ModelFactory)new DataModelFactory());
        appModel.addFactory((ModelFactory)new ConfigurationModelFactory());
        appModel.addFactory((ModelFactory)new LocaleSetModelFactory());
        appModel.addFactory((ModelFactory)new ConnectionSetModelFactory());
        try {
            document.load((InputStream)new ByteArrayInputStream(xdp), null, false);
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-302", 1, e);
        }
        if (TemplateModel.getTemplateModel((AppModel)appModel, (boolean)false) == null) {
            throw new ICCException("ALC-ACM-002-302", 1);
        }
        return document;
    }

    private static Element getXFASubElement(Node node, int classTag, boolean createDefault) {
        Element el = ((Element)node).getElement(classTag, true, 0, createDefault, false);
        return el;
    }

    public static boolean customizeFragmentLayout(FragmentLayout fragmentLayout) throws UnsupportedEncodingException {
        return com.adobe.fd.ccm.channels.print.fdinternal.util.LayoutUtil.customizeFragmentLayout((FragmentLayout)fragmentLayout);
    }

    public static void updateVariableAssignments(Set<VariableAssignment> varAssgnmnts, Map<String, Field> existingFieldIdToNewFieldMap, Set<FieldAssignment> fieldAssgments, Map<String, Field> removedFieldIdToField) {
        HashMap<String, Field> removedFieldPathToField = new HashMap<String, Field>();
        if (removedFieldIdToField != null) {
            for (Field removedField : removedFieldIdToField.values()) {
                removedFieldPathToField.put(removedField.getPath(), removedField);
            }
        }
        HashMap<String, FieldAssignment> removedFieldIdToFAS = new HashMap<String, FieldAssignment>();
        for (FieldAssignment fas : fieldAssgments) {
            if (fas.getFieldPath() == null || !removedFieldPathToField.containsKey(fas.getFieldPath())) continue;
            Field field = (Field)removedFieldPathToField.get(fas.getFieldPath());
            removedFieldIdToFAS.put(field.getId(), fas);
        }
        for (VariableAssignment varAssignment : varAssgnmnts) {
            if (!VariableAssignment.Source.FIELD.equals((Object)varAssignment.getSource())) continue;
            if (existingFieldIdToNewFieldMap.containsKey(varAssignment.getSourceReference())) {
                Field fieldRef = existingFieldIdToNewFieldMap.get(varAssignment.getSourceReference());
                if (fieldRef == null) continue;
                varAssignment.setSourceReference(fieldRef.getId());
                continue;
            }
            if (!removedFieldIdToFAS.containsKey(varAssignment.getSourceReference())) continue;
            FieldAssignment refrredFAS = (FieldAssignment)removedFieldIdToFAS.get(varAssignment.getSourceReference());
            LayoutUtil.updateVASPropertiesFromFieldAssgnment(varAssignment, refrredFAS);
        }
    }

    private static void updateVASPropertiesFromFieldAssgnment(VariableAssignment varAssignment, FieldAssignment refrredFAS) {
        logger.debug("Field object to be assigned to [" + varAssignment.getVariable() != null ? varAssignment.getVariable().getId() : varAssignment.getId() + "] is being removed.");
        varAssignment.setSource(VariableAssignment.Source.USER);
        varAssignment.setSourceReference("");
        if (refrredFAS != null) {
            varAssignment.setOptional(refrredFAS.isOptional());
            varAssignment.setEditable(refrredFAS.isEditable());
            varAssignment.setMultiLine(refrredFAS.isMultiLine());
            if (FieldAssignment.Bind.USER.equals((Object)refrredFAS.getBinding()) || FieldAssignment.Bind.CONST.equals((Object)refrredFAS.getBinding())) {
                varAssignment.setSourceReference(refrredFAS.getBindingReference());
            }
        }
    }

    public static boolean updateVariableForTARemoval(Set<TargetAreaAssignment> taAssignments, Set<VariableAssignment> variableAssignments, Map<String, TargetArea> taTobeRemoved, String layoutBeingUpdatedId, String formId) {
        boolean letterUpdated = false;
        Set<Object> variableIdTobeRemove = new HashSet();
        Set<Object> variableIdToRetain = new HashSet();
        HashMap<String, Variable> varIDToVariableMap = new HashMap<String, Variable>();
        LinkedHashSet<TargetAreaAssignment> relatedRetainedTaAssignments = new LinkedHashSet<TargetAreaAssignment>();
        LinkedHashSet<TargetAreaAssignment> relatedRemovedTaAssignments = new LinkedHashSet<TargetAreaAssignment>();
        HashSet<String> taToRemovePath = new HashSet<String>();
        for (TargetArea ta : taTobeRemoved.values()) {
            taToRemovePath.add(ta.getPath());
        }
        LayoutUtil.populateNestedTAAs(taAssignments, taToRemovePath, relatedRetainedTaAssignments, relatedRemovedTaAssignments, false, layoutBeingUpdatedId, formId);
        Map<String, Variable> tempVarIDToVariableMap = LayoutUtil.getUsedVariables(relatedRetainedTaAssignments);
        varIDToVariableMap.putAll(tempVarIDToVariableMap);
        variableIdToRetain = tempVarIDToVariableMap.keySet();
        tempVarIDToVariableMap = LayoutUtil.getUsedVariables(relatedRemovedTaAssignments);
        varIDToVariableMap.putAll(tempVarIDToVariableMap);
        variableIdTobeRemove = tempVarIDToVariableMap.keySet();
        Set<String> varIDMustRemove = LayoutUtil.difference(variableIdTobeRemove, variableIdToRetain);
        logger.debug(" found variable_ids to be removed for target area " + varIDMustRemove);
        if (varIDMustRemove.size() > 0) {
            letterUpdated = true;
        }
        HashSet<ModuleUtil.UniqueVariable> variablesToRemove = new HashSet<ModuleUtil.UniqueVariable>();
        for (String varIdRemove : varIDMustRemove) {
            Variable var = (Variable)varIDToVariableMap.get(varIdRemove);
            ModuleUtil.UniqueVariable uniqVar = new ModuleUtil.UniqueVariable(var);
            variablesToRemove.add(uniqVar);
        }
        ModuleUtil.updateRefsForVariableRemoval(variablesToRemove, variableAssignments);
        ModuleUtil.updateVariableAssignmentForVariableRemoval(varIDMustRemove, variableAssignments);
        return letterUpdated;
    }

    private static Map<String, Variable> getUsedVariables(Set<TargetAreaAssignment> taAssignments) {
        HashMap<String, Variable> varIDToVariableMap = new HashMap<String, Variable>();
        for (TargetAreaAssignment tas : taAssignments) {
            List<ModuleAssignment> masList = tas.getModuleAssignmentList();
            if (masList == null) continue;
            for (ModuleAssignment mas : masList) {
                Set<Variable> variables;
                if (mas.getDataModule() == null || (variables = ModuleUtil.getAllVariables(mas.getDataModule())) == null) continue;
                for (Variable var : variables) {
                    varIDToVariableMap.put(var.getId(), var);
                }
            }
        }
        return varIDToVariableMap;
    }

    public static void populateNestedTAAs(Set<TargetAreaAssignment> taaList, Set<String> taToRemovePath, Set<TargetAreaAssignment> taAssignmentToRatain, Set<TargetAreaAssignment> taAssignmentToRemove, boolean removeAllTA, String layoutBeingUpdatedId, String currentLayoutId) {
        if (taaList == null) {
            return;
        }
        for (TargetAreaAssignment tas : taaList) {
            if (removeAllTA || layoutBeingUpdatedId.equals(currentLayoutId) && taToRemovePath.contains(tas.getTargetAreaPath())) {
                taAssignmentToRemove.add(tas);
                if (tas.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : tas.getContainerLayoutAssignmentList()) {
                    if (cla.getTargetAreaAssignments() == null) continue;
                    LayoutUtil.populateNestedTAAs(cla.getTargetAreaAssignments(), taToRemovePath, taAssignmentToRatain, taAssignmentToRemove, true, layoutBeingUpdatedId, cla.getContainerLayout().getId());
                }
                continue;
            }
            taAssignmentToRatain.add(tas);
            if (tas.getContainerLayoutAssignmentList() == null) continue;
            for (ContainerLayoutAssignment cla : tas.getContainerLayoutAssignmentList()) {
                if (cla.getTargetAreaAssignments() == null) continue;
                LayoutUtil.populateNestedTAAs(cla.getTargetAreaAssignments(), taToRemovePath, taAssignmentToRatain, taAssignmentToRemove, false, layoutBeingUpdatedId, cla.getContainerLayout().getId());
            }
        }
    }

    public static void updateTAAssignment(Map<String, TargetArea> taTobeRemoved, Set<TargetAreaAssignment> TargetAreaAssignments, Map<String, TargetArea> exisitingTAPathToNewTAs) {
        Iterator<TargetAreaAssignment> taAssIter = TargetAreaAssignments.iterator();
        while (taAssIter.hasNext()) {
            TargetAreaAssignment taAsgmt = taAssIter.next();
            logger.debug(" processing Targe Area assignment " + taAsgmt.toString());
            if (taAsgmt.getTargetArea() != null) {
                String taID = taAsgmt.getTargetArea().getId();
                if (taTobeRemoved.containsKey(taID)) {
                    logger.debug("removing Target Area assignment " + taAsgmt.toString());
                    taAssIter.remove();
                    continue;
                }
                if (!exisitingTAPathToNewTAs.containsKey(taAsgmt.getTargetAreaPath())) continue;
                taAsgmt.setTargetArea(exisitingTAPathToNewTAs.get(taAsgmt.getTargetAreaPath()));
                logger.info("Correcting the target area assignment mapping in the letter. Setting the target area " + taAsgmt.getId() + " in " + taAsgmt.getTargetArea().getId());
                continue;
            }
            if (taAsgmt.getTargetAreaPath() != null) {
                if (exisitingTAPathToNewTAs.containsKey(taAsgmt.getTargetAreaPath())) {
                    taAsgmt.setTargetArea(exisitingTAPathToNewTAs.get(taAsgmt.getTargetAreaPath()));
                    logger.info("Correcting the target area assignment mapping in the letter. Setting the target area " + taAsgmt.getId() + " in " + taAsgmt.getTargetArea().getId());
                    continue;
                }
                taAssIter.remove();
                continue;
            }
            logger.warn("TargetArea Assignment " + taAsgmt.getId() + " contains a null or invalid TargetArea Id.");
        }
    }

    public static void updateFieldAssignment(Map<String, Field> fieldsTobeRemoved, Set<FieldAssignment> fieldAssignments, Map<String, Field> existingFieldPathToFields) {
        Iterator<FieldAssignment> fAssIter = fieldAssignments.iterator();
        while (fAssIter.hasNext()) {
            FieldAssignment fAsgmt = fAssIter.next();
            logger.debug("processing field assignment " + fAsgmt.toString());
            if (fAsgmt.getField() != null) {
                String fieldID = fAsgmt.getField().getId();
                if (fieldsTobeRemoved.containsKey(fieldID)) {
                    logger.debug("removing field assignment " + fAsgmt.toString());
                    fAssIter.remove();
                    continue;
                }
                if (!existingFieldPathToFields.containsKey(fAsgmt.getFieldPath())) continue;
                fAsgmt.setField(existingFieldPathToFields.get(fAsgmt.getFieldPath()));
                logger.info("Correcting the field assignment mapping in the letter. Setting the field " + fAsgmt.getId() + " in " + fAsgmt.getField().getId());
                continue;
            }
            if (fAsgmt.getFieldPath() != null) {
                if (existingFieldPathToFields.containsKey(fAsgmt.getFieldPath())) {
                    fAsgmt.setField(existingFieldPathToFields.get(fAsgmt.getFieldPath()));
                    logger.info("Correcting the field assignment mapping in the letter. Setting the field " + fAsgmt.getId() + " in " + fAsgmt.getField().getId());
                    continue;
                }
                fAssIter.remove();
                continue;
            }
            logger.warn("Field Assignment " + fAsgmt.getId() + " contains a null or invalid Field Id.");
        }
    }

    public static void populateFragmentFieldAndTAs(FragmentLayout fragmentLayout, Set<Field> fields, Set<TargetArea> targetAreas) {
        LayoutUtil.populateFieldAndTAsOfTables(fragmentLayout, fields, targetAreas);
        if (fragmentLayout.getTargetAreas() != null) {
            targetAreas.addAll(fragmentLayout.getTargetAreas());
        }
        if (fragmentLayout.getFields() != null) {
            fields.addAll(fragmentLayout.getFields());
        }
    }

    public static void populateFieldAndTAsOfTables(FragmentLayout fragmentLayout, Set<Field> fields, Set<TargetArea> tas) {
        if (fragmentLayout.getTables() != null) {
            Set<Table> oldFragmentTables = fragmentLayout.getTables();
            for (Table table : oldFragmentTables) {
                List<TableRow> tableRows;
                TableRow tableRow = table.getHeaderRow();
                if (tableRow != null) {
                    fields.addAll(tableRow.getFields());
                    tas.addAll(tableRow.getTargetAreas());
                }
                if ((tableRow = table.getFooterRow()) != null) {
                    fields.addAll(tableRow.getFields());
                    tas.addAll(tableRow.getTargetAreas());
                }
                if ((tableRows = table.getBodyRows()) == null) continue;
                for (TableRow tblRow : tableRows) {
                    fields.addAll(tblRow.getFields());
                    tas.addAll(tblRow.getTargetAreas());
                }
            }
        }
    }

    public static boolean isUpdateDependencyRequired(Set<TargetArea> oldFormTas, Set<TargetArea> newFormTas, Set<Field> oldFormFields, Set<Field> newFormFields) {
        HashMap<String, String> oldTAPathToTAId = new HashMap<String, String>();
        if (oldFormTas != null) {
            for (TargetArea ta : oldFormTas) {
                oldTAPathToTAId.put(ta.getPath(), ta.getId());
            }
        }
        if (newFormTas != null) {
            for (TargetArea ta : newFormTas) {
                if (oldTAPathToTAId.containsKey(ta.getPath())) {
                    if (ta.getId() == null || ta.getId().equals(oldTAPathToTAId.get(ta.getPath()))) continue;
                    return true;
                }
                return true;
            }
            if (oldTAPathToTAId.keySet().size() != newFormTas.size()) {
                return true;
            }
        } else if (oldFormTas != null && oldFormTas.size() > 0) {
            return true;
        }
        HashMap<String, String> oldFieldPathToFieldId = new HashMap<String, String>();
        if (oldFormFields != null) {
            for (Field oldField : oldFormFields) {
                oldFieldPathToFieldId.put(oldField.getPath(), oldField.getId());
            }
        }
        if (newFormFields != null) {
            for (Field field : newFormFields) {
                if (oldFieldPathToFieldId.containsKey(field.getPath())) {
                    if (field.getId() == null || field.getId().equals(oldFieldPathToFieldId.get(field.getPath()))) continue;
                    return true;
                }
                return true;
            }
            if (oldFieldPathToFieldId.size() != newFormFields.size()) {
                return true;
            }
        } else if (oldFormFields != null && oldFormFields.size() > 0) {
            return true;
        }
        return false;
    }

    private static Set<String> findVarialeIDsForName(String name, Map<String, String> idToName) {
        HashSet<String> ids = new HashSet<String>();
        if (idToName.containsValue(name)) {
            for (String id : idToName.keySet()) {
                String retrivedValue = idToName.get(id);
                if (!name.equals(retrivedValue)) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    public static void sortContainerLayoutAssignments(List<ContainerLayoutAssignment> clas) {
        if (clas.size() > 1) {
            Collections.sort(clas, new Comparator<ContainerLayoutAssignment>(){

                @Override
                public int compare(ContainerLayoutAssignment cla1, ContainerLayoutAssignment cla2) {
                    int cla2Length;
                    int cla1Length = cla1.getId().length();
                    return cla1Length < (cla2Length = cla2.getId().length()) ? -1 : (cla1Length == cla2Length ? 0 : 1);
                }
            });
        }
    }

    private static <T> Set<T> difference(Set<T> setA, Set<T> setB) {
        HashSet<T> result = new HashSet<T>(setA);
        result.removeAll(setB);
        return result;
    }

    private static enum TableLayout {
        TABLE,
        HEADER,
        ROW,
        FOOTER,
        NONE;

    }

    private static enum LayoutType {
        TEMPLATE,
        FRAGMENT;

    }
}

