/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dct.util;

import com.adobe.dct.exception.DCTException;
import com.adobe.livecycle.content.sling.ResourceResolverHolder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager {
    private static final Logger logger = LoggerFactory.getLogger(FileManager.class);

    public static byte[] retrieveContentFromJCRRepository(String absPath) throws DCTException, IOException {
        return FileManager.retrieveContentFromJCRRepository(absPath, false);
    }

    public static byte[] retrieveContentFromJCRRepository(String absPath, boolean deleteFile) throws DCTException, IOException {
        return FileManager.retrieveContentFromJCRRepository(absPath, deleteFile, null);
    }

    public static byte[] retrieveContentFromJCRRepository(String absPath, boolean deleteFile, Session session) throws DCTException, IOException {
        if (absPath == null || absPath.trim().equals("")) {
            return null;
        }
        if (!FileManager.nodeExists(absPath)) {
            return null;
        }
        if (FileManager.isFolder(absPath)) {
            return null;
        }
        byte[] result = null;
        try {
            if (session == null) {
                session = FileManager.getSession();
            }
            Node ntFileNode = session.getNode(absPath);
            Node ntResourceNode = ntFileNode.getNode("jcr:content");
            InputStream is = ntResourceNode.getProperty("jcr:data").getBinary().getStream();
            BufferedInputStream bin = new BufferedInputStream(is);
            result = IOUtils.toByteArray((InputStream)bin);
            bin.close();
            is.close();
            if (deleteFile) {
                session.removeItem(absPath);
            }
        }
        catch (Exception ex) {
            throw new DCTException("Error reading file from JCR Repository : ", ex);
        }
        return result;
    }

    private static Session getSession() throws RepositoryException {
        ResourceResolver resolver = ResourceResolverHolder.getResourceResolver();
        return (Session)resolver.adaptTo(Session.class);
    }

    public static boolean nodeExists(String absPath) throws DCTException {
        try {
            return FileManager.getSession().nodeExists(absPath);
        }
        catch (RepositoryException ex) {
            throw new DCTException("Error reading file from JCR Repository : ", ex);
        }
    }

    public static String getResolvedResourcePath(ResourceResolver resourceResolver, String relativePath) {
        Resource resource;
        if (resourceResolver == null) {
            resourceResolver = ResourceResolverHolder.getResourceResolver();
        }
        if ((resource = resourceResolver.getResource(relativePath)) != null) {
            return resource.getPath();
        }
        return null;
    }

    private static boolean isFolder(String absPath) throws DCTException {
        try {
            Node node = FileManager.getSession().getNode(absPath);
            String defaultPrimaryTypeName = node.getPrimaryNodeType().getName();
            return "nt:folder".equals(defaultPrimaryTypeName);
        }
        catch (RepositoryException ex) {
            throw new DCTException("Error reading file from JCR Repository :", ex);
        }
    }
}

