/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.api.bridge;

import com.adobe.aem.dermis.api.bridge.DataContext;
import com.adobe.aem.dermis.api.bridge.OperationOptions;
import com.adobe.aem.dermis.model.value.IValueMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.commons.json.JSONObject;

public class Query {
    private String formDataModelPath;
    private DataContext dataContext;
    private OperationOptions options;
    private boolean evaluateComputedAttrs = true;

    public Query(String formDataModelPath, DataContext dataContext) {
        this.formDataModelPath = formDataModelPath;
        this.dataContext = dataContext;
    }

    public Query(String formDataModelPath, DataContext dataContext, OperationOptions options) {
        this(formDataModelPath, dataContext);
        this.options = options;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public void setDataContext(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    public String getFormDataModelPath() {
        return this.formDataModelPath;
    }

    public void setFormDataModelPath(String formDataModelPath) {
        this.formDataModelPath = formDataModelPath;
    }

    public String getEntityId() {
        String entityName = null;
        if (this.options != null) {
            entityName = this.options.getEntityId();
        }
        return entityName;
    }

    public String getOperationId() {
        String operationId = null;
        if (this.options != null) {
            operationId = this.options.getOperationId();
        }
        return operationId;
    }

    public void addEntityAndOperation(String entityId, String operationId) {
        Map<String, String> entityOperationMapping = new HashMap<String, String>();
        if (this.options == null) {
            this.options = new OperationOptions(null, entityOperationMapping);
        } else if (this.options.getEntityOperationMapping() == null) {
            this.options.setEntityOperationMapping(entityOperationMapping);
        } else {
            entityOperationMapping = this.options.getEntityOperationMapping();
        }
        entityOperationMapping.put(entityId, operationId);
    }

    public OperationOptions getOptions() {
        return this.options;
    }

    public void setOptions(OperationOptions options) {
        this.options = options;
    }

    @Deprecated
    public void setArguments(JSONObject arguments) {
        if (this.options != null) {
            this.options.setArguments(arguments);
        }
    }

    public void setArgumentsValueMap(IValueMap arguments) {
        if (this.options != null) {
            this.options.setArgumentsValueMap(arguments);
        }
    }

    @Deprecated
    public JSONObject getArguments() {
        JSONObject arguments = null;
        if (this.options != null) {
            arguments = this.options.getArguments();
        }
        return arguments;
    }

    public IValueMap getArgumentsValueMap() {
        IValueMap valueMap = null;
        if (this.options != null) {
            valueMap = this.options.getArgumentsValueMap();
        }
        return valueMap;
    }

    public Map<String, String> getEntityOperationMapping() {
        Map<String, String> entityOperationMapping = null;
        if (this.options != null) {
            entityOperationMapping = this.options.getEntityOperationMapping();
        }
        return entityOperationMapping;
    }

    public void replaceOperationRefByName(String operationRef, String operationName) {
        Map<String, String> entityOperationMapping = this.getEntityOperationMapping();
        if (entityOperationMapping != null && entityOperationMapping.size() > 0) {
            for (Map.Entry<String, String> entry : entityOperationMapping.entrySet()) {
                if (entry == null || !entry.getValue().equals(operationRef)) continue;
                entry.setValue(operationName);
                break;
            }
        }
    }

    public String getSelectionPoints() {
        String selectionPoints = null;
        if (this.options != null) {
            selectionPoints = this.options.getSelectionPoints();
        }
        return selectionPoints;
    }

    public boolean getOutputTypeArray() {
        return this.options.getOutputTypeArray();
    }

    public void setOutputTypeArray(boolean isOutputTypeArray) {
        this.options.setOutputTypeArray(isOutputTypeArray);
    }

    public boolean isEvaluateComputedAttrs() {
        return this.evaluateComputedAttrs;
    }

    public void setEvaluateComputedAttrs(boolean evaluateComputedAttrs) {
        this.evaluateComputedAttrs = evaluateComputedAttrs;
    }
}

