/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pdf.inputs;

import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;

public class JavascriptPreferences
extends PreferencesMap {
    private static final long serialVersionUID = 5190655797953420424L;
    private static final String MEMORY_THRESHHOLD_STR = "memoryThreshhold";
    private static final double MEMORY_THRESHHOLD_DEFAULT = 0.9;
    private static final String INSTRUCTION_COUNT_STR = "instructionCount";
    private static final int INSTRUCTION_COUNT_DEFAULT = 1000;
    private static final String SCRIPT_TIMEOUT_INTERVAL_STR = "scriptTimeOutInterval";
    private static final int SCRIPT_TIMEOUT_INTERVAL_DEFAULT = 10;

    public JavascriptPreferences() {
        this.put(MEMORY_THRESHHOLD_STR, (Object)0.9);
        this.put(INSTRUCTION_COUNT_STR, (Object)1000);
        this.put(SCRIPT_TIMEOUT_INTERVAL_STR, (Object)10);
    }

    protected PreferencesMap createChild(String myKey) {
        return null;
    }

    protected Object getPrefValueFromString(String prefName, String value) {
        if (prefName.equalsIgnoreCase(MEMORY_THRESHHOLD_STR)) {
            return new Double(value);
        }
        if (prefName.equalsIgnoreCase(INSTRUCTION_COUNT_STR) || prefName.equalsIgnoreCase(SCRIPT_TIMEOUT_INTERVAL_STR)) {
            return new Integer(value);
        }
        return null;
    }

    public PreferencesMap newInstance() {
        return new JavascriptPreferences();
    }

    public void setMemoryThreshhold(double memoryThreshhold) {
        this.put(MEMORY_THRESHHOLD_STR, (Object)memoryThreshhold);
    }

    public double getMemoryThreshhold() {
        return (Double)this.get(MEMORY_THRESHHOLD_STR);
    }

    public void setInstructionCount(int instructionCount) {
        this.put(INSTRUCTION_COUNT_STR, (Object)instructionCount);
    }

    public int getInstructionCount() {
        return (Integer)this.get(INSTRUCTION_COUNT_STR);
    }

    public void setScriptTimeOutInterval(int scriptTimeOutInterval) {
        this.put(SCRIPT_TIMEOUT_INTERVAL_STR, (Object)scriptTimeOutInterval);
    }

    public int getScriptTimeOutInterval() {
        return (Integer)this.get(SCRIPT_TIMEOUT_INTERVAL_STR);
    }
}

