/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pdf.inputs;

import com.adobe.fd.signatures.truststore.businessobject.HSMProfileBO;
import java.util.HashMap;
import org.apache.sling.api.resource.ResourceResolver;

public class CredentialContext {
    private final String PROP_ALIAS = "credential.alias";
    private final String PROP_RESOURCERESOLVER = "resource.resolver";
    private final String PROP_IS_HSM_CREDENTIAL = "is.hsm.credential";
    private final String PROP_HSM_PROFILE = "hsm.profile";
    private HashMap<String, Object> map = new HashMap();

    public CredentialContext(String credentialAlias, ResourceResolver resourceResolver, boolean isHSMCredential) {
        this.map.put("credential.alias", credentialAlias);
        this.map.put("resource.resolver", resourceResolver);
        this.map.put("is.hsm.credential", isHSMCredential);
    }

    public CredentialContext(HSMProfileBO hsmProfileBO) {
        this.map.put("hsm.profile", hsmProfileBO);
        this.map.put("is.hsm.credential", true);
    }

    public CredentialContext(String credentialAlias, ResourceResolver resourceResolver) {
        this.map.put("credential.alias", credentialAlias);
        this.map.put("resource.resolver", resourceResolver);
        this.map.put("is.hsm.credential", false);
    }

    public Object getProperty(String property) {
        return this.map.get(property);
    }

    public void setProperty(String property, Object value) {
        this.map.put(property, value);
    }

    public ResourceResolver getResourceResolver() {
        return (ResourceResolver)this.map.get("resource.resolver");
    }

    public String getAlias() {
        return (String)this.map.get("credential.alias");
    }

    public Boolean isHSMCredential() {
        return (Boolean)this.map.get("is.hsm.credential");
    }

    public HSMProfileBO getHSMProfileBO() {
        return (HSMProfileBO)this.map.get("hsm.profile");
    }
}

