/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.client.types;

import com.adobe.fd.signatures.pdf.inputs.DSSPreferences;
import com.adobe.fd.signatures.pdf.inputs.DSSPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.PKIPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesStore
extends PreferencesMap {
    private static final long serialVersionUID = 4070167119947976643L;
    private static Logger logger;
    private static final String dssPKIPropertyFile = "dss.properties";
    private static final String dssStr = "dss";
    private static Properties fileProperties;

    public PreferencesStore() {
        this(true);
    }

    private PreferencesStore(boolean initWithProps) {
        logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.put(dssStr, (Object)new DSSPreferencesImpl());
        if (initWithProps && fileProperties != null) {
            this.setPreferences(fileProperties);
        }
    }

    public void setPreferences(Properties props) {
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            this.setPreference(string, value);
        }
    }

    protected Object getPrefValueFromString(String prefName, String value) {
        return null;
    }

    public PreferencesMap newInstance() {
        return new PreferencesStore(false);
    }

    protected PreferencesMap createChild(String myKey) {
        if (myKey.equalsIgnoreCase(dssStr)) {
            return new DSSPreferencesImpl();
        }
        return null;
    }

    public DSSPreferences getDSSPreferences() {
        return (DSSPreferences)this.get(dssStr);
    }

    public void setDSSPreferences(DSSPreferences prefs) {
        this.put(dssStr, (Object)prefs);
    }

    public PKIPreferences getPKIPreferences() {
        return this.getDSSPreferences().getPKIPreferences();
    }

    public void setPKIPreferences(PKIPreferences prefs) {
        this.getDSSPreferences().setPKIPreferences(prefs);
    }

    static {
        fileProperties = null;
        InputStream is = PreferencesStore.class.getResourceAsStream(dssPKIPropertyFile);
        if (is != null) {
            fileProperties = new Properties();
            try {
                fileProperties.load(is);
            }
            catch (IOException e) {
                logger.info("", (Throwable)e);
                throw new RuntimeException("Can not load properties file");
            }
        }
    }
}

