/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.docmanager;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.aemfd.docmanager.internal.passivation.DataBufferPassivationHandler;
import com.adobe.aemfd.docmanager.io.IOUtils;
import com.adobe.aemfd.docmanager.passivation.DocumentPassivationHandler;
import com.adobe.aemfd.docmanager.source.DocumentSourceHandler;
import com.adobe.aemfd.docmanager.source.FileBasedDocumentSourceHandler;
import com.adobe.service.DataBuffer;
import com.adobe.service.DataManager;
import com.adobe.service.FileDataBuffer;
import com.adobe.service.FileDataBufferHelper;
import com.adobe.service.InlinedDataBuffer;
import com.adobe.service.InvalidSourceException;
import java.io.File;
import java.io.IOException;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentVsDataBuffer {
    private static final Logger logger = LoggerFactory.getLogger(DocumentVsDataBuffer.class);

    private static boolean isNotEmpty(String str) {
        return str != null && str.trim().length() != 0;
    }

    public static Document toDocument(DataBuffer db) {
        Document res;
        if (db._is_a(FileDataBufferHelper.id())) {
            FileDataBuffer fdb = FileDataBufferHelper.narrow((Object)db);
            File f = new File(fdb.getFilePath());
            res = new Document(f);
        } else {
            res = new Document((DocumentPassivationHandler)new DataBufferPassivationHandler(db));
        }
        String type = db.getContentType();
        if (DocumentVsDataBuffer.isNotEmpty(type)) {
            res.setContentType(type);
        }
        return res;
    }

    public static Document toDocument(InlinedDataBuffer idb) {
        if (idb.isInlined) {
            Document res = new Document(idb.inlinedData);
            if (DocumentVsDataBuffer.isNotEmpty(idb.inlinedContentType)) {
                res.setContentType(idb.inlinedContentType);
            }
            return res;
        }
        return DocumentVsDataBuffer.toDocument(idb.remoteDataBuffer);
    }

    private static DataBuffer toDataBuffer(Document doc, boolean passivate) throws IOException {
        FileDataBuffer res;
        File f;
        DocumentSourceHandler dsh;
        if (passivate) {
            doc.passivate();
        }
        if ((dsh = doc.getSourceHandler()) == null) {
            throw new IllegalStateException("Document source handler is null even after passivation!");
        }
        if (dsh instanceof FileBasedDocumentSourceHandler) {
            f = ((FileBasedDocumentSourceHandler)dsh).getSourceFile();
        } else {
            f = IOUtils.getTempFileManager().getTransactionBoundTempFile();
            doc.copyToFile(f);
        }
        DataManager dm = IOUtils.getTempFileManager().getDataManager();
        try {
            res = dm.createFileDataBuffer(f.getPath());
        }
        catch (InvalidSourceException e) {
            throw new IOException("Error creating FileDataBuffer from file " + f.getPath(), e);
        }
        try {
            String type = doc.getContentType();
            if (DocumentVsDataBuffer.isNotEmpty(type)) {
                res.setContentType(type);
            }
        }
        catch (UnsupportedOperationException e) {
            logger.warn("UnsupportedOperationException encountered on calling getContentType() on document of type " + doc.getClass().getName() + ". This warning can be ignored for SharedPdfDocument instances", (Throwable)e);
        }
        return res;
    }

    public static DataBuffer toDataBuffer(Document doc) throws IOException {
        return DocumentVsDataBuffer.toDataBuffer(doc, true);
    }

    public static InlinedDataBuffer toInlinedDataBuffer(Document doc) throws IOException {
        InlinedDataBuffer res = new InlinedDataBuffer();
        res.inlinedContentType = "";
        res.inlinedData = new byte[0];
        byte[] inlined = doc.getInlineData();
        if (inlined != null) {
            res.isInlined = true;
            try {
                String type = doc.getContentType();
                if (DocumentVsDataBuffer.isNotEmpty(type)) {
                    res.inlinedContentType = type;
                }
            }
            catch (UnsupportedOperationException e) {
                logger.warn("UnsupportedOperationException encountered on calling getContentType() on document of type " + doc.getClass().getName() + ". This warning can be ignored for SharedPdfDocument instances", (Throwable)e);
            }
            res.inlinedData = inlined;
        } else {
            res.isInlined = false;
            res.remoteDataBuffer = DocumentVsDataBuffer.toDataBuffer(doc, false);
        }
        return res;
    }
}

