/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.dermis.authentication.exception;

import com.adobe.aemfd.dermis.authentication.exception.DermisLogger;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationException
extends Exception {
    protected static final Logger logger = LoggerFactory.getLogger(AuthenticationException.class);
    protected String originCode;
    protected String originMessage;
    protected String messageCode;
    protected Object[] messageArgs;
    protected String unresolvedMessage;

    public AuthenticationException() {
    }

    public AuthenticationException(String resourceID, String[] args, int severity) {
        this(resourceID, args);
        DermisLogger.logMessage(this.getClass(), severity, resourceID, args);
    }

    public AuthenticationException(String resourceID, String[] args) {
        this(resourceID + ": " + DermisLogger.getString(resourceID, args));
        this.unresolvedMessage = DermisLogger.getString(resourceID);
        this.messageArgs = args;
        this.messageCode = resourceID;
    }

    public AuthenticationException(String resourceID, String[] args, String originCode, String originMessage) {
        this(resourceID, args);
        this.originCode = originCode;
        this.originMessage = originMessage;
    }

    public AuthenticationException(String resourceID, int severity, Throwable cause) {
        this(resourceID + ": " + DermisLogger.getString(resourceID), cause);
        this.messageCode = resourceID;
        DermisLogger.logMessage(this.getClass(), severity, resourceID, null, cause);
    }

    public AuthenticationException(String resourceID, String[] args, int severity, Throwable cause) {
        this(resourceID + ": " + DermisLogger.getString(resourceID, args), cause);
        this.messageArgs = args;
        this.messageCode = resourceID;
        DermisLogger.logMessage(this.getClass(), severity, resourceID, args, cause);
    }

    public AuthenticationException(String resourceID, int severity) {
        this(resourceID + ": " + DermisLogger.getString(resourceID, null));
        this.messageCode = resourceID;
        DermisLogger.logMessage(this.getClass(), severity, resourceID);
    }

    public AuthenticationException(String message) {
        super(message);
    }

    public AuthenticationException(Throwable cause) {
        super(cause);
    }

    public AuthenticationException(String message, Throwable cause) {
        super(message, cause);
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageArgs(Object[] messageArgs) {
        this.messageArgs = messageArgs;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(String code) {
        this.messageCode = code;
    }

    public String getUnresolvedMessage() {
        return this.unresolvedMessage;
    }

    public void setUnresolvedMessage(String unresolvedMessage) {
        this.unresolvedMessage = unresolvedMessage;
    }

    public String getOriginCode() {
        return this.originCode;
    }

    public String getOriginMessage() {
        return this.originMessage;
    }

    public JSONObject getJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("errorCode", (Object)this.messageCode);
            String errorMessage = DermisLogger.getString(this.messageCode, (String[])this.messageArgs);
            if (StringUtils.isEmpty((String)errorMessage)) {
                errorMessage = this.getMessage();
            }
            jsonObject.put("errorMessage", (Object)errorMessage);
            if (StringUtils.isNotEmpty((String)this.originCode)) {
                jsonObject.put("originCode", (Object)this.originCode);
            }
            if (StringUtils.isNotEmpty((String)this.originMessage)) {
                jsonObject.put("originMessage", (Object)this.originMessage);
            }
        }
        catch (JSONException e) {
            DermisLogger.logErrorAndDebug(AuthenticationException.class, "Error while creating json object", (Exception)((Object)e));
        }
        return jsonObject;
    }
}

