/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aem.transaction.core.ITransactionRecorder;
import com.adobe.aem.transaction.core.exception.TransactionException;
import com.adobe.aem.transaction.core.model.TransactionRecord;
import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.common.GuideValidationResult;
import com.adobe.aemds.guide.fdinternal.api.IValidationResult;
import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.model.SignAgreementInfo;
import com.adobe.aemds.guide.model.SubmitType;
import com.adobe.aemds.guide.model.ValidationOptions;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuidePDFSubmitHelper;
import com.adobe.aemds.guide.service.GuideStoreContentSubmission;
import com.adobe.aemds.guide.service.SignAgreementService;
import com.adobe.aemds.guide.service.external.FormPortalSubmitPreprocessor;
import com.adobe.aemds.guide.service.external.GuideSubmitPostProcessor;
import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.aemds.guide.submitutils.FileRequestParameter;
import com.adobe.aemds.guide.submitutils.FormFieldRequestParameter;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideSubmitErrorCause;
import com.adobe.aemds.guide.utils.GuideSubmitUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.XMLUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.submitutils.CustomParameterRequest;
import com.adobe.forms.common.submitutils.CustomResponse;
import com.adobe.forms.common.submitutils.ParameterMap;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Adaptive Form Submit"}), @Property(name="sling.servlet.selectors", value={"af.submit", "af.agreement", "af.signSubmit"})})
public class GuideSubmitServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -5597140632392446185L;
    public static final String REQ_ATTR_FORWARD_PATH = "forward.path";
    public static final String REQ_ATTR_FORWARD_OPTIONS = "forward.options";
    public static final String REQUEST_ATTR_WORKFLOW_PATH = "Forms.workflow.path";
    public static final String REQUEST_ATTR_WORKFLOW_PAYLOAD_PATH = "Forms.workflow.payloadPath";
    public static final String REQUEST_ATTR_REDIRECT_PARAMETER_MAP = "redirectParameters";
    private static final int LENGTH_GUIDE_FILE_ATTACHMENT = 21;
    private Logger logger = LoggerFactory.getLogger(GuideSubmitServlet.class);
    @Reference
    private ITransactionRecorder transactionRecorder;
    @Reference
    private GuideModelTransformer guideModelTransformer;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private volatile SignAgreementService signAgreementService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuidePDFSubmitHelper guidePDFSubmitHelper;
    @Reference
    private GuideStoreContentSubmission guideStoreContentSubmission;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private FormPortalSubmitPreprocessor formsPortalPreProcessor;
    @Reference(name="guideSubmitPostProcessors", referenceInterface=GuideSubmitPostProcessor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private Map<Comparable<Object>, GuideSubmitPostProcessor> guideSubmitPostProcessors = new ConcurrentSkipListMap(Collections.reverseOrder());

    private TransactionRecord getAdaptiveFormSubmitTransaction(Resource formResource) {
        String resId = formResource != null ? formResource.getPath() : "";
        String resType = "FORM";
        String resSubType = "ADAPTIVE-FORM";
        String transactionType = "SUBMIT";
        String transactionSubType = null;
        String resName = formResource != null && formResource.getParent() != null ? (String)formResource.getParent().getValueMap().get("jcr:title", (Object)"") : "";
        Integer transactionCount = 1;
        return new TransactionRecord(transactionCount, resType, resSubType, transactionType, transactionSubType, resId, resName);
    }

    private GuideValidationResult validateForm(SlingHttpServletRequest request, String locale) {
        Resource guideContainerResource = request.getResource();
        ValidationOptions validationOptions = new ValidationOptions.ValidationOptionsBuilder().setFormContainerResource(guideContainerResource).setData(request.getParameter("jcr:data")).setCaptchaData(request.getParameter("captchaData")).setServerUrl(this.getServerUrl(request)).setContextPath(request.getContextPath()).setLocale(locale).setFileAttachmentMap(request.getParameter("fileAttachmentMap")).build();
        ValueMap properties = guideContainerResource.getValueMap();
        GuideValidationResult guideValidationResult = null;
        guideValidationResult = this.guideModelTransformer.validateForm(validationOptions);
        return guideValidationResult;
    }

    private SubmitResult<SignAgreementInfo> doPostPrerequisites(SlingHttpServletRequest request, SlingHttpServletResponse response, ParameterMap wrappedParameterMap, SubmitType submitType) throws RepositoryException {
        SubmitResult<SignAgreementInfo> result = new SubmitResult<SignAgreementInfo>();
        SignAgreementInfo signAgreementInfo = null;
        String locale = GuideSubmitUtils.getLocale(request);
        GuideValidationResult guideValidationResult = this.validateForm(request, locale);
        if (guideValidationResult != null && guideValidationResult.hasErrors()) {
            this.logger.error("Server validation failed.");
            result.errorResult = guideValidationResult;
            return result;
        }
        FormSubmitInfo submitInfo = new FormSubmitInfo();
        Resource formContainerResource = request.getResource();
        GuideContainer guideContainer = GuideContainer.from(formContainerResource);
        String schemaType = guideContainer.getSchema().getValue();
        boolean isDorConfigured = GuideUtils.isDORConfigured(formContainerResource);
        ValueMap properties = ResourceUtil.getValueMap((Resource)formContainerResource);
        Boolean isAdobeSignEnabled = Boolean.valueOf((String)properties.get("_useSignedPdf", (Object)""));
        Boolean isRedirectURLSet = StringUtils.isNotEmpty((String)((String)properties.get("redirect", (Object)"")));
        String postSignUrl = "";
        JSONObject guideJson = this.guideModelTransformer.exportGuideJsonObject(formContainerResource, null, new Locale(locale));
        String guideJsonString = guideJson != null ? guideJson.toString() : "";
        String fileAttachmentMap = request.getParameter("fileAttachmentMap");
        I18n i18n = new I18n((HttpServletRequest)request);
        List<JSONObject> fileAttachmentList = GuideUtils.getFileAttachmentList(guideJsonString);
        SubmitResult<List<FileAttachmentWrapper>> fileAttachmentWrapperListResult = this.getFileAttachmentWrapperList(wrappedParameterMap, fileAttachmentList, request.getResourceResolver(), fileAttachmentMap, i18n);
        if (((SubmitResult)fileAttachmentWrapperListResult).hasError()) {
            result.errorResult = fileAttachmentWrapperListResult.errorResult;
            return result;
        }
        List fileAttachmentWrapperList = (List)fileAttachmentWrapperListResult.result;
        ResourceResolver resourceResolver = request.getResourceResolver();
        Authorizable auth = (Authorizable)resourceResolver.adaptTo(Authorizable.class);
        submitInfo.setFormContainerPath(formContainerResource.getPath());
        submitInfo.setFormContainerResource(formContainerResource);
        submitInfo.setContentType(GuideUtils.getDataMimeType(formContainerResource));
        submitInfo.setFileAttachments(fileAttachmentWrapperList);
        submitInfo.setFileAttachmentMap(fileAttachmentMap);
        RequestParameter[] jcrDataParam = (RequestParameter[])wrappedParameterMap.get((Object)"jcr:data");
        if (jcrDataParam != null && jcrDataParam.length > 0) {
            String data = jcrDataParam[0].getString();
            if (((Boolean)properties.get("enableServerValidation", (Object)false)).booleanValue() && isDorConfigured) {
                data = GuideUtils.isJsonBasedSchema(schemaType) ? GuideUtils.syncExcludeFromDorData(data, guideValidationResult.getExcludeFromDorData()) : XMLUtils.syncExcludeFromDorData(data, guideValidationResult.getExcludeFromDorData());
                RequestParameter[] jcrData = new RequestParameter[]{new FormFieldRequestParameter(data)};
                wrappedParameterMap.put((Object)"jcr:data", (Object)jcrData);
            }
            submitInfo.setData(data);
        }
        submitInfo.setFormSubmitter(resourceResolver.getUserID());
        submitInfo.setLocale(GuideUtils.getXFALocale(locale));
        if (request.getParameter("_useSignedPdf") != null || isAdobeSignEnabled.booleanValue()) {
            if (isDorConfigured) {
                wrappedParameterMap = this.guidePDFSubmitHelper.getWrappedParameterMapForPdfSubmit(request, response, wrappedParameterMap);
                String pdfName = (String)request.getAttribute("pdfName");
                FileRequestParameter pdfRequestParam = (FileRequestParameter)((RequestParameter[])wrappedParameterMap.get((Object)pdfName))[0];
                submitInfo.setDocumentOfRecord(new FileAttachmentWrapper(pdfName, "application/pdf", pdfRequestParam.get()));
            } else {
                this.logger.debug("DOR Template is not configured for the form. Skipping DOR generation");
            }
        }
        request.setAttribute("FormSubmitInfo", (Object)submitInfo);
        if (isRedirectURLSet.booleanValue() && isAdobeSignEnabled.booleanValue() && (postSignUrl = GuideSubmitServlet.getRedirectUrl(request)) != null) {
            postSignUrl = GuideSubmitUtils.addContextPathWithServerUrl(postSignUrl, request.getContextPath(), this.getServerUrl(request));
        }
        if (isAdobeSignEnabled.booleanValue() && submitInfo.getDocumentOfRecord() != null && (signAgreementInfo = this.signAgreementService.createAgreement(submitInfo, postSignUrl, SubmitType.IMMEDIATE == submitType)).getAgreementId() == null) {
            ((SubmitResult)result).setErrorResult(GuideSubmitErrorCause.AGREEMENT_CREATION, "Error During Agreement Creation", "500");
            this.logger.error("Could not complete Submit Action due to failed agreement creation");
            return result;
        }
        if (this.formsPortalPreProcessor != null) {
            HashMap<String, Object> preProcessorOptions = new HashMap<String, Object>();
            preProcessorOptions.put("FormSubmitInfo", submitInfo);
            preProcessorOptions.put("enablePortalSubmit", Boolean.valueOf((String)properties.get("enablePortalSubmit", (Object)"false")));
            if (signAgreementInfo != null) {
                submitInfo.setAgreementId(signAgreementInfo.getAgreementId());
                preProcessorOptions.put("signAgreementInfo", signAgreementInfo);
            }
            preProcessorOptions.put("submitType", (Object)submitType);
            preProcessorOptions.put("draftID", request.getParameter("draftID"));
            preProcessorOptions.put("afSubmissionInfo", request.getParameter("afSubmissionInfo"));
            PortalRecordInfo portalResult = this.formsPortalPreProcessor.doPreProcess(preProcessorOptions);
            submitInfo.setPortalRecordInfo(portalResult);
        }
        result.result = signAgreementInfo;
        return result;
    }

    private ParameterMap addGuideValueMap(SlingHttpServletRequest request, ParameterMap wrappedParameterMap) throws JSONException {
        String guideValues = request.getParameter("_guideValuesMap");
        JSONObject guideValueMapJson = StringUtils.isNotEmpty((String)guideValues) ? new JSONObject(guideValues) : new JSONObject();
        FormSubmitInfo submitInfo = (FormSubmitInfo)request.getAttribute("FormSubmitInfo");
        PortalRecordInfo portalResult = submitInfo.getPortalRecordInfo();
        if (portalResult != null) {
            String submitLink;
            String submitId = portalResult.getSubmitID();
            if (StringUtils.isNotEmpty((String)submitId)) {
                guideValueMapJson.put("submitID", (Object)submitId);
            }
            if (StringUtils.isNotEmpty((String)(submitLink = portalResult.getSubmitLink()))) {
                guideValueMapJson.put("submitLink", (Object)submitLink);
            }
        }
        FormFieldRequestParameter paramValue = new FormFieldRequestParameter(guideValueMapJson.toString());
        RequestParameter[] paramArr = new RequestParameter[]{paramValue};
        GuideUtils.addToRequestMap(wrappedParameterMap, "_guideValuesMap", paramArr);
        return wrappedParameterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubmitResult doSubmit(SlingHttpServletRequest request, SlingHttpServletResponse response) throws RepositoryException, ServletException, IOException, JSONException {
        String forwardPath;
        Resource forwardResource;
        block43: {
            HashMap<String, String> optionsMap;
            boolean asyncSubmit;
            Boolean isPortalSubmitEnabled;
            Boolean isAdobeSignEnabled;
            ValueMap properties;
            SignAgreementInfo signAgreementInfo;
            ParameterMap wrappedParameterMap;
            SlingHttpServletRequest wrappedRequest;
            block42: {
                Object actionType;
                Resource formResource;
                SubmitResult result;
                block41: {
                    SubmitResult<SignAgreementInfo> postPrerequisitesResult;
                    block40: {
                        SubmitResult<ParameterMap> addToNewRequestResult;
                        block39: {
                            forwardResource = null;
                            forwardPath = null;
                            result = new SubmitResult();
                            wrappedRequest = request;
                            addToNewRequestResult = this.addToNewRequest(wrappedRequest, response);
                            if (!((SubmitResult)addToNewRequestResult).hasError()) break block39;
                            SubmitResult<ParameterMap> submitResult = addToNewRequestResult;
                            try {
                                ModifiableValueMap forwardResourceProperties;
                                if (forwardResource != null && (forwardResourceProperties = (ModifiableValueMap)forwardResource.adaptTo(ModifiableValueMap.class)) != null && forwardResourceProperties.containsKey((Object)"afStoreContentTempPermission")) {
                                    forwardResourceProperties.remove((Object)"afStoreContentTempPermission");
                                    request.getResourceResolver().commit();
                                    this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
                                }
                            }
                            catch (Exception ex) {
                                this.logger.error("Could not unset privileges", (Throwable)ex);
                            }
                            return submitResult;
                        }
                        wrappedParameterMap = (ParameterMap)addToNewRequestResult.result;
                        postPrerequisitesResult = this.doPostPrerequisites(request, response, wrappedParameterMap, SubmitType.DEFERRED);
                        if (!((SubmitResult)postPrerequisitesResult).hasError()) break block40;
                        postPrerequisitesResult.wrappedParameterMap = wrappedParameterMap;
                        SubmitResult<SignAgreementInfo> ex = postPrerequisitesResult;
                        try {
                            ModifiableValueMap forwardResourceProperties;
                            if (forwardResource != null && (forwardResourceProperties = (ModifiableValueMap)forwardResource.adaptTo(ModifiableValueMap.class)) != null && forwardResourceProperties.containsKey((Object)"afStoreContentTempPermission")) {
                                forwardResourceProperties.remove((Object)"afStoreContentTempPermission");
                                request.getResourceResolver().commit();
                                this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
                            }
                        }
                        catch (Exception ex2) {
                            this.logger.error("Could not unset privileges", (Throwable)ex2);
                        }
                        return ex;
                    }
                    signAgreementInfo = (SignAgreementInfo)postPrerequisitesResult.result;
                    formResource = request.getResource();
                    properties = ResourceUtil.getValueMap((Resource)formResource);
                    isAdobeSignEnabled = Boolean.valueOf((String)properties.get("_useSignedPdf", (Object)""));
                    isPortalSubmitEnabled = Boolean.valueOf((String)properties.get("enablePortalSubmit", (Object)"false"));
                    asyncSubmit = "true".equals(request.getParameter("_asyncSubmit"));
                    String pendingSignUrl = null;
                    if (signAgreementInfo != null) {
                        pendingSignUrl = signAgreementInfo.getSigningURL();
                    }
                    if (asyncSubmit || !isAdobeSignEnabled.booleanValue() || !StringUtils.isNotEmpty((String)pendingSignUrl)) break block41;
                    response.sendRedirect(pendingSignUrl);
                    SubmitResult submitResult = null;
                    try {
                        ModifiableValueMap forwardResourceProperties;
                        if (forwardResource != null && (forwardResourceProperties = (ModifiableValueMap)forwardResource.adaptTo(ModifiableValueMap.class)) != null && forwardResourceProperties.containsKey((Object)"afStoreContentTempPermission")) {
                            forwardResourceProperties.remove((Object)"afStoreContentTempPermission");
                            request.getResourceResolver().commit();
                            this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error("Could not unset privileges", (Throwable)ex);
                    }
                    return submitResult;
                }
                optionsMap = new HashMap<String, String>();
                wrappedParameterMap = this.addGuideValueMap(wrappedRequest, wrappedParameterMap);
                wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
                CustomResponse wrappedResp = new CustomResponse(response);
                this.setDefaultRedirectParameters(wrappedRequest);
                if (!isAdobeSignEnabled.booleanValue()) {
                    actionType = (String)properties.get("actionType", (Object)"");
                    if (StringUtils.isEmpty((String)actionType)) {
                        this.logger.warn("Author has not associated any submit action with the form.");
                    }
                    FormsHelper.runAction((String)actionType, (String)"post", (Resource)formResource, (SlingHttpServletRequest)wrappedRequest, (SlingHttpServletResponse)wrappedResp);
                }
                if (wrappedResp.getStatus() != 500) break block42;
                result.errorResult = request.getAttribute("FormSubmissionError") != null && request.getAttribute("FormSubmissionError") instanceof GuideValidationResult ? (GuideValidationResult)request.getAttribute("FormSubmissionError") : GuideSubmitUtils.getDefaultGuideValidationResult();
                result.wrappedParameterMap = wrappedParameterMap;
                actionType = result;
                try {
                    ModifiableValueMap forwardResourceProperties;
                    if (forwardResource != null && (forwardResourceProperties = (ModifiableValueMap)forwardResource.adaptTo(ModifiableValueMap.class)) != null && forwardResourceProperties.containsKey((Object)"afStoreContentTempPermission")) {
                        forwardResourceProperties.remove((Object)"afStoreContentTempPermission");
                        request.getResourceResolver().commit();
                        this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Could not unset privileges", (Throwable)ex);
                }
                return actionType;
            }
            try {
                String redirectUrl = GuideSubmitServlet.getRedirectUrl(wrappedRequest);
                FormSubmitInfo submitInfo = (FormSubmitInfo)request.getAttribute("FormSubmitInfo");
                if (asyncSubmit || redirectUrl == null || redirectUrl.length() == 0) {
                    JSONObject successPayload = new JSONObject(this.prepareSuccessPayload(wrappedRequest, properties, redirectUrl));
                    Map<String, String> redirectParamsMap = GuideSubmitUtils.getRedirectParameters(wrappedRequest);
                    redirectParamsMap.put("afSuccessPayload", successPayload.toString());
                    if (redirectUrl != null) {
                        redirectParamsMap.put("afSuccessRedirectUrl", redirectUrl);
                    }
                    if (isAdobeSignEnabled.booleanValue()) {
                        if (signAgreementInfo != null) {
                            redirectParamsMap.put("agreementId", signAgreementInfo.getAgreementId());
                        }
                        redirectParamsMap.put("systemId", submitInfo.getPortalRecordInfo().getSubmitID());
                    } else if (isPortalSubmitEnabled.booleanValue()) {
                        PortalRecordInfo portalRecordInfo = submitInfo.getPortalRecordInfo();
                        redirectParamsMap.put("submitID", portalRecordInfo.getSubmitID());
                        redirectParamsMap.put("path", portalRecordInfo.getSubmitLink());
                    }
                    GuideSubmitUtils.setRedirectParameters(wrappedRequest, redirectParamsMap);
                    redirectUrl = request.getResource().getPath() + "." + "guideAsyncThankYouPage.html";
                    redirectUrl = GuideSubmitUtils.prepareRedirectUrl(wrappedRequest, redirectUrl);
                } else {
                    redirectUrl = GuideSubmitUtils.prepareRedirectUrl(wrappedRequest, redirectUrl);
                }
                FormFieldRequestParameter rpm = new FormFieldRequestParameter(redirectUrl);
                RequestParameter[] f = new RequestParameter[]{rpm};
                GuideUtils.addToRequestMap(wrappedParameterMap, ":redirect", f);
                this.removeUnusedParameters(wrappedParameterMap);
                wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
                forwardPath = this.getForwardPath(wrappedRequest);
                if (forwardPath != null && forwardPath.length() > 0) {
                    forwardResource = wrappedRequest.getResourceResolver().resolve(forwardPath);
                    Objects.requireNonNull(request.getRequestDispatcher(forwardResource, this.getForwardOptions((ServletRequest)wrappedRequest))).forward((ServletRequest)wrappedRequest, (ServletResponse)response);
                } else {
                    redirectUrl = GuideSubmitUtils.addContextPath(redirectUrl, request.getContextPath());
                    response.sendRedirect(redirectUrl);
                }
                if (isAdobeSignEnabled.booleanValue()) break block43;
                for (GuideSubmitPostProcessor guideSubmitPostProcessor : this.guideSubmitPostProcessors.values()) {
                    try {
                        guideSubmitPostProcessor.handlePostProcess(submitInfo.getData(), submitInfo.getFileAttachments(), optionsMap);
                    }
                    catch (Exception e) {
                        this.logger.error("The current guideSubmitPostProcessor could not give path", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    ModifiableValueMap forwardResourceProperties;
                    if (forwardResource != null && (forwardResourceProperties = (ModifiableValueMap)forwardResource.adaptTo(ModifiableValueMap.class)) != null && forwardResourceProperties.containsKey((Object)"afStoreContentTempPermission")) {
                        forwardResourceProperties.remove((Object)"afStoreContentTempPermission");
                        request.getResourceResolver().commit();
                        this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Could not unset privileges", (Throwable)ex);
                }
                throw throwable;
            }
        }
        try {
            ModifiableValueMap forwardResourceProperties;
            if (forwardResource != null && (forwardResourceProperties = (ModifiableValueMap)forwardResource.adaptTo(ModifiableValueMap.class)) != null && forwardResourceProperties.containsKey((Object)"afStoreContentTempPermission")) {
                forwardResourceProperties.remove((Object)"afStoreContentTempPermission");
                request.getResourceResolver().commit();
                this.guideStoreContentSubmission.unsetPrivilegesForStoreContent(GuideUtils.getUserSessionFromRequest(request), forwardPath);
            }
        }
        catch (Exception ex) {
            this.logger.error("Could not unset privileges", (Throwable)ex);
        }
        return null;
    }

    private void setDefaultRedirectParameters(SlingHttpServletRequest wrappedRequest) {
        Map<String, String> redirectParameters = GuideSubmitUtils.getRedirectParameters(wrappedRequest);
        if (!redirectParameters.containsKey("owner")) {
            redirectParameters.put("owner", GuideSubmitUtils.getUserID(wrappedRequest));
        }
        if (!redirectParameters.containsKey("status")) {
            redirectParameters.put("status", "Submitted");
        }
        GuideSubmitUtils.setRedirectParameters(wrappedRequest, redirectParameters);
    }

    private SubmitResult sendAgreementInfo(SlingHttpServletRequest request, SlingHttpServletResponse response) throws RepositoryException, JSONException, IOException {
        SubmitResult<ParameterMap> addToNewRequestResult = this.addToNewRequest(request, response);
        if (((SubmitResult)addToNewRequestResult).hasError()) {
            return addToNewRequestResult;
        }
        ParameterMap wrappedParameterMap = (ParameterMap)addToNewRequestResult.result;
        SubmitResult<SignAgreementInfo> postPrerequisitesResult = this.doPostPrerequisites(request, response, wrappedParameterMap, SubmitType.IMMEDIATE);
        if (((SubmitResult)postPrerequisitesResult).hasError()) {
            postPrerequisitesResult.wrappedParameterMap = wrappedParameterMap;
            return postPrerequisitesResult;
        }
        SignAgreementInfo signAgreementInfo = (SignAgreementInfo)postPrerequisitesResult.result;
        JSONObject jsonObject = new JSONObject();
        FormSubmitInfo submitInfo = (FormSubmitInfo)request.getAttribute("FormSubmitInfo");
        PortalRecordInfo portalResult = submitInfo.getPortalRecordInfo();
        if (StringUtils.isNotEmpty((String)signAgreementInfo.getSigningURL())) {
            jsonObject.put("signingURL", (Object)signAgreementInfo.getSigningURL());
        }
        jsonObject.put("agreementId", (Object)signAgreementInfo.getAgreementId());
        jsonObject.put("systemId", (Object)portalResult.getSubmitID());
        this.sendJSONResponse(response, jsonObject);
        return null;
    }

    private void doSignSubmit(SlingHttpServletRequest request, SlingHttpServletResponse response) throws JSONException, IOException {
        Resource formContainerResource = request.getResource();
        Resource signerInfoResource = formContainerResource.getChild("signerInfo");
        String signConfigPath = "";
        String agreementId = request.getParameter("agreementId");
        String systemId = request.getParameter("systemId");
        String newSystemId = "";
        String pendingSignId = "";
        String link = "";
        if (signerInfoResource != null) {
            signConfigPath = (String)signerInfoResource.getValueMap().get("signConfigPath", (Object)"");
        }
        if (StringUtils.isNotEmpty((String)signConfigPath)) {
            Map<String, Object> result = this.signAgreementService.submitAgreement(systemId, agreementId, signConfigPath);
            if (result != null) {
                link = (String)result.get("path");
                newSystemId = (String)result.get("submitID");
                pendingSignId = (String)result.get("pendingSignID");
            } else {
                pendingSignId = systemId;
                link = "/content/forms/portal/render.dor.pdf/pendingSign/" + pendingSignId;
            }
        }
        Resource afResource = GuideSubmitUtils.getParentResource(formContainerResource, "cq:Page");
        String formName = (String)afResource.getValueMap().get("jcr:title", (Object)afResource.getName());
        String submitId = "";
        if (StringUtils.isNotEmpty((String)newSystemId)) {
            submitId = newSystemId;
        } else if (StringUtils.isNotEmpty((String)pendingSignId)) {
            submitId = pendingSignId;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("agreementId", (Object)agreementId);
        jsonObject.put("guideName", (Object)formName);
        jsonObject.put("submitID", (Object)submitId);
        jsonObject.put("owner", (Object)GuideSubmitUtils.getUserID(request));
        jsonObject.put("path", (Object)link);
        this.sendJSONResponse(response, jsonObject);
    }

    private void sendJSONResponse(SlingHttpServletResponse response, JSONObject jsonObject) throws IOException {
        response.setContentType("application/json");
        response.getWriter().write(jsonObject.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        block21: {
            String[] requestSelectors = request.getRequestPathInfo().getSelectors();
            String requestSelector = "";
            if (requestSelectors.length > 1) {
                requestSelector = requestSelectors[1];
            }
            SubmitResult result = null;
            ParameterMap wrappedParameterMap = null;
            SubmitResult<ParameterMap> addToNewRequestResult = this.addToNewRequest(request, response);
            if (!((SubmitResult)addToNewRequestResult).hasError()) {
                wrappedParameterMap = (ParameterMap)addToNewRequestResult.result;
            }
            boolean recordTransaction = true;
            try {
                this.transactionRecorder.startContext();
                if ("signSubmit".equals(requestSelector)) {
                    recordTransaction = false;
                    this.doSignSubmit(request, response);
                } else {
                    result = "agreement".equals(requestSelector) ? this.sendAgreementInfo(request, response) : this.doSubmit(request, response);
                }
                if (result != null && result.hasError()) {
                    this.sendErrorBackToClient(request, response, result.wrappedParameterMap != null ? result.wrappedParameterMap : wrappedParameterMap, result.errorResult);
                    this.transactionRecorder.discardTransaction();
                    break block21;
                }
                if (!recordTransaction) break block21;
                try {
                    if (response.getStatus() < 400) {
                        TransactionRecord transactionRecord = this.getAdaptiveFormSubmitTransaction(request.getResource());
                        this.transactionRecorder.recordTransaction(transactionRecord);
                        break block21;
                    }
                    this.transactionRecorder.discardTransaction();
                }
                catch (TransactionException e) {
                    this.logger.error("Transaction exception while recording transaction", (Throwable)e);
                }
            }
            catch (GuideException e) {
                this.sendErrorBackToClient(request, response, wrappedParameterMap, null);
                this.logger.error("Could not complete Submit Action due to " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                GuideValidationResult guideValidationResult = GuideSubmitUtils.getDefaultGuideValidationResult();
                if (e instanceof IOException | e instanceof RepositoryException) {
                    guideValidationResult.setErrorMessage("System error occurred during IO");
                } else if (e instanceof JSONException) {
                    guideValidationResult.setErrorMessage("System error occurred during JSON operations");
                } else if (e instanceof ServletException) {
                    guideValidationResult.setErrorMessage("Failed to forward/process request");
                }
                if (recordTransaction) {
                    this.transactionRecorder.discardTransaction();
                }
                this.sendErrorBackToClient(request, response, wrappedParameterMap, guideValidationResult);
                this.logger.error("Could not complete Submit Action due to " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.transactionRecorder.endContext();
            }
        }
    }

    private void sendErrorBackToClient(SlingHttpServletRequest request, SlingHttpServletResponse response, ParameterMap wrappedParameterMap, GuideValidationResult guideValidationResult) {
        if (guideValidationResult == null) {
            guideValidationResult = GuideSubmitUtils.getDefaultGuideValidationResult();
        }
        CustomParameterRequest wrappedErrorRequest = new CustomParameterRequest(request, wrappedParameterMap, "GET");
        wrappedErrorRequest.setAttribute("guideErrorList", (Object)guideValidationResult);
        JSONObject errorObject = guideValidationResult.getValidationPayload();
        wrappedErrorRequest.setAttribute("guideError", (Object)errorObject);
        wrappedErrorRequest.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)WCMMode.DISABLED);
        wrappedErrorRequest.setAttribute("data", (Object)request.getParameter("jcr:data"));
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSuffix(null);
        options.setReplaceSelectors(null);
        if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With")) || "true".equals(request.getParameter("_asyncSubmit"))) {
            response.setStatus(500);
            response.setContentType("application/json");
            try {
                response.getWriter().write(errorObject.toString());
            }
            catch (IOException e) {
                if (errorObject != null) {
                    this.logger.debug("sendErrorBackToClient: errorObject:" + errorObject.toString());
                }
                this.logger.error("sendErrorBackToClient: failed to write to response " + e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                Objects.requireNonNull(request.getRequestDispatcher(request.getParameter(":selfUrl") + ".html", options)).forward((ServletRequest)wrappedErrorRequest, (ServletResponse)response);
            }
            catch (IOException | NullPointerException | ServletException e) {
                this.logger.error("sendErrorBackToClient: failed to forward request " + e.getMessage(), e);
            }
        }
    }

    protected void bindGuideSubmitPostProcessors(GuideSubmitPostProcessor guideSubmitPostProcessor, Map<String, Object> config) {
        this.guideSubmitPostProcessors.put(ServiceUtil.getComparableForServiceRanking(config), guideSubmitPostProcessor);
    }

    protected void unbindGuideSubmitPostProcessors(GuideSubmitPostProcessor guideSubmitPostProcessor, Map<String, Object> config) {
        this.guideSubmitPostProcessors.remove(ServiceUtil.getComparableForServiceRanking(config));
    }

    private RequestDispatcherOptions getForwardOptions(ServletRequest req) {
        return (RequestDispatcherOptions)req.getAttribute(REQ_ATTR_FORWARD_OPTIONS);
    }

    private String getServerUrl(SlingHttpServletRequest req) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        return url.toString();
    }

    @Deprecated
    public static void setForwardPath(SlingHttpServletRequest req, String path, String selector, String suffix) {
        GuideSubmitUtils.setForwardPath(req, path, selector, suffix);
    }

    private String getForwardPath(SlingHttpServletRequest req) {
        return (String)req.getAttribute(REQ_ATTR_FORWARD_PATH);
    }

    private static String getRedirectUrl(SlingHttpServletRequest request) {
        String redirectUrl = (String)request.getAttribute(":redirect");
        if (redirectUrl == null) {
            redirectUrl = request.getParameter(":redirect");
        }
        return redirectUrl;
    }

    @Deprecated
    public static String getReqAttrPdfName(SlingHttpServletRequest request) {
        return GuideSubmitUtils.getReqAttrPdfName(request);
    }

    public static void setRequestAttrPdfName(SlingHttpServletRequest request, String value) {
        request.setAttribute("pdfName", (Object)value);
    }

    private SubmitResult<ParameterMap> addToNewRequest(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        SubmitResult<ParameterMap> result = new SubmitResult<ParameterMap>();
        ParameterMap wrappedParameterMap = new ParameterMap();
        RequestParameterMap originalParams = request.getRequestParameterMap();
        for (Map.Entry param : originalParams.entrySet()) {
            boolean isFile;
            RequestParameter rp = ((RequestParameter[])param.getValue())[0];
            boolean bl = isFile = ((String)param.getKey()).contains("_guideFileAttachment.") && "_guideFileAttachment.".equals(((String)param.getKey()).substring(0, 21));
            if (!rp.isFormField()) {
                RequestParameter[] rps = (RequestParameter[])param.getValue();
                String[] fileNames = null;
                try {
                    fileNames = URLDecoder.decode(rps[0].getName(), StandardCharsets.UTF_8.name()).split("\\r\\n|\\r|\\n");
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error("Exception in decoding filename parameter", (Throwable)e);
                }
                if (fileNames == null) continue;
                for (int fileIndex = 0; fileIndex < fileNames.length; ++fileIndex) {
                    RequestParameter[] fileRpm = new RequestParameter[1];
                    String fileName = fileNames[fileIndex];
                    fileRpm[0] = new FileRequestParameter(fileName, rps[fileIndex].get(), rps[fileIndex].getContentType());
                    GuideUtils.addToRequestMap(wrappedParameterMap, fileName, fileRpm);
                }
                continue;
            }
            if (!isFile) {
                GuideUtils.addToRequestMap(wrappedParameterMap, (String)param.getKey(), (RequestParameter[])param.getValue());
                continue;
            }
            String paramName = ((String)param.getKey()).substring(21);
            RequestParameter rpm = ((RequestParameter[])param.getValue())[0];
            RequestParameter[] fileRpm = new RequestParameter[1];
            String fileUrl = rpm.toString();
            String normalizedFileUrl = "";
            normalizedFileUrl = ResourceUtil.normalize((String)fileUrl);
            if (normalizedFileUrl == null) {
                String error = "[AEMAF] Invalid Path in File Attachement " + fileUrl;
                this.logger.error(error);
                ((SubmitResult)result).setErrorResult(GuideSubmitErrorCause.FORM_SUBMISSION, error, "400");
                return result;
            }
            if (normalizedFileUrl.startsWith("/tmp/fd/af/")) {
                Resource fileResource = request.getResourceResolver().getResource(normalizedFileUrl);
                if (fileResource != null) {
                    fileRpm[0] = new FileRequestParameter(paramName, fileResource);
                }
            } else {
                try {
                    ParameterMap newMap = new ParameterMap();
                    CustomParameterRequest newRequest = new CustomParameterRequest(request, newMap, "GET");
                    CustomResponse newResponse = new CustomResponse(response);
                    Objects.requireNonNull(newRequest.getRequestDispatcher(normalizedFileUrl, new RequestDispatcherOptions())).forward((ServletRequest)newRequest, (ServletResponse)newResponse);
                    byte[] fileBytes = newResponse.getCopy();
                    String contentType = newResponse.getContentType();
                    fileRpm[0] = new FileRequestParameter(paramName, fileBytes, contentType);
                }
                catch (Exception e) {
                    String error = "[AEMAF]Error while hitting REST URL";
                    this.logger.error(error, (Throwable)e);
                    ((SubmitResult)result).setErrorResult(GuideSubmitErrorCause.FORM_SUBMISSION, error, "400");
                    return result;
                }
            }
            GuideUtils.addToRequestMap(wrappedParameterMap, paramName, fileRpm);
        }
        result.result = wrappedParameterMap;
        return result;
    }

    private SubmitResult<List<FileAttachmentWrapper>> getFileAttachmentWrapperList(ParameterMap parameterMap, List<JSONObject> fileAttachmentList, ResourceResolver resourceResolver, String fileAttachmentMap, I18n i18n) {
        SubmitResult<List<FileAttachmentWrapper>> result = new SubmitResult<List<FileAttachmentWrapper>>();
        ArrayList<FileAttachmentWrapper> fileAttachments = new ArrayList<FileAttachmentWrapper>();
        for (Map.Entry param : parameterMap.entrySet()) {
            RequestParameter[] rpm = (RequestParameter[])param.getValue();
            if (rpm != null && rpm.length > 0 && rpm[0] == null) {
                ((SubmitResult)result).setErrorResult(GuideSubmitErrorCause.FORM_SUBMISSION, "getFileAttachmentWrapperList: rpm[0] is null for:" + (String)param.getKey(), "500");
                this.logger.error("getFileAttachmentWrapperList: rpm[0] is null for:" + (String)param.getKey());
                return result;
            }
            if (rpm == null || rpm.length <= 0 || rpm[0].isFormField()) continue;
            FileAttachmentWrapper fileAttachment = new FileAttachmentWrapper(rpm[0].getFileName(), rpm[0].getContentType(), rpm[0].get());
            IValidationResult validationResult = GuideUtils.validateFileNameAndContentType(fileAttachment, fileAttachmentList, resourceResolver, fileAttachmentMap);
            if (!validationResult.isSuccess()) {
                String invalidErrorMessage = "[AF] Invalid file name or mime type for file resulted in submission failure";
                ((SubmitResult)result).setErrorResult(GuideSubmitErrorCause.FORM_SUBMISSION, i18n.getVar(validationResult.getMessage()), "400");
                this.logger.error(invalidErrorMessage);
                return result;
            }
            fileAttachments.add(fileAttachment);
        }
        result.result = fileAttachments;
        return result;
    }

    private void removeUnusedParameters(ParameterMap map) {
        map.remove((Object)"_useSignedPdf");
        map.remove((Object)"_asyncSubmit");
    }

    private Map<String, String> prepareSuccessPayload(SlingHttpServletRequest request, ValueMap properties, String redirectUrl) throws UnsupportedEncodingException {
        Resource aemFormResource;
        String aemFormCompPath = request.getParameter("aemFormComponentPath");
        String defaultThankYouPageUrl = request.getParameter("guideContainerPath") + "." + "guideThankYouPage.html";
        String defaultThankYouMessage = I18n.get((HttpServletRequest)request, (String)"Thank you for submitting the form.");
        HashMap<String, String> successPayload = new HashMap();
        Resource resource = aemFormResource = StringUtils.isBlank((String)aemFormCompPath) ? null : request.getResourceResolver().getResource(aemFormCompPath);
        if (redirectUrl == null) {
            redirectUrl = defaultThankYouPageUrl;
        }
        if (aemFormResource != null) {
            String thankYouContent;
            ValueMap aemFormProperties = (ValueMap)aemFormResource.adaptTo(ValueMap.class);
            if (aemFormProperties == null) {
                return successPayload;
            }
            String thankYouOption = (String)aemFormProperties.get("thankyouConfig", (Object)GuideConstants.ThankYouOption.PAGE.toString());
            String thankYouPage = GuideUtils.getRedirectUrl((String)aemFormProperties.get("thankyouPage", (Object)""), null);
            String thankYouMessage = (String)aemFormProperties.get("thankyouMessage", (Object)defaultThankYouMessage);
            if (GuideConstants.ThankYouOption.PAGE.toString().equals(thankYouOption)) {
                thankYouContent = StringUtils.isBlank((String)thankYouPage) ? GuideSubmitUtils.addContextPath(defaultThankYouPageUrl, request.getContextPath()) : GuideSubmitUtils.addContextPath(thankYouPage, request.getContextPath());
                thankYouContent = GuideSubmitUtils.prepareRedirectUrl(request, thankYouContent);
            } else {
                thankYouContent = thankYouMessage;
            }
            successPayload.put("thankYouOption", thankYouOption);
            successPayload.put("thankYouContent", thankYouContent);
            successPayload.put("aemFormComponentPath", aemFormCompPath);
        } else {
            successPayload = GuideSubmitUtils.getAFSuccessPayload(request, properties, redirectUrl);
        }
        return successPayload;
    }

    protected void bindTransactionRecorder(ITransactionRecorder iTransactionRecorder) {
        this.transactionRecorder = iTransactionRecorder;
    }

    protected void unbindTransactionRecorder(ITransactionRecorder iTransactionRecorder) {
        if (this.transactionRecorder == iTransactionRecorder) {
            this.transactionRecorder = null;
        }
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }

    protected void bindSignAgreementService(SignAgreementService signAgreementService) {
        this.signAgreementService = signAgreementService;
    }

    protected void unbindSignAgreementService(SignAgreementService signAgreementService) {
        if (this.signAgreementService == signAgreementService) {
            this.signAgreementService = null;
        }
    }

    protected void bindGuidePDFSubmitHelper(GuidePDFSubmitHelper guidePDFSubmitHelper) {
        this.guidePDFSubmitHelper = guidePDFSubmitHelper;
    }

    protected void unbindGuidePDFSubmitHelper(GuidePDFSubmitHelper guidePDFSubmitHelper) {
        if (this.guidePDFSubmitHelper == guidePDFSubmitHelper) {
            this.guidePDFSubmitHelper = null;
        }
    }

    protected void bindGuideStoreContentSubmission(GuideStoreContentSubmission guideStoreContentSubmission) {
        this.guideStoreContentSubmission = guideStoreContentSubmission;
    }

    protected void unbindGuideStoreContentSubmission(GuideStoreContentSubmission guideStoreContentSubmission) {
        if (this.guideStoreContentSubmission == guideStoreContentSubmission) {
            this.guideStoreContentSubmission = null;
        }
    }

    protected void bindFormsPortalPreProcessor(FormPortalSubmitPreprocessor formPortalSubmitPreprocessor) {
        this.formsPortalPreProcessor = formPortalSubmitPreprocessor;
    }

    protected void unbindFormsPortalPreProcessor(FormPortalSubmitPreprocessor formPortalSubmitPreprocessor) {
        if (this.formsPortalPreProcessor == formPortalSubmitPreprocessor) {
            this.formsPortalPreProcessor = null;
        }
    }

    private static class SubmitResult<T> {
        T result = null;
        ParameterMap wrappedParameterMap = null;
        GuideValidationResult errorResult = null;

        private SubmitResult() {
        }

        private boolean hasError() {
            return this.errorResult != null;
        }

        private void setErrorResult(GuideSubmitErrorCause errorCause, String errorMessage, String originCode) {
            this.errorResult = new GuideValidationResult(errorCause, errorMessage);
            this.errorResult.setOriginDetails(originCode, null);
        }
    }
}

