/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.service.GuidePDFSubmitHelper;
import com.adobe.forms.common.service.DoRTemplateParsingException;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer"}), @Property(name="sling.servlet.methods", value={"GET", "POST"}), @Property(name="service.description", value={"DOR Generation"}), @Property(name="sling.servlet.selectors", value={"af.dor"}), @Property(name="sling.servlet.extensions", value={"pdf"})})
public class DorGenerationServlet
extends SlingAllMethodsServlet {
    @Reference
    private GuidePDFSubmitHelper guidePDFSubmitHelper;
    private Logger logger = LoggerFactory.getLogger(DorGenerationServlet.class);

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            RequestPathInfo requestPathInfo = request.getRequestPathInfo();
            String renderType = "print." + requestPathInfo.getExtension();
            request.setAttribute("renderType", (Object)renderType);
            Map<String, Object> renderOutputMap = this.guidePDFSubmitHelper.getGeneratedDor(request, response);
            response.setContentType((String)renderOutputMap.get("contentType"));
            response.getOutputStream().write((byte[])renderOutputMap.get("outputContent"));
        }
        catch (DoRTemplateParsingException e) {
            this.logger.error("Exception in DOR Template Parsing Exception for Dor generation:", (Throwable)e);
            response.setStatus(500);
            response.getWriter().write("DoR Template Parsing Exception");
        }
        catch (Exception e) {
            this.logger.error("Exception in doGet for Dor generation:", (Throwable)e);
            response.setStatus(500);
            response.getWriter().write("DoR Generation Failed");
        }
    }

    protected void bindGuidePDFSubmitHelper(GuidePDFSubmitHelper guidePDFSubmitHelper) {
        this.guidePDFSubmitHelper = guidePDFSubmitHelper;
    }

    protected void unbindGuidePDFSubmitHelper(GuidePDFSubmitHelper guidePDFSubmitHelper) {
        if (this.guidePDFSubmitHelper == guidePDFSubmitHelper) {
            this.guidePDFSubmitHelper = null;
        }
    }
}

