/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model;

import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.XMLUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormSubmitInfo {
    private Resource formContainerResource;
    private String formContainerPath;
    private String data;
    private String locale;
    private List<FileAttachmentWrapper> fileAttachments;
    private String fileAttachmentMap;
    private FileAttachmentWrapper documentOfRecord;
    private String formSubmitter;
    private String contentType;
    private byte[] signData;
    private String agreementId;
    private PortalRecordInfo portalRecordInfo;
    private static Logger logger = LoggerFactory.getLogger(FormSubmitInfo.class);

    public String getFormContainerPath() {
        return this.formContainerPath;
    }

    public void setFormContainerPath(String formContainerPath) {
        this.formContainerPath = formContainerPath;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data = this.addMetaInfoInData(data);
    }

    public List<FileAttachmentWrapper> getFileAttachments() {
        return this.fileAttachments;
    }

    public void setFileAttachments(List<FileAttachmentWrapper> fileAttachments) {
        this.fileAttachments = fileAttachments;
    }

    public FileAttachmentWrapper getDocumentOfRecord() {
        return this.documentOfRecord;
    }

    public void setDocumentOfRecord(FileAttachmentWrapper documentOfRecord) {
        this.documentOfRecord = documentOfRecord;
    }

    public String getFileAttachmentMap() {
        return this.fileAttachmentMap;
    }

    public void setFileAttachmentMap(String fileAttachmentMap) {
        this.fileAttachmentMap = fileAttachmentMap;
    }

    public Resource getFormContainerResource() {
        return this.formContainerResource;
    }

    public void setFormContainerResource(Resource formContainerResource) {
        this.formContainerResource = formContainerResource;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getFormSubmitter() {
        return this.formSubmitter;
    }

    public void setFormSubmitter(String formSubmitter) {
        this.formSubmitter = formSubmitter;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getSignData() {
        return this.signData;
    }

    public void setSignData(byte[] signData) {
        this.signData = signData;
    }

    public String getAgreementId() {
        return this.agreementId;
    }

    public void setAgreementId(String agreementId) {
        this.agreementId = agreementId;
    }

    public PortalRecordInfo getPortalRecordInfo() {
        return this.portalRecordInfo;
    }

    public void setPortalRecordInfo(PortalRecordInfo portalRecordInfo) {
        this.portalRecordInfo = portalRecordInfo;
    }

    private String addMetaInfoInData(String data) {
        String messagedData = data;
        switch (MimeContentType.getMimeType(this.contentType)) {
            case APPLICATION_XML: {
                messagedData = XMLUtils.addSubmissionInfoMetaData(data, this.formContainerPath, this.getDateForSubmissionTime());
                break;
            }
            case APPLICATION_JSON: {
                messagedData = this.addSubmissionInfoMetaDataToJson(data);
            }
        }
        return messagedData;
    }

    private String addSubmissionInfoMetaDataToJson(String data) {
        String messagedData = data;
        try {
            JSONObject dataJsonObject = new JSONObject(data);
            JSONObject submissionInfoRootTag = dataJsonObject.optJSONObject("afData").optJSONObject("afSubmissionInfo");
            if (this.formContainerPath != null && submissionInfoRootTag != null) {
                String formDamPath = GuideUtils.convertGuideContainerPathToFMAssetPath(this.formContainerPath);
                submissionInfoRootTag.put("afPath", (Object)formDamPath);
            }
            submissionInfoRootTag.put("afSubmissionTime", (Object)this.getDateForSubmissionTime());
            messagedData = dataJsonObject.toString();
        }
        catch (Exception e) {
            logger.error("Error in adding submission meta data to JSON " + e.getMessage(), (Throwable)e);
        }
        return messagedData;
    }

    private String getDateForSubmissionTime() {
        return new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
    }

    private static enum MimeContentType {
        APPLICATION_XML("application/xml"),
        APPLICATION_JSON("application/json");

        private String mimeType;

        private MimeContentType(String mimeType) {
            this.mimeType = mimeType;
        }

        static MimeContentType getMimeType(String mimeType) {
            MimeContentType retVal = APPLICATION_XML;
            for (MimeContentType mimeContentType : MimeContentType.values()) {
                if (!StringUtils.equals((CharSequence)mimeContentType.mimeType, (CharSequence)mimeType)) continue;
                retVal = mimeContentType;
                break;
            }
            return retVal;
        }
    }
}

