/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.LocaleList;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AndroidIdUtil;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.GooglePlayServicesClient;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.OnGoogleAdIdReadListener;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.scheduler.AsyncTaskExecutor;
import com.adjust.sdk.scheduler.SingleThreadFutureScheduler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class Util {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z";
    private static final String fieldReadErrorMessage = "Unable to read '%s' field in migration device with message (%s)";
    public static final DecimalFormat SecondsDisplayFormat = Util.newLocalDecimalFormat();
    public static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z", Locale.US);
    private static volatile SingleThreadFutureScheduler playAdIdScheduler = null;

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    public static String createUuid() {
        return UUID.randomUUID().toString();
    }

    private static DecimalFormat newLocalDecimalFormat() {
        DecimalFormatSymbols decimalFormatSymbols;
        DecimalFormatSymbols decimalFormatSymbols2 = decimalFormatSymbols;
        decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        return new DecimalFormat("0.0", decimalFormatSymbols2);
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        if (!Pattern.compile("\\s").matcher(string).find()) {
            return string;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        return Util.formatString("'%s'", objectArray2);
    }

    public static Object getAdvertisingInfoObject(final Context context, long l) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<Object>(){

            @Override
            public final Object call() {
                try {
                    return Reflection.getAdvertisingInfoObject(context);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }, l);
    }

    public static String getPlayAdId(final Context context, final Object object, long l) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<String>(){

            @Override
            public final Object call() {
                return Reflection.getPlayAdId(context, object);
            }
        }, l);
    }

    public static Boolean isPlayTrackingEnabled(final Context context, final Object object, long l) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<Boolean>(){

            @Override
            public final Object call() {
                return Reflection.isPlayTrackingEnabled(context, object);
            }
        }, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static <R> R runSyncInPlayAdIdSchedulerWithTimeout(Context object, Callable<R> callable, long l) {
        if (playAdIdScheduler == null) {
            object = Util.class;
            // MONITORENTER : com.adjust.sdk.Util.class
            if (playAdIdScheduler == null) {
                playAdIdScheduler = new SingleThreadFutureScheduler("PlayAdIdLibrary", true);
            }
        }
        try {
            return (R)playAdIdScheduler.scheduleFutureWithReturn(callable, 0L).get(l, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (ExecutionException executionException) {}
        return null;
    }

    public static void getGoogleAdId(Context context, OnGoogleAdIdReadListener contextArray) {
        AsyncTaskExecutor<Context, String> asyncTaskExecutor = new AsyncTaskExecutor<Context, String>((OnGoogleAdIdReadListener)contextArray){
            public final /* synthetic */ OnGoogleAdIdReadListener a;
            {
                this.a = onGoogleAdIdReadListener;
            }

            @Override
            public final void onPostExecute(Object object) {
                4 v0 = string;
                String string = (String)object;
                object = v0.a;
                if (object != null) {
                    object.onGoogleAdIdRead(string);
                    return;
                }
            }

            @Override
            public final Object doInBackground(Object[] object) {
                ILogger iLogger = AdjustFactory.getLogger();
                object = Util.getGoogleAdId(((Context[])object)[0]);
                iLogger.debug("GoogleAdId read " + (String)object, new Object[0]);
                return object;
            }
        };
        Context[] contextArray2 = new Context[1];
        contextArray = contextArray2;
        contextArray2[0] = context;
        asyncTaskExecutor.execute(contextArray);
    }

    private static String getGoogleAdId(Context context) {
        Object object;
        String string;
        block4: {
            string = null;
            try {
                object = GooglePlayServicesClient.getGooglePlayServicesInfo(context, 11000L);
                if (object == null) break block4;
            }
            catch (Exception exception) {}
            string = ((GooglePlayServicesClient.GooglePlayServicesInfo)object).getGpsAdid();
        }
        if (string == null && (object = Util.getAdvertisingInfoObject(context, 11000L)) != null) {
            string = Util.getPlayAdId(context, object, 1000L);
        }
        return string;
    }

    public static String getAndroidId(Context context) {
        return AndroidIdUtil.getAndroidId(context);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObject(Context var0, String var1_3, String var2_4, Class<T> var3_5) {
        block21: {
            block20: {
                block19: {
                    block22: {
                        v0 = var3_5;
                        v1 = var0;
                        v2 = var1_3 /* !! */ ;
                        var0 = null;
                        var1_3 /* !! */  = null;
                        var0 = v1.openFileInput(v2);
                        var3_5 = v3;
                        v3 = new BufferedInputStream((InputStream)var0);
                        var0 = v4;
                        ** try [egrp 3[TRYBLOCK] [9, 8 : 26->30)] { 
lbl13:
                        // 1 sources

                        break block22;
lbl14:
                        // 1 sources

                        catch (Exception var0_1) {
                            var0 = var3_5;
                            var3_5 = var0_1;
                            break block19;
                        }
lbl18:
                        // 1 sources

                        catch (FileNotFoundException v5) {
                            var0 = var3_5;
                            break block20;
                        }
                        catch (Exception var3_9) {
                            break block19;
                        }
                        catch (FileNotFoundException v6) {
                            break block20;
                        }
                    }
                    try {
                        var1_3 /* !! */  = v0.cast(new ObjectInputStream((InputStream)var3_5).readObject());
                        Util.getLogger().debug("Read %s: %s", new Object[]{var2_4, var1_3 /* !! */ });
                        break block21;
                    }
                    catch (Exception var3_6) {
                    }
                    catch (ClassCastException var3_7) {
                        ** GOTO lbl-1000
                    }
                    catch (ClassNotFoundException var3_8) {
                        ** GOTO lbl56
                    }
                    {
                        v7 = Util.getLogger();
                        var3_5 = "Failed to read %s object (%s)";
                        var4_10 /* !! */  = var3_6.getMessage();
                        v8 = var3_5;
                        v9 = new Object[2];
                    }
                    var3_5 = v9;
                    {
                        v9[0] = var2_4;
                        v9[1] = var4_10 /* !! */ ;
                        v7.error((String)v8, var3_5);
                        break block21;
                    }
lbl-1000:
                    // 1 sources

                    {
                        v10 = Util.getLogger();
                        var3_5 = "Failed to cast %s object (%s)";
                        var4_10 /* !! */  = var3_7.getMessage();
                        v11 = var3_5;
                        v12 = new Object[2];
                    }
                    var3_5 = v12;
                    {
                        v12[0] = var2_4;
                        v12[1] = var4_10 /* !! */ ;
                        v10.error((String)v11, var3_5);
                        break block21;
lbl56:
                        // 1 sources

                        v13 = Util.getLogger();
                        var3_5 = "Failed to find %s class (%s)";
                        var4_10 /* !! */  = var3_8.getMessage();
                        v14 = var3_5;
                        v15 = new Object[2];
                    }
                    var3_5 = v15;
                    {
                        v15[0] = var2_4;
                        v15[1] = var4_10 /* !! */ ;
                        v13.error((String)v14, var3_5);
                        break block21;
                    }
                }
                v16 = new Object[2];
                var4_10 /* !! */  = v16;
                v16[0] = var2_4;
                v16[1] = var3_5;
                Util.getLogger().error("Failed to open %s file for reading (%s)", var4_10 /* !! */ );
                break block21;
            }
            v17 = new Object[1];
            var3_5 = v17;
            v17[0] = var2_4;
            Util.getLogger().debug("%s file not found", var3_5);
        }
        if (var0 == null) return (T)var1_3 /* !! */ ;
        try {
            var0.close();
            return (T)var1_3 /* !! */ ;
        }
        catch (Exception var0_2) {
            v18 = new Object[2];
            var3_5 = v18;
            v18[0] = var2_4;
            v18[1] = var0_2;
            Util.getLogger().error("Failed to close %s file for reading (%s)", var3_5);
        }
        return (T)var1_3 /* !! */ ;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> void writeObject(T t, Context objectArray, String objectArray2, String string) {
        block12: {
            block11: {
                T t2;
                ObjectOutputStream objectOutputStream;
                BufferedOutputStream bufferedOutputStream;
                Context context = objectArray;
                objectArray = null;
                objectArray = context.openFileOutput((String)objectArray2, 0);
                {
                    catch (Exception exception) {
                        break block11;
                    }
                }
                objectArray2 = bufferedOutputStream;
                {
                    bufferedOutputStream = new BufferedOutputStream((OutputStream)objectArray);
                }
                objectArray = objectOutputStream;
                try {
                    t2 = t;
                    objectArray((OutputStream)objectArray2);
                }
                catch (Exception exception) {
                    objectArray = objectArray2;
                    break block11;
                }
                {
                    objectOutputStream.writeObject(t2);
                    Util.getLogger().debug("Wrote %s: %s", string, t);
                    break block12;
                }
            }
            Object[] objectArray3 = new Object[2];
            objectArray2 = objectArray3;
            objectArray3[0] = string;
            objectArray3[1] = t;
            Util.getLogger().error("Failed to open %s for writing (%s)", objectArray2);
        }
        if (objectArray == null) return;
        try {
            objectArray.close();
            return;
        }
        catch (Exception exception) {
            Object[] objectArray4 = new Object[2];
            objectArray = objectArray4;
            objectArray4[0] = string;
            objectArray4[1] = exception;
            Util.getLogger().error("Failed to close %s file for writing (%s)", objectArray);
        }
    }

    public static boolean checkPermission(Context object, String string) {
        try {
            return object.checkCallingOrSelfPermission(string) == 0;
        }
        catch (Exception exception) {
            object = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = object;
            Util.getLogger().debug("Unable to check permission '%s' with message (%s)", objectArray2);
            return false;
        }
    }

    public static String readStringField(ObjectInputStream.GetField getField, String string, String string2) {
        return Util.readObjectField(getField, string, string2);
    }

    public static <T> T readObjectField(ObjectInputStream.GetField getField, String string, T object) {
        try {
            return (T)getField.get(string, object);
        }
        catch (Exception exception) {
            T t = object;
            String string2 = exception.getMessage();
            Object[] objectArray = new Object[2];
            object = objectArray;
            objectArray[0] = string;
            objectArray[1] = string2;
            Util.getLogger().debug(fieldReadErrorMessage, object);
            return t;
        }
    }

    public static boolean readBooleanField(ObjectInputStream.GetField getField, String string, boolean bl) {
        try {
            return getField.get(string, bl);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = string2;
            Util.getLogger().debug(fieldReadErrorMessage, objectArray2);
            return bl;
        }
    }

    public static int readIntField(ObjectInputStream.GetField getField, String string, int n) {
        try {
            return getField.get(string, n);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = string2;
            Util.getLogger().debug(fieldReadErrorMessage, objectArray2);
            return n;
        }
    }

    public static long readLongField(ObjectInputStream.GetField getField, String string, long l) {
        try {
            return getField.get(string, l);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = string2;
            Util.getLogger().debug(fieldReadErrorMessage, objectArray2);
            return l;
        }
    }

    public static double readDoubleField(ObjectInputStream.GetField getField, String string, double d) {
        try {
            return getField.get(string, d);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = string2;
            Util.getLogger().debug(fieldReadErrorMessage, objectArray2);
            return d;
        }
    }

    public static boolean equalObject(Object object, Object object2) {
        if (object != null && object2 != null) {
            return object.equals(object2);
        }
        return object == null && object2 == null;
    }

    public static boolean equalsDouble(Double d, Double d2) {
        if (d != null && d2 != null) {
            return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
        }
        return d == null && d2 == null;
    }

    public static boolean equalString(String string, String string2) {
        return Util.equalObject(string, string2);
    }

    public static boolean equalEnum(Enum enum_, Enum enum_2) {
        return Util.equalObject(enum_, enum_2);
    }

    public static boolean equalLong(Long l, Long l2) {
        return Util.equalObject(l, l2);
    }

    public static boolean equalInt(Integer n, Integer n2) {
        return Util.equalObject(n, n2);
    }

    public static boolean equalBoolean(Boolean bl, Boolean bl2) {
        return Util.equalObject(bl, bl2);
    }

    public static int hashBoolean(Boolean bl, int n) {
        if (bl == null) {
            return n * 37;
        }
        int n2 = n * 37;
        return bl.hashCode() + n2;
    }

    public static int hashLong(Long l, int n) {
        if (l == null) {
            return n * 37;
        }
        int n2 = n * 37;
        return l.hashCode() + n2;
    }

    public static int hashDouble(Double d, int n) {
        if (d == null) {
            return n * 37;
        }
        int n2 = n * 37;
        return d.hashCode() + n2;
    }

    public static int hashString(String string, int n) {
        if (string == null) {
            return n * 37;
        }
        int n2 = n * 37;
        return string.hashCode() + n2;
    }

    public static int hashEnum(Enum enum_, int n) {
        if (enum_ == null) {
            return n * 37;
        }
        int n2 = n * 37;
        return enum_.hashCode() + n2;
    }

    public static int hashObject(Object object, int n) {
        if (object == null) {
            return n * 37;
        }
        int n2 = n * 37;
        return object.hashCode() + n2;
    }

    public static String hash(String string, String object) {
        String string2 = object;
        String string3 = string;
        string = null;
        try {
            object = string3.getBytes("UTF-8");
        }
        catch (Exception exception) {
            return string;
        }
        MessageDigest messageDigest = MessageDigest.getInstance(string2);
        Object object2 = object;
        int n = 0;
        messageDigest.update((byte[])object2, n, ((Object)object2).length);
        return Util.convertToHex(messageDigest.digest());
    }

    public static String convertToHex(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger;
        bigInteger = new BigInteger(1, byArray);
        return Util.formatString("%0" + (byArray.length << 1) + "x", bigInteger2);
    }

    public static String[] getSupportedAbis() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        return null;
    }

    public static String getCpuAbi() {
        if (Build.VERSION.SDK_INT < 21) {
            return Build.CPU_ABI;
        }
        return null;
    }

    public static String getReasonString(String string, Throwable objectArray) {
        if (objectArray != null) {
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = string;
            objectArray2[1] = objectArray;
            return Util.formatString("%s: %s", objectArray3);
        }
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = string;
        return Util.formatString("%s", objectArray);
    }

    public static long getWaitingTime(int n, BackoffStrategy backoffStrategy) {
        int n2 = backoffStrategy.minRetries;
        if (n < n2) {
            return 0L;
        }
        double d = n - n2;
        double d2 = Util.randomInRange(backoffStrategy.minRange, backoffStrategy.maxRange);
        return (long)((double)Math.min((long)Math.pow(2.0, d) * backoffStrategy.milliSecondMultiplier, backoffStrategy.maxWait) * d2);
    }

    private static double randomInRange(double d, double d2) {
        Random random;
        Random random2 = random;
        random = new Random();
        double d3 = d2 - d;
        return random2.nextDouble() * d3 + d;
    }

    public static boolean isValidParameter(String objectArray, String string, String string2) {
        if (objectArray == null) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = string2;
            objectArray2[1] = string;
            Util.getLogger().error("%s parameter %s is missing", objectArray);
            return false;
        }
        if (objectArray.equals("")) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray3[0] = string2;
            objectArray3[1] = string;
            Util.getLogger().error("%s parameter %s is empty", objectArray);
            return false;
        }
        return true;
    }

    public static boolean isAdjustUninstallDetectionPayload(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        return map.size() == 1 && Objects.equals(map.get("adjust_purpose"), "uninstall detection");
    }

    public static Map<String, String> mergeParameters(Map<String, String> object, Map<String, String> hashMap, String string) {
        HashMap<String, String> hashMap2;
        if (object == null) {
            return hashMap;
        }
        if (hashMap == null) {
            return object;
        }
        HashMap<String, String> hashMap3 = hashMap;
        hashMap = hashMap2;
        hashMap2 = new HashMap<String, String>((Map<String, String>)object);
        object = Util.getLogger();
        for (Map.Entry entry : hashMap3.entrySet()) {
            String string2 = hashMap.put((String)entry.getKey(), (String)entry.getValue());
            if (string2 == null) continue;
            Map.Entry entry2 = entry;
            entry = entry2.getKey();
            Object v = entry2.getValue();
            Object[] objectArray = new Object[4];
            Object[] objectArray2 = objectArray;
            objectArray[0] = entry;
            objectArray[1] = string2;
            objectArray[2] = string;
            objectArray[3] = v;
            object.warn("Key %s with value %s from %s parameter was replaced by value %s", objectArray2);
        }
        return hashMap;
    }

    public static Locale getLocale(Configuration configuration) {
        LocaleList localeList;
        int n = Build.VERSION.SDK_INT;
        if (n >= 24 && (localeList = configuration.getLocales()) != null && !localeList.isEmpty()) {
            return localeList.get(0);
        }
        if (n < 24) {
            return configuration.locale;
        }
        return null;
    }

    public static String formatString(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public static boolean hasRootCause(Exception object) {
        StringWriter stringWriter;
        Exception exception = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter((Writer)object));
        return ((StringWriter)object).toString().contains("Caused by:");
    }

    public static String getRootCause(Exception exception) {
        StringWriter stringWriter;
        if (!Util.hasRootCause(exception)) {
            return null;
        }
        StringWriter stringWriter2 = stringWriter;
        stringWriter2();
        exception.printStackTrace(new PrintWriter(stringWriter2));
        String string = stringWriter.toString();
        int n = string.indexOf("Caused by:");
        return string.substring(n, string.indexOf("\n", n));
    }

    private static String getSdkPrefix(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (!stringArray.contains("@")) {
            return null;
        }
        if ((stringArray = stringArray.split("@")) == null) {
            return null;
        }
        if (stringArray.length != 2) {
            return null;
        }
        return stringArray[0];
    }

    public static String getSdkPrefixPlatform(String stringArray) {
        if ((stringArray = Util.getSdkPrefix((String)stringArray)) == null) {
            return null;
        }
        if ((stringArray = stringArray.split("\\d+", 2)) == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public static boolean isUrlFilteredOut(Uri object) {
        if (object == null) {
            return true;
        }
        if ((object = object.toString()) != null && ((String)object).length() != 0) {
            return ((String)object).matches("^(fb|vk)[0-9]{5,}[^:]*://authorize.*access_token=.*");
        }
        return true;
    }

    public static boolean isUrlWithTrackerQueryParam(Uri uri) {
        block4: {
            try {
                if (uri.getQueryParameter("adj_t") == null) break block4;
                return true;
            }
            catch (Exception exception) {}
        }
        if (uri.getQueryParameter("adjust_t") != null) {
            return true;
        }
        return false;
    }

    public static String getSdkVersion() {
        return "android5.4.5";
    }

    public static boolean resolveContentProvider(Context context, String string) {
        try {
            return context.getPackageManager().resolveContentProvider(string, 0) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isEqualReferrerDetails(ReferrerDetails referrerDetails, String string, ActivityState activityState) {
        if (string.equals("google")) {
            return Util.isEqualGoogleReferrerDetails(referrerDetails, activityState);
        }
        if (string.equals("huawei_ads")) {
            return Util.isEqualHuaweiReferrerAdsDetails(referrerDetails, activityState);
        }
        if (string.equals("huawei_app_gallery")) {
            return Util.isEqualHuaweiReferrerAppGalleryDetails(referrerDetails, activityState);
        }
        if (string.equals("samsung")) {
            return Util.isEqualSamsungReferrerDetails(referrerDetails, activityState);
        }
        if (string.equals("xiaomi")) {
            return Util.isEqualXiaomiReferrerDetails(referrerDetails, activityState);
        }
        if (string.equals("vivo")) {
            return Util.isEqualVivoReferrerDetails(referrerDetails, activityState);
        }
        if (string.equals("meta")) {
            return Util.isEqualMetaReferrerDetails(referrerDetails, activityState);
        }
        return false;
    }

    public static boolean canReadPlayIds(AdjustConfig adjustConfig) {
        return !adjustConfig.coppaComplianceEnabled && !adjustConfig.playStoreKidsComplianceEnabled;
    }

    public static boolean canReadNonPlayIds(AdjustConfig adjustConfig) {
        return !adjustConfig.coppaComplianceEnabled && !adjustConfig.playStoreKidsComplianceEnabled;
    }

    public static boolean isGooglePlayGamesForPC(Context context) {
        return context.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE");
    }

    private static boolean isEqualGoogleReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTime && referrerDetails.installBeginTimestampSeconds == activityState.installBegin && referrerDetails.referrerClickTimestampServerSeconds == activityState.clickTimeServer && referrerDetails.installBeginTimestampServerSeconds == activityState.installBeginServer && Util.equalString(referrerDetails.installReferrer, activityState.installReferrer) && Util.equalString(referrerDetails.installVersion, activityState.installVersion) && Util.equalBoolean(referrerDetails.googlePlayInstant, activityState.googlePlayInstant);
    }

    private static boolean isEqualHuaweiReferrerAdsDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeHuawei && referrerDetails.installBeginTimestampSeconds == activityState.installBeginHuawei && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerHuawei);
    }

    private static boolean isEqualHuaweiReferrerAppGalleryDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeHuawei && referrerDetails.installBeginTimestampSeconds == activityState.installBeginHuawei && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerHuaweiAppGallery);
    }

    private static boolean isEqualSamsungReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeSamsung && referrerDetails.installBeginTimestampSeconds == activityState.installBeginSamsung && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerSamsung);
    }

    private static boolean isEqualXiaomiReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeXiaomi && referrerDetails.installBeginTimestampSeconds == activityState.installBeginXiaomi && referrerDetails.referrerClickTimestampServerSeconds == activityState.clickTimeServerXiaomi && referrerDetails.installBeginTimestampServerSeconds == activityState.installBeginServerXiaomi && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerXiaomi) && Util.equalString(referrerDetails.installVersion, activityState.installVersionXiaomi);
    }

    private static boolean isEqualVivoReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeVivo && referrerDetails.installBeginTimestampSeconds == activityState.installBeginVivo && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerVivo) && Util.equalString(referrerDetails.installVersion, activityState.installVersionVivo);
    }

    private static boolean isEqualMetaReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeMeta && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerMeta) && Util.equalBoolean(referrerDetails.isClick, activityState.isClickMeta);
    }

    public static boolean isEnabledFromActivityStateFile(Context object) {
        if ((object = Util.readObject(object, "AdjustIoActivityState", "Activity state", ActivityState.class)) == null) {
            return true;
        }
        return object.enabled;
    }

    public static AdjustAttribution attributionFromJson(JSONObject jSONObject, String string) {
        AdjustAttribution adjustAttribution;
        if (jSONObject == null) {
            return null;
        }
        AdjustAttribution adjustAttribution2 = adjustAttribution;
        adjustAttribution = new AdjustAttribution();
        adjustAttribution2.jsonResponse = jSONObject.toString();
        if ("unity".equals(string)) {
            adjustAttribution2.trackerToken = jSONObject.optString("tracker_token", "");
            adjustAttribution2.trackerName = jSONObject.optString("tracker_name", "");
            adjustAttribution2.network = jSONObject.optString("network", "");
            adjustAttribution2.campaign = jSONObject.optString("campaign", "");
            adjustAttribution2.adgroup = jSONObject.optString("adgroup", "");
            adjustAttribution2.creative = jSONObject.optString("creative", "");
            adjustAttribution2.clickLabel = jSONObject.optString("click_label", "");
            adjustAttribution2.costType = jSONObject.optString("cost_type", "");
            adjustAttribution2.costAmount = jSONObject.optDouble("cost_amount", 0.0);
            adjustAttribution2.costCurrency = jSONObject.optString("cost_currency", "");
            adjustAttribution2.fbInstallReferrer = jSONObject.optString("fb_install_referrer", "");
            return adjustAttribution2;
        }
        adjustAttribution2.trackerToken = jSONObject.optString("tracker_token");
        adjustAttribution2.trackerName = jSONObject.optString("tracker_name");
        adjustAttribution2.network = jSONObject.optString("network");
        adjustAttribution2.campaign = jSONObject.optString("campaign");
        adjustAttribution2.adgroup = jSONObject.optString("adgroup");
        adjustAttribution2.creative = jSONObject.optString("creative");
        adjustAttribution2.clickLabel = jSONObject.optString("click_label");
        adjustAttribution2.costType = jSONObject.optString("cost_type");
        adjustAttribution2.costAmount = jSONObject.optDouble("cost_amount");
        adjustAttribution2.costCurrency = jSONObject.optString("cost_currency");
        adjustAttribution2.fbInstallReferrer = jSONObject.optString("fb_install_referrer");
        return adjustAttribution2;
    }
}

