/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageHandler
implements IPackageHandler,
IActivityPackageSender.ResponseDataCallbackSubscriber {
    private static final String PACKAGE_QUEUE_FILENAME = "AdjustIoPackageQueue";
    private static final String PACKAGE_QUEUE_NAME = "Package queue";
    private ThreadScheduler scheduler;
    private IActivityPackageSender activityPackageSender;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private List<ActivityPackage> packageQueue;
    private AtomicBoolean isSending;
    private boolean paused;
    private Context context;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private BackoffStrategy backoffStrategyForInstallSession;
    private boolean isRetrying;
    private long retryStartedAtTimeMilliSeconds;
    private double totalWaitTimeSeconds;

    public static void deleteState(Context context) {
        PackageHandler.deletePackageQueue(context);
    }

    public PackageHandler(IActivityHandler iActivityHandler, Context context, boolean bl, IActivityPackageSender iActivityPackageSender) {
        PackageHandler packageHandler = this;
        this.scheduler = new SingleThreadCachedScheduler("PackageHandler");
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getPackageHandlerBackoffStrategy();
        this.backoffStrategyForInstallSession = AdjustFactory.getInstallSessionBackoffStrategy();
        this.isRetrying = false;
        this.totalWaitTimeSeconds = 0.0;
        packageHandler.init(iActivityHandler, context, bl, iActivityPackageSender);
        packageHandler.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PackageHandler.this.initI();
            }
        });
    }

    private void initI() {
        AtomicBoolean atomicBoolean;
        PackageHandler packageHandler = atomicBoolean2;
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        atomicBoolean = new AtomicBoolean();
        packageHandler.isSending = atomicBoolean2;
        packageHandler.readPackageQueueI();
    }

    private void addI(ActivityPackage objectArray) {
        long l;
        if (((PackageHandler)object).isRetrying) {
            l = System.currentTimeMillis();
            objectArray.setWaitBeforeSendTimeSeconds(((PackageHandler)object).totalWaitTimeSeconds - (double)(l - ((PackageHandler)object).retryStartedAtTimeMilliSeconds) / 1000.0);
        }
        PackageHandler packageHandler = object;
        l = ((PackageHandler)object).packageQueue.size();
        PackageBuilder.addLong(objectArray.getParameters(), "enqueue_size", l);
        packageHandler.packageQueue.add((ActivityPackage)objectArray);
        Object object = ((PackageHandler)object).packageQueue.size();
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = object;
        objectArray2[1] = objectArray;
        packageHandler.logger.debug("Added package %d (%s)", objectArray3);
        object = objectArray.getExtendedString();
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = object;
        packageHandler.logger.verbose("%s", objectArray);
        packageHandler.writePackageQueueI();
    }

    private void sendFirstI() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Package handler is paused", new Object[0]);
            return;
        }
        if (this.isSending.getAndSet(true)) {
            this.logger.verbose("Package handler is already sending", new Object[0]);
            return;
        }
        PackageHandler packageHandler = this;
        Map<String, String> map = packageHandler.generateSendingParametersI();
        ActivityPackage activityPackage = this.packageQueue.get(0);
        long l = activityPackage.getRetryCount();
        PackageBuilder.addLong(map, "retry_count", l);
        l = activityPackage.getFirstErrorCode();
        PackageBuilder.addLong(map, "first_error", l);
        l = activityPackage.getLastErrorCode();
        PackageBuilder.addLong(map, "last_error", l);
        double d = this.totalWaitTimeSeconds;
        PackageBuilder.addDouble(map, "wait_total", d);
        d = activityPackage.getWaitBeforeSendTimeSeconds();
        PackageBuilder.addDouble(map, "wait_time", d);
        packageHandler.activityPackageSender.sendActivityPackage(activityPackage, map, this);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> hashMap;
        PackageHandler packageHandler = hashMap2;
        HashMap<String, String> hashMap2 = hashMap;
        long l = System.currentTimeMillis();
        PackageBuilder.addString(new HashMap<String, String>(), "sent_at", Util.dateFormatter.format(l));
        int n = packageHandler.packageQueue.size() - 1;
        if (n > 0) {
            long l2 = n;
            PackageBuilder.addLong((Map<String, String>)hashMap2, "queue_size", l2);
        }
        return hashMap2;
    }

    private void sendNextI(Long l) {
        ((PackageHandler)((Object)d)).isRetrying = false;
        ((PackageHandler)((Object)d)).retryStartedAtTimeMilliSeconds = 0L;
        if (((PackageHandler)((Object)d)).packageQueue.isEmpty()) {
            ((PackageHandler)((Object)d)).totalWaitTimeSeconds = 0.0;
            return;
        }
        PackageHandler packageHandler = d;
        packageHandler.packageQueue.remove(0);
        packageHandler.writePackageQueueI();
        if (l != null && l > 0L) {
            Runnable runnable;
            PackageHandler packageHandler2 = d;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public final void run() {
                    7 v0 = this;
                    v0.PackageHandler.this.logger.verbose("Package handler finished waiting to continue", new Object[0]);
                    v0.PackageHandler.this.isSending.set(false);
                    v0.PackageHandler.this.sendFirstPackage();
                }
            };
            Double d = (double)l.longValue() / 1000.0;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = d;
            packageHandler2.logger.verbose("Waiting for %d seconds before continuing for next package in continue_in", objectArray2);
            packageHandler2.scheduler.schedule(runnable2, l);
        } else {
            PackageHandler packageHandler3 = d;
            packageHandler3.logger.verbose("Package handler can send", new Object[0]);
            packageHandler3.isSending.set(false);
            packageHandler3.sendFirstI();
        }
    }

    private void flushI() {
        PackageHandler packageHandler = this;
        packageHandler.packageQueue.clear();
        packageHandler.writePackageQueueI();
    }

    private void readPackageQueueI() {
        Object object;
        Object[] objectArray;
        try {
            ((PackageHandler)object).packageQueue = Util.readObject(((PackageHandler)object).context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME, List.class);
        }
        catch (Exception exception) {
            objectArray = exception.getMessage();
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = PACKAGE_QUEUE_NAME;
            objectArray2[1] = objectArray;
            ((PackageHandler)object).logger.error("Failed to read %s file (%s)", objectArray3);
            ((PackageHandler)object).packageQueue = null;
        }
        objectArray = ((PackageHandler)object).packageQueue;
        if (objectArray != null) {
            object = objectArray.size();
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = object;
            ((PackageHandler)object).logger.debug("Package handler read %d packages", objectArray);
        } else {
            ArrayList arrayList;
            PackageHandler packageHandler = object;
            object = arrayList;
            arrayList = new ArrayList();
            packageHandler.packageQueue = object;
        }
    }

    private void writePackageQueueI() {
        PackageHandler packageHandler = n;
        Util.writeObject(packageHandler.packageQueue, ((PackageHandler)((Object)n)).context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME);
        Integer n = ((PackageHandler)((Object)n)).packageQueue.size();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n;
        packageHandler.logger.debug("Package handler wrote %d packages", objectArray2);
    }

    public static Boolean deletePackageQueue(Context context) {
        return context.deleteFile(PACKAGE_QUEUE_FILENAME);
    }

    @Override
    public void teardown() {
        PackageHandler packageHandler = this;
        packageHandler.logger.verbose("PackageHandler teardown", new Object[0]);
        List<ActivityPackage> list = packageHandler.scheduler;
        if (list != null) {
            list.teardown();
        }
        if ((list = this.activityHandlerWeakRef) != null) {
            ((Reference)((Object)list)).clear();
        }
        if ((list = this.packageQueue) != null) {
            list.clear();
        }
        PackageHandler packageHandler2 = this;
        packageHandler2.scheduler = null;
        packageHandler2.activityHandlerWeakRef = null;
        packageHandler2.packageQueue = null;
        packageHandler2.isSending = null;
        packageHandler2.context = null;
        packageHandler2.logger = null;
        packageHandler2.backoffStrategy = null;
    }

    @Override
    public void init(IActivityHandler iActivityHandler, Context context, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        this.context = context;
        this.paused = bl ^ true;
        this.activityPackageSender = iActivityPackageSender;
    }

    @Override
    public void addPackage(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PackageHandler.this.addI(activityPackage);
            }
        });
    }

    @Override
    public void sendFirstPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PackageHandler.this.sendFirstI();
            }
        });
    }

    @Override
    public void onResponseDataCallback(ResponseData object) {
        Runnable runnable;
        PackageHandler packageHandler = string;
        packageHandler.logger.debug("Got response in PackageHandler", new Object[0]);
        Object object2 = (IActivityHandler)packageHandler.activityHandlerWeakRef.get();
        if (object2 != null && ((ResponseData)object).trackingState == TrackingState.OPTED_OUT) {
            object2.gotOptOutResponse();
        }
        if (!((ResponseData)object).willRetry) {
            ((PackageHandler)((Object)string)).scheduler.submit(new Runnable((ResponseData)object){
                public final /* synthetic */ ResponseData a;
                {
                    this.a = responseData;
                }

                @Override
                public final void run() {
                    PackageHandler.this.sendNextI(this.a.continueIn);
                }
            });
            if (object2 != null) {
                object2.finishedTrackingActivity((ResponseData)object);
            }
            return;
        }
        if (!((PackageHandler)((Object)string)).isRetrying) {
            PackageHandler packageHandler2 = string;
            packageHandler2.isRetrying = true;
            packageHandler2.retryStartedAtTimeMilliSeconds = System.currentTimeMillis();
        }
        ((PackageHandler)((Object)string)).writePackageQueueI();
        if (object2 != null) {
            object2.finishedTrackingActivity((ResponseData)object);
        }
        object2 = runnable;
        runnable = new Runnable(){

            @Override
            public final void run() {
                5 v0 = this;
                v0.PackageHandler.this.logger.verbose("Package handler can send", new Object[0]);
                v0.PackageHandler.this.isSending.set(false);
                v0.PackageHandler.this.sendFirstPackage();
            }
        };
        Long l = ((ResponseData)object).retryIn;
        if (l != null) {
            long l2 = l;
            ((PackageHandler)((Object)string)).scheduler.schedule((Runnable)object2, l2);
            return;
        }
        int n = ((ResponseData)object).activityPackage.increaseRetries();
        SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(((PackageHandler)((Object)string)).context);
        long l3 = ((ResponseData)object).activityPackage.getActivityKind() == ActivityKind.SESSION && !sharedPreferencesManager.getInstallTracked() ? Util.getWaitingTime(n, ((PackageHandler)((Object)string)).backoffStrategyForInstallSession) : Util.getWaitingTime(n, ((PackageHandler)((Object)string)).backoffStrategy);
        ResponseData responseData = object;
        PackageHandler packageHandler3 = string;
        double d = (double)l3 / 1000.0;
        String string = Util.SecondsDisplayFormat.format(d);
        packageHandler3.totalWaitTimeSeconds += d;
        object = ((ResponseData)object).activityPackage.getActivityKind().toString();
        Integer n2 = n;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = object;
        objectArray[2] = n2;
        packageHandler3.logger.verbose("Waiting for %s seconds before retrying %s for the %d time", objectArray2);
        packageHandler3.scheduler.schedule((Runnable)object2, l3);
        ActivityPackage activityPackage = responseData.activityPackage;
        activityPackage.setWaitBeforeSendTimeSeconds(activityPackage.getWaitBeforeSendTimeSeconds() + d);
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    @Override
    public void flush() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PackageHandler.this.flushI();
            }
        });
    }
}

