/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.net.Uri;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.AdjustAdRevenue;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustDeeplink;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustPlayStorePurchase;
import com.adjust.sdk.AdjustPlayStoreSubscription;
import com.adjust.sdk.AdjustPurchaseVerificationResult;
import com.adjust.sdk.AdjustSigner;
import com.adjust.sdk.AdjustTestOptions;
import com.adjust.sdk.AdjustThirdPartySharing;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.GooglePlayInstallReferrerDetails;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IRunActivityHandler;
import com.adjust.sdk.InstallReferrer;
import com.adjust.sdk.InstallReferrerReadListener;
import com.adjust.sdk.OnAdidReadListener;
import com.adjust.sdk.OnAmazonAdIdReadListener;
import com.adjust.sdk.OnAttributionReadListener;
import com.adjust.sdk.OnDeeplinkResolvedListener;
import com.adjust.sdk.OnGooglePlayInstallReferrerReadListener;
import com.adjust.sdk.OnIsEnabledListener;
import com.adjust.sdk.OnLastDeeplinkReadListener;
import com.adjust.sdk.OnPurchaseVerificationFinishedListener;
import com.adjust.sdk.OnSdkVersionReadListener;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.Util;
import com.adjust.sdk.scheduler.AsyncTaskExecutor;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import java.util.ArrayList;
import java.util.List;

public class AdjustInstance {
    private String pushToken;
    private Boolean startEnabled = null;
    private boolean startOffline = false;
    private IActivityHandler activityHandler;
    private PreLaunchActions preLaunchActions;
    private OnDeeplinkResolvedListener cachedDeeplinkResolutionCallback;
    private ArrayList<OnAdidReadListener> cachedAdidReadCallbacks;
    private ArrayList<OnAttributionReadListener> cachedAttributionReadCallbacks;
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;
    private String purchaseVerificationPath;

    public AdjustInstance() {
        ArrayList arrayList;
        ArrayList arrayList2;
        PreLaunchActions preLaunchActions;
        Object object = preLaunchActions;
        preLaunchActions = new PreLaunchActions();
        v1.preLaunchActions = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        v1.cachedAdidReadCallbacks = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.cachedAttributionReadCallbacks = object;
    }

    private boolean checkActivityHandler(String string) {
        return this.checkActivityHandler(string, false);
    }

    private boolean checkActivityHandler(boolean bl, String string, String string2) {
        if (bl) {
            return this.checkActivityHandler(string, true);
        }
        return this.checkActivityHandler(string2, true);
    }

    private boolean checkActivityHandler(String string, boolean bl) {
        Object[] objectArray;
        if (objectArray.activityHandler != null) {
            return true;
        }
        if (string == null) {
            AdjustFactory.getLogger().error("Adjust not initialized correctly", new Object[0]);
            return false;
        }
        if (bl) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            AdjustFactory.getLogger().warn("Adjust not initialized, but %s saved for launch", objectArray);
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string;
            AdjustFactory.getLogger().warn("Adjust not initialized, can't perform %s", objectArray);
        }
        return false;
    }

    private void saveRawReferrer(String string, long l2, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).saveRawReferrer(string, l2);
    }

    private void savePreinstallReferrer(String string, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).savePreinstallReferrer(string);
    }

    private void savePushToken(String string, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).savePushToken(string);
    }

    private void saveGdprForgetMe(Context context) {
        SharedPreferencesManager.getDefaultInstance(context).setGdprForgetMe();
    }

    private void saveDeeplink(Uri uri, long l2, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).saveDeeplink(uri, l2);
    }

    private void cacheDeeplink(Uri uri, Context context) {
        SharedPreferencesManager.getDefaultInstance(context).cacheDeeplink(uri);
    }

    private String getCachedDeeplink(Context context) {
        return SharedPreferencesManager.getDefaultInstance(context).getCachedDeeplink();
    }

    private void setSendingReferrersAsNotSent(Context context) {
        new SingleThreadCachedScheduler("AdjustInstance").submit(() -> SharedPreferencesManager.getDefaultInstance(context).setSendingReferrersAsNotSent());
    }

    private boolean isInstanceEnabled() {
        Boolean bl = ((AdjustInstance)((Object)bl)).startEnabled;
        return bl == null || bl.booleanValue();
    }

    public void initSdk(AdjustConfig adjustConfig) {
        if (!AdjustSigner.isPresent()) {
            AdjustFactory.getLogger().error("Missing signature library, SDK can't be initialised", new Object[0]);
            return;
        }
        if (adjustConfig == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return;
        }
        if (!adjustConfig.isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return;
        }
        if (this.activityHandler != null) {
            AdjustFactory.getLogger().error("Adjust already initialized", new Object[0]);
            return;
        }
        adjustConfig.preLaunchActions = this.preLaunchActions;
        adjustConfig.pushToken = this.pushToken;
        adjustConfig.startEnabled = this.startEnabled;
        adjustConfig.startOffline = this.startOffline;
        adjustConfig.basePath = this.basePath;
        adjustConfig.gdprPath = this.gdprPath;
        adjustConfig.subscriptionPath = this.subscriptionPath;
        adjustConfig.purchaseVerificationPath = this.purchaseVerificationPath;
        adjustConfig.cachedDeeplinkResolutionCallback = this.cachedDeeplinkResolutionCallback;
        adjustConfig.cachedAdidReadCallbacks = this.cachedAdidReadCallbacks;
        adjustConfig.cachedAttributionReadCallbacks = this.cachedAttributionReadCallbacks;
        this.activityHandler = AdjustFactory.getActivityHandler(adjustConfig);
        this.setSendingReferrersAsNotSent(adjustConfig.context);
    }

    public void trackEvent(AdjustEvent adjustEvent) {
        if (!this.checkActivityHandler("trackEvent")) {
            return;
        }
        this.activityHandler.trackEvent(adjustEvent);
    }

    public void onResume() {
        if (!this.checkActivityHandler("onResume")) {
            return;
        }
        this.activityHandler.onResume();
    }

    public void onPause() {
        if (!this.checkActivityHandler("onPause")) {
            return;
        }
        this.activityHandler.onPause();
    }

    public void enable() {
        this.startEnabled = Boolean.TRUE;
        if (this.checkActivityHandler(true, "enabled mode", "disabled mode")) {
            this.activityHandler.setEnabled(true);
        }
    }

    public void disable() {
        this.startEnabled = Boolean.FALSE;
        if (this.checkActivityHandler(false, "enabled mode", "disabled mode")) {
            this.activityHandler.setEnabled(false);
        }
    }

    public void isEnabled(Context context, final OnIsEnabledListener onIsEnabledListener) {
        if (!contextArray2.checkActivityHandler("isEnabled")) {
            Context[] contextArray = new Context[1];
            Context[] contextArray2 = contextArray;
            contextArray[0] = context;
            new AsyncTaskExecutor<Context, Boolean>(){

                @Override
                public final void onPostExecute(Object object) {
                    b b2 = bl;
                    Boolean bl = (Boolean)object;
                    b2.onIsEnabledListener.onIsEnabledRead(bl);
                }

                @Override
                public final Object doInBackground(Object[] objectArray) {
                    return Util.isEnabledFromActivityStateFile(((Context[])objectArray)[0]);
                }
            }.execute(contextArray2);
            return;
        }
        contextArray2.activityHandler.isEnabled(onIsEnabledListener);
    }

    public void processDeeplink(AdjustDeeplink adjustDeeplink, Context context) {
        if (adjustDeeplink != null && adjustDeeplink.isValid()) {
            AdjustInstance adjustInstance = this;
            adjustInstance.cacheDeeplink(adjustDeeplink.url, context);
            long l2 = System.currentTimeMillis();
            if (!adjustInstance.checkActivityHandler("processDeeplink", true)) {
                this.saveDeeplink(adjustDeeplink.url, l2, context);
                return;
            }
            this.activityHandler.processDeeplink(adjustDeeplink.url, l2);
            return;
        }
        AdjustFactory.getLogger().warn("Skipping deeplink processing (null or empty)", new Object[0]);
    }

    public void processAndResolveDeeplink(AdjustDeeplink adjustDeeplink, Context context, OnDeeplinkResolvedListener onDeeplinkResolvedListener) {
        if (adjustDeeplink != null && adjustDeeplink.isValid()) {
            if (onDeeplinkResolvedListener == null) {
                this.processDeeplink(adjustDeeplink, context);
                return;
            }
            AdjustInstance adjustInstance = this;
            adjustInstance.cacheDeeplink(adjustDeeplink.url, context);
            long l2 = System.currentTimeMillis();
            if (!adjustInstance.checkActivityHandler("processAndResolveDeeplink", true)) {
                this.saveDeeplink(adjustDeeplink.url, l2, context);
                this.cachedDeeplinkResolutionCallback = onDeeplinkResolvedListener;
                return;
            }
            this.activityHandler.processAndResolveDeeplink(adjustDeeplink.url, l2, onDeeplinkResolvedListener);
            return;
        }
        AdjustFactory.getLogger().warn("Skipping deeplink processing (null or empty)", new Object[0]);
    }

    public void sendReferrer(String string, Context context) {
        long l2 = System.currentTimeMillis();
        if (string != null && string.length() != 0) {
            AdjustInstance adjustInstance = this;
            adjustInstance.saveRawReferrer(string, l2, context);
            if (adjustInstance.checkActivityHandler("referrer", true) && this.activityHandler.isEnabled()) {
                this.activityHandler.sendReftagReferrer();
            }
            return;
        }
        AdjustFactory.getLogger().warn("Skipping INSTALL_REFERRER intent referrer processing (null or empty)", new Object[0]);
    }

    public void sendPreinstallReferrer(String string, Context context) {
        if (string != null && string.length() != 0) {
            AdjustInstance adjustInstance = this;
            adjustInstance.savePreinstallReferrer(string, context);
            if (adjustInstance.checkActivityHandler("preinstall referrer", true) && this.activityHandler.isEnabled()) {
                this.activityHandler.sendPreinstallReferrer();
            }
            return;
        }
        AdjustFactory.getLogger().warn("Skipping SYSTEM_INSTALLER_REFERRER preinstall referrer processing (null or empty)", new Object[0]);
    }

    public void switchToOfflineMode() {
        if (!this.checkActivityHandler(true, "offline mode", "online mode")) {
            this.startOffline = true;
        } else {
            this.activityHandler.setOfflineMode(true);
        }
    }

    public void switchBackToOnlineMode() {
        if (!this.checkActivityHandler(false, "offline mode", "online mode")) {
            this.startOffline = false;
        } else {
            this.activityHandler.setOfflineMode(false);
        }
    }

    public void addGlobalCallbackParameter(final String string, final String string2) {
        if (this.checkActivityHandler("adding global callback parameter", true)) {
            this.activityHandler.addGlobalCallbackParameter(string, string2);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                c c2 = string3;
                String string3 = c2.string;
                activityHandler.addGlobalCallbackParameterI(string3, c2.string2);
            }
        });
    }

    public void addGlobalPartnerParameter(final String string, final String string2) {
        if (this.checkActivityHandler("adding global partner parameter", true)) {
            this.activityHandler.addGlobalPartnerParameter(string, string2);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                d d2 = string3;
                String string3 = d2.string;
                activityHandler.addGlobalPartnerParameterI(string3, d2.string2);
            }
        });
    }

    public void removeGlobalCallbackParameter(final String string) {
        if (this.checkActivityHandler("removing global callback parameter", true)) {
            this.activityHandler.removeGlobalCallbackParameter(string);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                activityHandler.removeGlobalCallbackParameterI(string);
            }
        });
    }

    public void removeGlobalPartnerParameter(final String string) {
        if (this.checkActivityHandler("removing global partner parameter", true)) {
            this.activityHandler.removeGlobalPartnerParameter(string);
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                activityHandler.removeGlobalPartnerParameterI(string);
            }
        });
    }

    public void removeGlobalCallbackParameters() {
        if (this.checkActivityHandler("resetting global callback parameters", true)) {
            this.activityHandler.removeGlobalCallbackParameters();
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                activityHandler.removeGlobalCallbackParametersI();
            }
        });
    }

    public void removeGlobalPartnerParameters() {
        if (this.checkActivityHandler("resetting global partner parameters", true)) {
            this.activityHandler.removeGlobalPartnerParameters();
            return;
        }
        this.preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

            @Override
            public final void run(ActivityHandler activityHandler) {
                activityHandler.removeGlobalPartnerParametersI();
            }
        });
    }

    public void teardown() {
        if (!this.checkActivityHandler("teardown")) {
            return;
        }
        this.activityHandler.teardown();
        this.activityHandler = null;
    }

    public void setPushToken(String string, Context context) {
        AdjustInstance adjustInstance = this;
        adjustInstance.savePushToken(string, context);
        if (adjustInstance.checkActivityHandler("push token", true) && this.activityHandler.isEnabled()) {
            this.activityHandler.setPushToken(string, true);
        }
    }

    public void gdprForgetMe(Context context) {
        AdjustInstance adjustInstance = this;
        adjustInstance.saveGdprForgetMe(context);
        if (adjustInstance.checkActivityHandler("gdpr", true) && this.activityHandler.isEnabled()) {
            this.activityHandler.gdprForgetMe();
        }
    }

    public void trackThirdPartySharing(AdjustThirdPartySharing adjustThirdPartySharing) {
        if (!this.checkActivityHandler("third party sharing", true)) {
            this.preLaunchActions.preLaunchAdjustThirdPartySharingArray.add(adjustThirdPartySharing);
            return;
        }
        this.activityHandler.trackThirdPartySharing(adjustThirdPartySharing);
    }

    public void trackMeasurementConsent(boolean bl) {
        if (!this.checkActivityHandler("measurement consent", true)) {
            this.preLaunchActions.lastMeasurementConsentTracked = bl;
            return;
        }
        this.activityHandler.trackMeasurementConsent(bl);
    }

    public void trackAdRevenue(AdjustAdRevenue adjustAdRevenue) {
        if (!this.checkActivityHandler("trackAdRevenue")) {
            return;
        }
        this.activityHandler.trackAdRevenue(adjustAdRevenue);
    }

    public void trackPlayStoreSubscription(AdjustPlayStoreSubscription adjustPlayStoreSubscription) {
        if (!this.checkActivityHandler("trackPlayStoreSubscription")) {
            return;
        }
        this.activityHandler.trackPlayStoreSubscription(adjustPlayStoreSubscription);
    }

    public void getAdid(OnAdidReadListener onAdidReadListener) {
        if (!this.checkActivityHandler("getAdid")) {
            this.cachedAdidReadCallbacks.add(onAdidReadListener);
            return;
        }
        this.activityHandler.getAdid(onAdidReadListener);
    }

    public void getAttribution(OnAttributionReadListener onAttributionReadListener) {
        if (!this.checkActivityHandler("getAttribution")) {
            this.cachedAttributionReadCallbacks.add(onAttributionReadListener);
            return;
        }
        this.activityHandler.getAttribution(onAttributionReadListener);
    }

    public void getSdkVersion(final OnSdkVersionReadListener onSdkVersionReadListener) {
        new AsyncTaskExecutor<Void, String>(){

            @Override
            public final void onPostExecute(Object object) {
                i i2 = string;
                String string = (String)object;
                i2.onSdkVersionReadListener.onSdkVersionRead(string);
            }

            @Override
            public final Object doInBackground(Object[] objectArray) {
                Void[] cfr_ignored_0 = (Void[])objectArray;
                return Util.getSdkVersion();
            }
        }.execute(new Void[0]);
    }

    public void getGooglePlayInstallReferrer(Context context, final OnGooglePlayInstallReferrerReadListener onGooglePlayInstallReferrerReadListener) {
        InstallReferrerReadListener installReferrerReadListener;
        InstallReferrerReadListener installReferrerReadListener2 = installReferrerReadListener;
        installReferrerReadListener = new InstallReferrerReadListener(){

            @Override
            public final void onInstallReferrerRead(ReferrerDetails referrerDetails, String string) {
                onGooglePlayInstallReferrerReadListener.onInstallReferrerRead(new GooglePlayInstallReferrerDetails(referrerDetails));
            }

            @Override
            public final void onFail(String string) {
                onGooglePlayInstallReferrerReadListener.onFail(string);
            }
        };
        new InstallReferrer(context, installReferrerReadListener2).startConnection();
    }

    public void getAmazonAdId(Context context, OnAmazonAdIdReadListener onAmazonAdIdReadListener) {
        DeviceInfo.getFireAdvertisingIdBypassConditions(context.getContentResolver(), onAmazonAdIdReadListener);
    }

    public void verifyPlayStorePurchase(AdjustPlayStorePurchase adjustPlayStorePurchase, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        if (!((AdjustInstance)((Object)adjustPurchaseVerificationResult2)).checkActivityHandler("verifyPurchase")) {
            AdjustPurchaseVerificationResult adjustPurchaseVerificationResult;
            AdjustPurchaseVerificationResult adjustPurchaseVerificationResult2 = adjustPurchaseVerificationResult;
            adjustPurchaseVerificationResult = new AdjustPurchaseVerificationResult("not_verified", 100, "SDK needs to be initialized before making purchase verification request");
            onPurchaseVerificationFinishedListener.onVerificationFinished(adjustPurchaseVerificationResult2);
            return;
        }
        ((AdjustInstance)((Object)adjustPurchaseVerificationResult2)).activityHandler.verifyPlayStorePurchase(adjustPlayStorePurchase, onPurchaseVerificationFinishedListener);
    }

    public void verifyAndTrackPlayStorePurchase(AdjustEvent adjustEvent, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        if (!((AdjustInstance)((Object)adjustPurchaseVerificationResult2)).checkActivityHandler("verifyAndTrack")) {
            if (onPurchaseVerificationFinishedListener != null) {
                AdjustPurchaseVerificationResult adjustPurchaseVerificationResult;
                AdjustPurchaseVerificationResult adjustPurchaseVerificationResult2 = adjustPurchaseVerificationResult;
                adjustPurchaseVerificationResult = new AdjustPurchaseVerificationResult("not_verified", 100, "SDK needs to be initialized before making purchase verification request");
                onPurchaseVerificationFinishedListener.onVerificationFinished(adjustPurchaseVerificationResult2);
            }
            return;
        }
        ((AdjustInstance)((Object)adjustPurchaseVerificationResult2)).activityHandler.verifyAndTrackPlayStorePurchase(adjustEvent, onPurchaseVerificationFinishedListener);
    }

    public void getLastDeeplink(final Context context, final OnLastDeeplinkReadListener onLastDeeplinkReadListener) {
        new AsyncTaskExecutor<Void, Uri>(){

            @Override
            public final void onPostExecute(Object object) {
                a a2 = a3;
                a a3 = (Uri)object;
                a2.onLastDeeplinkReadListener.onLastDeeplinkRead((Uri)a3);
            }

            @Override
            public final Object doInBackground(Object[] objectArray) {
                a a2;
                Void[] cfr_ignored_0 = (Void[])objectArray;
                try {
                    a2 = Uri.parse((String)a2.AdjustInstance.this.getCachedDeeplink(a2.context));
                }
                catch (Exception exception) {
                    a2 = null;
                }
                return a2;
            }
        }.execute(new Void[0]);
    }

    public void setTestOptions(AdjustTestOptions adjustTestOptions) {
        String string = adjustTestOptions.basePath;
        if (string != null) {
            ((AdjustInstance)this).basePath = string;
        }
        if ((string = adjustTestOptions.gdprPath) != null) {
            ((AdjustInstance)this).gdprPath = string;
        }
        if ((string = adjustTestOptions.subscriptionPath) != null) {
            ((AdjustInstance)this).subscriptionPath = string;
        }
        if ((string = adjustTestOptions.purchaseVerificationPath) != null) {
            ((AdjustInstance)this).purchaseVerificationPath = string;
        }
        if ((this = adjustTestOptions.baseUrl) != null) {
            AdjustFactory.setBaseUrl((String)this);
        }
        if ((this = adjustTestOptions.gdprUrl) != null) {
            AdjustFactory.setGdprUrl((String)this);
        }
        if ((this = adjustTestOptions.subscriptionUrl) != null) {
            AdjustFactory.setSubscriptionUrl((String)this);
        }
        if ((this = adjustTestOptions.purchaseVerificationUrl) != null) {
            AdjustFactory.setPurchaseVerificationUrl((String)this);
        }
        if ((this = adjustTestOptions.timerIntervalInMilliseconds) != null) {
            AdjustFactory.setTimerInterval((Long)this);
        }
        if (adjustTestOptions.timerStartInMilliseconds != null) {
            AdjustFactory.setTimerStart(adjustTestOptions.timerIntervalInMilliseconds);
        }
        if ((this = adjustTestOptions.sessionIntervalInMilliseconds) != null) {
            AdjustFactory.setSessionInterval((Long)this);
        }
        if ((this = adjustTestOptions.subsessionIntervalInMilliseconds) != null) {
            AdjustFactory.setSubsessionInterval((Long)this);
        }
        if ((this = adjustTestOptions.tryInstallReferrer) != null) {
            AdjustFactory.setTryInstallReferrer((Boolean)this);
        }
        if (adjustTestOptions.noBackoffWait != null) {
            BackoffStrategy backoffStrategy = BackoffStrategy.NO_WAIT;
            AdjustFactory.setPackageHandlerBackoffStrategy(backoffStrategy);
            AdjustFactory.setSdkClickBackoffStrategy(backoffStrategy);
        }
        if ((this = adjustTestOptions.ignoreSystemLifecycleBootstrap) != null) {
            AdjustFactory.setIgnoreSystemLifecycleBootstrap((Boolean)this);
        }
    }

    public static class PreLaunchActions {
        public List<IRunActivityHandler> preLaunchActionsArray;
        public List<AdjustThirdPartySharing> preLaunchAdjustThirdPartySharingArray;
        public Boolean lastMeasurementConsentTracked;

        public PreLaunchActions() {
            ArrayList arrayList;
            ArrayList arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList();
            v1.preLaunchActionsArray = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.preLaunchAdjustThirdPartySharingArray = object;
            v1.lastMeasurementConsentTracked = null;
        }
    }
}

