/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageHandler
implements IPackageHandler,
IActivityPackageSender.ResponseDataCallbackSubscriber {
    private static final String PACKAGE_QUEUE_FILENAME = "AdjustIoPackageQueue";
    private static final String PACKAGE_QUEUE_NAME = "Package queue";
    private ThreadScheduler scheduler;
    private IActivityPackageSender activityPackageSender;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private List<ActivityPackage> packageQueue;
    private AtomicBoolean isSending;
    private boolean paused;
    private Context context;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private BackoffStrategy backoffStrategyForInstallSession;
    private boolean isRetrying;
    private long retryStartedAtTimeMilliSeconds;
    private double totalWaitTimeSeconds;

    public static void deleteState(Context context) {
        PackageHandler.deletePackageQueue(context);
    }

    public PackageHandler(IActivityHandler iActivityHandler, Context context, boolean bl, IActivityPackageSender iActivityPackageSender) {
        PackageHandler packageHandler = this;
        this.scheduler = new SingleThreadCachedScheduler("PackageHandler");
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getPackageHandlerBackoffStrategy();
        this.backoffStrategyForInstallSession = AdjustFactory.getInstallSessionBackoffStrategy();
        this.isRetrying = false;
        this.totalWaitTimeSeconds = 0.0;
        packageHandler.init(iActivityHandler, context, bl, iActivityPackageSender);
        packageHandler.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PackageHandler.this.initI();
            }
        });
    }

    private void initI() {
        AtomicBoolean atomicBoolean;
        PackageHandler packageHandler = atomicBoolean2;
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        atomicBoolean = new AtomicBoolean();
        packageHandler.isSending = atomicBoolean2;
        packageHandler.readPackageQueueI();
    }

    private void addI(ActivityPackage activityPackage) {
        long l2;
        if (objectArray6.isRetrying) {
            l2 = System.currentTimeMillis();
            activityPackage.setWaitBeforeSendTimeSeconds(objectArray6.totalWaitTimeSeconds - (double)(l2 - objectArray6.retryStartedAtTimeMilliSeconds) / 1000.0);
        }
        Object[] objectArray = objectArray6;
        Object[] objectArray2 = objectArray6;
        l2 = objectArray6.packageQueue.size();
        PackageBuilder.addLong(activityPackage.getParameters(), "enqueue_size", l2);
        objectArray.packageQueue.add(activityPackage);
        Object[] objectArray3 = new Object[2];
        Object[] objectArray4 = objectArray3;
        objectArray3[0] = objectArray6.packageQueue.size();
        objectArray3[1] = activityPackage;
        objectArray2.logger.debug("Added package %d (%s)", objectArray4);
        Object[] objectArray5 = new Object[1];
        Object[] objectArray6 = objectArray5;
        objectArray5[0] = activityPackage.getExtendedString();
        objectArray.logger.verbose("%s", objectArray6);
        super.writePackageQueueI();
    }

    private void sendFirstI() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Package handler is paused", new Object[0]);
            return;
        }
        if (this.isSending.getAndSet(true)) {
            this.logger.verbose("Package handler is already sending", new Object[0]);
            return;
        }
        PackageHandler packageHandler = this;
        Map<String, String> map = packageHandler.generateSendingParametersI();
        ActivityPackage activityPackage = this.packageQueue.get(0);
        long l2 = activityPackage.getRetryCount();
        PackageBuilder.addLong(map, "retry_count", l2);
        l2 = activityPackage.getFirstErrorCode();
        PackageBuilder.addLong(map, "first_error", l2);
        l2 = activityPackage.getLastErrorCode();
        PackageBuilder.addLong(map, "last_error", l2);
        double d2 = this.totalWaitTimeSeconds;
        PackageBuilder.addDouble(map, "wait_total", d2);
        d2 = activityPackage.getWaitBeforeSendTimeSeconds();
        PackageBuilder.addDouble(map, "wait_time", d2);
        packageHandler.activityPackageSender.sendActivityPackage(activityPackage, map, this);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> hashMap;
        PackageHandler packageHandler = hashMap2;
        HashMap<String, String> hashMap2 = hashMap;
        long l2 = System.currentTimeMillis();
        PackageBuilder.addString(new HashMap<String, String>(), "sent_at", Util.dateFormatter.format(l2));
        int n2 = packageHandler.packageQueue.size() - 1;
        if (n2 > 0) {
            long l3 = n2;
            PackageBuilder.addLong((Map<String, String>)hashMap2, "queue_size", l3);
        }
        return hashMap2;
    }

    private void sendNextI(Long l2) {
        objectArray2.isRetrying = false;
        objectArray2.retryStartedAtTimeMilliSeconds = 0L;
        if (objectArray2.packageQueue.isEmpty()) {
            objectArray2.totalWaitTimeSeconds = 0.0;
            return;
        }
        objectArray2.packageQueue.remove(0);
        objectArray2.writePackageQueueI();
        if (l2 != null && l2 > 0L) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public final void run() {
                    g g2 = this;
                    g2.PackageHandler.this.logger.verbose("Package handler finished waiting to continue", new Object[0]);
                    g2.PackageHandler.this.isSending.set(false);
                    g2.PackageHandler.this.sendFirstPackage();
                }
            };
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = (double)l2.longValue() / 1000.0;
            objectArray2.logger.verbose("Waiting for %d seconds before continuing for next package in continue_in", objectArray2);
            objectArray2.scheduler.schedule(runnable2, l2);
        } else {
            Object[] objectArray = objectArray2;
            objectArray.logger.verbose("Package handler can send", new Object[0]);
            objectArray.isSending.set(false);
            objectArray2.sendFirstI();
        }
    }

    private void flushI() {
        PackageHandler packageHandler = this;
        packageHandler.packageQueue.clear();
        packageHandler.writePackageQueueI();
    }

    private void readPackageQueueI() {
        Object[] objectArray;
        try {
            objectArray.packageQueue = Util.readObject(objectArray.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME, List.class);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = PACKAGE_QUEUE_NAME;
            objectArray2[1] = exception.getMessage();
            objectArray.logger.error("Failed to read %s file (%s)", objectArray3);
            objectArray.packageQueue = null;
        }
        List<ActivityPackage> list = objectArray.packageQueue;
        if (list != null) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = list.size();
            objectArray.logger.debug("Package handler read %d packages", objectArray);
        } else {
            ArrayList arrayList;
            PackageHandler packageHandler = objectArray;
            objectArray = arrayList;
            arrayList = new ArrayList();
            packageHandler.packageQueue = objectArray;
        }
    }

    private void writePackageQueueI() {
        PackageHandler packageHandler = this;
        Util.writeObject(packageHandler.packageQueue, this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.packageQueue.size();
        packageHandler.logger.debug("Package handler wrote %d packages", objectArray2);
    }

    public static Boolean deletePackageQueue(Context context) {
        return context.deleteFile(PACKAGE_QUEUE_FILENAME);
    }

    @Override
    public void teardown() {
        PackageHandler packageHandler = this;
        packageHandler.logger.verbose("PackageHandler teardown", new Object[0]);
        List<ActivityPackage> list = packageHandler.scheduler;
        if (list != null) {
            list.teardown();
        }
        if ((list = this.activityHandlerWeakRef) != null) {
            ((Reference)((Object)list)).clear();
        }
        if ((list = this.packageQueue) != null) {
            list.clear();
        }
        PackageHandler packageHandler2 = this;
        packageHandler2.scheduler = null;
        packageHandler2.activityHandlerWeakRef = null;
        packageHandler2.packageQueue = null;
        packageHandler2.isSending = null;
        packageHandler2.context = null;
        packageHandler2.logger = null;
        packageHandler2.backoffStrategy = null;
    }

    @Override
    public void init(IActivityHandler iActivityHandler, Context context, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        this.context = context;
        this.paused = bl ^ true;
        this.activityPackageSender = iActivityPackageSender;
    }

    @Override
    public void addPackage(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PackageHandler.this.addI(activityPackage);
            }
        });
    }

    @Override
    public void sendFirstPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PackageHandler.this.sendFirstI();
            }
        });
    }

    @Override
    public void onResponseDataCallback(final ResponseData responseData) {
        Runnable runnable;
        PackageHandler packageHandler = this;
        packageHandler.logger.debug("Got response in PackageHandler", new Object[0]);
        Object object = (IActivityHandler)packageHandler.activityHandlerWeakRef.get();
        if (object != null && responseData.trackingState == TrackingState.OPTED_OUT) {
            object.gotOptOutResponse();
        }
        if (!responseData.willRetry) {
            this.scheduler.submit(new Runnable(){

                @Override
                public final void run() {
                    PackageHandler.this.sendNextI(responseData.continueIn);
                }
            });
            if (object != null) {
                object.finishedTrackingActivity(responseData);
            }
            return;
        }
        if (!this.isRetrying) {
            PackageHandler packageHandler2 = this;
            packageHandler2.isRetrying = true;
            packageHandler2.retryStartedAtTimeMilliSeconds = System.currentTimeMillis();
        }
        this.writePackageQueueI();
        if (object != null) {
            object.finishedTrackingActivity(responseData);
        }
        object = runnable;
        runnable = new Runnable(){

            @Override
            public final void run() {
                e e2 = this;
                e2.PackageHandler.this.logger.verbose("Package handler can send", new Object[0]);
                e2.PackageHandler.this.isSending.set(false);
                e2.PackageHandler.this.sendFirstPackage();
            }
        };
        Long l2 = responseData.retryIn;
        if (l2 != null) {
            long l3 = l2;
            this.scheduler.schedule((Runnable)object, l3);
            return;
        }
        int n2 = responseData.activityPackage.increaseRetries();
        SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(this.context);
        long l4 = responseData.activityPackage.getActivityKind() == ActivityKind.SESSION && !sharedPreferencesManager.getInstallTracked() ? Util.getWaitingTime(n2, this.backoffStrategyForInstallSession) : Util.getWaitingTime(n2, this.backoffStrategy);
        PackageHandler packageHandler3 = this;
        double d2 = (double)l4 / 1000.0;
        String string = Util.SecondsDisplayFormat.format(d2);
        packageHandler3.totalWaitTimeSeconds += d2;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string;
        objectArray[1] = n2;
        packageHandler3.logger.verbose("Waiting for %s seconds before retrying the %d time", objectArray2);
        packageHandler3.scheduler.schedule((Runnable)object, l4);
        ActivityPackage activityPackage = responseData.activityPackage;
        activityPackage.setWaitBeforeSendTimeSeconds(activityPackage.getWaitBeforeSendTimeSeconds() + d2);
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    @Override
    public void flush() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PackageHandler.this.flushI();
            }
        });
    }
}

