/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimerOnce {
    private ScheduledExecutorService scheduler;
    private ScheduledFuture waitingTask;
    private String name;
    private Runnable command;
    private ILogger logger;

    public TimerOnce(ScheduledExecutorService scheduler, Runnable command, String name) {
        this.name = name;
        this.scheduler = scheduler;
        this.command = command;
        this.logger = AdjustFactory.getLogger();
    }

    public void startIn(long fireIn) {
        this.cancel(false);
        String fireInSeconds = Util.SecondsDisplayFormat.format((double)fireIn / 1000.0);
        this.logger.verbose("%s starting. Launching in %s seconds", this.name, fireInSeconds);
        this.waitingTask = this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                TimerOnce.this.logger.verbose("%s fired", TimerOnce.this.name);
                TimerOnce.this.command.run();
                TimerOnce.this.waitingTask = null;
            }
        }, fireIn, TimeUnit.MILLISECONDS);
    }

    public long getFireIn() {
        if (this.waitingTask == null) {
            return 0L;
        }
        return this.waitingTask.getDelay(TimeUnit.MILLISECONDS);
    }

    private void cancel(boolean log) {
        if (this.waitingTask != null) {
            this.waitingTask.cancel(false);
        }
        this.waitingTask = null;
        if (log) {
            this.logger.verbose("%s canceled", this.name);
        }
    }

    public void cancel() {
        this.cancel(true);
    }
}

