/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Looper;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.OnDeviceIdsRead;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.ResponseData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    private static SimpleDateFormat dateFormat;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z";
    private static final String fieldReadErrorMessage = "Unable to read '%s' field in migration device with message (%s)";

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    protected static String createUuid() {
        return UUID.randomUUID().toString();
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        return String.format(Locale.US, "'%s'", string);
    }

    public static String dateFormat(long date) {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        }
        return dateFormat.format(date);
    }

    public static String getPlayAdId(Context context) {
        return Reflection.getPlayAdId(context);
    }

    public static void getGoogleAdId(Context context, final OnDeviceIdsRead onDeviceIdRead) {
        ILogger logger = AdjustFactory.getLogger();
        if (Looper.myLooper() != Looper.getMainLooper()) {
            logger.debug("GoogleAdId being read in the background", new Object[0]);
            String GoogleAdId = Util.getPlayAdId(context);
            logger.debug("GoogleAdId read " + GoogleAdId, new Object[0]);
            onDeviceIdRead.onGoogleAdIdRead(GoogleAdId);
            return;
        }
        logger.debug("GoogleAdId being read in the foreground", new Object[0]);
        new AsyncTask<Context, Void, String>(){

            protected String doInBackground(Context ... params) {
                ILogger logger = AdjustFactory.getLogger();
                Context innerContext = params[0];
                String innerResult = Util.getPlayAdId(innerContext);
                logger.debug("GoogleAdId read " + innerResult, new Object[0]);
                return innerResult;
            }

            protected void onPostExecute(String playAdiId) {
                ILogger logger = AdjustFactory.getLogger();
                onDeviceIdRead.onGoogleAdIdRead(playAdiId);
            }
        }.execute((Object[])new Context[]{context});
    }

    public static Boolean isPlayTrackingEnabled(Context context) {
        return Reflection.isPlayTrackingEnabled(context);
    }

    public static String getMacAddress(Context context) {
        return Reflection.getMacAddress(context);
    }

    public static Map<String, String> getPluginKeys(Context context) {
        return Reflection.getPluginKeys(context);
    }

    public static String getAndroidId(Context context) {
        return Reflection.getAndroidId(context);
    }

    public static <T> T readObject(Context context, String filename, String objectName, Class<T> type) {
        InputStream closable = null;
        T object = null;
        try {
            FileInputStream inputStream = context.openFileInput(filename);
            closable = inputStream;
            BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
            closable = bufferedStream;
            ObjectInputStream objectStream = new ObjectInputStream(bufferedStream);
            closable = objectStream;
            try {
                object = type.cast(objectStream.readObject());
                Util.getLogger().debug("Read %s: %s", objectName, object);
            }
            catch (ClassNotFoundException e) {
                Util.getLogger().error("Failed to find %s class (%s)", objectName, e.getMessage());
            }
            catch (ClassCastException e) {
                Util.getLogger().error("Failed to cast %s object (%s)", objectName, e.getMessage());
            }
            catch (Exception e) {
                Util.getLogger().error("Failed to read %s object (%s)", objectName, e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            Util.getLogger().verbose("%s file not found", objectName);
        }
        catch (Exception e) {
            Util.getLogger().error("Failed to open %s file for reading (%s)", objectName, e);
        }
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Exception e) {
            Util.getLogger().error("Failed to close %s file for reading (%s)", objectName, e);
        }
        return object;
    }

    public static <T> void writeObject(T object, Context context, String filename, String objectName) {
        OutputStream closable = null;
        try {
            FileOutputStream outputStream = context.openFileOutput(filename, 0);
            closable = outputStream;
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
            closable = bufferedStream;
            ObjectOutputStream objectStream = new ObjectOutputStream(bufferedStream);
            closable = objectStream;
            try {
                objectStream.writeObject(object);
                Util.getLogger().debug("Wrote %s: %s", objectName, object);
            }
            catch (NotSerializableException e) {
                Util.getLogger().error("Failed to serialize %s", objectName);
            }
        }
        catch (Exception e) {
            Util.getLogger().error("Failed to open %s for writing (%s)", objectName, e);
        }
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Exception e) {
            Util.getLogger().error("Failed to close %s file for writing (%s)", objectName, e);
        }
    }

    public static ResponseData readHttpResponse(HttpsURLConnection connection, ActivityPackage activityPackage) throws Exception {
        String message;
        StringBuffer sb = new StringBuffer();
        ILogger logger = Util.getLogger();
        Integer responseCode = null;
        try {
            String line;
            responseCode = connection.getResponseCode();
            InputStream inputStream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            logger.error("Failed to read response. (%s)", e.getMessage());
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        String stringResponse = sb.toString();
        logger.verbose("Response: %s", stringResponse);
        if (stringResponse == null || stringResponse.length() == 0) {
            return responseData;
        }
        JSONObject jsonResponse = null;
        try {
            jsonResponse = new JSONObject(stringResponse);
        }
        catch (JSONException e) {
            String message2 = String.format("Failed to parse json response. (%s)", e.getMessage());
            logger.error(message2, new Object[0]);
            responseData.message = message2;
        }
        if (jsonResponse == null) {
            return responseData;
        }
        responseData.jsonResponse = jsonResponse;
        responseData.message = message = jsonResponse.optString("message", null);
        responseData.timestamp = jsonResponse.optString("timestamp", null);
        responseData.adid = jsonResponse.optString("adid", null);
        if (message == null) {
            message = "No message found";
        }
        if (responseCode != null && responseCode == 200) {
            logger.info("%s", message);
            responseData.success = true;
        } else {
            logger.error("%s", message);
        }
        return responseData;
    }

    public static HttpsURLConnection createGETHttpsURLConnection(String urlString, String clientSdk) throws IOException {
        HttpsURLConnection connection = Util.createHttpsURLConnection(urlString, clientSdk);
        connection.setRequestMethod("GET");
        return connection;
    }

    public static HttpsURLConnection createPOSTHttpsURLConnection(String urlString, String clientSdk, Map<String, String> parameters) throws IOException {
        HttpsURLConnection connection = Util.createHttpsURLConnection(urlString, clientSdk);
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.writeBytes(Util.getPostDataString(parameters));
        wr.flush();
        wr.close();
        return connection;
    }

    private static String getPostDataString(Map<String, String> body) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : body.entrySet()) {
            String encodedValue;
            String encodedName = URLEncoder.encode(entry.getKey(), "UTF-8");
            String value = entry.getValue();
            String string = encodedValue = value != null ? URLEncoder.encode(value, "UTF-8") : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormat(now);
        result.append("&");
        result.append(URLEncoder.encode("sent_at", "UTF-8"));
        result.append("=");
        result.append(URLEncoder.encode(dateString, "UTF-8"));
        return result.toString();
    }

    public static HttpsURLConnection createHttpsURLConnection(String urlString, String clientSdk) throws IOException {
        URL url = new URL(urlString);
        HttpsURLConnection connection = AdjustFactory.getHttpsURLConnection(url);
        connection.setRequestProperty("Client-SDK", clientSdk);
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(60000);
        return connection;
    }

    public static boolean checkPermission(Context context, String permission2) {
        int result = context.checkCallingOrSelfPermission(permission2);
        return result == 0;
    }

    public static String readStringField(ObjectInputStream.GetField fields, String name, String defaultValue) {
        return Util.readObjectField(fields, name, defaultValue);
    }

    public static <T> T readObjectField(ObjectInputStream.GetField fields, String name, T defaultValue) {
        try {
            return (T)fields.get(name, defaultValue);
        }
        catch (Exception e) {
            Util.getLogger().debug(fieldReadErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    public static boolean readBooleanField(ObjectInputStream.GetField fields, String name, boolean defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            Util.getLogger().debug(fieldReadErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    public static int readIntField(ObjectInputStream.GetField fields, String name, int defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            Util.getLogger().debug(fieldReadErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    public static long readLongField(ObjectInputStream.GetField fields, String name, long defaultValue) {
        try {
            return fields.get(name, defaultValue);
        }
        catch (Exception e) {
            Util.getLogger().debug(fieldReadErrorMessage, name, e.getMessage());
            return defaultValue;
        }
    }

    public static boolean equalObject(Object first, Object second) {
        if (first == null || second == null) {
            return first == null && second == null;
        }
        return first.equals(second);
    }

    public static boolean equalsMap(Map first, Map second) {
        if (first == null || second == null) {
            return first == null && second == null;
        }
        return first.entrySet().equals(second.entrySet());
    }

    public static boolean equalsDouble(Double first, Double second) {
        if (first == null || second == null) {
            return first == null && second == null;
        }
        return Double.doubleToLongBits(first) == Double.doubleToLongBits(second);
    }

    public static boolean equalString(String first, String second) {
        return Util.equalObject(first, second);
    }

    public static boolean equalEnum(Enum first, Enum second) {
        return Util.equalObject(first, second);
    }

    public static boolean equalLong(Long first, Long second) {
        return Util.equalObject(first, second);
    }

    public static boolean equalInt(Integer first, Integer second) {
        return Util.equalObject(first, second);
    }

    public static boolean equalBoolean(Boolean first, Boolean second) {
        return Util.equalObject(first, second);
    }

    public static int hashBoolean(Boolean value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashLong(Long value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashString(String value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashEnum(Enum value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static int hashMap(Map value) {
        if (value == null) {
            return 0;
        }
        return value.entrySet().hashCode();
    }

    public static String sha1(String text) {
        return Util.hash(text, "SHA-1");
    }

    public static String md5(String text) {
        return Util.hash(text, "MD5");
    }

    public static String hash(String text, String method) {
        String hashString = null;
        try {
            byte[] bytes = text.getBytes("UTF-8");
            MessageDigest mesd = MessageDigest.getInstance(method);
            mesd.update(bytes, 0, bytes.length);
            byte[] hash = mesd.digest();
            hashString = Util.convertToHex(hash);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashString;
    }

    public static String convertToHex(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        String formatString = "%0" + (bytes.length << 1) + "x";
        return String.format(Locale.US, formatString, bigInt);
    }
}

