/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;

public class ActivityState
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9039439291143138148L;
    private transient ILogger logger = AdjustFactory.getLogger();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("uuid", String.class), new ObjectStreamField("enabled", Boolean.TYPE), new ObjectStreamField("askingAttribution", Boolean.TYPE), new ObjectStreamField("eventCount", Integer.TYPE), new ObjectStreamField("sessionCount", Integer.TYPE), new ObjectStreamField("subsessionCount", Integer.TYPE), new ObjectStreamField("sessionLength", Long.TYPE), new ObjectStreamField("timeSpent", Long.TYPE), new ObjectStreamField("lastActivity", Long.TYPE), new ObjectStreamField("lastInterval", Long.TYPE)};
    protected String uuid = Util.createUuid();
    protected boolean enabled = true;
    protected boolean askingAttribution = false;
    protected int eventCount = 0;
    protected int sessionCount = 0;
    protected int subsessionCount = -1;
    protected long sessionLength = -1L;
    protected long timeSpent = -1L;
    protected long lastActivity = -1L;
    protected long lastInterval = -1L;

    protected ActivityState() {
    }

    protected void resetSessionAttributes(long now) {
        this.subsessionCount = 1;
        this.sessionLength = 0L;
        this.timeSpent = 0L;
        this.lastActivity = now;
        this.lastInterval = -1L;
    }

    public String toString() {
        return String.format(Locale.US, "ec:%d sc:%d ssc:%d sl:%.1f ts:%.1f la:%s uuid:%s", this.eventCount, this.sessionCount, this.subsessionCount, (double)this.sessionLength / 1000.0, (double)this.timeSpent / 1000.0, ActivityState.stamp(this.lastActivity), this.uuid);
    }

    public ActivityState shallowCopy() {
        try {
            return (ActivityState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ActivityState otherActivityState = (ActivityState)other;
        if (!Util.equalString(this.uuid, otherActivityState.uuid)) {
            return false;
        }
        if (!Util.equalBoolean(this.enabled, otherActivityState.enabled)) {
            return false;
        }
        if (!Util.equalBoolean(this.askingAttribution, otherActivityState.askingAttribution)) {
            return false;
        }
        if (!Util.equalInt(this.eventCount, otherActivityState.eventCount)) {
            return false;
        }
        if (!Util.equalInt(this.sessionCount, otherActivityState.sessionCount)) {
            return false;
        }
        if (!Util.equalInt(this.subsessionCount, otherActivityState.subsessionCount)) {
            return false;
        }
        if (!Util.equalLong(this.sessionLength, otherActivityState.sessionLength)) {
            return false;
        }
        if (!Util.equalLong(this.timeSpent, otherActivityState.timeSpent)) {
            return false;
        }
        return Util.equalLong(this.lastInterval, otherActivityState.lastInterval);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + Util.hashString(this.uuid);
        hashCode = 37 * hashCode + Util.hashBoolean(this.enabled);
        hashCode = 37 * hashCode + Util.hashBoolean(this.askingAttribution);
        hashCode = 37 * hashCode + this.eventCount;
        hashCode = 37 * hashCode + this.sessionCount;
        hashCode = 37 * hashCode + this.subsessionCount;
        hashCode = 37 * hashCode + Util.hashLong(this.sessionLength);
        hashCode = 37 * hashCode + Util.hashLong(this.timeSpent);
        hashCode = 37 * hashCode + Util.hashLong(this.lastInterval);
        return hashCode;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.eventCount = Util.readIntField(fields, "eventCount", 0);
        this.sessionCount = Util.readIntField(fields, "sessionCount", 0);
        this.subsessionCount = Util.readIntField(fields, "subsessionCount", -1);
        this.sessionLength = Util.readLongField(fields, "sessionLength", -1L);
        this.timeSpent = Util.readLongField(fields, "timeSpent", -1L);
        this.lastActivity = Util.readLongField(fields, "lastActivity", -1L);
        this.lastInterval = Util.readLongField(fields, "lastInterval", -1L);
        this.uuid = Util.readStringField(fields, "uuid", null);
        this.enabled = Util.readBooleanField(fields, "enabled", true);
        this.askingAttribution = Util.readBooleanField(fields, "askingAttribution", false);
        if (this.uuid == null) {
            this.uuid = Util.createUuid();
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private static String stamp(long dateMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dateMillis);
        Object[] objectArray = new Object[3];
        objectArray[0] = 11;
        objectArray[1] = 12;
        objectArray[2] = 13;
        return String.format(Locale.US, "%02d:%02d:%02d", objectArray);
    }
}

