/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.PackageFactory;
import com.adjust.sdk.PreinstallUtil;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class SdkClickHandler
implements ISdkClickHandler {
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static final String SCHEDULED_EXECUTOR_SOURCE = "SdkClickHandler";
    private static final String SOURCE_REFTAG = "reftag";
    private static final String SOURCE_INSTALL_REFERRER = "install_referrer";
    private boolean paused;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private List<ActivityPackage> packageQueue;
    private ThreadScheduler scheduler;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private IActivityPackageSender activityPackageSender;

    public SdkClickHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.init(iActivityHandler, bl, iActivityPackageSender);
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getSdkClickBackoffStrategy();
        this.scheduler = new SingleThreadCachedScheduler(SCHEDULED_EXECUTOR_SOURCE);
    }

    private void sendNextSdkClick() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                SdkClickHandler.this.sendNextSdkClickI();
            }
        });
    }

    private void sendNextSdkClickI() {
        Runnable runnable;
        Object object = (IActivityHandler)((SdkClickHandler)((Object)string)).activityHandlerWeakRef.get();
        if (object.getActivityState() == null) {
            return;
        }
        if (object.getActivityState().isGdprForgotten) {
            return;
        }
        if (((SdkClickHandler)((Object)string)).paused) {
            return;
        }
        if (((SdkClickHandler)((Object)string)).packageQueue.isEmpty()) {
            return;
        }
        object = ((SdkClickHandler)((Object)string)).packageQueue.remove(0);
        int n2 = object.getRetries();
        Runnable runnable2 = runnable;
        runnable = new Runnable(){
            public final /* synthetic */ ActivityPackage a;
            {
                this.a = activityPackage;
            }

            @Override
            public final void run() {
                e e2 = this;
                e2.SdkClickHandler.this.sendSdkClickI(this.a);
                e2.SdkClickHandler.this.sendNextSdkClick();
            }
        };
        if (n2 <= 0) {
            runnable2.run();
            return;
        }
        SdkClickHandler sdkClickHandler = string;
        long l2 = Util.getWaitingTime(n2, ((SdkClickHandler)((Object)string)).backoffStrategy);
        double d2 = (double)l2 / 1000.0;
        String string = Util.SecondsDisplayFormat.format(d2);
        Object[] objectArray = new Object[2];
        object = objectArray;
        object[0] = string;
        objectArray[1] = n2;
        sdkClickHandler.logger.verbose("Waiting for %s seconds before retrying sdk_click for the %d time", object);
        sdkClickHandler.scheduler.schedule(runnable2, l2);
    }

    private void sendSdkClickI(ActivityPackage object) {
        IActivityHandler iActivityHandler = (IActivityHandler)((SdkClickHandler)this).activityHandlerWeakRef.get();
        String string = ((ActivityPackage)object).getParameters().get("source");
        boolean bl = string != null && string.equals(SOURCE_REFTAG);
        String string2 = ((ActivityPackage)object).getParameters().get("raw_referrer");
        if (bl && SharedPreferencesManager.getDefaultInstance(iActivityHandler.getContext()).getRawReferrer(string2, ((ActivityPackage)object).getClickTimeInMilliseconds()) == null) {
            return;
        }
        boolean bl2 = string != null && string.equals(SOURCE_INSTALL_REFERRER);
        long l2 = -1L;
        long l3 = -1L;
        String string3 = null;
        long l4 = -1L;
        long l5 = -1L;
        String string4 = null;
        Boolean bl3 = null;
        Boolean bl4 = null;
        String string5 = null;
        if (bl2) {
            ActivityPackage activityPackage = object;
            l2 = activityPackage.getClickTimeInSeconds();
            l3 = activityPackage.getInstallBeginTimeInSeconds();
            string3 = activityPackage.getParameters().get("referrer");
            l4 = activityPackage.getClickTimeServerInSeconds();
            l5 = activityPackage.getInstallBeginTimeServerInSeconds();
            string4 = activityPackage.getInstallVersion();
            bl3 = activityPackage.getGooglePlayInstant();
            bl4 = activityPackage.getIsClick();
            string5 = activityPackage.getParameters().get("referrer_api");
        }
        boolean bl5 = string != null && string.equals("preinstall");
        SdkClickHandler sdkClickHandler = this;
        Object object2 = sdkClickHandler.generateSendingParametersI();
        if (!((object2 = sdkClickHandler.activityPackageSender.sendActivityPackageSync((ActivityPackage)object, (Map<String, String>)object2)) instanceof SdkClickResponseData)) {
            return;
        }
        object2 = (SdkClickResponseData)object2;
        if (((ResponseData)object2).willRetry) {
            ((SdkClickHandler)this).retrySendingI((ActivityPackage)object);
            return;
        }
        if (iActivityHandler == null) {
            return;
        }
        if (((ResponseData)object2).trackingState == TrackingState.OPTED_OUT) {
            iActivityHandler.gotOptOutResponse();
            return;
        }
        if (bl) {
            SharedPreferencesManager.getDefaultInstance(iActivityHandler.getContext()).removeRawReferrer(string2, ((ActivityPackage)object).getClickTimeInMilliseconds());
        }
        if (bl2) {
            Object object3 = object2;
            ((SdkClickResponseData)object3).clickTime = l2;
            ((SdkClickResponseData)object3).installBegin = l3;
            ((SdkClickResponseData)object3).installReferrer = string3;
            ((SdkClickResponseData)object3).clickTimeServer = l4;
            ((SdkClickResponseData)object3).installBeginServer = l5;
            ((SdkClickResponseData)object3).installVersion = string4;
            ((SdkClickResponseData)object3).googlePlayInstant = bl3;
            ((SdkClickResponseData)object3).isClick = bl4;
            ((SdkClickResponseData)object3).referrerApi = string5;
            ((SdkClickResponseData)object3).isInstallReferrer = true;
        }
        if (bl5 && (this = ((ActivityPackage)object).getParameters().get("found_location")) != null && !((String)this).isEmpty()) {
            object = SharedPreferencesManager.getDefaultInstance(iActivityHandler.getContext());
            if ("system_installer_referrer".equalsIgnoreCase((String)this)) {
                ((SharedPreferencesManager)object).removePreinstallReferrer();
            } else {
                ((SharedPreferencesManager)object).setPreinstallPayloadReadStatus(PreinstallUtil.markAsRead((String)this, ((SharedPreferencesManager)object).getPreinstallPayloadReadStatus()));
            }
        }
        iActivityHandler.finishedTrackingActivity((ResponseData)object2);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> hashMap;
        SdkClickHandler sdkClickHandler = hashMap2;
        HashMap<String, String> hashMap2 = hashMap;
        long l2 = System.currentTimeMillis();
        PackageBuilder.addString(new HashMap<String, String>(), "sent_at", Util.dateFormatter.format(l2));
        int n2 = sdkClickHandler.packageQueue.size() - 1;
        if (n2 > 0) {
            long l3 = n2;
            PackageBuilder.addLong((Map<String, String>)hashMap2, "queue_size", l3);
        }
        return hashMap2;
    }

    private void retrySendingI(ActivityPackage objectArray) {
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.increaseRetries();
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = n2;
        this.logger.error("Retrying sdk_click package for the %d time", objectArray);
        this.sendSdkClick((ActivityPackage)objectArray2);
    }

    private void logErrorMessageI(ActivityPackage object, String objectArray, Throwable throwable) {
        SdkClickHandler sdkClickHandler = object2;
        Object object2 = ((ActivityPackage)object).getFailureMessage();
        object = Util.getReasonString((String)objectArray, throwable);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = object2;
        objectArray2[1] = object;
        object2 = Util.formatString("%s. (%s)", objectArray);
        sdkClickHandler.logger.error((String)object2, new Object[0]);
    }

    @Override
    public void init(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        SdkClickHandler sdkClickHandler = this;
        sdkClickHandler.paused = bl ^ true;
        sdkClickHandler.packageQueue = new ArrayList<ActivityPackage>();
        sdkClickHandler.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        this.activityPackageSender = iActivityPackageSender;
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextSdkClick();
    }

    @Override
    public void sendSdkClick(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                a a2 = this;
                a2.SdkClickHandler.this.packageQueue.add(activityPackage);
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = SdkClickHandler.this.packageQueue.size();
                a2.SdkClickHandler.this.logger.debug("Added sdk_click %d", objectArray2);
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = activityPackage.getExtendedString();
                a2.SdkClickHandler.this.logger.verbose("%s", objectArray2);
                a2.SdkClickHandler.this.sendNextSdkClick();
            }
        });
    }

    @Override
    public void sendReftagReferrers() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                block17: {
                    IActivityHandler iActivityHandler = (IActivityHandler)objectArray2.SdkClickHandler.this.activityHandlerWeakRef.get();
                    SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(iActivityHandler.getContext());
                    JSONArray jSONArray = sharedPreferencesManager.getRawReferrerArray();
                    boolean bl = false;
                    int n2 = 0;
                    while (true) {
                        block16: {
                            if (n2 >= jSONArray.length()) break;
                            Object object = jSONArray.getJSONArray(n2);
                            if (object.optInt(2, -1) != 0) break block16;
                            Object[] objectArray = objectArray2;
                            String string = object.optString(0, null);
                            IActivityHandler iActivityHandler2 = iActivityHandler;
                            IActivityHandler iActivityHandler3 = iActivityHandler2;
                            IActivityHandler iActivityHandler4 = iActivityHandler2;
                            IActivityHandler iActivityHandler5 = iActivityHandler2;
                            IActivityHandler iActivityHandler6 = iActivityHandler2;
                            IActivityHandler iActivityHandler7 = iActivityHandler2;
                            JSONArray jSONArray2 = object;
                            JSONArray jSONArray3 = jSONArray2;
                            long l2 = jSONArray2.optLong(1, -1L);
                            jSONArray3.put(2, 1);
                            bl = true;
                            ActivityState activityState = iActivityHandler4.getActivityState();
                            AdjustConfig adjustConfig = iActivityHandler5.getAdjustConfig();
                            DeviceInfo deviceInfo = iActivityHandler6.getDeviceInfo();
                            SessionParameters sessionParameters = iActivityHandler7.getSessionParameters();
                            ActivityHandler.InternalState internalState = iActivityHandler3.getInternalState();
                            object = PackageFactory.buildReftagSdkClickPackage(string, l2, activityState, adjustConfig, deviceInfo, sessionParameters, internalState);
                            objectArray.SdkClickHandler.this.sendSdkClick((ActivityPackage)object);
                        }
                        ++n2;
                    }
                    if (!bl) break block17;
                    try {
                        sharedPreferencesManager.saveRawReferrerArray(jSONArray);
                    }
                    catch (JSONException jSONException) {
                        Object[] objectArray = new Object[1];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = jSONException.getMessage();
                        objectArray2.SdkClickHandler.this.logger.error("Send saved raw referrers error (%s)", objectArray2);
                    }
                }
            }
        });
    }

    @Override
    public void sendPreinstallPayload(final String string, final String string2) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                Object object = (IActivityHandler)object2.SdkClickHandler.this.activityHandlerWeakRef.get();
                if (object == null) {
                    return;
                }
                c c2 = object2;
                IActivityHandler iActivityHandler = object;
                Object object2 = object2.string2;
                object = iActivityHandler.getActivityState();
                AdjustConfig adjustConfig = iActivityHandler.getAdjustConfig();
                DeviceInfo deviceInfo = iActivityHandler.getDeviceInfo();
                SessionParameters sessionParameters = iActivityHandler.getSessionParameters();
                object2 = PackageFactory.buildPreinstallSdkClickPackage(c2.string, (String)object2, (ActivityState)object, adjustConfig, deviceInfo, sessionParameters);
                c2.SdkClickHandler.this.sendSdkClick((ActivityPackage)object2);
            }
        });
    }

    @Override
    public void teardown() {
        SdkClickHandler sdkClickHandler = this;
        sdkClickHandler.logger.verbose("SdkClickHandler teardown", new Object[0]);
        WeakReference<IActivityHandler> weakReference = sdkClickHandler.scheduler;
        if (weakReference != null) {
            weakReference.teardown();
        }
        if ((weakReference = this.packageQueue) != null) {
            weakReference.clear();
        }
        if ((weakReference = this.activityHandlerWeakRef) != null) {
            weakReference.clear();
        }
        SdkClickHandler sdkClickHandler2 = this;
        sdkClickHandler2.logger = null;
        sdkClickHandler2.packageQueue = null;
        sdkClickHandler2.backoffStrategy = null;
        sdkClickHandler2.scheduler = null;
    }
}

