/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPurchaseVerificationHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.PurchaseVerificationResponseData;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PurchaseVerificationHandler
implements IPurchaseVerificationHandler {
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static final String SCHEDULED_EXECUTOR_SOURCE = "PurchaseVerificationHandler";
    private boolean paused;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private List<ActivityPackage> packageQueue;
    private ThreadScheduler scheduler;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private IActivityPackageSender activityPackageSender;

    public PurchaseVerificationHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.init(iActivityHandler, bl, iActivityPackageSender);
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getSdkClickBackoffStrategy();
        this.scheduler = new SingleThreadCachedScheduler(SCHEDULED_EXECUTOR_SOURCE);
    }

    private void sendNextPurchaseVerificationPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackageI();
            }
        });
    }

    private void sendNextPurchaseVerificationPackageI() {
        Runnable runnable;
        Object object = (IActivityHandler)((PurchaseVerificationHandler)((Object)string)).activityHandlerWeakRef.get();
        if (object.getActivityState() == null) {
            return;
        }
        if (object.getActivityState().isGdprForgotten) {
            return;
        }
        if (((PurchaseVerificationHandler)((Object)string)).paused) {
            return;
        }
        if (((PurchaseVerificationHandler)((Object)string)).packageQueue.isEmpty()) {
            return;
        }
        object = ((PurchaseVerificationHandler)((Object)string)).packageQueue.remove(0);
        int n2 = object.getRetries();
        Runnable runnable2 = runnable;
        runnable = new Runnable(){
            public final /* synthetic */ ActivityPackage a;
            {
                this.a = activityPackage;
            }

            @Override
            public final void run() {
                c c2 = this;
                c2.PurchaseVerificationHandler.this.sendPurchaseVerificationPackageI(this.a);
                c2.PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackage();
            }
        };
        if (n2 <= 0) {
            runnable2.run();
            return;
        }
        PurchaseVerificationHandler purchaseVerificationHandler = string;
        long l2 = Util.getWaitingTime(n2, ((PurchaseVerificationHandler)((Object)string)).backoffStrategy);
        double d2 = (double)l2 / 1000.0;
        String string = Util.SecondsDisplayFormat.format(d2);
        Object[] objectArray = new Object[2];
        object = objectArray;
        object[0] = string;
        objectArray[1] = n2;
        purchaseVerificationHandler.logger.verbose("Waiting for %s seconds before retrying purchase_verification for the %d time", object);
        purchaseVerificationHandler.scheduler.schedule(runnable2, l2);
    }

    private void sendPurchaseVerificationPackageI(ActivityPackage activityPackage) {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        IActivityHandler iActivityHandler = (IActivityHandler)purchaseVerificationHandler.activityHandlerWeakRef.get();
        Object object = purchaseVerificationHandler.generateSendingParametersI();
        if (!((object = purchaseVerificationHandler.activityPackageSender.sendActivityPackageSync(activityPackage, (Map<String, String>)object)) instanceof PurchaseVerificationResponseData)) {
            return;
        }
        object = (PurchaseVerificationResponseData)object;
        if (((ResponseData)object).willRetry) {
            this.retrySendingI(activityPackage);
            return;
        }
        if (iActivityHandler == null) {
            return;
        }
        if (((ResponseData)object).trackingState == TrackingState.OPTED_OUT) {
            iActivityHandler.gotOptOutResponse();
            return;
        }
        iActivityHandler.finishedTrackingActivity((ResponseData)object);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> hashMap;
        PurchaseVerificationHandler purchaseVerificationHandler = hashMap2;
        HashMap<String, String> hashMap2 = hashMap;
        long l2 = System.currentTimeMillis();
        PackageBuilder.addString(new HashMap<String, String>(), "sent_at", Util.dateFormatter.format(l2));
        int n2 = purchaseVerificationHandler.packageQueue.size() - 1;
        if (n2 > 0) {
            long l3 = n2;
            PackageBuilder.addLong((Map<String, String>)hashMap2, "queue_size", l3);
        }
        return hashMap2;
    }

    private void retrySendingI(ActivityPackage objectArray) {
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.increaseRetries();
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = n2;
        this.logger.error("Retrying purchase_verification package for the %d time", objectArray);
        this.sendPurchaseVerificationPackage((ActivityPackage)objectArray2);
    }

    @Override
    public void init(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        purchaseVerificationHandler.paused = bl ^ true;
        purchaseVerificationHandler.packageQueue = new ArrayList<ActivityPackage>();
        purchaseVerificationHandler.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        this.activityPackageSender = iActivityPackageSender;
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextPurchaseVerificationPackage();
    }

    @Override
    public void sendPurchaseVerificationPackage(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                a a2 = this;
                a2.PurchaseVerificationHandler.this.packageQueue.add(activityPackage);
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = PurchaseVerificationHandler.this.packageQueue.size();
                a2.PurchaseVerificationHandler.this.logger.debug("Added purchase_verification %d", objectArray2);
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = activityPackage.getExtendedString();
                a2.PurchaseVerificationHandler.this.logger.verbose("%s", objectArray2);
                a2.PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackage();
            }
        });
    }

    @Override
    public void teardown() {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        purchaseVerificationHandler.logger.verbose("PurchaseVerificationHandler teardown", new Object[0]);
        WeakReference<IActivityHandler> weakReference = purchaseVerificationHandler.scheduler;
        if (weakReference != null) {
            weakReference.teardown();
        }
        if ((weakReference = this.packageQueue) != null) {
            weakReference.clear();
        }
        if ((weakReference = this.activityHandlerWeakRef) != null) {
            weakReference.clear();
        }
        PurchaseVerificationHandler purchaseVerificationHandler2 = this;
        purchaseVerificationHandler2.logger = null;
        purchaseVerificationHandler2.packageQueue = null;
        purchaseVerificationHandler2.backoffStrategy = null;
        purchaseVerificationHandler2.scheduler = null;
    }
}

