/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustInstance;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.LogLevel;
import com.adjust.sdk.OnAttributionChangedListener;
import com.adjust.sdk.OnDeeplinkResolvedListener;
import com.adjust.sdk.OnDeeplinkResponseListener;
import com.adjust.sdk.OnEventTrackingFailedListener;
import com.adjust.sdk.OnEventTrackingSucceededListener;
import com.adjust.sdk.OnSessionTrackingFailedListener;
import com.adjust.sdk.OnSessionTrackingSucceededListener;
import com.adjust.sdk.Util;

public class AdjustConfig {
    public static final String ENVIRONMENT_SANDBOX = "sandbox";
    public static final String ENVIRONMENT_PRODUCTION = "production";
    public static final String URL_STRATEGY_INDIA = "url_strategy_india";
    public static final String URL_STRATEGY_CHINA = "url_strategy_china";
    public static final String URL_STRATEGY_CN = "url_strategy_cn";
    public static final String URL_STRATEGY_CN_ONLY = "url_strategy_cn_only";
    public static final String DATA_RESIDENCY_EU = "data_residency_eu";
    public static final String DATA_RESIDENCY_TR = "data_residency_tr";
    public static final String DATA_RESIDENCY_US = "data_residency_us";
    public static final String AD_REVENUE_APPLOVIN_MAX = "applovin_max_sdk";
    public static final String AD_REVENUE_MOPUB = "mopub";
    public static final String AD_REVENUE_ADMOB = "admob_sdk";
    public static final String AD_REVENUE_IRONSOURCE = "ironsource_sdk";
    public static final String AD_REVENUE_ADMOST = "admost_sdk";
    public static final String AD_REVENUE_UNITY = "unity_sdk";
    public static final String AD_REVENUE_HELIUM_CHARTBOOST = "helium_chartboost_sdk";
    public static final String AD_REVENUE_SOURCE_PUBLISHER = "publisher_sdk";
    public static final String AD_REVENUE_TOPON = "topon_sdk";
    public static final String AD_REVENUE_ADX = "adx_sdk";
    String basePath;
    String gdprPath;
    String subscriptionPath;
    String purchaseVerificationPath;
    Context context;
    String appToken;
    String environment;
    String processName;
    String sdkPrefix;
    boolean eventBufferingEnabled;
    String defaultTracker;
    OnAttributionChangedListener onAttributionChangedListener;
    Boolean deviceKnown;
    Class deepLinkComponent;
    OnEventTrackingSucceededListener onEventTrackingSucceededListener;
    OnEventTrackingFailedListener onEventTrackingFailedListener;
    OnSessionTrackingSucceededListener onSessionTrackingSucceededListener;
    OnSessionTrackingFailedListener onSessionTrackingFailedListener;
    OnDeeplinkResponseListener onDeeplinkResponseListener;
    boolean sendInBackground;
    Double delayStart;
    AdjustInstance.PreLaunchActions preLaunchActions;
    ILogger logger;
    String userAgent;
    String pushToken;
    Boolean startEnabled;
    boolean startOffline;
    String secretId;
    String appSecret;
    String externalDeviceId;
    boolean preinstallTrackingEnabled;
    Boolean needsCost;
    String urlStrategy;
    String preinstallFilePath;
    boolean playStoreKidsAppEnabled;
    boolean coppaCompliantEnabled;
    boolean finalAttributionEnabled;
    String fbAppId;
    boolean readDeviceInfoOnceEnabled;
    OnDeeplinkResolvedListener cachedDeeplinkResolutionCallback;

    public AdjustConfig(Context context, String string, String string2) {
        AdjustConfig adjustConfig = this;
        adjustConfig.init(context, string, string2, false);
    }

    public AdjustConfig(Context context, String string, String string2, boolean bl) {
        AdjustConfig adjustConfig = this;
        adjustConfig.init(context, string, string2, bl);
    }

    private void init(Context context, String string, String string2, boolean bl) {
        this.logger = AdjustFactory.getLogger();
        if (bl && ENVIRONMENT_PRODUCTION.equals(string2)) {
            this.setLogLevel(LogLevel.SUPRESS, string2);
        } else {
            this.setLogLevel(LogLevel.INFO, string2);
        }
        if (context != null) {
            context = context.getApplicationContext();
        }
        AdjustConfig adjustConfig = this;
        adjustConfig.context = context;
        adjustConfig.appToken = string;
        adjustConfig.environment = string2;
        adjustConfig.eventBufferingEnabled = false;
        adjustConfig.sendInBackground = false;
        adjustConfig.preinstallTrackingEnabled = false;
    }

    private void setLogLevel(LogLevel logLevel, String string) {
        this.logger.setLogLevel(logLevel, ENVIRONMENT_PRODUCTION.equals(string));
    }

    private boolean checkContext(Context context) {
        if (context == null) {
            this.logger.error("Missing context", new Object[0]);
            return false;
        }
        if (!Util.checkPermission(context, "android.permission.INTERNET")) {
            this.logger.error("Missing permission: INTERNET", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkAppToken(String string) {
        if (string == null) {
            objectArray2.logger.error("Missing App Token", new Object[0]);
            return false;
        }
        if (string.length() != 12) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray2.logger.error("Malformed App Token '%s'", objectArray2);
            return false;
        }
        return true;
    }

    private boolean checkEnvironment(String string) {
        if (string == null) {
            objectArray2.logger.error("Missing environment", new Object[0]);
            return false;
        }
        if (string.equals(ENVIRONMENT_SANDBOX)) {
            objectArray2.logger.warnInProduction("SANDBOX: Adjust is running in Sandbox mode. Use this setting for testing. Don't forget to set the environment to `production` before publishing!", new Object[0]);
            return true;
        }
        if (string.equals(ENVIRONMENT_PRODUCTION)) {
            objectArray2.logger.warnInProduction("PRODUCTION: Adjust is running in Production mode. Use this setting only for the build that you want to publish. Set the environment to `sandbox` if you want to test your app!", new Object[0]);
            return true;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray2.logger.error("Unknown environment '%s'", objectArray2);
        return false;
    }

    public void setEventBufferingEnabled(Boolean bl) {
        if (bl == null) {
            this.eventBufferingEnabled = false;
            return;
        }
        this.eventBufferingEnabled = bl;
    }

    public void setSendInBackground(boolean bl) {
        this.sendInBackground = bl;
    }

    public void setLogLevel(LogLevel logLevel) {
        AdjustConfig adjustConfig = this;
        adjustConfig.setLogLevel(logLevel, adjustConfig.environment);
    }

    public void setSdkPrefix(String string) {
        this.sdkPrefix = string;
    }

    public void setProcessName(String string) {
        this.processName = string;
    }

    public void setDefaultTracker(String string) {
        this.defaultTracker = string;
    }

    public void setOnAttributionChangedListener(OnAttributionChangedListener onAttributionChangedListener) {
        this.onAttributionChangedListener = onAttributionChangedListener;
    }

    public void setDeviceKnown(boolean bl) {
        this.deviceKnown = bl;
    }

    public void setDeepLinkComponent(Class clazz) {
        this.deepLinkComponent = clazz;
    }

    public void setOnEventTrackingSucceededListener(OnEventTrackingSucceededListener onEventTrackingSucceededListener) {
        this.onEventTrackingSucceededListener = onEventTrackingSucceededListener;
    }

    public void setOnEventTrackingFailedListener(OnEventTrackingFailedListener onEventTrackingFailedListener) {
        this.onEventTrackingFailedListener = onEventTrackingFailedListener;
    }

    public void setOnSessionTrackingSucceededListener(OnSessionTrackingSucceededListener onSessionTrackingSucceededListener) {
        this.onSessionTrackingSucceededListener = onSessionTrackingSucceededListener;
    }

    public void setOnSessionTrackingFailedListener(OnSessionTrackingFailedListener onSessionTrackingFailedListener) {
        this.onSessionTrackingFailedListener = onSessionTrackingFailedListener;
    }

    public void setOnDeeplinkResponseListener(OnDeeplinkResponseListener onDeeplinkResponseListener) {
        this.onDeeplinkResponseListener = onDeeplinkResponseListener;
    }

    public void setDelayStart(double d2) {
        this.delayStart = d2;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public void setAppSecret(long l2, long l3, long l4, long l5, long l6) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = l2;
        objectArray2.secretId = Util.formatString("%d", objectArray2);
        Object[] objectArray3 = new Object[4];
        objectArray2 = objectArray3;
        objectArray2[0] = l3;
        objectArray2[1] = l4;
        objectArray2[2] = l5;
        objectArray3[3] = l6;
        objectArray2.appSecret = Util.formatString("%d%d%d%d", objectArray2);
    }

    @Deprecated
    public void setReadMobileEquipmentIdentity(boolean bl) {
        this.logger.warn("This method has been deprecated and shouldn't be used anymore", new Object[0]);
    }

    public void setExternalDeviceId(String string) {
        this.externalDeviceId = string;
    }

    public void setPreinstallTrackingEnabled(boolean bl) {
        this.preinstallTrackingEnabled = bl;
    }

    public void setPreinstallFilePath(String string) {
        this.preinstallFilePath = string;
    }

    public void setNeedsCost(boolean bl) {
        this.needsCost = bl;
    }

    public void setPlayStoreKidsAppEnabled(boolean bl) {
        this.playStoreKidsAppEnabled = bl;
    }

    public void setCoppaCompliantEnabled(boolean bl) {
        this.coppaCompliantEnabled = bl;
    }

    public void setFinalAttributionEnabled(boolean bl) {
        this.finalAttributionEnabled = bl;
    }

    public void setFbAppId(String string) {
        this.fbAppId = string;
    }

    public boolean isValid() {
        AdjustConfig adjustConfig = this;
        if (!adjustConfig.checkAppToken(adjustConfig.appToken)) {
            return false;
        }
        AdjustConfig adjustConfig2 = this;
        if (!adjustConfig2.checkEnvironment(adjustConfig2.environment)) {
            return false;
        }
        AdjustConfig adjustConfig3 = this;
        return adjustConfig3.checkContext(adjustConfig3.context);
    }

    public void setUrlStrategy(String string) {
        if (string != null && !string.isEmpty()) {
            if (!(string.equals(URL_STRATEGY_INDIA) || string.equals(URL_STRATEGY_CHINA) || string.equals(URL_STRATEGY_CN) || string.equals(URL_STRATEGY_CN_ONLY) || string.equals(DATA_RESIDENCY_EU) || string.equals(DATA_RESIDENCY_TR) || string.equals(DATA_RESIDENCY_US))) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                this.logger.warn("Unrecognised url strategy %s", objectArray2);
            }
            this.urlStrategy = string;
            return;
        }
        this.logger.error("Invalid url strategy", new Object[0]);
    }

    public void setReadDeviceInfoOnceEnabled(boolean bl) {
        this.readDeviceInfoOnceEnabled = bl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getGdprPath() {
        return this.gdprPath;
    }

    public String getSubscriptionPath() {
        return this.subscriptionPath;
    }

    public String getPurchaseVerificationPath() {
        return this.purchaseVerificationPath;
    }

    public Context getContext() {
        return this.context;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getSdkPrefix() {
        return this.sdkPrefix;
    }

    public boolean isEventBufferingEnabled() {
        return this.eventBufferingEnabled;
    }

    public String getDefaultTracker() {
        return this.defaultTracker;
    }

    public OnAttributionChangedListener getOnAttributionChangedListener() {
        return this.onAttributionChangedListener;
    }

    public Boolean getDeviceKnown() {
        return this.deviceKnown;
    }

    public Class getDeepLinkComponent() {
        return this.deepLinkComponent;
    }

    public OnEventTrackingSucceededListener getOnEventTrackingSucceededListener() {
        return this.onEventTrackingSucceededListener;
    }

    public OnEventTrackingFailedListener getOnEventTrackingFailedListener() {
        return this.onEventTrackingFailedListener;
    }

    public OnSessionTrackingSucceededListener getOnSessionTrackingSucceededListener() {
        return this.onSessionTrackingSucceededListener;
    }

    public OnSessionTrackingFailedListener getOnSessionTrackingFailedListener() {
        return this.onSessionTrackingFailedListener;
    }

    public OnDeeplinkResponseListener getOnDeeplinkResponseListener() {
        return this.onDeeplinkResponseListener;
    }

    public boolean isSendInBackground() {
        return this.sendInBackground;
    }

    public Double getDelayStart() {
        return this.delayStart;
    }

    public AdjustInstance.PreLaunchActions getPreLaunchActions() {
        return this.preLaunchActions;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getPushToken() {
        return this.pushToken;
    }

    public Boolean getStartEnabled() {
        return this.startEnabled;
    }

    public boolean isStartOffline() {
        return this.startOffline;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getExternalDeviceId() {
        return this.externalDeviceId;
    }

    public boolean isPreinstallTrackingEnabled() {
        return this.preinstallTrackingEnabled;
    }

    public Boolean getNeedsCost() {
        return this.needsCost;
    }

    public String getUrlStrategy() {
        return this.urlStrategy;
    }

    public String getPreinstallFilePath() {
        return this.preinstallFilePath;
    }

    public boolean isPlayStoreKidsAppEnabled() {
        return this.playStoreKidsAppEnabled;
    }

    public boolean isCoppaCompliantEnabled() {
        return this.coppaCompliantEnabled;
    }

    public boolean isFinalAttributionEnabled() {
        return this.finalAttributionEnabled;
    }

    public String getFbAppId() {
        return this.fbAppId;
    }

    public boolean isReadDeviceInfoOnceEnabled() {
        return this.readDeviceInfoOnceEnabled;
    }
}

