/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustSigner;
import com.adjust.sdk.AttributionHandler;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IPurchaseVerificationHandler;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.Logger;
import com.adjust.sdk.PackageHandler;
import com.adjust.sdk.PurchaseVerificationHandler;
import com.adjust.sdk.SdkClickHandler;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.network.UtilNetworking;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class AdjustFactory {
    private static IPackageHandler packageHandler;
    private static IAttributionHandler attributionHandler;
    private static IActivityHandler activityHandler;
    private static ILogger logger;
    private static ISdkClickHandler sdkClickHandler;
    private static IPurchaseVerificationHandler purchaseVerificationHandler;
    private static long timerInterval = -1L;
    private static long timerStart = -1L;
    private static long sessionInterval = -1L;
    private static long subsessionInterval = -1L;
    private static BackoffStrategy sdkClickBackoffStrategy;
    private static BackoffStrategy packageHandlerBackoffStrategy;
    private static BackoffStrategy installSessionBackoffStrategy;
    private static long maxDelayStart = -1L;
    private static String baseUrl;
    private static String gdprUrl;
    private static String subscriptionUrl;
    private static String purchaseVerificationUrl;
    private static UtilNetworking.IConnectionOptions connectionOptions;
    private static UtilNetworking.IHttpsURLConnectionProvider httpsURLConnectionProvider;
    private static boolean tryInstallReferrer = true;

    public static IPackageHandler getPackageHandler(IActivityHandler iActivityHandler, Context context, boolean bl, IActivityPackageSender iActivityPackageSender) {
        IPackageHandler iPackageHandler = packageHandler;
        if (iPackageHandler == null) {
            return new PackageHandler(iActivityHandler, context, bl, iActivityPackageSender);
        }
        iPackageHandler.init(iActivityHandler, context, bl, iActivityPackageSender);
        return packageHandler;
    }

    public static ILogger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    public static long getTimerInterval() {
        long l2 = timerInterval;
        if (l2 == -1L) {
            return 60000L;
        }
        return l2;
    }

    public static long getTimerStart() {
        long l2 = timerStart;
        if (l2 == -1L) {
            return 60000L;
        }
        return l2;
    }

    public static long getSessionInterval() {
        long l2 = sessionInterval;
        if (l2 == -1L) {
            return 1800000L;
        }
        return l2;
    }

    public static long getSubsessionInterval() {
        long l2 = subsessionInterval;
        if (l2 == -1L) {
            return 1000L;
        }
        return l2;
    }

    public static BackoffStrategy getSdkClickBackoffStrategy() {
        BackoffStrategy backoffStrategy = sdkClickBackoffStrategy;
        if (backoffStrategy == null) {
            return BackoffStrategy.SHORT_WAIT;
        }
        return backoffStrategy;
    }

    public static BackoffStrategy getPackageHandlerBackoffStrategy() {
        BackoffStrategy backoffStrategy = packageHandlerBackoffStrategy;
        if (backoffStrategy == null) {
            return BackoffStrategy.LONG_WAIT;
        }
        return backoffStrategy;
    }

    public static BackoffStrategy getInstallSessionBackoffStrategy() {
        BackoffStrategy backoffStrategy = installSessionBackoffStrategy;
        if (backoffStrategy == null) {
            return BackoffStrategy.SHORT_WAIT;
        }
        return backoffStrategy;
    }

    public static IActivityHandler getActivityHandler(AdjustConfig adjustConfig) {
        IActivityHandler iActivityHandler = activityHandler;
        if (iActivityHandler == null) {
            return ActivityHandler.getInstance(adjustConfig);
        }
        iActivityHandler.init(adjustConfig);
        return activityHandler;
    }

    public static IAttributionHandler getAttributionHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        IAttributionHandler iAttributionHandler = attributionHandler;
        if (iAttributionHandler == null) {
            return new AttributionHandler(iActivityHandler, bl, iActivityPackageSender);
        }
        iAttributionHandler.init(iActivityHandler, bl, iActivityPackageSender);
        return attributionHandler;
    }

    public static ISdkClickHandler getSdkClickHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        ISdkClickHandler iSdkClickHandler = sdkClickHandler;
        if (iSdkClickHandler == null) {
            return new SdkClickHandler(iActivityHandler, bl, iActivityPackageSender);
        }
        iSdkClickHandler.init(iActivityHandler, bl, iActivityPackageSender);
        return sdkClickHandler;
    }

    public static IPurchaseVerificationHandler getPurchaseVerificationHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        IPurchaseVerificationHandler iPurchaseVerificationHandler = purchaseVerificationHandler;
        if (iPurchaseVerificationHandler == null) {
            return new PurchaseVerificationHandler(iActivityHandler, bl, iActivityPackageSender);
        }
        iPurchaseVerificationHandler.init(iActivityHandler, bl, iActivityPackageSender);
        return purchaseVerificationHandler;
    }

    public static long getMaxDelayStart() {
        long l2 = maxDelayStart;
        if (l2 == -1L) {
            return 10000L;
        }
        return l2;
    }

    public static String getBaseUrl() {
        return baseUrl;
    }

    public static String getGdprUrl() {
        return gdprUrl;
    }

    public static String getSubscriptionUrl() {
        return subscriptionUrl;
    }

    public static String getPurchaseVerificationUrl() {
        return purchaseVerificationUrl;
    }

    public static UtilNetworking.IConnectionOptions getConnectionOptions() {
        UtilNetworking.IConnectionOptions iConnectionOptions = connectionOptions;
        if (iConnectionOptions == null) {
            return UtilNetworking.createDefaultConnectionOptions();
        }
        return iConnectionOptions;
    }

    public static UtilNetworking.IHttpsURLConnectionProvider getHttpsURLConnectionProvider() {
        UtilNetworking.IHttpsURLConnectionProvider iHttpsURLConnectionProvider = httpsURLConnectionProvider;
        if (iHttpsURLConnectionProvider == null) {
            return UtilNetworking.createDefaultHttpsURLConnectionProvider();
        }
        return iHttpsURLConnectionProvider;
    }

    public static boolean getTryInstallReferrer() {
        return tryInstallReferrer;
    }

    public static void setPackageHandler(IPackageHandler iPackageHandler) {
        packageHandler = iPackageHandler;
    }

    public static void setLogger(ILogger iLogger) {
        logger = iLogger;
    }

    public static void setTimerInterval(long l2) {
        timerInterval = l2;
    }

    public static void setTimerStart(long l2) {
        timerStart = l2;
    }

    public static void setSessionInterval(long l2) {
        sessionInterval = l2;
    }

    public static void setSubsessionInterval(long l2) {
        subsessionInterval = l2;
    }

    public static void setSdkClickBackoffStrategy(BackoffStrategy backoffStrategy) {
        sdkClickBackoffStrategy = backoffStrategy;
    }

    public static void setPackageHandlerBackoffStrategy(BackoffStrategy backoffStrategy) {
        packageHandlerBackoffStrategy = backoffStrategy;
    }

    public static void setActivityHandler(IActivityHandler iActivityHandler) {
        activityHandler = iActivityHandler;
    }

    public static void setAttributionHandler(IAttributionHandler iAttributionHandler) {
        attributionHandler = iAttributionHandler;
    }

    public static void setSdkClickHandler(ISdkClickHandler iSdkClickHandler) {
        sdkClickHandler = iSdkClickHandler;
    }

    public static void setBaseUrl(String string) {
        baseUrl = string;
    }

    public static void setGdprUrl(String string) {
        gdprUrl = string;
    }

    public static void setSubscriptionUrl(String string) {
        subscriptionUrl = string;
    }

    public static void setPurchaseVerificationUrl(String string) {
        purchaseVerificationUrl = string;
    }

    public static void setConnectionOptions(UtilNetworking.IConnectionOptions iConnectionOptions) {
        connectionOptions = iConnectionOptions;
    }

    public static void setHttpsURLConnectionProvider(UtilNetworking.IHttpsURLConnectionProvider iHttpsURLConnectionProvider) {
        httpsURLConnectionProvider = iHttpsURLConnectionProvider;
    }

    public static void setTryInstallReferrer(boolean bl) {
        tryInstallReferrer = bl;
    }

    public static void enableSigning() {
        AdjustSigner.enableSigning(AdjustFactory.getLogger());
    }

    public static void disableSigning() {
        AdjustSigner.disableSigning(AdjustFactory.getLogger());
    }

    private static String byte2HexFormatted(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2]);
            int n2 = string.length();
            if (n2 == 1) {
                string = "0" + string;
            }
            if (n2 > 2) {
                string = string.substring(n2 - 2, n2);
            }
            stringBuilder2.append(string.toUpperCase());
        }
        return stringBuilder2.toString();
    }

    public static void teardown(Context context) {
        if (context != null) {
            Context context2 = context;
            ActivityHandler.deleteState(context2);
            PackageHandler.deleteState(context2);
        }
        packageHandler = null;
        attributionHandler = null;
        activityHandler = null;
        logger = null;
        sdkClickHandler = null;
        timerInterval = -1L;
        timerStart = -1L;
        sessionInterval = -1L;
        subsessionInterval = -1L;
        sdkClickBackoffStrategy = null;
        packageHandlerBackoffStrategy = null;
        maxDelayStart = -1L;
        baseUrl = "https://app.adjust.com";
        gdprUrl = "https://gdpr.adjust.com";
        subscriptionUrl = "https://subscription.adjust.com";
        purchaseVerificationUrl = "https://ssrv.adjust.com";
        connectionOptions = null;
        httpsURLConnectionProvider = null;
        tryInstallReferrer = true;
    }

    public static class URLGetConnection {
        public HttpsURLConnection httpsURLConnection;
        public URL url;

        public URLGetConnection(HttpsURLConnection httpsURLConnection, URL uRL) {
            this.httpsURLConnection = httpsURLConnection;
            this.url = uRL;
        }
    }
}

