/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import android.net.Uri;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.network.UrlStrategy;
import com.adjust.sdk.network.UtilNetworking;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityPackageSender
implements IActivityPackageSender {
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;
    private String purchaseVerificationPath;
    private String clientSdk;
    private ILogger logger;
    private ThreadExecutor executor;
    private UrlStrategy urlStrategy;
    private UtilNetworking.IHttpsURLConnectionProvider httpsURLConnectionProvider;
    private UtilNetworking.IConnectionOptions connectionOptions;

    public ActivityPackageSender(String string, String string2, String string3, String string4, String string5, String string6) {
        ActivityPackageSender activityPackageSender = this;
        this.basePath = string2;
        this.gdprPath = string3;
        this.subscriptionPath = string4;
        this.purchaseVerificationPath = string5;
        activityPackageSender.clientSdk = string6;
        activityPackageSender.logger = AdjustFactory.getLogger();
        activityPackageSender.executor = new SingleThreadCachedScheduler("ActivityPackageSender");
        activityPackageSender.urlStrategy = new UrlStrategy(AdjustFactory.getBaseUrl(), AdjustFactory.getGdprUrl(), AdjustFactory.getSubscriptionUrl(), AdjustFactory.getPurchaseVerificationUrl(), string);
        activityPackageSender.httpsURLConnectionProvider = AdjustFactory.getHttpsURLConnectionProvider();
        activityPackageSender.connectionOptions = AdjustFactory.getConnectionOptions();
    }

    private boolean shouldRetryToSend(ResponseData responseData) {
        if (!responseData.willRetry) {
            ActivityPackageSender activityPackageSender = this;
            activityPackageSender.logger.debug("Will not retry with current url strategy", new Object[0]);
            activityPackageSender.urlStrategy.resetAfterSuccess();
            return false;
        }
        if (this.urlStrategy.shouldRetryAfterFailure(responseData.activityKind)) {
            this.logger.error("Failed with current url strategy, but it will retry with new", new Object[0]);
            return true;
        }
        this.logger.error("Failed with current url strategy and it will not retry", new Object[0]);
        return false;
    }

    /*
     * Exception decompiling
     */
    private void tryToGetResponse(ResponseData var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void localError(Throwable throwable, String string, ResponseData responseData) {
        ResponseData responseData2 = responseData;
        String string2 = this.errorMessage(throwable, string, responseData.activityPackage);
        this.logger.error(string2, new Object[0]);
        responseData2.message = string2;
        responseData2.willRetry = false;
    }

    private void remoteError(Throwable throwable, String string, ResponseData responseData) {
        StringBuilder stringBuilder;
        ResponseData responseData2 = responseData;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        String string2 = stringBuilder.append(this.errorMessage(throwable, string, responseData.activityPackage)).append(" Will retry later").toString();
        this.logger.error(string2, new Object[0]);
        responseData2.message = string2;
        responseData2.willRetry = true;
    }

    private String errorMessage(Throwable object, String objectArray, ActivityPackage activityPackage) {
        String string = activityPackage.getFailureMessage();
        object = Util.getReasonString((String)objectArray, (Throwable)object);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = object;
        return Util.formatString("%s. (%s)", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private String generateUrlStringForGET(ActivityKind object, String object22, Map<String, String> map, Map<String, String> map2) {
        void var4_8;
        void var3_7;
        Uri.Builder builder;
        URL uRL;
        Object object3;
        ActivityPackageSender activityPackageSender = object3;
        object3 = activityPackageSender.urlWithExtraPathByActivityKind((ActivityKind)((Object)object), ((ActivityPackageSender)object3).urlStrategy.targetUrlByActivityKind((ActivityKind)((Object)object)));
        object = uRL;
        uRL = new URL((String)object3);
        object3 = builder;
        object3();
        object3.scheme(((URL)object).getProtocol());
        object3.encodedAuthority(((URL)object).getAuthority());
        object3.path(((URL)object).getPath());
        builder.appendPath((String)object22);
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = object3.toString();
        activityPackageSender.logger.debug("Making request to url: %s", (Object[])object);
        for (Map.Entry entry : var3_7.entrySet()) {
            object3.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
        }
        if (var4_8 != null) {
            for (Map.Entry entry : var4_8.entrySet()) {
                object3.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return object3.build().toString();
    }

    private String generateUrlStringForPOST(ActivityKind object, String string) {
        object = objectArray4.urlWithExtraPathByActivityKind((ActivityKind)((Object)object), objectArray4.urlStrategy.targetUrlByActivityKind((ActivityKind)((Object)object)));
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = string;
        object = Util.formatString("%s%s", objectArray2);
        Object[] objectArray3 = new Object[1];
        Object[] objectArray4 = objectArray3;
        objectArray3[0] = object;
        objectArray4.logger.debug("Making request to url : %s", objectArray4);
        return object;
    }

    private String urlWithExtraPathByActivityKind(ActivityKind activityKind, String string) {
        if (activityKind == ActivityKind.GDPR) {
            if (this.gdprPath != null) {
                string = string + this.gdprPath;
            }
            return string;
        }
        if (activityKind == ActivityKind.SUBSCRIPTION) {
            if (this.subscriptionPath != null) {
                string = string + this.subscriptionPath;
            }
            return string;
        }
        if (activityKind == ActivityKind.PURCHASE_VERIFICATION) {
            if (this.purchaseVerificationPath != null) {
                string = string + this.purchaseVerificationPath;
            }
            return string;
        }
        if (this.basePath != null) {
            string = string + this.basePath;
        }
        return string;
    }

    private DataOutputStream configConnectionForGET(HttpsURLConnection httpsURLConnection) {
        httpsURLConnection.setRequestMethod("GET");
        return null;
    }

    private DataOutputStream configConnectionForPOST(HttpsURLConnection httpsURLConnection, Map<String, String> map, Map<String, String> map2) {
        HttpsURLConnection httpsURLConnection2 = httpsURLConnection;
        httpsURLConnection2.setRequestMethod("POST");
        httpsURLConnection2.setUseCaches(false);
        httpsURLConnection2.setDoInput(true);
        httpsURLConnection2.setDoOutput(true);
        String string = ((ActivityPackageSender)((Object)string)).generatePOSTBodyString(map, map2);
        if (string == null) {
            return null;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
        dataOutputStream.writeBytes(string);
        return dataOutputStream;
    }

    private String generatePOSTBodyString(Map<String, String> map, Map<String, String> map2) {
        StringBuilder stringBuilder;
        if (map.isEmpty()) {
            return null;
        }
        ActivityPackageSender activityPackageSender = stringBuilder2;
        ActivityPackageSender activityPackageSender2 = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        activityPackageSender2.injectParametersToPOSTStringBuilder(map, stringBuilder2);
        activityPackageSender.injectParametersToPOSTStringBuilder(map2, stringBuilder2);
        if (stringBuilder2.length() > 0) {
            StringBuilder stringBuilder3 = stringBuilder2;
            if (stringBuilder3.charAt(stringBuilder3.length() - 1) == '&') {
                Object object = stringBuilder2;
                ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
            }
        }
        return stringBuilder2.toString();
    }

    private void injectParametersToPOSTStringBuilder(Map<String, String> object, StringBuilder stringBuilder) {
        if (object != null && !object.isEmpty()) {
            for (Map.Entry entry : object.entrySet()) {
                object = URLEncoder.encode((String)entry.getKey(), "UTF-8");
                String string = (String)entry.getValue();
                string = string != null ? URLEncoder.encode(string, "UTF-8") : "";
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append((String)object);
                stringBuilder2.append("=");
                stringBuilder2.append(string);
                stringBuilder2.append("&");
            }
            return;
        }
    }

    private void parseResponse(ResponseData responseData, String string) {
        JSONObject jSONObject;
        if (string.length() == 0) {
            this.logger.error("Empty response string", new Object[0]);
            return;
        }
        JSONObject jSONObject2 = null;
        JSONObject jSONObject3 = jSONObject;
        try {
            jSONObject = new JSONObject(string);
            jSONObject2 = jSONObject3;
        }
        catch (JSONException jSONException) {
            ActivityPackageSender activityPackageSender = this;
            string = activityPackageSender.errorMessage(jSONException, "Failed to parse JSON response", responseData.activityPackage);
            activityPackageSender.logger.error(string, new Object[0]);
        }
        if (jSONObject2 == null) {
            return;
        }
        responseData.jsonResponse = jSONObject2;
        responseData.message = UtilNetworking.extractJsonString(jSONObject2, "message");
        responseData.adid = UtilNetworking.extractJsonString(jSONObject2, "adid");
        responseData.timestamp = UtilNetworking.extractJsonString(jSONObject2, "timestamp");
        string = UtilNetworking.extractJsonString(jSONObject2, "tracking_state");
        if (string != null && string.equals("opted_out")) {
            responseData.trackingState = TrackingState.OPTED_OUT;
        }
        responseData.askIn = UtilNetworking.extractJsonLong(jSONObject2, "ask_in");
        responseData.retryIn = UtilNetworking.extractJsonLong(jSONObject2, "retry_in");
        responseData.continueIn = UtilNetworking.extractJsonLong(jSONObject2, "continue_in");
        responseData.attribution = AdjustAttribution.fromJson(jSONObject2.optJSONObject("attribution"), responseData.adid, Util.getSdkPrefixPlatform(this.clientSdk));
    }

    private String buildAndExtractAuthorizationHeader(Map<String, String> map, ActivityKind object) {
        String string;
        String string2;
        Map<String, String> map2 = map;
        object = object.toString();
        String string3 = ActivityPackageSender.extractSecretId(map2);
        String string4 = ActivityPackageSender.extractHeadersId(map2);
        String string5 = ActivityPackageSender.extractSignature(map2);
        string4 = this.buildAuthorizationHeaderV2(string5, string3, string4, string2 = ActivityPackageSender.extractAlgorithm(map2), string = ActivityPackageSender.extractNativeVersion(map2));
        if (string4 != null) {
            return string4;
        }
        Map<String, String> map3 = map;
        return this.buildAuthorizationHeaderV1(map3, ActivityPackageSender.extractAppSecret(map3), string3, (String)object);
    }

    private String buildAuthorizationHeaderV1(Map<String, String> object, String string, String string2, String object2) {
        if (string != null && string.length() != 0) {
            Map<String, String> map = objectArray8.getSignature((Map<String, String>)object, (String)object2, string);
            object = Util.sha256(map.get("clear_signature"));
            string = map.get("fields");
            Object[] objectArray = new Object[1];
            object2 = objectArray;
            objectArray[0] = string2;
            string2 = Util.formatString("secret_id=\"%s\"", object2);
            Object[] objectArray2 = new Object[1];
            object2 = objectArray2;
            objectArray2[0] = object;
            object = Util.formatString("signature=\"%s\"", object2);
            Object[] objectArray3 = new Object[1];
            object2 = objectArray3;
            objectArray3[0] = "sha256";
            object2 = Util.formatString("algorithm=\"%s\"", object2);
            Object[] objectArray4 = new Object[1];
            Object[] objectArray5 = objectArray4;
            objectArray4[0] = string;
            string = Util.formatString("headers=\"%s\"", objectArray5);
            Object[] objectArray6 = new Object[4];
            objectArray5 = objectArray6;
            objectArray6[0] = string2;
            objectArray6[1] = object;
            objectArray6[2] = object2;
            objectArray6[3] = string;
            object = Util.formatString("Signature %s,%s,%s,%s", objectArray5);
            Object[] objectArray7 = new Object[1];
            Object[] objectArray8 = objectArray7;
            objectArray7[0] = object;
            objectArray8.logger.verbose("authorizationHeader: %s", objectArray8);
            return object;
        }
        return null;
    }

    private String buildAuthorizationHeaderV2(String string, String string2, String string3, String string4, String string5) {
        if (string2 != null && string != null && string3 != null) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            string = Util.formatString("signature=\"%s\"", objectArray2);
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = string2;
            string2 = Util.formatString("secret_id=\"%s\"", objectArray2);
            Object[] objectArray4 = new Object[1];
            objectArray2 = objectArray4;
            objectArray4[0] = string3;
            string3 = Util.formatString("headers_id=\"%s\"", objectArray2);
            objectArray2 = "algorithm=\"%s\"";
            Object[] objectArray5 = new Object[1];
            int n2 = 0;
            if (string4 == null) {
                string4 = "adj1";
            }
            objectArray5[n2] = string4;
            string4 = Util.formatString((String)objectArray2, objectArray5);
            objectArray2 = "native_version=\"%s\"";
            objectArray5 = new Object[1];
            n2 = 0;
            if (string5 == null) {
                string5 = "";
            }
            objectArray5[n2] = string5;
            string5 = Util.formatString((String)objectArray2, objectArray5);
            Object[] objectArray6 = new Object[5];
            objectArray2 = objectArray6;
            objectArray6[0] = string;
            objectArray6[1] = string2;
            objectArray6[2] = string4;
            objectArray6[3] = string3;
            objectArray6[4] = string5;
            string = Util.formatString("Signature %s,%s,%s,%s,%s", objectArray2);
            Object[] objectArray7 = new Object[1];
            Object[] objectArray8 = objectArray7;
            objectArray7[0] = string;
            objectArray8.logger.verbose("authorizationHeader: %s", objectArray8);
            return string;
        }
        return null;
    }

    private Map<String, String> getSignature(Map<String, String> object, String object2, String object32) {
        HashMap<Object, Object> hashMap;
        HashMap<Object, Object> hashMap2;
        Object object4;
        Object object3 = object;
        ActivityPackageSender activityPackageSender = object4;
        Object object5 = object;
        object4 = (String)object5.get("created_at");
        String string = activityPackageSender.getValidIdentifier((Map<String, String>)object5);
        String string2 = (String)object3.get(string);
        String string3 = "source";
        String string4 = (String)object3.get("source");
        Object object6 = object;
        object = "payload";
        String string5 = (String)object6.get("payload");
        HashMap<Object, Object> hashMap3 = hashMap2 = hashMap;
        hashMap3();
        hashMap3.put("app_secret", object32);
        hashMap3.put("created_at", object4);
        hashMap3.put("activity_kind", object2);
        hashMap.put(string, string2);
        if (string4 != null) {
            hashMap2.put(string3, string4);
        }
        if (string5 != null) {
            hashMap2.put(object, string5);
        }
        object4 = "";
        object = "";
        for (Map.Entry entry : hashMap2.entrySet()) {
            if (entry.getValue() == null) continue;
            object4 = (String)object4 + (String)entry.getKey() + " ";
            object = (String)object + (String)entry.getValue();
        }
        Object object7 = object4;
        object4 = ((String)object7).substring(0, ((String)object7).length() - 1);
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("clear_signature", (String)object);
        hashMap4.put("fields", (String)object4);
        return hashMap4;
    }

    private String getValidIdentifier(Map<String, String> map) {
        String string = "gps_adid";
        String string2 = "fire_adid";
        String string3 = "android_id";
        String string4 = "android_uuid";
        if (map.get("gps_adid") != null) {
            return string;
        }
        if (map.get(string2) != null) {
            return string2;
        }
        if (map.get(string3) != null) {
            return string3;
        }
        if (map.get(string4) != null) {
            return string4;
        }
        return null;
    }

    private static String extractAppSecret(Map<String, String> map) {
        return map.remove("app_secret");
    }

    private static String extractSecretId(Map<String, String> map) {
        return map.remove("secret_id");
    }

    private static String extractSignature(Map<String, String> map) {
        return map.remove("signature");
    }

    private static String extractAlgorithm(Map<String, String> map) {
        return map.remove("algorithm");
    }

    private static String extractNativeVersion(Map<String, String> map) {
        return map.remove("native_version");
    }

    private static String extractHeadersId(Map<String, String> map) {
        return map.remove("headers_id");
    }

    private static void extractEventCallbackId(Map<String, String> map) {
        map.remove("event_callback_id");
    }

    @Override
    public void sendActivityPackage(final ActivityPackage activityPackage, final Map<String, String> map, final IActivityPackageSender.ResponseDataCallbackSubscriber responseDataCallbackSubscriber) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                a a2 = activityPackage2;
                ActivityPackage activityPackage2 = a2.activityPackage;
                activityPackage2.responseDataCallbackSubscriber.onResponseDataCallback(activityPackage2.ActivityPackageSender.this.sendActivityPackageSync(activityPackage2, a2.map));
            }
        });
    }

    @Override
    public ResponseData sendActivityPackageSync(ActivityPackage activityPackage, Map<String, String> map) {
        ResponseData responseData;
        ActivityPackageSender activityPackageSender;
        do {
            activityPackageSender = this;
            responseData = ResponseData.buildResponseData(activityPackage, map);
            activityPackageSender.tryToGetResponse(responseData);
        } while (activityPackageSender.shouldRetryToSend(responseData));
        return responseData;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer readConnectionResponse(HttpsURLConnection var1_2, ResponseData var2_3) {
        block15: {
            block14: {
                v0 = var1_2;
                var3_4 = v1;
                v1 = new StringBuilder();
                var4_5 = null;
                v0.connect();
                var4_5 = v0.getResponseCode();
                var5_6 = var4_5 >= 400 ? var1_2.getErrorStream() : var1_2.getInputStream();
                var6_9 = v2;
                v2 = new InputStreamReader((InputStream)var5_6);
                var5_6 = v3;
                v3 = new BufferedReader((Reader)var6_9);
                ** while ((var6_9 = var5_6.readLine()) != null)
lbl-1000:
                // 1 sources

                {
                    var3_4.append((String)var6_9);
                    continue;
                }
lbl20:
                // 2 sources

                while (true) {
                    var1_2.disconnect();
                    break block14;
                    break;
                }
                {
                    catch (Throwable var0_1) {
                        break block15;
                    }
                    catch (IOException var5_7) {}
                    {
                        var5_8 = "Connecting and reading response";
                        var5_8 = this.errorMessage(var5_7, var5_8, var2_3.activityPackage);
                        this.logger.error(var5_8, new Object[0]);
                        if (var1_2 != null) ** continue;
                    }
                }
            }
            if (var3_4.length() == 0) {
                this.logger.error("Empty response string buffer", new Object[0]);
                return var4_5;
            }
            if (var4_5 == 429) {
                this.logger.error("Too frequent requests to the endpoint (429)", new Object[0]);
                return var4_5;
            }
            v4 = var2_3;
            v5 = var2_3;
            var1_2 = var3_4.toString();
            v6 = new Object[1];
            var2_3 = v6;
            v6[0] = var1_2;
            this.logger.debug("Response string: %s", var2_3);
            this.parseResponse((ResponseData)v5, (String)var1_2);
            var1_2 = v4.message;
            if (var1_2 == null) {
                return var4_5;
            }
            if (var4_5 == 200) {
                v7 = new Object[1];
                this = v7;
                v7[0] = var1_2;
                this.logger.info("Response message: %s", this);
                return var4_5;
            }
            v8 = new Object[1];
            this = v8;
            v8[0] = var1_2;
            this.logger.error("Response message: %s", this);
            return var4_5;
        }
        if (var1_2 == null) throw var0_1;
        var1_2.disconnect();
        throw var0_1;
    }
}

