/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class UtilNetworking {
    private static String userAgent;

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    public static void setUserAgent(String string) {
        userAgent = string;
    }

    public static IConnectionOptions createDefaultConnectionOptions() {
        return new IConnectionOptions(){

            @Override
            public final void applyConnectionOptions(HttpsURLConnection httpsURLConnection, String string) {
                HttpsURLConnection httpsURLConnection2 = httpsURLConnection;
                httpsURLConnection2.setRequestProperty("Client-SDK", string);
                httpsURLConnection2.setConnectTimeout(60000);
                httpsURLConnection2.setReadTimeout(60000);
                if (userAgent != null) {
                    httpsURLConnection.setRequestProperty("User-Agent", userAgent);
                }
            }
        };
    }

    public static IHttpsURLConnectionProvider createDefaultHttpsURLConnectionProvider() {
        return new IHttpsURLConnectionProvider(){

            @Override
            public final HttpsURLConnection generateHttpsURLConnection(URL uRL) {
                return (HttpsURLConnection)uRL.openConnection();
            }
        };
    }

    public static String extractJsonString(JSONObject object, String string) {
        if ((object = object.opt(string)) instanceof String) {
            return (String)object;
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static Long extractJsonLong(JSONObject object, String string) {
        if ((object = object.opt(string)) instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            long l2;
            try {
                l2 = (long)Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
            return l2;
        }
        return null;
    }

    public static interface IHttpsURLConnectionProvider {
        public HttpsURLConnection generateHttpsURLConnection(URL var1);
    }

    public static interface IConnectionOptions {
        public void applyConnectionOptions(HttpsURLConnection var1, String var2);
    }
}

