/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PreinstallUtil {
    private static final long SYSTEM_PROPERTY_BITMASK = 1L;
    private static final long SYSTEM_PROPERTY_REFLECTION_BITMASK = 2L;
    private static final long SYSTEM_PROPERTY_PATH_BITMASK = 4L;
    private static final long SYSTEM_PROPERTY_PATH_REFLECTION_BITMASK = 8L;
    private static final long CONTENT_PROVIDER_BITMASK = 16L;
    private static final long CONTENT_PROVIDER_INTENT_ACTION_BITMASK = 32L;
    private static final long FILE_SYSTEM_BITMASK = 64L;
    private static final long CONTENT_PROVIDER_NO_PERMISSION_BITMASK = 128L;
    private static final long ALL_LOCATION_BITMASK = 255L;

    public static boolean hasAllLocationsBeenRead(long l2) {
        return (l2 & 0xFFL) == 255L;
    }

    public static boolean hasNotBeenRead(String string, long l2) {
        String string2 = string;
        string2.getClass();
        int n2 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 2080271301: {
                if (!string.equals("content_provider_no_permission")) break;
                n2 = 7;
                break;
            }
            case 2055247442: {
                if (!string.equals("file_system")) break;
                n2 = 6;
                break;
            }
            case -95318717: {
                if (!string.equals("system_properties")) break;
                n2 = 5;
                break;
            }
            case -468656985: {
                if (!string.equals("system_properties_reflection")) break;
                n2 = 4;
                break;
            }
            case -480091743: {
                if (!string.equals("system_properties_path")) break;
                n2 = 3;
                break;
            }
            case -782042377: {
                if (!string.equals("content_provider")) break;
                n2 = 2;
                break;
            }
            case -1590804087: {
                if (!string.equals("system_properties_path_reflection")) break;
                n2 = 1;
                break;
            }
            case -1771852303: {
                if (!string.equals("content_provider_intent_action")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return false;
            }
            case 7: {
                return (l2 & 0x80L) != 128L;
            }
            case 6: {
                return (l2 & 0x40L) != 64L;
            }
            case 5: {
                return (l2 & 1L) != 1L;
            }
            case 4: {
                return (l2 & 2L) != 2L;
            }
            case 3: {
                return (l2 & 4L) != 4L;
            }
            case 2: {
                return (l2 & 0x10L) != 16L;
            }
            case 1: {
                return (l2 & 8L) != 8L;
            }
            case 0: 
        }
        return (l2 & 0x20L) != 32L;
    }

    public static long markAsRead(String string, long l2) {
        String string2 = string;
        string2.getClass();
        int n2 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 2080271301: {
                if (!string.equals("content_provider_no_permission")) break;
                n2 = 7;
                break;
            }
            case 2055247442: {
                if (!string.equals("file_system")) break;
                n2 = 6;
                break;
            }
            case -95318717: {
                if (!string.equals("system_properties")) break;
                n2 = 5;
                break;
            }
            case -468656985: {
                if (!string.equals("system_properties_reflection")) break;
                n2 = 4;
                break;
            }
            case -480091743: {
                if (!string.equals("system_properties_path")) break;
                n2 = 3;
                break;
            }
            case -782042377: {
                if (!string.equals("content_provider")) break;
                n2 = 2;
                break;
            }
            case -1590804087: {
                if (!string.equals("system_properties_path_reflection")) break;
                n2 = 1;
                break;
            }
            case -1771852303: {
                if (!string.equals("content_provider_intent_action")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return l2;
            }
            case 7: {
                return l2 | 0x80L;
            }
            case 6: {
                return l2 | 0x40L;
            }
            case 5: {
                return l2 | 1L;
            }
            case 4: {
                return l2 | 2L;
            }
            case 3: {
                return l2 | 4L;
            }
            case 2: {
                return l2 | 0x10L;
            }
            case 1: {
                return l2 | 8L;
            }
            case 0: 
        }
        return l2 | 0x20L;
    }

    public static String getPayloadFromSystemProperty(String string, ILogger iLogger) {
        return PreinstallUtil.readSystemProperty("adjust.preinstall." + string, iLogger);
    }

    public static String getPayloadFromSystemPropertyReflection(String string, ILogger iLogger) {
        return PreinstallUtil.readSystemPropertyReflection("adjust.preinstall." + string, iLogger);
    }

    public static String getPayloadFromSystemPropertyFilePath(String string, ILogger iLogger) {
        String string2 = PreinstallUtil.readSystemProperty("adjust.preinstall.path", iLogger);
        if (string2 != null && !string2.isEmpty()) {
            if ((string2 = PreinstallUtil.readFileContent(string2, iLogger)) != null && !string2.isEmpty()) {
                return PreinstallUtil.readPayloadFromJsonString(string2, string, iLogger);
            }
            return null;
        }
        return null;
    }

    public static String getPayloadFromSystemPropertyFilePathReflection(String string, ILogger iLogger) {
        String string2 = PreinstallUtil.readSystemPropertyReflection("adjust.preinstall.path", iLogger);
        if (string2 != null && !string2.isEmpty()) {
            if ((string2 = PreinstallUtil.readFileContent(string2, iLogger)) != null && !string2.isEmpty()) {
                return PreinstallUtil.readPayloadFromJsonString(string2, string, iLogger);
            }
            return null;
        }
        return null;
    }

    public static String getPayloadFromContentProviderDefault(Context objectArray, String string, ILogger iLogger) {
        if (!Util.resolveContentProvider((Context)objectArray, "com.adjust.preinstall")) {
            return null;
        }
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray3[0] = "com.adjust.preinstall";
        objectArray3[1] = "trackers";
        return PreinstallUtil.readContentProvider((Context)objectArray2, Util.formatString("content://%s/%s", objectArray), string, iLogger);
    }

    public static List<String> getPayloadsFromContentProviderIntentAction(Context context, String string, ILogger iLogger) {
        return PreinstallUtil.readContentProviderIntentAction(context, string, "android.permission.INSTALL_PACKAGES", iLogger);
    }

    public static List<String> getPayloadsFromContentProviderNoPermission(Context context, String string, ILogger iLogger) {
        return PreinstallUtil.readContentProviderIntentAction(context, string, null, iLogger);
    }

    public static String getPayloadFromFileSystem(String string, String string2, ILogger iLogger) {
        block5: {
            String string3;
            block4: {
                string3 = PreinstallUtil.readFileContent("/data/local/tmp/adjust.preinstall", iLogger);
                if (string3 != null && !string3.isEmpty()) break block4;
                if (string2 != null && !string2.isEmpty()) {
                    string3 = PreinstallUtil.readFileContent(string2, iLogger);
                }
                if (string3 == null || string3.isEmpty()) break block5;
            }
            return PreinstallUtil.readPayloadFromJsonString(string3, string, iLogger);
        }
        return null;
    }

    private static String readSystemProperty(String string, ILogger objectArray) {
        try {
            return System.getProperty(string);
        }
        catch (Exception exception) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = string;
            objectArray3[1] = exception.getMessage();
            objectArray2.error("Exception read system property key [%s] error [%s]", objectArray);
            return null;
        }
    }

    private static String readSystemPropertyReflection(String string, ILogger objectArray) {
        Class<?> clazz;
        try {
            clazz = Class.forName("android.os.SystemProperties");
        }
        catch (Exception exception) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = string;
            objectArray3[1] = exception.getMessage();
            objectArray2.error("Exception read system property using reflection key [%s] error [%s]", objectArray);
            return null;
        }
        String string2 = "get";
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        return (String)clazz.getDeclaredMethod(string2, classArray).invoke(clazz, string);
    }

    private static String readContentProvider(Context object, String string, String objectArray, ILogger iLogger) {
        block14: {
            block13: {
                String[] stringArray;
                Uri uri;
                ContentResolver contentResolver;
                try {
                    contentResolver = object.getContentResolver();
                    uri = Uri.parse((String)string);
                    stringArray = new String[1];
                }
                catch (Exception exception) {
                    Object[] objectArray2 = new Object[2];
                    objectArray = objectArray2;
                    objectArray[0] = string;
                    objectArray2[1] = exception.getMessage();
                    iLogger.error("Exception read content provider uri [%s] error [%s]", objectArray);
                    return null;
                }
                stringArray[0] = "encrypted_data";
                object = "package_name=?";
                String[] stringArray2 = new String[1];
                String[] stringArray3 = stringArray2;
                stringArray2[0] = objectArray;
                object = contentResolver.query(uri, stringArray, (String)object, stringArray3, null);
                if (object != null) break block13;
                ILogger iLogger2 = iLogger;
                object = "Read content provider cursor null content uri [%s]";
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = string;
                iLogger2.debug((String)object, objectArray);
                return null;
            }
            if (object.moveToFirst()) break block14;
            Object object2 = object;
            ILogger iLogger3 = iLogger;
            object = "Read content provider cursor empty content uri [%s]";
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = string;
            iLogger3.debug((String)object, objectArray);
            object2.close();
            return null;
        }
        String string2 = object.getString(0);
        object.close();
        return string2;
    }

    private static List<String> readContentProviderIntentAction(Context context, String string, String string2, ILogger iLogger) {
        if (Build.VERSION.SDK_INT >= 19) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>();
            for (Object object : context.getPackageManager().queryIntentContentProviders(new Intent("com.attribution.REFERRAL_PROVIDER"), 0)) {
                boolean bl = true;
                if (string2 != null && context.getPackageManager().checkPermission(string2, ((ResolveInfo)object).providerInfo.packageName) != 0) {
                    bl = false;
                }
                if (!bl || (object = ((ResolveInfo)object).providerInfo.authority) == null || ((String)object).isEmpty()) continue;
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = object;
                objectArray[1] = "trackers";
                object = PreinstallUtil.readContentProvider(context, Util.formatString("content://%s/%s", objectArray2), string, iLogger);
                if (object == null || ((String)object).isEmpty()) continue;
                arrayList2.add((String)object);
            }
            if (!arrayList2.isEmpty()) {
                return arrayList2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFileContent(String var0, ILogger var1_7) {
        block12: {
            var2_8 = v0;
            if (!new File(var0).exists() || !var2_8.isFile() || !var2_8.canRead()) break block12;
            var0_1 = (int)var2_8.length();
            if (var0_1 <= 0) {
                var1_7.debug("Read file content empty file", new Object[0]);
                return null;
            }
            var0_2 = new byte[var0_1];
            var3_9 = v1;
            v1 = new FileInputStream(var2_8);
            v1.read(var0_2);
            v1.close();
            return new String(var0_2);
            {
                catch (Throwable var0_3) {
                    ** GOTO lbl30
                }
                catch (Exception var0_4) {}
                {
                    v2 = var1_7;
                    v3 = "Exception read file input stream error [%s]";
                    v4 = new Object[1];
                    var0_5 = 0;
                }
                {
                    v4[var0_5] = var0_4.getMessage();
                    v2.error(v3, v4);
                }
                try {
                    var3_9.close();
                    return null;
lbl30:
                    // 1 sources

                    var3_9.close();
                    throw var0_3;
                }
                catch (Exception var0_6) {
                    v5 = var1_7;
                    v6 = new Object[1];
                    var1_7 = v6;
                    v6[0] = var0_6.getMessage();
                    v5.error("Exception read file content error [%s]", var1_7);
                }
            }
        }
        return null;
    }

    private static String readPayloadFromJsonString(String string, String objectArray, ILogger iLogger) {
        try {
            return new JSONObject(string.trim()).optString((String)objectArray);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = exception.getMessage();
            iLogger.error("Exception read payload from json string error [%s]", objectArray);
            return null;
        }
    }
}

