/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Process;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAdRevenue;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustPlayStoreSubscription;
import com.adjust.sdk.AdjustSigner;
import com.adjust.sdk.AdjustThirdPartySharing;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.EventResponseData;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRunActivityHandler;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.InstallReferrer;
import com.adjust.sdk.InstallReferrerHuawei;
import com.adjust.sdk.InstallReferrerReadListener;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.PackageFactory;
import com.adjust.sdk.PreinstallUtil;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.Util;
import com.adjust.sdk.a;
import com.adjust.sdk.network.ActivityPackageSender;
import com.adjust.sdk.network.UtilNetworking;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import com.adjust.sdk.scheduler.TimerCycle;
import com.adjust.sdk.scheduler.TimerOnce;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.JSONObject;

public class ActivityHandler
implements IActivityHandler {
    private static long FOREGROUND_TIMER_INTERVAL;
    private static long FOREGROUND_TIMER_START;
    private static long BACKGROUND_TIMER_INTERVAL;
    private static long SESSION_INTERVAL;
    private static long SUBSESSION_INTERVAL;
    private static final String TIME_TRAVEL = "Time travel!";
    private static final String ACTIVITY_STATE_NAME = "Activity state";
    private static final String ATTRIBUTION_NAME = "Attribution";
    private static final String FOREGROUND_TIMER_NAME = "Foreground timer";
    private static final String BACKGROUND_TIMER_NAME = "Background timer";
    private static final String DELAY_START_TIMER_NAME = "Delay Start timer";
    private static final String SESSION_CALLBACK_PARAMETERS_NAME = "Session Callback parameters";
    private static final String SESSION_PARTNER_PARAMETERS_NAME = "Session Partner parameters";
    private static final String SESSION_PARAMETERS_NAME = "Session parameters";
    private ThreadExecutor executor;
    private IPackageHandler packageHandler;
    private ActivityState activityState;
    private ILogger logger;
    private TimerCycle foregroundTimer;
    private TimerOnce backgroundTimer;
    private TimerOnce delayStartTimer;
    private InternalState internalState;
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;
    private a deviceInfo;
    private AdjustConfig adjustConfig;
    private AdjustAttribution attribution;
    private IAttributionHandler attributionHandler;
    private ISdkClickHandler sdkClickHandler;
    private SessionParameters sessionParameters;
    private InstallReferrer installReferrer;
    private InstallReferrerHuawei installReferrerHuawei;

    public static void deleteState(Context context) {
        Context context2 = context;
        ActivityHandler.deleteActivityState(context2);
        ActivityHandler.deleteAttribution(context2);
        ActivityHandler.deleteSessionCallbackParameters(context2);
        ActivityHandler.deleteSessionPartnerParameters(context2);
        SharedPreferencesManager.getDefaultInstance(context2).clear();
    }

    private ActivityHandler(AdjustConfig adjustConfig) {
        InternalState internalState;
        SingleThreadCachedScheduler singleThreadCachedScheduler;
        ActivityHandler activityHandler = this;
        activityHandler.init(adjustConfig);
        this.logger = AdjustFactory.getLogger();
        this.logger.lockLogLevel();
        Object object = singleThreadCachedScheduler;
        singleThreadCachedScheduler = new SingleThreadCachedScheduler("ActivityHandler");
        activityHandler.executor = object;
        object = internalState;
        internalState = new InternalState();
        activityHandler.internalState = object;
        Boolean bl = adjustConfig.startEnabled;
        boolean bl2 = bl != null ? bl : true;
        ActivityHandler activityHandler2 = this;
        ((InternalState)object).enabled = bl2;
        InternalState internalState2 = activityHandler2.internalState;
        internalState2.offline = adjustConfig.startOffline;
        internalState2.background = true;
        internalState2.delayStart = false;
        internalState2.updatePackages = false;
        internalState2.sessionResponseProcessed = false;
        internalState2.firstSdkStart = false;
        internalState2.preinstallHasBeenRead = false;
        activityHandler2.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.initI();
            }
        });
    }

    public static ActivityHandler getInstance(AdjustConfig objectArray) {
        if (objectArray == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return null;
        }
        if (!objectArray.isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return null;
        }
        if (objectArray.processName != null) {
            int n2 = Process.myPid();
            Object object = (ActivityManager)objectArray.context.getSystemService("activity");
            if (object == null) {
                return null;
            }
            if ((object = object.getRunningAppProcesses()) == null) {
                return null;
            }
            object = object.iterator();
            while (object.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo.pid != n2) continue;
                if (runningAppProcessInfo.processName.equalsIgnoreCase(objectArray.processName)) break;
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = runningAppProcessInfo.processName;
                AdjustFactory.getLogger().info("Skipping initialization in background process (%s)", objectArray);
                return null;
            }
        }
        return new ActivityHandler((AdjustConfig)objectArray);
    }

    private boolean isEnabledI() {
        ActivityState activityState = this.activityState;
        if (activityState != null) {
            return activityState.enabled;
        }
        return this.internalState.isEnabled();
    }

    private void updateAdidI(String string) {
        if (string == null) {
            return;
        }
        if (string.equals(this.activityState.adid)) {
            return;
        }
        this.activityState.adid = string;
        this.writeActivityStateI();
    }

    private void initI() {
        ActivityPackageSender activityPackageSender;
        ActivityPackageSender activityPackageSender2;
        ActivityPackageSender activityPackageSender3;
        Double d2;
        Object object;
        ActivityHandler activityHandler = this;
        SESSION_INTERVAL = AdjustFactory.getSessionInterval();
        SUBSESSION_INTERVAL = AdjustFactory.getSubsessionInterval();
        FOREGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        FOREGROUND_TIMER_START = AdjustFactory.getTimerStart();
        BACKGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        activityHandler.readAttributionI(activityHandler.adjustConfig.context);
        activityHandler.readActivityStateI(activityHandler.adjustConfig.context);
        activityHandler.sessionParameters = new SessionParameters();
        activityHandler.readSessionCallbackParametersI(activityHandler.adjustConfig.context);
        activityHandler.readSessionPartnerParametersI(activityHandler.adjustConfig.context);
        Object object2 = activityHandler.adjustConfig;
        if (((AdjustConfig)object2).startEnabled != null) {
            ((AdjustConfig)object2).preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

                @Override
                public void run(ActivityHandler activityHandler) {
                    activityHandler.setEnabledI(((ActivityHandler)ActivityHandler.this).adjustConfig.startEnabled);
                }
            });
        }
        if (this.internalState.hasFirstSdkStartOcurred()) {
            InternalState internalState = this.internalState;
            object2 = this.activityState;
            internalState.enabled = ((ActivityState)object2).enabled;
            internalState.updatePackages = ((ActivityState)object2).updatePackages;
            internalState.firstLaunch = false;
        } else {
            this.internalState.firstLaunch = true;
        }
        ActivityHandler activityHandler2 = this;
        activityHandler2.readConfigFile(activityHandler2.adjustConfig.context);
        AdjustConfig adjustConfig = this.adjustConfig;
        object2 = adjustConfig.context;
        activityHandler2.deviceInfo = new a((Context)object2, adjustConfig.sdkPrefix);
        if (activityHandler2.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Event buffering is enabled", new Object[0]);
        }
        ActivityHandler activityHandler3 = this;
        activityHandler3.deviceInfo.b(this.adjustConfig);
        if (activityHandler3.deviceInfo.a == null) {
            if (!Util.canReadPlayIds(this.adjustConfig)) {
                if (this.adjustConfig.coppaCompliantEnabled) {
                    this.logger.info("Cannot read Google Play Services Advertising ID with COPPA enabled", new Object[0]);
                }
                if (this.adjustConfig.playStoreKidsAppEnabled) {
                    this.logger.info("Cannot read Google Play Services Advertising ID with play store kids app enabled", new Object[0]);
                }
            } else {
                this.logger.warn("Unable to get Google Play Services Advertising ID at start time", new Object[0]);
            }
            if (this.deviceInfo.f == null) {
                if (!Util.canReadNonPlayIds(this.adjustConfig)) {
                    if (this.adjustConfig.coppaCompliantEnabled) {
                        this.logger.info("Cannot read non Play IDs with COPPA enabled", new Object[0]);
                    }
                    if (this.adjustConfig.playStoreKidsAppEnabled) {
                        this.logger.info("Cannot read non Play IDs with play store kids app enabled", new Object[0]);
                    }
                } else {
                    this.logger.error("Unable to get any Device IDs. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
                }
            }
        } else {
            this.logger.info("Google Play Services Advertising ID read correctly at start time", new Object[0]);
        }
        if ((object2 = this.adjustConfig.defaultTracker) != null) {
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = object2;
            this.logger.info("Default tracker: '%s'", (Object[])object);
        }
        if ((object2 = this.adjustConfig.pushToken) != null) {
            ActivityHandler activityHandler4 = this;
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = object2;
            activityHandler4.logger.info("Push token: '%s'", (Object[])object);
            if (activityHandler4.internalState.hasFirstSdkStartOcurred()) {
                ActivityHandler activityHandler5 = this;
                activityHandler5.setPushToken(activityHandler5.adjustConfig.pushToken, false);
            } else {
                SharedPreferencesManager.getDefaultInstance(this.getContext()).savePushToken(this.adjustConfig.pushToken);
            }
        } else if (this.internalState.hasFirstSdkStartOcurred() && (object2 = SharedPreferencesManager.getDefaultInstance(this.getContext()).getPushToken()) != null) {
            this.setPushToken((String)object2, true);
        }
        if (this.internalState.hasFirstSdkStartOcurred()) {
            object2 = SharedPreferencesManager.getDefaultInstance(this.getContext());
            if (((SharedPreferencesManager)object2).getGdprForgetMe()) {
                this.gdprForgetMe();
            } else {
                if (((SharedPreferencesManager)object2).getDisableThirdPartySharing()) {
                    this.disableThirdPartySharing();
                }
                object2 = this.adjustConfig.preLaunchActions.preLaunchAdjustThirdPartySharingArray.iterator();
                while (object2.hasNext()) {
                    this.trackThirdPartySharing(object2.next());
                }
                object2 = this.adjustConfig.preLaunchActions.lastMeasurementConsentTracked;
                if (object2 != null) {
                    this.trackMeasurementConsent((Boolean)object2);
                }
                ActivityHandler activityHandler6 = this;
                activityHandler6.adjustConfig.preLaunchActions.preLaunchAdjustThirdPartySharingArray = new ArrayList<AdjustThirdPartySharing>();
                activityHandler6.adjustConfig.preLaunchActions.lastMeasurementConsentTracked = null;
            }
        }
        long l2 = FOREGROUND_TIMER_START;
        long l3 = FOREGROUND_TIMER_INTERVAL;
        this.foregroundTimer = new TimerCycle(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.foregroundTimerFired();
            }
        }, l2, l3, FOREGROUND_TIMER_NAME);
        if (this.adjustConfig.sendInBackground) {
            this.logger.info("Send in background configured", new Object[0]);
            this.backgroundTimer = new TimerOnce(new Runnable(){

                @Override
                public void run() {
                    ActivityHandler.this.backgroundTimerFired();
                }
            }, BACKGROUND_TIMER_NAME);
        }
        if (this.internalState.hasFirstSdkStartNotOcurred() && (d2 = this.adjustConfig.delayStart) != null && d2 > 0.0) {
            this.logger.info("Delay start configured", new Object[0]);
            this.internalState.delayStart = true;
            this.delayStartTimer = new TimerOnce(new Runnable(){

                @Override
                public void run() {
                    ActivityHandler.this.sendFirstPackages();
                }
            }, DELAY_START_TIMER_NAME);
        }
        ActivityHandler activityHandler7 = this;
        UtilNetworking.setUserAgent(activityHandler7.adjustConfig.userAgent);
        ActivityPackageSender activityPackageSender4 = activityPackageSender3;
        AdjustConfig adjustConfig2 = this.adjustConfig;
        object = adjustConfig2.urlStrategy;
        String string = adjustConfig2.basePath;
        String string2 = adjustConfig2.gdprPath;
        String string3 = adjustConfig2.subscriptionPath;
        Object object3 = object;
        object = this.deviceInfo.h;
        activityPackageSender3 = new ActivityPackageSender((String)object3, string, string2, string3, (String)object);
        object = activityHandler7.adjustConfig.context;
        activityHandler7.packageHandler = AdjustFactory.getPackageHandler(activityHandler7, object, activityHandler7.toSendI(false), activityPackageSender4);
        activityPackageSender4 = activityPackageSender2;
        AdjustConfig adjustConfig3 = this.adjustConfig;
        object = adjustConfig3.urlStrategy;
        string = adjustConfig3.basePath;
        string2 = adjustConfig3.gdprPath;
        string3 = adjustConfig3.subscriptionPath;
        Object object4 = object;
        object = this.deviceInfo.h;
        activityPackageSender2 = new ActivityPackageSender((String)object4, string, string2, string3, (String)object);
        activityHandler7.attributionHandler = AdjustFactory.getAttributionHandler(activityHandler7, activityHandler7.toSendI(false), activityPackageSender4);
        activityPackageSender4 = activityPackageSender;
        AdjustConfig adjustConfig4 = this.adjustConfig;
        object = adjustConfig4.urlStrategy;
        string = adjustConfig4.basePath;
        string2 = adjustConfig4.gdprPath;
        string3 = adjustConfig4.subscriptionPath;
        Object object5 = object;
        object = this.deviceInfo.h;
        activityPackageSender = new ActivityPackageSender((String)object5, string, string2, string3, (String)object);
        activityHandler7.sdkClickHandler = AdjustFactory.getSdkClickHandler(activityHandler7, activityHandler7.toSendI(true), activityPackageSender4);
        if (activityHandler7.isToUpdatePackagesI()) {
            this.updatePackagesI();
        }
        ActivityHandler activityHandler8 = this;
        activityHandler8.installReferrer = new InstallReferrer(this.adjustConfig.context, new InstallReferrerReadListener(){

            @Override
            public void onInstallReferrerRead(ReferrerDetails referrerDetails, String string) {
                ActivityHandler.this.sendInstallReferrer(referrerDetails, string);
            }
        });
        activityHandler8.installReferrerHuawei = new InstallReferrerHuawei(this.adjustConfig.context, new InstallReferrerReadListener(){

            @Override
            public void onInstallReferrerRead(ReferrerDetails referrerDetails, String string) {
                ActivityHandler.this.sendInstallReferrer(referrerDetails, string);
            }
        });
        activityHandler8.preLaunchActionsI(activityHandler8.adjustConfig.preLaunchActions.preLaunchActionsArray);
        activityHandler8.sendReftagReferrerI();
    }

    private void checkForPreinstallI() {
        Object object = this.activityState;
        if (object == null) {
            return;
        }
        if (!((ActivityState)object).enabled) {
            return;
        }
        if (((ActivityState)object).isGdprForgotten) {
            return;
        }
        ActivityHandler activityHandler = this;
        activityHandler.sendPreinstallReferrerI();
        if (!activityHandler.adjustConfig.preinstallTrackingEnabled) {
            return;
        }
        if (this.internalState.hasPreinstallBeenRead()) {
            return;
        }
        object = this.deviceInfo.i;
        if (object != null && !((String)object).isEmpty()) {
            String string;
            Object object2;
            object = SharedPreferencesManager.getDefaultInstance(this.getContext());
            long l2 = ((SharedPreferencesManager)object).getPreinstallPayloadReadStatus();
            if (PreinstallUtil.hasAllLocationsBeenRead(l2)) {
                this.internalState.preinstallHasBeenRead = true;
                return;
            }
            if (PreinstallUtil.hasNotBeenRead("system_properties", l2)) {
                object2 = PreinstallUtil.getPayloadFromSystemProperty(this.deviceInfo.i, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "system_properties");
                } else {
                    l2 = PreinstallUtil.markAsRead("system_properties", l2);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("system_properties_reflection", l2)) {
                object2 = PreinstallUtil.getPayloadFromSystemPropertyReflection(this.deviceInfo.i, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "system_properties_reflection");
                } else {
                    l2 = PreinstallUtil.markAsRead("system_properties_reflection", l2);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("system_properties_path", l2)) {
                object2 = PreinstallUtil.getPayloadFromSystemPropertyFilePath(this.deviceInfo.i, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "system_properties_path");
                } else {
                    l2 = PreinstallUtil.markAsRead("system_properties_path", l2);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("system_properties_path_reflection", l2)) {
                object2 = PreinstallUtil.getPayloadFromSystemPropertyFilePathReflection(this.deviceInfo.i, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "system_properties_path_reflection");
                } else {
                    l2 = PreinstallUtil.markAsRead("system_properties_path_reflection", l2);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("content_provider", l2)) {
                ActivityHandler activityHandler2 = this;
                object2 = activityHandler2.deviceInfo.i;
                if ((object2 = PreinstallUtil.getPayloadFromContentProviderDefault(this.adjustConfig.context, (String)object2, activityHandler2.logger)) != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "content_provider");
                } else {
                    l2 = PreinstallUtil.markAsRead("content_provider", l2);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("content_provider_intent_action", l2)) {
                ActivityHandler activityHandler3 = this;
                object2 = activityHandler3.deviceInfo.i;
                if ((object2 = PreinstallUtil.getPayloadsFromContentProviderIntentAction(this.adjustConfig.context, (String)object2, activityHandler3.logger)) != null && !object2.isEmpty()) {
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        string = (String)object2.next();
                        this.sdkClickHandler.sendPreinstallPayload(string, "content_provider_intent_action");
                    }
                } else {
                    l2 = PreinstallUtil.markAsRead("content_provider_intent_action", l2);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("content_provider_no_permission", l2)) {
                ActivityHandler activityHandler4 = this;
                object2 = activityHandler4.deviceInfo.i;
                if ((object2 = PreinstallUtil.getPayloadsFromContentProviderNoPermission(this.adjustConfig.context, (String)object2, activityHandler4.logger)) != null && !object2.isEmpty()) {
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        string = (String)object2.next();
                        this.sdkClickHandler.sendPreinstallPayload(string, "content_provider_no_permission");
                    }
                } else {
                    l2 = PreinstallUtil.markAsRead("content_provider_no_permission", l2);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("file_system", l2)) {
                ActivityHandler activityHandler5 = this;
                object2 = activityHandler5.adjustConfig.preinstallFilePath;
                if ((object2 = PreinstallUtil.getPayloadFromFileSystem(this.deviceInfo.i, object2, activityHandler5.logger)) != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "file_system");
                } else {
                    l2 = PreinstallUtil.markAsRead("file_system", l2);
                }
            }
            ((SharedPreferencesManager)object).setPreinstallPayloadReadStatus(l2);
            this.internalState.preinstallHasBeenRead = true;
            return;
        }
        this.logger.debug("Can't read preinstall payload, invalid package name", new Object[0]);
    }

    private void readConfigFile(Context object) {
        Properties properties;
        try {
            object = object.getAssets().open("adjust_config.properties");
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = exception.getMessage();
            objectArray2.logger.debug("%s file not found in this app", objectArray2);
            return;
        }
        Properties properties2 = properties;
        properties2();
        properties2.load((InputStream)object);
        objectArray2.logger.verbose("adjust_config.properties file read and loaded", new Object[0]);
        object = properties.getProperty("defaultTracker");
        if (object != null) {
            objectArray2.adjustConfig.defaultTracker = object;
        }
    }

    private void preLaunchActionsI(List<IRunActivityHandler> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ((IRunActivityHandler)object.next()).run(this);
        }
    }

    private void startI() {
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            ActivityHandler activityHandler = this;
            AdjustSigner.onResume(activityHandler.adjustConfig.logger);
            activityHandler.startFirstSessionI();
            return;
        }
        if (!this.activityState.enabled) {
            return;
        }
        ActivityHandler activityHandler = this;
        AdjustSigner.onResume(activityHandler.adjustConfig.logger);
        activityHandler.updateHandlersStatusAndSendI();
        activityHandler.processCoppaComplianceI();
        activityHandler.processSessionI();
        activityHandler.checkAttributionStateI();
        activityHandler.processCachedDeeplinkI();
    }

    private void startFirstSessionI() {
        ActivityHandler activityHandler = this;
        activityHandler.activityState = new ActivityState();
        activityHandler.internalState.firstSdkStart = true;
        activityHandler.updateHandlersStatusAndSendI();
        long l2 = System.currentTimeMillis();
        SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(activityHandler.getContext());
        activityHandler.activityState.pushToken = sharedPreferencesManager.getPushToken();
        if (activityHandler.internalState.isEnabled()) {
            if (sharedPreferencesManager.getGdprForgetMe()) {
                this.gdprForgetMeI();
            } else {
                this.processCoppaComplianceI();
                if (sharedPreferencesManager.getDisableThirdPartySharing()) {
                    this.disableThirdPartySharingI();
                }
                Object object = this.adjustConfig.preLaunchActions.preLaunchAdjustThirdPartySharingArray.iterator();
                while (object.hasNext()) {
                    this.trackThirdPartySharingI(object.next());
                }
                object = this.adjustConfig.preLaunchActions.lastMeasurementConsentTracked;
                if (object != null) {
                    this.trackMeasurementConsentI((Boolean)object);
                }
                ActivityHandler activityHandler2 = this;
                activityHandler2.adjustConfig.preLaunchActions.preLaunchAdjustThirdPartySharingArray = new ArrayList<AdjustThirdPartySharing>();
                activityHandler2.adjustConfig.preLaunchActions.lastMeasurementConsentTracked = null;
                activityHandler2.activityState.sessionCount = 1;
                this.transferSessionPackageI(l2);
                this.checkAfterNewStartI(sharedPreferencesManager);
            }
        }
        SharedPreferencesManager sharedPreferencesManager2 = sharedPreferencesManager;
        ActivityHandler activityHandler3 = this;
        activityHandler3.activityState.resetSessionAttributes(l2);
        activityHandler3.activityState.enabled = this.internalState.isEnabled();
        activityHandler3.activityState.updatePackages = this.internalState.itHasToUpdatePackages();
        activityHandler3.writeActivityStateI();
        sharedPreferencesManager2.removePushToken();
        sharedPreferencesManager2.removeGdprForgetMe();
        sharedPreferencesManager2.removeDisableThirdPartySharing();
        this.processCachedDeeplinkI();
    }

    private void processSessionI() {
        if (this.activityState.isGdprForgotten) {
            return;
        }
        long l2 = System.currentTimeMillis();
        ActivityState activityState = this.activityState;
        long l3 = l2 - activityState.lastActivity;
        if (l3 < 0L) {
            ActivityHandler activityHandler = this;
            activityHandler.logger.error(TIME_TRAVEL, new Object[0]);
            activityHandler.activityState.lastActivity = l2;
            activityHandler.writeActivityStateI();
            return;
        }
        if (l3 > SESSION_INTERVAL) {
            ActivityHandler activityHandler = this;
            activityHandler.trackNewSessionI(l2);
            activityHandler.checkAfterNewStartI();
            return;
        }
        if (l3 > SUBSESSION_INTERVAL) {
            int n2;
            ActivityHandler activityHandler = this;
            ActivityState activityState2 = activityState;
            activityState2.subsessionCount = n2 = activityState2.subsessionCount + 1;
            activityState2.sessionLength += l3;
            activityState.lastActivity = l2;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n2;
            objectArray[1] = this.activityState.sessionCount;
            activityHandler.logger.verbose("Started subsession %d of session %d", objectArray2);
            activityHandler.writeActivityStateI();
            activityHandler.checkForPreinstallI();
            activityHandler.installReferrer.startConnection();
            activityHandler.installReferrerHuawei.readReferrer();
            return;
        }
        this.logger.verbose("Time span since last activity too short for a new subsession", new Object[0]);
    }

    private void trackNewSessionI(long l2) {
        ActivityHandler activityHandler = activityState;
        ActivityState activityState = ((ActivityHandler)((Object)activityState)).activityState;
        long l3 = l2 - activityState.lastActivity;
        ++activityState.sessionCount;
        activityState.lastInterval = l3;
        activityHandler.transferSessionPackageI(l2);
        activityHandler.activityState.resetSessionAttributes(l2);
        activityHandler.writeActivityStateI();
    }

    private void checkAttributionStateI() {
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return;
        }
        if (this.internalState.isFirstLaunch() && this.internalState.hasSessionResponseNotBeenProcessed()) {
            return;
        }
        if (this.attribution != null && !this.activityState.askingAttribution) {
            return;
        }
        this.attributionHandler.getAttribution();
    }

    private void processCachedDeeplinkI() {
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return;
        }
        SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(this.getContext());
        String string = sharedPreferencesManager.getDeeplinkUrl();
        long l2 = sharedPreferencesManager.getDeeplinkClickTime();
        if (string == null) {
            return;
        }
        if (l2 == -1L) {
            return;
        }
        this.readOpenUrl(Uri.parse((String)string), l2);
        sharedPreferencesManager.removeDeeplink();
    }

    private void endI() {
        if (!this.toSendI()) {
            this.pauseSendingI();
        }
        if (this.updateActivityStateI(System.currentTimeMillis())) {
            this.writeActivityStateI();
        }
    }

    private void trackEventI(AdjustEvent object) {
        PackageBuilder packageBuilder;
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return;
        }
        if (!this.isEnabledI()) {
            return;
        }
        if (!this.checkEventI((AdjustEvent)object)) {
            return;
        }
        if (!this.checkOrderIdI(((AdjustEvent)object).orderId)) {
            return;
        }
        if (this.activityState.isGdprForgotten) {
            return;
        }
        ActivityHandler activityHandler2 = this;
        long l2 = System.currentTimeMillis();
        Object object2 = activityHandler2.activityState;
        ++((ActivityState)object2).eventCount;
        activityHandler2.updateActivityStateI(l2);
        object2 = packageBuilder;
        AdjustEvent adjustEvent = object;
        Object object3 = object2;
        ActivityHandler activityHandler3 = this;
        object = activityHandler3.adjustConfig;
        object2 = activityHandler3.deviceInfo;
        ActivityState activityState = activityHandler3.activityState;
        SessionParameters sessionParameters = activityHandler3.sessionParameters;
        ((PackageBuilder)object3)((AdjustConfig)object, (a)object2, activityState, sessionParameters, l2);
        object = packageBuilder.buildEventPackage(adjustEvent, this.internalState.isInDelayedStart());
        activityHandler2.packageHandler.addPackage((ActivityPackage)object);
        if (activityHandler2.adjustConfig.eventBufferingEnabled) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = ((ActivityPackage)object).getSuffix();
            this.logger.info("Buffered event %s", objectArray2);
        } else {
            this.packageHandler.sendFirstPackage();
        }
        if (this.adjustConfig.sendInBackground && this.internalState.isInBackground()) {
            this.startBackgroundTimerI();
        }
        this.writeActivityStateI();
    }

    private void launchEventResponseTasksI(final EventResponseData eventResponseData) {
        Handler handler;
        this.updateAdidI(eventResponseData.adid);
        Handler handler2 = handler;
        handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean bl = eventResponseData.success;
        if (bl && this.adjustConfig.onEventTrackingSucceededListener != null) {
            this.logger.debug("Launching success event tracking listener", new Object[0]);
            handler2.post(new Runnable(){

                @Override
                public void run() {
                    if (ActivityHandler.this.adjustConfig == null) {
                        return;
                    }
                    if (((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingSucceededListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingSucceededListener.onFinishedEventTrackingSucceeded(eventResponseData.getSuccessResponseData());
                }
            });
            return;
        }
        if (!bl && this.adjustConfig.onEventTrackingFailedListener != null) {
            this.logger.debug("Launching failed event tracking listener", new Object[0]);
            handler2.post(new Runnable(){

                @Override
                public void run() {
                    if (ActivityHandler.this.adjustConfig == null) {
                        return;
                    }
                    if (((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingFailedListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingFailedListener.onFinishedEventTrackingFailed(eventResponseData.getFailureResponseData());
                }
            });
            return;
        }
    }

    private void launchSdkClickResponseTasksI(SdkClickResponseData sdkClickResponseData) {
        Handler handler;
        SdkClickResponseData sdkClickResponseData2 = sdkClickResponseData;
        this.updateAdidI(sdkClickResponseData.adid);
        sdkClickResponseData = handler;
        handler = new Handler(this.adjustConfig.context.getMainLooper());
        if (this.updateAttributionI(sdkClickResponseData2.attribution)) {
            this.launchAttributionListenerI((Handler)sdkClickResponseData);
        }
    }

    private void launchSessionResponseTasksI(SessionResponseData sessionResponseData) {
        Handler handler;
        this.logger.debug("Launching SessionResponse tasks", new Object[0]);
        this.updateAdidI(sessionResponseData.adid);
        Handler handler2 = handler;
        handler = new Handler(this.adjustConfig.context.getMainLooper());
        if (this.updateAttributionI(sessionResponseData.attribution)) {
            this.launchAttributionListenerI(handler2);
        }
        if (this.attribution == null && !this.activityState.askingAttribution) {
            this.attributionHandler.getAttribution();
        }
        if (sessionResponseData.success) {
            SharedPreferencesManager.getDefaultInstance(this.getContext()).setInstallTracked();
        }
        this.launchSessionResponseListenerI(sessionResponseData, handler2);
        this.internalState.sessionResponseProcessed = true;
    }

    private void launchSessionResponseListenerI(final SessionResponseData sessionResponseData, Handler handler) {
        boolean bl = sessionResponseData.success;
        if (bl && this.adjustConfig.onSessionTrackingSucceededListener != null) {
            this.logger.debug("Launching success session tracking listener", new Object[0]);
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (ActivityHandler.this.adjustConfig == null) {
                        return;
                    }
                    if (((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingSucceededListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingSucceededListener.onFinishedSessionTrackingSucceeded(sessionResponseData.getSuccessResponseData());
                }
            });
            return;
        }
        if (!bl && this.adjustConfig.onSessionTrackingFailedListener != null) {
            this.logger.debug("Launching failed session tracking listener", new Object[0]);
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (ActivityHandler.this.adjustConfig == null) {
                        return;
                    }
                    if (((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingFailedListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingFailedListener.onFinishedSessionTrackingFailed(sessionResponseData.getFailureResponseData());
                }
            });
            return;
        }
    }

    private void launchAttributionResponseTasksI(AttributionResponseData attributionResponseData) {
        Handler handler;
        this.updateAdidI(attributionResponseData.adid);
        Handler handler2 = handler;
        handler = new Handler(this.adjustConfig.context.getMainLooper());
        if (this.updateAttributionI(attributionResponseData.attribution)) {
            this.launchAttributionListenerI(handler2);
        }
        this.prepareDeeplinkI(attributionResponseData.deeplink, handler2);
    }

    private void launchAttributionListenerI(Handler object) {
        Runnable runnable;
        if (this.adjustConfig.onAttributionChangedListener == null) {
            return;
        }
        Handler handler = object;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (ActivityHandler.this.adjustConfig == null) {
                    return;
                }
                if (((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener == null) {
                    return;
                }
                ((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener.onAttributionChanged(ActivityHandler.this.attribution);
            }
        };
        handler.post((Runnable)object);
    }

    private void prepareDeeplinkI(final Uri uri, final Handler intent) {
        if (uri == null) {
            return;
        }
        Intent intent2 = intent;
        Intent intent3 = new Object[1];
        intent = intent3;
        intent3[0] = uri;
        this.logger.info("Deferred deeplink received (%s)", (Object[])intent);
        intent = this.createDeeplinkIntentI(uri);
        intent2.post(new Runnable(){

            @Override
            public void run() {
                if (m03.ActivityHandler.this.adjustConfig == null) {
                    return;
                }
                boolean bl = true;
                if (((ActivityHandler)m03.ActivityHandler.this).adjustConfig.onDeeplinkResponseListener != null) {
                    bl = ((ActivityHandler)m03.ActivityHandler.this).adjustConfig.onDeeplinkResponseListener.launchReceivedDeeplink(m03.uri);
                }
                if (bl) {
                    m0 m02 = m03;
                    m0 m03 = m02.intent;
                    m03.ActivityHandler.this.launchDeeplinkMain((Intent)m03, m02.uri);
                }
            }
        });
    }

    private Intent createDeeplinkIntentI(Uri uri) {
        Intent intent;
        if (this.adjustConfig.deepLinkComponent == null) {
            Intent intent2;
            intent = intent2;
            intent2 = new Intent("android.intent.action.VIEW", uri);
        } else {
            Intent intent3;
            intent = intent3;
            AdjustConfig adjustConfig = this.adjustConfig;
            Context context = adjustConfig.context;
            Class clazz = adjustConfig.deepLinkComponent;
            intent3 = new Intent("android.intent.action.VIEW", uri, context, clazz);
        }
        Intent intent4 = intent;
        intent.setFlags(0x10000000);
        intent4.setPackage(this.adjustConfig.context.getPackageName());
        return intent4;
    }

    private void launchDeeplinkMain(Intent intent, Uri uri) {
        Object[] objectArray;
        if (!(objectArray.adjustConfig.context.getPackageManager().queryIntentActivities(intent, 0).size() > 0)) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = uri;
            objectArray.logger.error("Unable to open deferred deep link (%s)", objectArray);
            return;
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = uri;
        objectArray.logger.info("Open deferred deep link (%s)", objectArray);
        objectArray.adjustConfig.context.startActivity(intent);
    }

    private void setEnabledI(boolean bl) {
        Object object;
        ActivityHandler activityHandler = this;
        if (!activityHandler.hasChangedStateI(activityHandler.isEnabledI(), bl, "Adjust already enabled", "Adjust already disabled")) {
            return;
        }
        if (bl && (object = this.activityState) != null && ((ActivityState)object).isGdprForgotten) {
            this.logger.error("Re-enabling SDK not possible for forgotten user", new Object[0]);
            return;
        }
        this.internalState.enabled = bl;
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            this.updateStatusI(bl ^ true, "Handlers will start as paused due to the SDK being disabled", "Handlers will still start as paused", "Handlers will start as active due to the SDK being enabled");
            return;
        }
        this.activityState.enabled = bl;
        this.writeActivityStateI();
        if (bl) {
            object = SharedPreferencesManager.getDefaultInstance(this.getContext());
            if (((SharedPreferencesManager)object).getGdprForgetMe()) {
                this.gdprForgetMeI();
            } else {
                this.processCoppaComplianceI();
                if (((SharedPreferencesManager)object).getDisableThirdPartySharing()) {
                    this.disableThirdPartySharingI();
                }
                Object object2 = this.adjustConfig.preLaunchActions.preLaunchAdjustThirdPartySharingArray.iterator();
                while (object2.hasNext()) {
                    this.trackThirdPartySharingI(object2.next());
                }
                object2 = this.adjustConfig.preLaunchActions.lastMeasurementConsentTracked;
                if (object2 != null) {
                    this.trackMeasurementConsentI((Boolean)object2);
                }
                ActivityHandler activityHandler2 = this;
                activityHandler2.adjustConfig.preLaunchActions.preLaunchAdjustThirdPartySharingArray = new ArrayList<AdjustThirdPartySharing>();
                activityHandler2.adjustConfig.preLaunchActions.lastMeasurementConsentTracked = null;
            }
            if (!((SharedPreferencesManager)object).getInstallTracked()) {
                ActivityHandler activityHandler3 = this;
                activityHandler3.logger.debug("Detected that install was not tracked at enable time", new Object[0]);
                activityHandler3.trackNewSessionI(System.currentTimeMillis());
            }
            this.checkAfterNewStartI((SharedPreferencesManager)object);
        }
        this.updateStatusI(bl ^ true, "Pausing handlers due to SDK being disabled", "Handlers remain paused", "Resuming handlers due to SDK being enabled");
    }

    private void checkAfterNewStartI() {
        ActivityHandler activityHandler = this;
        activityHandler.checkAfterNewStartI(SharedPreferencesManager.getDefaultInstance(activityHandler.getContext()));
    }

    private void checkAfterNewStartI(SharedPreferencesManager sharedPreferencesManager) {
        String string = sharedPreferencesManager.getPushToken();
        if (string != null && !string.equals(this.activityState.pushToken)) {
            this.setPushToken(string, true);
        }
        if (sharedPreferencesManager.getRawReferrerArray() != null) {
            this.sendReftagReferrer();
        }
        ActivityHandler activityHandler = this;
        activityHandler.checkForPreinstallI();
        activityHandler.installReferrer.startConnection();
        activityHandler.installReferrerHuawei.readReferrer();
    }

    private void setOfflineModeI(boolean bl) {
        ActivityHandler activityHandler = this;
        if (!activityHandler.hasChangedStateI(activityHandler.internalState.isOffline(), bl, "Adjust already in offline mode", "Adjust already in online mode")) {
            return;
        }
        this.internalState.offline = bl;
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            this.updateStatusI(bl, "Handlers will start paused due to SDK being offline", "Handlers will still start as paused", "Handlers will start as active due to SDK being online");
            return;
        }
        this.updateStatusI(bl, "Pausing handlers to put SDK offline mode", "Handlers remain paused", "Resuming handlers to put SDK in online mode");
    }

    private boolean hasChangedStateI(boolean bl, boolean bl2, String string, String string2) {
        if (bl != bl2) {
            return true;
        }
        if (bl) {
            this.logger.debug(string, new Object[0]);
        } else {
            this.logger.debug(string2, new Object[0]);
        }
        return false;
    }

    private void updateStatusI(boolean bl, String string, String string2, String string3) {
        if (bl) {
            this.logger.info(string, new Object[0]);
        } else if (this.pausedI(false)) {
            if (this.pausedI(true)) {
                this.logger.info(string2, new Object[0]);
            } else {
                this.logger.info(string2 + ", except the Sdk Click Handler", new Object[0]);
            }
        } else {
            this.logger.info(string3, new Object[0]);
        }
        this.updateHandlersStatusAndSendI();
    }

    private void setAskingAttributionI(boolean bl) {
        this.activityState.askingAttribution = bl;
        this.writeActivityStateI();
    }

    private void sendReftagReferrerI() {
        if (!this.isEnabledI()) {
            return;
        }
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            return;
        }
        this.sdkClickHandler.sendReftagReferrers();
    }

    private void sendPreinstallReferrerI() {
        if (!this.isEnabledI()) {
            return;
        }
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            return;
        }
        String string = SharedPreferencesManager.getDefaultInstance(this.getContext()).getPreinstallReferrer();
        if (string != null && !string.isEmpty()) {
            this.sdkClickHandler.sendPreinstallPayload(string, "system_installer_referrer");
            return;
        }
    }

    private void sendInstallReferrerI(ReferrerDetails object, String object2) {
        if (!((ActivityHandler)object3).isEnabledI()) {
            return;
        }
        if (!((ActivityHandler)object3).isValidReferrerDetails((ReferrerDetails)object)) {
            return;
        }
        if (Util.isEqualReferrerDetails((ReferrerDetails)object, (String)object2, ((ActivityHandler)object3).activityState)) {
            return;
        }
        ActivityHandler activityHandler = object3;
        ReferrerDetails referrerDetails = object;
        String string = object2;
        ActivityHandler activityHandler2 = object3;
        Object object3 = activityHandler2.activityState;
        object = activityHandler2.adjustConfig;
        object2 = activityHandler2.deviceInfo;
        SessionParameters sessionParameters = activityHandler2.sessionParameters;
        object3 = PackageFactory.buildInstallReferrerSdkClickPackage(referrerDetails, string, (ActivityState)object3, (AdjustConfig)object, (a)object2, sessionParameters);
        activityHandler.sdkClickHandler.sendSdkClick((ActivityPackage)object3);
    }

    private boolean isValidReferrerDetails(ReferrerDetails referrerDetails) {
        if (referrerDetails == null) {
            return false;
        }
        String string = referrerDetails.installReferrer;
        if (string == null) {
            return false;
        }
        return string.length() != 0;
    }

    private void readOpenUrlI(Uri object, long l2) {
        if (!this.isEnabledI()) {
            return;
        }
        if (Util.isUrlFilteredOut(object)) {
            this.logger.debug("Deep link (" + object.toString() + ") processing skipped", new Object[0]);
            return;
        }
        Uri uri = object;
        ActivityHandler activityHandler = this;
        object = activityHandler.activityState;
        AdjustConfig adjustConfig = activityHandler.adjustConfig;
        a a2 = activityHandler.deviceInfo;
        SessionParameters sessionParameters = activityHandler.sessionParameters;
        if ((object = PackageFactory.buildDeeplinkSdkClickPackage(uri, l2, (ActivityState)object, adjustConfig, a2, sessionParameters)) == null) {
            return;
        }
        this.sdkClickHandler.sendSdkClick((ActivityPackage)object);
    }

    private void updateHandlersStatusAndSendI() {
        if (!this.toSendI()) {
            this.pauseSendingI();
            return;
        }
        ActivityHandler activityHandler = this;
        activityHandler.resumeSendingI();
        if (!activityHandler.adjustConfig.eventBufferingEnabled || this.internalState.isFirstLaunch() && this.internalState.hasSessionResponseNotBeenProcessed()) {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void pauseSendingI() {
        ActivityHandler activityHandler = this;
        activityHandler.attributionHandler.pauseSending();
        activityHandler.packageHandler.pauseSending();
        if (!activityHandler.toSendI(true)) {
            this.sdkClickHandler.pauseSending();
        } else {
            this.sdkClickHandler.resumeSending();
        }
    }

    private void resumeSendingI() {
        ActivityHandler activityHandler = this;
        activityHandler.attributionHandler.resumeSending();
        activityHandler.packageHandler.resumeSending();
        activityHandler.sdkClickHandler.resumeSending();
    }

    private boolean updateActivityStateI(long l2) {
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return false;
        }
        ActivityState activityState = this.activityState;
        long l3 = l2 - activityState.lastActivity;
        if (l3 > SESSION_INTERVAL) {
            return false;
        }
        activityState.lastActivity = l2;
        if (l3 < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
        } else {
            ActivityState activityState2 = activityState;
            activityState2.sessionLength += l3;
            activityState2.timeSpent += l3;
        }
        return true;
    }

    public static boolean deleteActivityState(Context context) {
        return context.deleteFile("AdjustIoActivityState");
    }

    public static boolean deleteAttribution(Context context) {
        return context.deleteFile("AdjustAttribution");
    }

    public static boolean deleteSessionCallbackParameters(Context context) {
        return context.deleteFile("AdjustSessionCallbackParameters");
    }

    public static boolean deleteSessionPartnerParameters(Context context) {
        return context.deleteFile("AdjustSessionPartnerParameters");
    }

    private void transferSessionPackageI(long l2) {
        ActivityHandler activityHandler = object;
        ActivityHandler activityHandler2 = object;
        Object object = activityHandler2.adjustConfig;
        a a2 = activityHandler2.deviceInfo;
        ActivityState activityState = activityHandler2.activityState;
        SessionParameters sessionParameters = activityHandler2.sessionParameters;
        object = new PackageBuilder((AdjustConfig)object, a2, activityState, sessionParameters, l2).buildSessionPackage(((ActivityHandler)object).internalState.isInDelayedStart());
        activityHandler.packageHandler.addPackage((ActivityPackage)object);
        activityHandler.packageHandler.sendFirstPackage();
    }

    private void startForegroundTimerI() {
        if (!this.isEnabledI()) {
            return;
        }
        this.foregroundTimer.start();
    }

    private void stopForegroundTimerI() {
        this.foregroundTimer.suspend();
    }

    private void foregroundTimerFiredI() {
        if (!this.isEnabledI()) {
            this.stopForegroundTimerI();
            return;
        }
        if (this.toSendI()) {
            this.packageHandler.sendFirstPackage();
        }
        if (this.updateActivityStateI(System.currentTimeMillis())) {
            this.writeActivityStateI();
        }
    }

    private void startBackgroundTimerI() {
        if (this.backgroundTimer == null) {
            return;
        }
        if (!this.toSendI()) {
            return;
        }
        if (this.backgroundTimer.getFireIn() > 0L) {
            return;
        }
        this.backgroundTimer.startIn(BACKGROUND_TIMER_INTERVAL);
    }

    private void stopBackgroundTimerI() {
        TimerOnce timerOnce = ((ActivityHandler)((Object)timerOnce)).backgroundTimer;
        if (timerOnce == null) {
            return;
        }
        timerOnce.cancel();
    }

    private void backgroundTimerFiredI() {
        if (this.toSendI()) {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void delayStartI() {
        Object[] objectArray;
        long l2;
        if (this.internalState.isNotInDelayedStart()) {
            return;
        }
        if (this.isToUpdatePackagesI()) {
            return;
        }
        Double d2 = this.adjustConfig.delayStart;
        double d3 = d2 != null ? d2 : 0.0;
        long l3 = (long)(d3 * 1000.0);
        if (l3 > (l2 = AdjustFactory.getMaxDelayStart())) {
            double d4 = l2 / 1000L;
            Object[] objectArray2 = Util.SecondsDisplayFormat;
            String string = objectArray2.format(d3);
            objectArray = Util.SecondsDisplayFormat.format(d4);
            Object[] objectArray3 = new Object[2];
            objectArray2 = objectArray3;
            objectArray3[0] = string;
            objectArray3[1] = objectArray;
            this.logger.warn("Delay start of %s seconds bigger than max allowed value of %s seconds", objectArray2);
            d3 = d4;
        } else {
            l2 = l3;
        }
        ActivityHandler activityHandler = this;
        Object object = Util.SecondsDisplayFormat.format(d3);
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = object;
        activityHandler.logger.info("Waiting %s seconds before starting first session", objectArray);
        activityHandler.delayStartTimer.startIn(l2);
        activityHandler.internalState.updatePackages = true;
        object = activityHandler.activityState;
        if (object != null) {
            ((ActivityState)object).updatePackages = true;
            this.writeActivityStateI();
        }
    }

    private void sendFirstPackagesI() {
        if (this.internalState.isNotInDelayedStart()) {
            this.logger.info("Start delay expired or never configured", new Object[0]);
            return;
        }
        ActivityHandler activityHandler = this;
        activityHandler.updatePackagesI();
        activityHandler.internalState.delayStart = false;
        activityHandler.delayStartTimer.cancel();
        activityHandler.delayStartTimer = null;
        activityHandler.updateHandlersStatusAndSendI();
    }

    private void updatePackagesI() {
        ActivityHandler activityHandler = this;
        activityHandler.packageHandler.updatePackages(this.sessionParameters);
        activityHandler.internalState.updatePackages = false;
        ActivityState activityState = activityHandler.activityState;
        if (activityState != null) {
            activityState.updatePackages = false;
            this.writeActivityStateI();
        }
    }

    private boolean isToUpdatePackagesI() {
        ActivityState activityState = this.activityState;
        if (activityState != null) {
            return activityState.updatePackages;
        }
        return this.internalState.itHasToUpdatePackages();
    }

    private void setPushTokenI(String object) {
        if (!objectArray2.checkActivityStateI(objectArray2.activityState)) {
            return;
        }
        if (!objectArray2.isEnabledI()) {
            return;
        }
        ActivityState activityState = objectArray2.activityState;
        if (activityState.isGdprForgotten) {
            return;
        }
        if (object == null) {
            return;
        }
        if (((String)object).equals(activityState.pushToken)) {
            return;
        }
        objectArray2.activityState.pushToken = object;
        objectArray2.writeActivityStateI();
        long l2 = System.currentTimeMillis();
        object = objectArray2.adjustConfig;
        a a2 = objectArray2.deviceInfo;
        ActivityState activityState2 = objectArray2.activityState;
        SessionParameters sessionParameters = objectArray2.sessionParameters;
        object = new PackageBuilder((AdjustConfig)object, a2, activityState2, sessionParameters, l2).buildInfoPackage("push");
        objectArray2.packageHandler.addPackage((ActivityPackage)object);
        SharedPreferencesManager.getDefaultInstance(objectArray2.getContext()).removePushToken();
        if (objectArray2.adjustConfig.eventBufferingEnabled) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = ((ActivityPackage)object).getSuffix();
            objectArray2.logger.info("Buffered event %s", objectArray2);
        } else {
            objectArray2.packageHandler.sendFirstPackage();
        }
    }

    private void gdprForgetMeI() {
        if (!objectArray4.checkActivityStateI(objectArray4.activityState)) {
            return;
        }
        if (!objectArray4.isEnabledI()) {
            return;
        }
        ActivityState activityState = objectArray4.activityState;
        if (activityState.isGdprForgotten) {
            return;
        }
        Object[] objectArray = objectArray4;
        Object[] objectArray2 = objectArray4;
        activityState.isGdprForgotten = true;
        objectArray.writeActivityStateI();
        long l2 = System.currentTimeMillis();
        AdjustConfig adjustConfig = objectArray4.adjustConfig;
        a a2 = objectArray4.deviceInfo;
        ActivityState activityState2 = objectArray4.activityState;
        SessionParameters sessionParameters = objectArray4.sessionParameters;
        ActivityPackage activityPackage = new PackageBuilder(adjustConfig, a2, activityState2, sessionParameters, l2).buildGdprPackage();
        objectArray2.packageHandler.addPackage(activityPackage);
        SharedPreferencesManager.getDefaultInstance(objectArray.getContext()).removeGdprForgetMe();
        if (objectArray2.adjustConfig.eventBufferingEnabled) {
            Object[] objectArray3 = new Object[1];
            Object[] objectArray4 = objectArray3;
            objectArray3[0] = activityPackage.getSuffix();
            objectArray4.logger.info("Buffered event %s", objectArray4);
        } else {
            objectArray4.packageHandler.sendFirstPackage();
        }
    }

    private void disableThirdPartySharingI() {
        SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(objectArray2.getContext());
        sharedPreferencesManager.setDisableThirdPartySharing();
        if (!objectArray2.checkActivityStateI(objectArray2.activityState)) {
            return;
        }
        if (!objectArray2.isEnabledI()) {
            return;
        }
        ActivityState activityState = objectArray2.activityState;
        if (activityState.isGdprForgotten) {
            return;
        }
        if (activityState.isThirdPartySharingDisabled) {
            return;
        }
        if (objectArray2.adjustConfig.coppaCompliantEnabled) {
            objectArray2.logger.warn("Call to disable third party sharing API ignored, already done when COPPA enabled", new Object[0]);
            return;
        }
        activityState.isThirdPartySharingDisabled = true;
        objectArray2.writeActivityStateI();
        long l2 = System.currentTimeMillis();
        AdjustConfig adjustConfig = objectArray2.adjustConfig;
        a a2 = objectArray2.deviceInfo;
        ActivityState activityState2 = objectArray2.activityState;
        SessionParameters sessionParameters = objectArray2.sessionParameters;
        ActivityPackage activityPackage = new PackageBuilder(adjustConfig, a2, activityState2, sessionParameters, l2).buildDisableThirdPartySharingPackage();
        objectArray2.packageHandler.addPackage(activityPackage);
        sharedPreferencesManager.removeDisableThirdPartySharing();
        if (objectArray2.adjustConfig.eventBufferingEnabled) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = activityPackage.getSuffix();
            objectArray2.logger.info("Buffered event %s", objectArray2);
        } else {
            objectArray2.packageHandler.sendFirstPackage();
        }
    }

    private void trackThirdPartySharingI(AdjustThirdPartySharing object) {
        if (!objectArray2.checkActivityStateI(objectArray2.activityState)) {
            objectArray2.adjustConfig.preLaunchActions.preLaunchAdjustThirdPartySharingArray.add((AdjustThirdPartySharing)object);
            return;
        }
        if (!objectArray2.isEnabledI()) {
            return;
        }
        if (objectArray2.activityState.isGdprForgotten) {
            return;
        }
        if (objectArray2.adjustConfig.coppaCompliantEnabled) {
            objectArray2.logger.warn("Calling third party sharing API not allowed when COPPA enabled", new Object[0]);
            return;
        }
        long l2 = System.currentTimeMillis();
        object = objectArray2.adjustConfig;
        a a2 = objectArray2.deviceInfo;
        ActivityState activityState = objectArray2.activityState;
        SessionParameters sessionParameters = objectArray2.sessionParameters;
        object = new PackageBuilder((AdjustConfig)object, a2, activityState, sessionParameters, l2).buildThirdPartySharingPackage((AdjustThirdPartySharing)object);
        objectArray2.packageHandler.addPackage((ActivityPackage)object);
        if (objectArray2.adjustConfig.eventBufferingEnabled) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = ((ActivityPackage)object).getSuffix();
            objectArray2.logger.info("Buffered event %s", objectArray2);
        } else {
            objectArray2.packageHandler.sendFirstPackage();
        }
    }

    private void trackMeasurementConsentI(boolean bl) {
        if (!objectArray2.checkActivityStateI(objectArray2.activityState)) {
            objectArray2.adjustConfig.preLaunchActions.lastMeasurementConsentTracked = bl;
            return;
        }
        if (!objectArray2.isEnabledI()) {
            return;
        }
        if (objectArray2.activityState.isGdprForgotten) {
            return;
        }
        long l2 = System.currentTimeMillis();
        Object object = objectArray2.adjustConfig;
        a a2 = objectArray2.deviceInfo;
        ActivityState activityState = objectArray2.activityState;
        SessionParameters sessionParameters = objectArray2.sessionParameters;
        object = new PackageBuilder((AdjustConfig)object, a2, activityState, sessionParameters, l2).buildMeasurementConsentPackage(bl);
        objectArray2.packageHandler.addPackage((ActivityPackage)object);
        if (objectArray2.adjustConfig.eventBufferingEnabled) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = ((ActivityPackage)object).getSuffix();
            objectArray2.logger.info("Buffered event %s", objectArray2);
        } else {
            objectArray2.packageHandler.sendFirstPackage();
        }
    }

    private void trackAdRevenueI(String object, JSONObject jSONObject) {
        ActivityHandler activityHandler = object2;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return;
        }
        if (!((ActivityHandler)object2).isEnabledI()) {
            return;
        }
        if (((ActivityHandler)object2).activityState.isGdprForgotten) {
            return;
        }
        ActivityHandler activityHandler2 = object2;
        long l2 = System.currentTimeMillis();
        ActivityHandler activityHandler3 = object2;
        Object object2 = activityHandler3.adjustConfig;
        object = activityHandler3.deviceInfo;
        ActivityState activityState = activityHandler3.activityState;
        SessionParameters sessionParameters = activityHandler3.sessionParameters;
        object2 = new PackageBuilder((AdjustConfig)object2, (a)object, activityState, sessionParameters, l2).buildAdRevenuePackage((String)object, jSONObject);
        activityHandler2.packageHandler.addPackage((ActivityPackage)object2);
        activityHandler2.packageHandler.sendFirstPackage();
    }

    private void trackAdRevenueI(AdjustAdRevenue object) {
        PackageBuilder packageBuilder;
        ActivityHandler activityHandler = object3;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return;
        }
        if (!((ActivityHandler)object3).isEnabledI()) {
            return;
        }
        if (!((ActivityHandler)object3).checkAdjustAdRevenue((AdjustAdRevenue)object)) {
            return;
        }
        if (((ActivityHandler)object3).activityState.isGdprForgotten) {
            return;
        }
        ActivityHandler activityHandler2 = object3;
        long l2 = System.currentTimeMillis();
        Object object2 = packageBuilder;
        AdjustAdRevenue adjustAdRevenue = object;
        ActivityHandler activityHandler3 = object3;
        PackageBuilder packageBuilder2 = object2;
        ActivityHandler activityHandler4 = object3;
        Object object3 = activityHandler4.adjustConfig;
        object = activityHandler4.deviceInfo;
        object2 = activityHandler4.activityState;
        SessionParameters sessionParameters = activityHandler4.sessionParameters;
        packageBuilder2((AdjustConfig)object3, (a)object, (ActivityState)object2, sessionParameters, l2);
        object3 = packageBuilder.buildAdRevenuePackage(adjustAdRevenue, activityHandler3.internalState.isInDelayedStart());
        activityHandler2.packageHandler.addPackage((ActivityPackage)object3);
        activityHandler2.packageHandler.sendFirstPackage();
    }

    private void trackSubscriptionI(AdjustPlayStoreSubscription object) {
        PackageBuilder packageBuilder;
        ActivityHandler activityHandler = object3;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return;
        }
        if (!((ActivityHandler)object3).isEnabledI()) {
            return;
        }
        if (((ActivityHandler)object3).activityState.isGdprForgotten) {
            return;
        }
        ActivityHandler activityHandler2 = object3;
        long l2 = System.currentTimeMillis();
        Object object2 = packageBuilder;
        AdjustPlayStoreSubscription adjustPlayStoreSubscription = object;
        ActivityHandler activityHandler3 = object3;
        PackageBuilder packageBuilder2 = object2;
        ActivityHandler activityHandler4 = object3;
        Object object3 = activityHandler4.adjustConfig;
        object = activityHandler4.deviceInfo;
        object2 = activityHandler4.activityState;
        SessionParameters sessionParameters = activityHandler4.sessionParameters;
        packageBuilder2((AdjustConfig)object3, (a)object, (ActivityState)object2, sessionParameters, l2);
        object3 = packageBuilder.buildSubscriptionPackage(adjustPlayStoreSubscription, activityHandler3.internalState.isInDelayedStart());
        activityHandler2.packageHandler.addPackage((ActivityPackage)object3);
        activityHandler2.packageHandler.sendFirstPackage();
    }

    private void gotOptOutResponseI() {
        ActivityHandler activityHandler = this;
        activityHandler.activityState.isGdprForgotten = true;
        activityHandler.writeActivityStateI();
        activityHandler.packageHandler.flush();
        activityHandler.setEnabledI(false);
    }

    private void readActivityStateI(Context context) {
        try {
            this.activityState = Util.readObject(context, "AdjustIoActivityState", ACTIVITY_STATE_NAME, ActivityState.class);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = ACTIVITY_STATE_NAME;
            objectArray[1] = exception.getMessage();
            this.logger.error("Failed to read %s file (%s)", objectArray2);
            this.activityState = null;
        }
        if (this.activityState != null) {
            this.internalState.firstSdkStart = true;
        }
    }

    private void readAttributionI(Context context) {
        try {
            objectArray2.attribution = Util.readObject(context, "AdjustAttribution", ATTRIBUTION_NAME, AdjustAttribution.class);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = ATTRIBUTION_NAME;
            objectArray[1] = exception.getMessage();
            objectArray2.logger.error("Failed to read %s file (%s)", objectArray2);
            objectArray2.attribution = null;
        }
    }

    private void readSessionCallbackParametersI(Context context) {
        try {
            objectArray2.sessionParameters.callbackParameters = Util.readObject(context, "AdjustSessionCallbackParameters", SESSION_CALLBACK_PARAMETERS_NAME, Map.class);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = SESSION_CALLBACK_PARAMETERS_NAME;
            objectArray[1] = exception.getMessage();
            objectArray2.logger.error("Failed to read %s file (%s)", objectArray2);
            objectArray2.sessionParameters.callbackParameters = null;
        }
    }

    private void readSessionPartnerParametersI(Context context) {
        try {
            objectArray2.sessionParameters.partnerParameters = Util.readObject(context, "AdjustSessionPartnerParameters", SESSION_PARTNER_PARAMETERS_NAME, Map.class);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = SESSION_PARTNER_PARAMETERS_NAME;
            objectArray[1] = exception.getMessage();
            objectArray2.logger.error("Failed to read %s file (%s)", objectArray2);
            objectArray2.sessionParameters.partnerParameters = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeActivityStateI() {
        Class<ActivityState> clazz = ActivityState.class;
        synchronized (ActivityState.class) {
            ActivityState activityState = this.activityState;
            if (activityState == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(activityState, this.adjustConfig.context, "AdjustIoActivityState", ACTIVITY_STATE_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void teardownActivityStateS() {
        Class<ActivityState> clazz = ActivityState.class;
        synchronized (ActivityState.class) {
            if (this.activityState == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.activityState = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAttributionI() {
        Class<AdjustAttribution> clazz = AdjustAttribution.class;
        synchronized (AdjustAttribution.class) {
            AdjustAttribution adjustAttribution = this.attribution;
            if (adjustAttribution == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(adjustAttribution, this.adjustConfig.context, "AdjustAttribution", ATTRIBUTION_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void teardownAttributionS() {
        Class<AdjustAttribution> clazz = AdjustAttribution.class;
        synchronized (AdjustAttribution.class) {
            if (this.attribution == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.attribution = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSessionCallbackParametersI() {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            SessionParameters sessionParameters = this.sessionParameters;
            if (sessionParameters == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(sessionParameters.callbackParameters, this.adjustConfig.context, "AdjustSessionCallbackParameters", SESSION_CALLBACK_PARAMETERS_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSessionPartnerParametersI() {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            SessionParameters sessionParameters = this.sessionParameters;
            if (sessionParameters == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(sessionParameters.partnerParameters, this.adjustConfig.context, "AdjustSessionPartnerParameters", SESSION_PARTNER_PARAMETERS_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void teardownAllSessionParametersS() {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            if (this.sessionParameters == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.sessionParameters = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean checkEventI(AdjustEvent adjustEvent) {
        if (adjustEvent == null) {
            this.logger.error("Event missing", new Object[0]);
            return false;
        }
        if (!adjustEvent.isValid()) {
            this.logger.error("Event not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkOrderIdI(String string) {
        if (string != null && !string.isEmpty()) {
            Object[] objectArray;
            if (objectArray.activityState.findOrderId(string)) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = string;
                objectArray.logger.info("Skipping duplicated order ID '%s'", objectArray);
                return false;
            }
            objectArray.activityState.addOrderId(string);
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string;
            objectArray.logger.verbose("Added order ID '%s'", objectArray);
            return true;
        }
        return true;
    }

    private boolean checkAdjustAdRevenue(AdjustAdRevenue adjustAdRevenue) {
        if (adjustAdRevenue == null) {
            this.logger.error("Ad revenue object missing", new Object[0]);
            return false;
        }
        if (!adjustAdRevenue.isValid()) {
            this.logger.error("Ad revenue object not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkActivityStateI(ActivityState activityState) {
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            this.logger.error("Sdk did not yet start", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean pausedI() {
        return this.pausedI(false);
    }

    private boolean pausedI(boolean bl) {
        if (bl) {
            return this.internalState.isOffline() || !this.isEnabledI();
        }
        return this.internalState.isOffline() || !this.isEnabledI() || this.internalState.isInDelayedStart();
    }

    private boolean toSendI() {
        return this.toSendI(false);
    }

    private boolean toSendI(boolean bl) {
        if (this.pausedI(bl)) {
            return false;
        }
        if (this.adjustConfig.sendInBackground) {
            return true;
        }
        return this.internalState.isInForeground();
    }

    private void checkForInstallReferrerInfo(SdkClickResponseData sdkClickResponseData) {
        Object object;
        if (!sdkClickResponseData.isInstallReferrer) {
            return;
        }
        String string = sdkClickResponseData.referrerApi;
        if (string != null && string.equalsIgnoreCase("huawei_ads")) {
            ActivityHandler activityHandler = object;
            object = activityHandler.activityState;
            ((ActivityState)object).clickTimeHuawei = sdkClickResponseData.clickTime;
            ((ActivityState)object).installBeginHuawei = sdkClickResponseData.installBegin;
            activityHandler.activityState.installReferrerHuawei = sdkClickResponseData.installReferrer;
            activityHandler.writeActivityStateI();
            return;
        }
        string = sdkClickResponseData.referrerApi;
        if (string != null && string.equalsIgnoreCase("huawei_app_gallery")) {
            Object object2 = object;
            object = ((ActivityHandler)object2).activityState;
            ((ActivityState)object).clickTimeHuawei = sdkClickResponseData.clickTime;
            ((ActivityState)object).installBeginHuawei = sdkClickResponseData.installBegin;
            ((ActivityHandler)object2).activityState.installReferrerHuaweiAppGallery = sdkClickResponseData.installReferrer;
            super.writeActivityStateI();
            return;
        }
        Object object3 = object;
        object = ((ActivityHandler)object3).activityState;
        ((ActivityState)object).clickTime = sdkClickResponseData.clickTime;
        ((ActivityState)object).installBegin = sdkClickResponseData.installBegin;
        ((ActivityState)object).installReferrer = sdkClickResponseData.installReferrer;
        ((ActivityState)object).clickTimeServer = sdkClickResponseData.clickTimeServer;
        ((ActivityState)object).installBeginServer = sdkClickResponseData.installBeginServer;
        ((ActivityState)object).installVersion = sdkClickResponseData.installVersion;
        ((ActivityHandler)object3).activityState.googlePlayInstant = sdkClickResponseData.googlePlayInstant;
        super.writeActivityStateI();
    }

    private void processCoppaComplianceI() {
        if (!this.adjustConfig.coppaCompliantEnabled) {
            this.resetThirdPartySharingCoppaActivityStateI();
            return;
        }
        this.disableThirdPartySharingForCoppaEnabledI();
    }

    private void disableThirdPartySharingForCoppaEnabledI() {
        AdjustThirdPartySharing adjustThirdPartySharing;
        if (!objectArray3.shouldDisableThirdPartySharingWhenCoppaEnabled()) {
            return;
        }
        Object[] objectArray = objectArray3;
        objectArray3.activityState.isThirdPartySharingDisabledForCoppa = true;
        objectArray.writeActivityStateI();
        Object object = adjustThirdPartySharing;
        adjustThirdPartySharing = new AdjustThirdPartySharing(Boolean.FALSE);
        long l2 = System.currentTimeMillis();
        object = objectArray3.adjustConfig;
        a a2 = objectArray3.deviceInfo;
        ActivityState activityState = objectArray3.activityState;
        SessionParameters sessionParameters = objectArray3.sessionParameters;
        object = new PackageBuilder((AdjustConfig)object, a2, activityState, sessionParameters, l2).buildThirdPartySharingPackage((AdjustThirdPartySharing)object);
        objectArray3.packageHandler.addPackage((ActivityPackage)object);
        if (objectArray.adjustConfig.eventBufferingEnabled) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = ((ActivityPackage)object).getSuffix();
            objectArray3.logger.info("Buffered event %s", objectArray3);
        } else {
            objectArray3.packageHandler.sendFirstPackage();
        }
    }

    private void resetThirdPartySharingCoppaActivityStateI() {
        ActivityState activityState = this.activityState;
        if (activityState == null) {
            return;
        }
        if (activityState.isThirdPartySharingDisabledForCoppa) {
            activityState.isThirdPartySharingDisabledForCoppa = false;
            this.writeActivityStateI();
        }
    }

    private boolean shouldDisableThirdPartySharingWhenCoppaEnabled() {
        if (((ActivityHandler)((Object)activityState)).activityState == null) {
            return false;
        }
        if (!((ActivityHandler)((Object)activityState)).isEnabledI()) {
            return false;
        }
        ActivityState activityState = ((ActivityHandler)((Object)activityState)).activityState;
        if (activityState.isGdprForgotten) {
            return false;
        }
        return activityState.isThirdPartySharingDisabledForCoppa ^ true;
    }

    @Override
    public void teardown() {
        Map<String, String> map = this.backgroundTimer;
        if (map != null) {
            ((TimerOnce)((Object)map)).teardown();
        }
        if ((map = this.foregroundTimer) != null) {
            ((TimerCycle)((Object)map)).teardown();
        }
        if ((map = this.delayStartTimer) != null) {
            ((TimerOnce)((Object)map)).teardown();
        }
        if ((map = this.executor) != null) {
            map.teardown();
        }
        if ((map = this.packageHandler) != null) {
            map.teardown();
        }
        if ((map = this.attributionHandler) != null) {
            map.teardown();
        }
        if ((map = this.sdkClickHandler) != null) {
            map.teardown();
        }
        if ((map = this.sessionParameters) != null) {
            map = ((SessionParameters)((Object)map)).callbackParameters;
            if (map != null) {
                map.clear();
            }
            if ((map = this.sessionParameters.partnerParameters) != null) {
                map.clear();
            }
        }
        ActivityHandler activityHandler = this;
        activityHandler.teardownActivityStateS();
        activityHandler.teardownAttributionS();
        activityHandler.teardownAllSessionParametersS();
        activityHandler.packageHandler = null;
        activityHandler.logger = null;
        activityHandler.foregroundTimer = null;
        activityHandler.executor = null;
        activityHandler.backgroundTimer = null;
        activityHandler.delayStartTimer = null;
        activityHandler.internalState = null;
        activityHandler.deviceInfo = null;
        activityHandler.adjustConfig = null;
        activityHandler.attributionHandler = null;
        activityHandler.sdkClickHandler = null;
        activityHandler.sessionParameters = null;
    }

    @Override
    public AdjustConfig getAdjustConfig() {
        return this.adjustConfig;
    }

    @Override
    public a getDeviceInfo() {
        return this.deviceInfo;
    }

    @Override
    public ActivityState getActivityState() {
        return this.activityState;
    }

    @Override
    public SessionParameters getSessionParameters() {
        return this.sessionParameters;
    }

    @Override
    public void init(AdjustConfig adjustConfig) {
        this.adjustConfig = adjustConfig;
    }

    @Override
    public void onResume() {
        this.internalState.background = false;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                v v2 = this;
                v2.ActivityHandler.this.delayStartI();
                v2.ActivityHandler.this.stopBackgroundTimerI();
                v2.ActivityHandler.this.startForegroundTimerI();
                v2.ActivityHandler.this.logger.verbose("Subsession start", new Object[0]);
                v2.ActivityHandler.this.startI();
            }
        });
    }

    @Override
    public void onPause() {
        this.internalState.background = true;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                g0 g02 = this;
                g02.ActivityHandler.this.stopForegroundTimerI();
                g02.ActivityHandler.this.startBackgroundTimerI();
                g02.ActivityHandler.this.logger.verbose("Subsession end", new Object[0]);
                g02.ActivityHandler.this.endI();
            }
        });
    }

    @Override
    public void trackEvent(final AdjustEvent adjustEvent) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (ActivityHandler.this.internalState.hasFirstSdkStartNotOcurred()) {
                    n0 n02 = this;
                    n02.ActivityHandler.this.logger.warn("Event tracked before first activity resumed.\nIf it was triggered in the Application class, it might timestamp or even send an install long before the user opens the app.\nPlease check https://github.com/adjust/android_sdk#can-i-trigger-an-event-at-application-launch for more information.", new Object[0]);
                    n02.ActivityHandler.this.startI();
                }
                ActivityHandler.this.trackEventI(adjustEvent);
            }
        });
    }

    @Override
    public void finishedTrackingActivity(ResponseData responseData) {
        if (responseData instanceof SessionResponseData) {
            ActivityHandler activityHandler = sdkClickResponseData;
            activityHandler.logger.debug("Finished tracking session", new Object[0]);
            activityHandler.attributionHandler.checkSessionResponse((SessionResponseData)responseData);
            return;
        }
        if (responseData instanceof SdkClickResponseData) {
            ActivityHandler activityHandler = sdkClickResponseData;
            SdkClickResponseData sdkClickResponseData = (SdkClickResponseData)responseData;
            activityHandler.checkForInstallReferrerInfo(sdkClickResponseData);
            activityHandler.attributionHandler.checkSdkClickResponse(sdkClickResponseData);
            return;
        }
        if (responseData instanceof EventResponseData) {
            ((ActivityHandler)((Object)sdkClickResponseData)).launchEventResponseTasks((EventResponseData)responseData);
            return;
        }
    }

    @Override
    public void setEnabled(final boolean bl) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.setEnabledI(bl);
            }
        });
    }

    @Override
    public void setOfflineMode(final boolean bl) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.setOfflineModeI(bl);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabledI();
    }

    @Override
    public void readOpenUrl(final Uri uri, final long l2) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                q0 q02 = q03;
                q0 q03 = q02.uri;
                long l22 = q02.l2;
                q03.ActivityHandler.this.readOpenUrlI((Uri)q03, l22);
            }
        });
    }

    @Override
    public boolean updateAttributionI(AdjustAttribution adjustAttribution) {
        if (adjustAttribution == null) {
            return false;
        }
        if (adjustAttribution.equals(this.attribution)) {
            return false;
        }
        this.attribution = adjustAttribution;
        this.writeAttributionI();
        return true;
    }

    @Override
    public void setAskingAttribution(final boolean bl) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.setAskingAttributionI(bl);
            }
        });
    }

    @Override
    public void sendReftagReferrer() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendReftagReferrerI();
            }
        });
    }

    @Override
    public void sendPreinstallReferrer() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendPreinstallReferrerI();
            }
        });
    }

    @Override
    public void sendInstallReferrer(final ReferrerDetails referrerDetails, final String string) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                b b2 = referrerDetails2;
                ReferrerDetails referrerDetails2 = b2.referrerDetails;
                referrerDetails2.ActivityHandler.this.sendInstallReferrerI(referrerDetails2, b2.string);
            }
        });
    }

    @Override
    public void launchEventResponseTasks(final EventResponseData eventResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchEventResponseTasksI(eventResponseData);
            }
        });
    }

    @Override
    public void launchSdkClickResponseTasks(final SdkClickResponseData sdkClickResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchSdkClickResponseTasksI(sdkClickResponseData);
            }
        });
    }

    @Override
    public void launchSessionResponseTasks(final SessionResponseData sessionResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchSessionResponseTasksI(sessionResponseData);
            }
        });
    }

    @Override
    public void launchAttributionResponseTasks(final AttributionResponseData attributionResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchAttributionResponseTasksI(attributionResponseData);
            }
        });
    }

    @Override
    public void sendFirstPackages() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendFirstPackagesI();
            }
        });
    }

    @Override
    public void addSessionCallbackParameter(final String string, final String string2) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                h h2 = string3;
                String string3 = h2.string;
                string3.ActivityHandler.this.addSessionCallbackParameterI(string3, h2.string2);
            }
        });
    }

    @Override
    public void addSessionPartnerParameter(final String string, final String string2) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                i i2 = string3;
                String string3 = i2.string;
                string3.ActivityHandler.this.addSessionPartnerParameterI(string3, i2.string2);
            }
        });
    }

    @Override
    public void removeSessionCallbackParameter(final String string) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.removeSessionCallbackParameterI(string);
            }
        });
    }

    @Override
    public void removeSessionPartnerParameter(final String string) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.removeSessionPartnerParameterI(string);
            }
        });
    }

    @Override
    public void resetSessionCallbackParameters() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.resetSessionCallbackParametersI();
            }
        });
    }

    @Override
    public void resetSessionPartnerParameters() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.resetSessionPartnerParametersI();
            }
        });
    }

    @Override
    public void setPushToken(final String string, final boolean bl) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (!bl) {
                    SharedPreferencesManager.getDefaultInstance(ActivityHandler.this.getContext()).savePushToken(string);
                }
                if (ActivityHandler.this.internalState.hasFirstSdkStartNotOcurred()) {
                    return;
                }
                ActivityHandler.this.setPushTokenI(string);
            }
        });
    }

    @Override
    public void gdprForgetMe() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.gdprForgetMeI();
            }
        });
    }

    @Override
    public void disableThirdPartySharing() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.disableThirdPartySharingI();
            }
        });
    }

    @Override
    public void trackThirdPartySharing(final AdjustThirdPartySharing adjustThirdPartySharing) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.trackThirdPartySharingI(adjustThirdPartySharing);
            }
        });
    }

    @Override
    public void trackMeasurementConsent(final boolean bl) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.trackMeasurementConsentI(bl);
            }
        });
    }

    @Override
    public void trackAdRevenue(final String string, final JSONObject jSONObject) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                t t2 = string2;
                String string2 = t2.string;
                string2.ActivityHandler.this.trackAdRevenueI(string2, t2.jSONObject);
            }
        });
    }

    @Override
    public void trackAdRevenue(final AdjustAdRevenue adjustAdRevenue) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.trackAdRevenueI(adjustAdRevenue);
            }
        });
    }

    @Override
    public void trackPlayStoreSubscription(final AdjustPlayStoreSubscription adjustPlayStoreSubscription) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.trackSubscriptionI(adjustPlayStoreSubscription);
            }
        });
    }

    @Override
    public void gotOptOutResponse() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.gotOptOutResponseI();
            }
        });
    }

    @Override
    public Context getContext() {
        return this.adjustConfig.context;
    }

    public void foregroundTimerFired() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.foregroundTimerFiredI();
            }
        });
    }

    public void backgroundTimerFired() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.backgroundTimerFiredI();
            }
        });
    }

    @Override
    public String getAdid() {
        ActivityState activityState = ((ActivityHandler)((Object)activityState)).activityState;
        if (activityState == null) {
            return null;
        }
        return activityState.adid;
    }

    @Override
    public AdjustAttribution getAttribution() {
        return this.attribution;
    }

    public InternalState getInternalState() {
        return this.internalState;
    }

    public void addSessionCallbackParameterI(String string, String string2) {
        if (!Util.isValidParameter(string, "key", "Session Callback")) {
            return;
        }
        if (!Util.isValidParameter(string2, "value", "Session Callback")) {
            return;
        }
        Object[] objectArray = objectArray3.sessionParameters;
        if (objectArray.callbackParameters == null) {
            LinkedHashMap linkedHashMap;
            SessionParameters sessionParameters = objectArray;
            objectArray = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            sessionParameters.callbackParameters = objectArray;
        }
        if (string2.equals(objectArray = objectArray3.sessionParameters.callbackParameters.get(string))) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = string;
            objectArray3.logger.verbose("Key %s already present with the same value", objectArray3);
            return;
        }
        if (objectArray != null) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = string;
            objectArray3.logger.warn("Key %s will be overwritten", objectArray);
        }
        objectArray3.sessionParameters.callbackParameters.put(string, string2);
        super.writeSessionCallbackParametersI();
    }

    public void addSessionPartnerParameterI(String string, String string2) {
        if (!Util.isValidParameter(string, "key", "Session Partner")) {
            return;
        }
        if (!Util.isValidParameter(string2, "value", "Session Partner")) {
            return;
        }
        Object[] objectArray = objectArray3.sessionParameters;
        if (objectArray.partnerParameters == null) {
            LinkedHashMap linkedHashMap;
            SessionParameters sessionParameters = objectArray;
            objectArray = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            sessionParameters.partnerParameters = objectArray;
        }
        if (string2.equals(objectArray = objectArray3.sessionParameters.partnerParameters.get(string))) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = string;
            objectArray3.logger.verbose("Key %s already present with the same value", objectArray3);
            return;
        }
        if (objectArray != null) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = string;
            objectArray3.logger.warn("Key %s will be overwritten", objectArray);
        }
        objectArray3.sessionParameters.partnerParameters.put(string, string2);
        super.writeSessionPartnerParametersI();
    }

    public void removeSessionCallbackParameterI(String string) {
        Object[] objectArray;
        if (!Util.isValidParameter(string, "key", "Session Callback")) {
            return;
        }
        Map<String, String> map = objectArray.sessionParameters.callbackParameters;
        if (map == null) {
            objectArray.logger.warn("Session Callback parameters are not set", new Object[0]);
            return;
        }
        if (map.remove(string) == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            objectArray.logger.warn("Key %s does not exist", objectArray);
            return;
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = string;
        objectArray.logger.debug("Key %s will be removed", objectArray);
        super.writeSessionCallbackParametersI();
    }

    public void removeSessionPartnerParameterI(String string) {
        Object[] objectArray;
        if (!Util.isValidParameter(string, "key", "Session Partner")) {
            return;
        }
        Map<String, String> map = objectArray.sessionParameters.partnerParameters;
        if (map == null) {
            objectArray.logger.warn("Session Partner parameters are not set", new Object[0]);
            return;
        }
        if (map.remove(string) == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            objectArray.logger.warn("Key %s does not exist", objectArray);
            return;
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = string;
        objectArray.logger.debug("Key %s will be removed", objectArray);
        super.writeSessionPartnerParametersI();
    }

    public void resetSessionCallbackParametersI() {
        if (this.sessionParameters.callbackParameters == null) {
            this.logger.warn("Session Callback parameters are not set", new Object[0]);
        }
        this.sessionParameters.callbackParameters = null;
        this.writeSessionCallbackParametersI();
    }

    public void resetSessionPartnerParametersI() {
        if (this.sessionParameters.partnerParameters == null) {
            this.logger.warn("Session Partner parameters are not set", new Object[0]);
        }
        this.sessionParameters.partnerParameters = null;
        this.writeSessionPartnerParametersI();
    }

    public class InternalState {
        public boolean enabled;
        public boolean offline;
        public boolean background;
        public boolean delayStart;
        public boolean updatePackages;
        public boolean firstLaunch;
        public boolean sessionResponseProcessed;
        public boolean firstSdkStart;
        public boolean preinstallHasBeenRead;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisabled() {
            return this.enabled ^ true;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public boolean isOnline() {
            return this.offline ^ true;
        }

        public boolean isInBackground() {
            return this.background;
        }

        public boolean isInForeground() {
            return this.background ^ true;
        }

        public boolean isInDelayedStart() {
            return this.delayStart;
        }

        public boolean isNotInDelayedStart() {
            return this.delayStart ^ true;
        }

        public boolean itHasToUpdatePackages() {
            return this.updatePackages;
        }

        public boolean isFirstLaunch() {
            return this.firstLaunch;
        }

        public boolean isNotFirstLaunch() {
            return this.firstLaunch ^ true;
        }

        public boolean hasSessionResponseNotBeenProcessed() {
            return this.sessionResponseProcessed ^ true;
        }

        public boolean hasFirstSdkStartOcurred() {
            return this.firstSdkStart;
        }

        public boolean hasFirstSdkStartNotOcurred() {
            return this.firstSdkStart ^ true;
        }

        public boolean hasPreinstallBeenRead() {
            return this.preinstallHasBeenRead;
        }
    }
}

