/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AdjustLinkResolution {
    private static volatile ExecutorService executor;
    private static final int maxRecursions = 10;
    private static final String[] expectedUrlHostSuffixArray;

    private AdjustLinkResolution() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void resolveLink(String url, String[] resolveUrlSuffixArray, final AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        if (adjustLinkResolutionCallback == null) {
            return;
        }
        if (url == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        URL originalURL = null;
        try {
            originalURL = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (originalURL == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        if (!AdjustLinkResolution.urlMatchesSuffix(originalURL.getHost(), resolveUrlSuffixArray)) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(originalURL));
            return;
        }
        if (executor == null) {
            String[] stringArray = expectedUrlHostSuffixArray;
            // MONITORENTER : expectedUrlHostSuffixArray
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
            // MONITOREXIT : stringArray
        }
        final URL finalOriginalURL = originalURL;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                AdjustLinkResolution.requestAndResolve(finalOriginalURL, 0, adjustLinkResolutionCallback);
            }
        });
    }

    private static void resolveLink(URL responseUrl, URL previousUrl, int recursionNumber, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        if (responseUrl == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(previousUrl));
            return;
        }
        if (AdjustLinkResolution.isTerminalUrl(responseUrl.getHost())) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(responseUrl));
            return;
        }
        if (recursionNumber > 10) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(responseUrl));
            return;
        }
        AdjustLinkResolution.requestAndResolve(responseUrl, recursionNumber, adjustLinkResolutionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void requestAndResolve(URL urlToRequest, int recursionNumber, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        URL resolvedURL;
        URL httpsUrl;
        block7: {
            httpsUrl = AdjustLinkResolution.convertToHttps(urlToRequest);
            resolvedURL = null;
            HttpURLConnection ucon = null;
            try {
                ucon = (HttpURLConnection)httpsUrl.openConnection();
                ucon.setInstanceFollowRedirects(false);
                ucon.connect();
                String headerLocationField = ucon.getHeaderField("Location");
                if (headerLocationField != null) {
                    resolvedURL = new URL(headerLocationField);
                }
                if (ucon == null) break block7;
                ucon.disconnect();
            }
            catch (Throwable throwable) {
                if (ucon != null) {
                    ucon.disconnect();
                }
                AdjustLinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, adjustLinkResolutionCallback);
                catch (Throwable throwable2) {
                    if (ucon != null) {
                        ucon.disconnect();
                    }
                    AdjustLinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, adjustLinkResolutionCallback);
                    throw throwable2;
                }
            }
        }
        AdjustLinkResolution.resolveLink(resolvedURL, httpsUrl, recursionNumber + 1, adjustLinkResolutionCallback);
    }

    private static boolean isTerminalUrl(String urlHost) {
        return AdjustLinkResolution.urlMatchesSuffix(urlHost, expectedUrlHostSuffixArray);
    }

    private static boolean urlMatchesSuffix(String urlHost, String[] suffixArray) {
        if (urlHost == null) {
            return false;
        }
        if (suffixArray == null) {
            return false;
        }
        for (String expectedUrlHostSuffix : suffixArray) {
            if (!urlHost.endsWith(expectedUrlHostSuffix)) continue;
            return true;
        }
        return false;
    }

    private static URL convertToHttps(URL urlToConvert) {
        if (urlToConvert == null) {
            return urlToConvert;
        }
        String stringUrlToConvert = urlToConvert.toExternalForm();
        if (stringUrlToConvert == null) {
            return urlToConvert;
        }
        if (!stringUrlToConvert.startsWith("http:")) {
            return urlToConvert;
        }
        URL convertedUrl = urlToConvert;
        try {
            convertedUrl = new URL("https:" + stringUrlToConvert.substring(5));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return convertedUrl;
    }

    private static Uri convertToUri(URL url) {
        if (url == null) {
            return null;
        }
        return Uri.parse((String)url.toString());
    }

    static {
        expectedUrlHostSuffixArray = new String[]{"adjust.com", "adj.st", "go.link"};
    }

    public static interface AdjustLinkResolutionCallback {
        public void resolvedLinkCallback(Uri var1);
    }
}

